/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.history.LogPanel;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.history.HistoryFilterPlusDialog;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ContextCreateDialog;
import org.zaproxy.zap.view.ContextGeneralPanel;
import org.zaproxy.zap.view.ContextsSitesPanel;
import org.zaproxy.zap.view.ContextsTreeCellRenderer;
import org.zaproxy.zap.view.DeleteContextAction;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.SiteMapListener;
import org.zaproxy.zap.view.SiteMapTreeCellRenderer;
import org.zaproxy.zap.view.SiteTreeFilter;
import org.zaproxy.zap.view.ZapToggleButton;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSelectableHistoryReferencesContainer;

public class SiteMapPanel
extends AbstractPanel {
    public static final String CONTEXT_TREE_COMPONENT_NAME = "ContextTree";
    private static final long serialVersionUID = -3161729504065679088L;
    private static Logger log = Logger.getLogger(SiteMapPanel.class);
    private JTree treeSite = null;
    private JTree treeContext = null;
    private DefaultTreeModel contextTree = null;
    private View view = null;
    private JToolBar panelToolbar = null;
    private ZapToggleButton scopeButton = null;
    private JButton filterButton = null;
    private JLabel filterStatus = null;
    private HistoryFilterPlusDialog filterPlusDialog = null;
    private JButton createContextButton = null;
    private JButton importContextButton = null;
    private JButton exportContextButton = null;
    private List<SiteMapListener> listeners = new ArrayList<SiteMapListener>();

    public SiteMapPanel() {
        this.initialize();
    }

    private View getView() {
        if (this.view == null) {
            this.view = View.getSingleton();
        }
        return this.view;
    }

    private void initialize() {
        this.setHideable(false);
        this.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
        this.setName(Constant.messages.getString("sites.panel.title"));
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40, false));
        this.setMnemonic(Constant.messages.getChar("sites.panel.mnemonic"));
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(300, 200);
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPanelToolbar(), LayoutHelper.getGBC(0, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        this.add((Component)new ContextsSitesPanel(this.getTreeContext(), this.getTreeSite(), "sitesPanelScrollPane"), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0, 1, new Insets(2, 2, 2, 2)));
        this.expandRoot();
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("ScriptsListToolbar");
            int i = 1;
            this.panelToolbar.add((Component)this.getScopeButton(), LayoutHelper.getGBC(i++, 0, 1, 0.0));
            this.panelToolbar.add((Component)this.getCreateContextButton(), LayoutHelper.getGBC(i++, 0, 1, 0.0));
            this.panelToolbar.add((Component)this.getImportContextButton(), LayoutHelper.getGBC(i++, 0, 1, 0.0));
            this.panelToolbar.add((Component)this.getExportContextButton(), LayoutHelper.getGBC(i++, 0, 1, 0.0));
            this.panelToolbar.add((Component)new JLabel(), LayoutHelper.getGBC(20, 0, 1, 1.0));
        }
        return this.panelToolbar;
    }

    private HistoryFilterPlusDialog getFilterPlusDialog() {
        if (this.filterPlusDialog == null) {
            this.filterPlusDialog = new HistoryFilterPlusDialog((Frame)this.getView().getMainFrame(), true);
            this.filterPlusDialog.setTitle(Constant.messages.getString("sites.filter.title"));
        }
        return this.filterPlusDialog;
    }

    private JLabel getFilterStatus() {
        this.filterStatus = new JLabel(Constant.messages.getString("history.filter.label.filter") + Constant.messages.getString("history.filter.label.off"));
        return this.filterStatus;
    }

    private JButton getFilterButton() {
        if (this.filterButton == null) {
            this.filterButton = new JButton();
            this.filterButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/16/054.png"))));
            this.filterButton.setToolTipText(Constant.messages.getString("history.filter.button.filter"));
            this.filterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SiteMapPanel.this.showFilterPlusDialog();
                }
            });
        }
        return this.filterButton;
    }

    private JButton getCreateContextButton() {
        if (this.createContextButton == null) {
            this.createContextButton = new JButton();
            this.createContextButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/fugue/application-blue-plus.png"))));
            this.createContextButton.setToolTipText(Constant.messages.getString("menu.file.context.create"));
            this.createContextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContextCreateDialog ccd = new ContextCreateDialog(View.getSingleton().getMainFrame());
                    ccd.setVisible(true);
                }
            });
        }
        return this.createContextButton;
    }

    private JButton getImportContextButton() {
        if (this.importContextButton == null) {
            this.importContextButton = new JButton();
            this.importContextButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/fugue/application-blue-import.png"))));
            this.importContextButton.setToolTipText(Constant.messages.getString("menu.file.context.import"));
            this.importContextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Control.getSingleton().getMenuFileControl().importContext();
                }
            });
        }
        return this.importContextButton;
    }

    private JButton getExportContextButton() {
        if (this.exportContextButton == null) {
            this.exportContextButton = new JButton();
            this.exportContextButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/fugue/application-blue-export.png"))));
            this.exportContextButton.setToolTipText(Constant.messages.getString("menu.file.context.export"));
            this.exportContextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Control.getSingleton().getMenuFileControl().exportContext();
                }
            });
        }
        return this.exportContextButton;
    }

    private void showFilterPlusDialog() {
        HistoryFilterPlusDialog dialog = this.getFilterPlusDialog();
        dialog.setModal(true);
        try {
            dialog.setAllTags(Model.getSingleton().getDb().getTableTag().getAllTags());
        }
        catch (DatabaseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        int exit = dialog.showDialog();
        SiteTreeFilter filter = new SiteTreeFilter(dialog.getFilter());
        filter.setInScope(this.getScopeButton().isSelected());
        if (exit != 2) {
            this.setFilter();
        }
    }

    private void setFilter() {
        SiteTreeFilter filter = new SiteTreeFilter(this.getFilterPlusDialog().getFilter());
        filter.setInScope(this.scopeButton.isSelected());
        ((SiteMap)this.treeSite.getModel()).setFilter(filter);
        ((DefaultTreeModel)this.treeSite.getModel()).nodeStructureChanged((SiteNode)this.treeSite.getModel().getRoot());
        this.getFilterStatus().setText(filter.toShortString());
        this.getFilterStatus().setToolTipText(filter.toLongString());
        this.expandRoot();
        this.reloadContextTree();
    }

    private JToggleButton getScopeButton() {
        if (this.scopeButton == null) {
            this.scopeButton = new ZapToggleButton();
            this.scopeButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(SiteMapPanel.class.getResource("/resource/icon/fugue/target-grey.png"))));
            this.scopeButton.setToolTipText(Constant.messages.getString("history.scope.button.unselected"));
            this.scopeButton.setSelectedIcon(DisplayUtils.getScaledIcon(new ImageIcon(SiteMapPanel.class.getResource("/resource/icon/fugue/target.png"))));
            this.scopeButton.setSelectedToolTipText(Constant.messages.getString("history.scope.button.selected"));
            this.scopeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SiteMapPanel.this.setFilter();
                }
            });
        }
        return this.scopeButton;
    }

    public JTree getTreeSite() {
        if (this.treeSite == null) {
            this.treeSite = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.treeSite.setShowsRootHandles(true);
            this.treeSite.setName("treeSite");
            this.treeSite.setToggleClickCount(1);
            LookAndFeel laf = UIManager.getLookAndFeel();
            if (laf != null && Constant.isMacOsX() && UIManager.getSystemLookAndFeelClassName().equals(laf.getClass().getName())) {
                this.treeSite.setRowHeight(0);
            }
            this.treeSite.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    SiteNode node = (SiteNode)SiteMapPanel.this.treeSite.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    if (!node.isRoot()) {
                        HttpMessage msg = null;
                        try {
                            msg = node.getHistoryReference().getHttpMessage();
                        }
                        catch (Exception e1) {
                            log.warn((Object)e1.getMessage(), (Throwable)e1);
                            return;
                        }
                        SiteMapPanel.this.getView().displayMessage(msg);
                        for (SiteMapListener listener : SiteMapPanel.this.listeners) {
                            listener.nodeSelected(node);
                        }
                    } else {
                        SiteMapPanel.this.getView().displayMessage(null);
                    }
                }
            });
            this.treeSite.setComponentPopupMenu(new SitesCustomPopupMenu());
            SiteMapTreeCellRenderer renderer = new SiteMapTreeCellRenderer(this.listeners);
            this.treeSite.setCellRenderer(renderer);
        }
        return this.treeSite;
    }

    public void reloadContextTree() {
        SiteNode root;
        if (this.contextTree == null) {
            root = new SiteNode(null, -1, Constant.messages.getString("context.list"));
            this.contextTree = new DefaultTreeModel(root);
        } else {
            root = (SiteNode)this.contextTree.getRoot();
            root.removeAllChildren();
        }
        for (Context ctx : Model.getSingleton().getSession().getContexts()) {
            if (!ctx.isInScope() && this.getScopeButton().isSelected()) continue;
            SiteNode node = new SiteNode(null, 1, ctx.getName());
            node.setUserObject(new Target(ctx));
            root.add(node);
        }
        this.contextTree.nodeStructureChanged(root);
    }

    public Context getSelectedContext() {
        SiteNode node = (SiteNode)this.treeContext.getLastSelectedPathComponent();
        if (node == null || node.isRoot()) {
            return null;
        }
        Target target = (Target)node.getUserObject();
        if (target != null) {
            return target.getContext();
        }
        return null;
    }

    private JTree getTreeContext() {
        if (this.treeContext == null) {
            this.reloadContextTree();
            this.treeContext = new JTree(this.contextTree);
            this.treeContext.setShowsRootHandles(true);
            this.treeContext.setName(CONTEXT_TREE_COMPONENT_NAME);
            this.treeContext.setToggleClickCount(1);
            this.treeContext.getSelectionModel().setSelectionMode(1);
            this.treeContext.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.mouseClicked(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    SiteNode node;
                    if (SiteMapPanel.this.treeSite.getLastSelectedPathComponent() != null) {
                        SiteMapPanel.this.getTreeSite().clearSelection();
                    }
                    if (e.getClickCount() > 1 && (node = (SiteNode)SiteMapPanel.this.treeContext.getLastSelectedPathComponent()) != null && node.getUserObject() != null) {
                        Target target = (Target)node.getUserObject();
                        SiteMapPanel.this.getView().showSessionDialog(Model.getSingleton().getSession(), ContextGeneralPanel.getPanelName(target.getContext()));
                    }
                }
            });
            this.treeContext.setComponentPopupMenu(new ContextsCustomPopupMenu());
            this.treeContext.setCellRenderer(new ContextsTreeCellRenderer());
            DeleteContextAction delContextAction = new DeleteContextAction(){
                private static final long serialVersionUID = 1L;

                @Override
                protected Context getContext() {
                    return SiteMapPanel.this.getSelectedContext();
                }
            };
            this.treeContext.getInputMap().put((KeyStroke)delContextAction.getValue("AcceleratorKey"), "zap.delete.context");
            this.treeContext.getActionMap().put("zap.delete.context", delContextAction);
        }
        return this.treeContext;
    }

    public void expandRoot() {
        TreeNode root = (TreeNode)this.treeSite.getModel().getRoot();
        if (root == null) {
            return;
        }
        final TreePath rootTreePath = new TreePath(root);
        if (EventQueue.isDispatchThread()) {
            this.getTreeSite().expandPath(rootTreePath);
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SiteMapPanel.this.getTreeSite().expandPath(rootTreePath);
                }
            });
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void addSiteMapListener(SiteMapListener listenner) {
        this.listeners.add(listenner);
    }

    public void removeSiteMapListener(SiteMapListener listener) {
        this.listeners.remove(listener);
    }

    public void showInSites(SiteNode node) {
        Object[] path = node.getPath();
        TreePath tp = new TreePath(path);
        this.treeSite.setExpandsSelectedPaths(true);
        this.treeSite.setSelectionPath(tp);
        this.treeSite.scrollPathToVisible(tp);
    }

    public void contextChanged(Context c) {
        this.getTreeContext();
        SiteNode root = (SiteNode)this.contextTree.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            SiteNode node = (SiteNode)root.getChildAt(i);
            Target target = (Target)node.getUserObject();
            if (c.getIndex() != target.getContext().getIndex()) continue;
            target.setContext(c);
            if (node.getNodeName().equals(c.getName())) {
                this.contextTree.nodeChanged(node);
                break;
            }
            this.reloadContextTree();
            break;
        }
    }

    protected class ContextsCustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected ContextsCustomPopupMenu() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            TreePath tp = SiteMapPanel.this.treeContext.getPathForLocation(x, y);
            if (tp != null) {
                boolean select = true;
                if (SiteMapPanel.this.treeContext.getSelectionPaths() != null) {
                    for (TreePath t : SiteMapPanel.this.treeContext.getSelectionPaths()) {
                        if (!t.equals(tp)) continue;
                        select = false;
                        break;
                    }
                }
                if (select) {
                    SiteMapPanel.this.treeContext.getSelectionModel().setSelectionPath(tp);
                }
            }
            View.getSingleton().getPopupMenu().show(SiteMapPanel.this.treeContext, x, y);
        }
    }

    protected class SitesCustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected SitesCustomPopupMenu() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            TreePath tp = SiteMapPanel.this.treeSite.getPathForLocation(x, y);
            if (tp != null) {
                boolean select = true;
                if (SiteMapPanel.this.treeSite.getSelectionPaths() != null) {
                    for (TreePath t : SiteMapPanel.this.treeSite.getSelectionPaths()) {
                        if (!t.equals(tp)) continue;
                        select = false;
                        break;
                    }
                }
                if (select) {
                    SiteMapPanel.this.treeSite.getSelectionModel().setSelectionPath(tp);
                }
            }
            int countSelectedNodes = SiteMapPanel.this.treeSite.getSelectionCount();
            ArrayList<HistoryReference> historyReferences = new ArrayList<HistoryReference>(countSelectedNodes);
            if (countSelectedNodes > 0) {
                for (TreePath path : SiteMapPanel.this.treeSite.getSelectionPaths()) {
                    SiteNode node = (SiteNode)path.getLastPathComponent();
                    HistoryReference historyReference = node.getHistoryReference();
                    if (historyReference == null) continue;
                    historyReferences.add(historyReference);
                }
            }
            DefaultSelectableHistoryReferencesContainer messageContainer = new DefaultSelectableHistoryReferencesContainer(SiteMapPanel.this.treeSite.getName(), SiteMapPanel.this.treeSite, Collections.emptyList(), historyReferences);
            View.getSingleton().getPopupMenu().show(messageContainer, x, y);
        }
    }
}

