/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.calendar.ical4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Logger;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import tr.util.DateUtils;

public class ICal4JWrapper {
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.tr.calendar.ical4j.ICal4JWrapper");
    public final TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
    public final Calendar calendar = new Calendar();
    public final TimeZone timezone;
    public final VTimeZone vtimezone;

    public ICal4JWrapper(String tzid) {
        this.calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        this.calendar.getProperties().add((Property)Version.VERSION_2_0);
        this.calendar.getProperties().add((Property)CalScale.GREGORIAN);
        if (tzid == null || tzid.trim().length() == 0) {
            this.timezone = null;
            this.vtimezone = null;
            LOG.info("No time zone specified.");
        } else {
            this.timezone = this.registry.getTimeZone(tzid);
            if (this.timezone == null) {
                this.vtimezone = null;
                LOG.warning("Time zone not recognised.");
            } else {
                this.vtimezone = this.timezone.getVTimeZone();
                this.calendar.getComponents().add((Component)this.vtimezone);
                LOG.info("Time zone added: " + this.timezone.getDisplayName());
            }
        }
    }

    public void createAllDayEvent(String uid, java.util.Date date, String summary, String description, String location, Integer priority) {
        assert (uid != null);
        assert (date != null);
        assert (summary != null);
        VEvent vevent = new VEvent(new Date(DateUtils.clearTime((java.util.Date)date)), summary);
        vevent.getProperties().add((Property)new Uid(uid));
        if (description != null) {
            vevent.getProperties().add((Property)new Description(description));
        }
        if (location != null) {
            vevent.getProperties().add((Property)new Location(location));
        }
        if (priority != null) {
            vevent.getProperties().add((Property)new Priority(priority.intValue()));
        }
        if (this.vtimezone != null) {
            vevent.getProperties().add((Property)this.vtimezone.getTimeZoneId());
        }
        try {
            vevent.validate();
            this.calendar.getComponents().add((Component)vevent);
        }
        catch (ValidationException ex) {
            LOG.severe("ValidationException for Event : " + vevent.toString() + "\n" + ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    public void createSpecificTimeEvent(String uid, java.util.Date date, String desc, String notes, String location, int hrs, int mns, Integer priority) {
        assert (uid != null);
        assert (desc != null);
        assert (date != null);
        assert (DateUtils.hasTime((java.util.Date)date));
        Dur dur = hrs == 0 && mns == 0 ? new Dur(0, 0, 15, 0) : new Dur(0, hrs, mns, 0);
        VEvent vevent = new VEvent((Date)new DateTime(date), dur, desc);
        vevent.getProperties().getProperty("DTSTART").getParameters().add((Parameter)Value.DATE_TIME);
        vevent.getProperties().add((Property)new Uid(uid));
        if (notes != null) {
            vevent.getProperties().add((Property)new Description(notes));
        }
        if (location != null) {
            vevent.getProperties().add((Property)new Location(location));
        }
        if (priority != null) {
            vevent.getProperties().add((Property)new Priority(priority.intValue()));
        }
        if (this.vtimezone != null) {
            vevent.getProperties().add((Property)this.vtimezone.getTimeZoneId());
        }
        try {
            vevent.validate();
            this.calendar.getComponents().add((Component)vevent);
        }
        catch (ValidationException ex) {
            LOG.severe("ValidationException for Event : " + vevent.toString() + "\n" + ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    public void createToDo(String uid, String desc, String notes, String location, Integer priority) {
        this.createToDo(uid, null, null, desc, notes, location, priority);
    }

    public void createToDo(String uid, java.util.Date start, java.util.Date due, String desc, String notes, String location, Integer priority) {
        assert (uid != null);
        assert (desc != null);
        VToDo vtodo = new VToDo();
        vtodo.getProperties().add((Property)new Summary(desc));
        vtodo.getProperties().add((Property)new Uid(uid));
        if (start != null) {
            DtStart dtStartProperty;
            if (DateUtils.hasTime((java.util.Date)start)) {
                dtStartProperty = new DtStart((Date)new DateTime(start));
                if (this.timezone != null) {
                    dtStartProperty.setTimeZone(this.timezone);
                }
            } else {
                dtStartProperty = new DtStart(new Date(DateUtils.clearTime((java.util.Date)start)));
            }
            vtodo.getProperties().add((Property)dtStartProperty);
        }
        if (due != null) {
            Due dueProperty;
            if (DateUtils.hasTime((java.util.Date)due)) {
                dueProperty = new Due((Date)new DateTime(due));
                if (this.timezone != null) {
                    dueProperty.setTimeZone(this.timezone);
                }
            } else {
                dueProperty = new Due(new Date(DateUtils.clearTime((java.util.Date)due)));
            }
            vtodo.getProperties().add((Property)dueProperty);
        }
        if (notes != null) {
            vtodo.getProperties().add((Property)new Description(notes));
        }
        if (location != null) {
            vtodo.getProperties().add((Property)new Location(location));
        }
        if (priority != null) {
            vtodo.getProperties().add((Property)new Priority(priority.intValue()));
        }
        if (this.vtimezone != null) {
            vtodo.getProperties().add((Property)this.vtimezone.getTimeZoneId());
        }
        try {
            vtodo.validate();
            this.calendar.getComponents().add((Component)vtodo);
        }
        catch (ValidationException ex) {
            LOG.severe("ValidationException for ToDO : " + vtodo.toString() + "\n" + ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    public void validate() throws ValidationException {
        this.calendar.validate();
    }

    public void write(File outfile) throws Exception {
        if (this.calendar.getComponents().size() > 0) {
            String encoding = "UTF-8";
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), encoding);
            CalendarOutputter outputter = new CalendarOutputter();
            outputter.output(this.calendar, (Writer)writer);
            ((Writer)writer).close();
        }
    }
}

