/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPConst;
import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPDateTimeFactory;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.XMPUtils;
import com.adobe.xmp.impl.Utils;
import com.adobe.xmp.impl.XMPNode;
import com.adobe.xmp.impl.xpath.XMPPath;
import com.adobe.xmp.impl.xpath.XMPPathSegment;
import com.adobe.xmp.options.PropertyOptions;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class XMPNodeUtils
implements XMPConst {
    static final int CLT_NO_VALUES = 0;
    static final int CLT_SPECIFIC_MATCH = 1;
    static final int CLT_SINGLE_GENERIC = 2;
    static final int CLT_MULTIPLE_GENERIC = 3;
    static final int CLT_XDEFAULT = 4;
    static final int CLT_FIRST_ITEM = 5;

    private XMPNodeUtils() {
    }

    static XMPNode findSchemaNode(XMPNode xMPNode, String string, boolean bl) throws XMPException {
        return XMPNodeUtils.findSchemaNode(xMPNode, string, null, bl);
    }

    static XMPNode findSchemaNode(XMPNode xMPNode, String string, String string2, boolean bl) throws XMPException {
        assert (xMPNode.getParent() == null);
        XMPNode xMPNode2 = xMPNode.findChildByName(string);
        if (xMPNode2 == null && bl) {
            xMPNode2 = new XMPNode(string, new PropertyOptions().setSchemaNode(true));
            xMPNode2.setImplicit(true);
            String string3 = XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(string);
            if (string3 == null) {
                if (string2 != null && string2.length() != 0) {
                    string3 = XMPMetaFactory.getSchemaRegistry().registerNamespace(string, string2);
                } else {
                    throw new XMPException("Unregistered schema namespace URI", 101);
                }
            }
            xMPNode2.setValue(string3);
            xMPNode.addChild(xMPNode2);
        }
        return xMPNode2;
    }

    static XMPNode findChildNode(XMPNode xMPNode, String string, boolean bl) throws XMPException {
        XMPNode xMPNode2;
        if (!xMPNode.getOptions().isSchemaNode() && !xMPNode.getOptions().isStruct()) {
            if (!xMPNode.isImplicit()) {
                throw new XMPException("Named children only allowed for schemas and structs", 102);
            }
            if (xMPNode.getOptions().isArray()) {
                throw new XMPException("Named children not allowed for arrays", 102);
            }
            if (bl) {
                xMPNode.getOptions().setStruct(true);
            }
        }
        if ((xMPNode2 = xMPNode.findChildByName(string)) == null && bl) {
            PropertyOptions propertyOptions = new PropertyOptions();
            xMPNode2 = new XMPNode(string, propertyOptions);
            xMPNode2.setImplicit(true);
            xMPNode.addChild(xMPNode2);
        }
        assert (xMPNode2 != null || !bl);
        return xMPNode2;
    }

    static XMPNode findNode(XMPNode xMPNode, XMPPath xMPPath, boolean bl, PropertyOptions propertyOptions) throws XMPException {
        if (xMPPath == null || xMPPath.size() == 0) {
            throw new XMPException("Empty XMPPath", 102);
        }
        XMPNode xMPNode2 = null;
        XMPNode xMPNode3 = null;
        xMPNode3 = XMPNodeUtils.findSchemaNode(xMPNode, xMPPath.getSegment(0).getName(), bl);
        if (xMPNode3 == null) {
            return null;
        }
        if (xMPNode3.isImplicit()) {
            xMPNode3.setImplicit(false);
            xMPNode2 = xMPNode3;
        }
        try {
            for (int i = 1; i < xMPPath.size(); ++i) {
                if ((xMPNode3 = XMPNodeUtils.followXPathStep(xMPNode3, xMPPath.getSegment(i), bl)) == null) {
                    if (bl) {
                        XMPNodeUtils.deleteNode(xMPNode2);
                    }
                    return null;
                }
                if (!xMPNode3.isImplicit()) continue;
                xMPNode3.setImplicit(false);
                if (i == 1 && xMPPath.getSegment(i).isAlias() && xMPPath.getSegment(i).getAliasForm() != 0) {
                    xMPNode3.getOptions().setOption(xMPPath.getSegment(i).getAliasForm(), true);
                } else if (i < xMPPath.size() - 1 && xMPPath.getSegment(i).getKind() == 1 && !xMPNode3.getOptions().isCompositeProperty()) {
                    xMPNode3.getOptions().setStruct(true);
                }
                if (xMPNode2 != null) continue;
                xMPNode2 = xMPNode3;
            }
        }
        catch (XMPException xMPException) {
            if (xMPNode2 != null) {
                XMPNodeUtils.deleteNode(xMPNode2);
            }
            throw xMPException;
        }
        if (xMPNode2 != null) {
            xMPNode3.getOptions().mergeWith(propertyOptions);
            xMPNode3.setOptions(xMPNode3.getOptions());
        }
        return xMPNode3;
    }

    static void deleteNode(XMPNode xMPNode) {
        XMPNode xMPNode2 = xMPNode.getParent();
        if (xMPNode.getOptions().isQualifier()) {
            xMPNode2.removeQualifier(xMPNode);
        } else {
            xMPNode2.removeChild(xMPNode);
        }
        if (!xMPNode2.hasChildren() && xMPNode2.getOptions().isSchemaNode()) {
            xMPNode2.getParent().removeChild(xMPNode2);
        }
    }

    static void setNodeValue(XMPNode xMPNode, Object object) {
        String string = XMPNodeUtils.serializeNodeValue(object);
        if (!xMPNode.getOptions().isQualifier() || !"xml:lang".equals(xMPNode.getName())) {
            xMPNode.setValue(string);
        } else {
            xMPNode.setValue(Utils.normalizeLangValue(string));
        }
    }

    static PropertyOptions verifySetOptions(PropertyOptions propertyOptions, Object object) throws XMPException {
        if (propertyOptions == null) {
            propertyOptions = new PropertyOptions();
        }
        if (propertyOptions.isArrayAltText()) {
            propertyOptions.setArrayAlternate(true);
        }
        if (propertyOptions.isArrayAlternate()) {
            propertyOptions.setArrayOrdered(true);
        }
        if (propertyOptions.isArrayOrdered()) {
            propertyOptions.setArray(true);
        }
        if (propertyOptions.isCompositeProperty() && object != null && object.toString().length() > 0) {
            throw new XMPException("Structs and arrays can't have values", 103);
        }
        propertyOptions.assertConsistency(propertyOptions.getOptions());
        return propertyOptions;
    }

    static String serializeNodeValue(Object object) {
        String string;
        if (object == null) {
            string = null;
        } else if (object instanceof Boolean) {
            string = XMPUtils.convertFromBoolean((Boolean)object);
        } else if (object instanceof Integer) {
            string = XMPUtils.convertFromInteger((Integer)object);
        } else if (object instanceof Long) {
            string = XMPUtils.convertFromLong((Long)object);
        } else if (object instanceof Double) {
            string = XMPUtils.convertFromDouble((Double)object);
        } else if (object instanceof XMPDateTime) {
            string = XMPUtils.convertFromDate((XMPDateTime)object);
        } else if (object instanceof GregorianCalendar) {
            XMPDateTime xMPDateTime = XMPDateTimeFactory.createFromCalendar((GregorianCalendar)object);
            string = XMPUtils.convertFromDate(xMPDateTime);
        } else {
            string = object instanceof byte[] ? XMPUtils.encodeBase64((byte[])object) : object.toString();
        }
        return string != null ? Utils.removeControlChars(string) : null;
    }

    private static XMPNode followXPathStep(XMPNode xMPNode, XMPPathSegment xMPPathSegment, boolean bl) throws XMPException {
        XMPNode xMPNode2 = null;
        int n = 0;
        int n2 = xMPPathSegment.getKind();
        if (n2 == 1) {
            xMPNode2 = XMPNodeUtils.findChildNode(xMPNode, xMPPathSegment.getName(), bl);
        } else if (n2 == 2) {
            xMPNode2 = XMPNodeUtils.findQualifierNode(xMPNode, xMPPathSegment.getName().substring(1), bl);
        } else {
            if (!xMPNode.getOptions().isArray()) {
                throw new XMPException("Indexing applied to non-array", 102);
            }
            if (n2 == 3) {
                n = XMPNodeUtils.findIndexedItem(xMPNode, xMPPathSegment.getName(), bl);
            } else if (n2 == 4) {
                n = xMPNode.getChildrenLength();
            } else if (n2 == 6) {
                String[] stringArray = Utils.splitNameAndValue(xMPPathSegment.getName());
                String string = stringArray[0];
                String string2 = stringArray[1];
                n = XMPNodeUtils.lookupFieldSelector(xMPNode, string, string2);
            } else if (n2 == 5) {
                String[] stringArray = Utils.splitNameAndValue(xMPPathSegment.getName());
                String string = stringArray[0];
                String string3 = stringArray[1];
                n = XMPNodeUtils.lookupQualSelector(xMPNode, string, string3, xMPPathSegment.getAliasForm());
            } else {
                throw new XMPException("Unknown array indexing step in FollowXPathStep", 9);
            }
            if (1 <= n && n <= xMPNode.getChildrenLength()) {
                xMPNode2 = xMPNode.getChild(n);
            }
        }
        return xMPNode2;
    }

    private static XMPNode findQualifierNode(XMPNode xMPNode, String string, boolean bl) throws XMPException {
        assert (!string.startsWith("?"));
        XMPNode xMPNode2 = xMPNode.findQualifierByName(string);
        if (xMPNode2 == null && bl) {
            xMPNode2 = new XMPNode(string, null);
            xMPNode2.setImplicit(true);
            xMPNode.addQualifier(xMPNode2);
        }
        return xMPNode2;
    }

    private static int findIndexedItem(XMPNode xMPNode, String string, boolean bl) throws XMPException {
        int n = 0;
        try {
            string = string.substring(1, string.length() - 1);
            n = Integer.parseInt(string);
            if (n < 1) {
                throw new XMPException("Array index must be larger than zero", 102);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMPException("Array index not digits.", 102);
        }
        if (bl && n == xMPNode.getChildrenLength() + 1) {
            XMPNode xMPNode2 = new XMPNode("[]", null);
            xMPNode2.setImplicit(true);
            xMPNode.addChild(xMPNode2);
        }
        return n;
    }

    private static int lookupFieldSelector(XMPNode xMPNode, String string, String string2) throws XMPException {
        int n = -1;
        block0: for (int i = 1; i <= xMPNode.getChildrenLength() && n < 0; ++i) {
            XMPNode xMPNode2 = xMPNode.getChild(i);
            if (!xMPNode2.getOptions().isStruct()) {
                throw new XMPException("Field selector must be used on array of struct", 102);
            }
            for (int j = 1; j <= xMPNode2.getChildrenLength(); ++j) {
                XMPNode xMPNode3 = xMPNode2.getChild(j);
                if (!string.equals(xMPNode3.getName()) || !string2.equals(xMPNode3.getValue())) continue;
                n = i;
                continue block0;
            }
        }
        return n;
    }

    private static int lookupQualSelector(XMPNode xMPNode, String string, String string2, int n) throws XMPException {
        if ("xml:lang".equals(string)) {
            int n2 = XMPNodeUtils.lookupLanguageItem(xMPNode, string2 = Utils.normalizeLangValue(string2));
            if (n2 < 0 && (n & 0x1000) > 0) {
                XMPNode xMPNode2 = new XMPNode("[]", null);
                XMPNode xMPNode3 = new XMPNode("xml:lang", "x-default", null);
                xMPNode2.addQualifier(xMPNode3);
                xMPNode.addChild(1, xMPNode2);
                return 1;
            }
            return n2;
        }
        for (int i = 1; i < xMPNode.getChildrenLength(); ++i) {
            XMPNode xMPNode4 = xMPNode.getChild(i);
            Iterator iterator = xMPNode4.iterateQualifier();
            while (iterator.hasNext()) {
                XMPNode xMPNode5 = (XMPNode)iterator.next();
                if (!string.equals(xMPNode5.getName()) || !string2.equals(xMPNode5.getValue())) continue;
                return i;
            }
        }
        return -1;
    }

    static void normalizeLangArray(XMPNode xMPNode) {
        if (!xMPNode.getOptions().isArrayAltText()) {
            return;
        }
        for (int i = 2; i <= xMPNode.getChildrenLength(); ++i) {
            XMPNode xMPNode2;
            block4: {
                xMPNode2 = xMPNode.getChild(i);
                if (!xMPNode2.hasQualifier() || !"x-default".equals(xMPNode2.getQualifier(1).getValue())) continue;
                try {
                    xMPNode.removeChild(i);
                    xMPNode.addChild(1, xMPNode2);
                }
                catch (XMPException xMPException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            if (i != 2) break;
            xMPNode.getChild(2).setValue(xMPNode2.getValue());
            break;
        }
    }

    static void detectAltText(XMPNode xMPNode) {
        if (xMPNode.getOptions().isArrayAlternate() && xMPNode.hasChildren()) {
            boolean bl = false;
            Iterator iterator = xMPNode.iterateChildren();
            while (iterator.hasNext()) {
                XMPNode xMPNode2 = (XMPNode)iterator.next();
                if (!xMPNode2.getOptions().getHasLanguage()) continue;
                bl = true;
                break;
            }
            if (bl) {
                xMPNode.getOptions().setArrayAltText(true);
                XMPNodeUtils.normalizeLangArray(xMPNode);
            }
        }
    }

    static void appendLangItem(XMPNode xMPNode, String string, String string2) throws XMPException {
        XMPNode xMPNode2 = new XMPNode("[]", string2, null);
        XMPNode xMPNode3 = new XMPNode("xml:lang", string, null);
        xMPNode2.addQualifier(xMPNode3);
        if (!"x-default".equals(xMPNode3.getValue())) {
            xMPNode.addChild(xMPNode2);
        } else {
            xMPNode.addChild(1, xMPNode2);
        }
    }

    static Object[] chooseLocalizedText(XMPNode xMPNode, String string, String string2) throws XMPException {
        if (!xMPNode.getOptions().isArrayAltText()) {
            throw new XMPException("Localized text array is not alt-text", 102);
        }
        if (!xMPNode.hasChildren()) {
            return new Object[]{new Integer(0), null};
        }
        int n = 0;
        XMPNode xMPNode2 = null;
        XMPNode xMPNode3 = null;
        Iterator iterator = xMPNode.iterateChildren();
        while (iterator.hasNext()) {
            XMPNode xMPNode4 = (XMPNode)iterator.next();
            if (xMPNode4.getOptions().isCompositeProperty()) {
                throw new XMPException("Alt-text array item is not simple", 102);
            }
            if (!xMPNode4.hasQualifier() || !"xml:lang".equals(xMPNode4.getQualifier(1).getName())) {
                throw new XMPException("Alt-text array item has no language qualifier", 102);
            }
            String string3 = xMPNode4.getQualifier(1).getValue();
            if (string2.equals(string3)) {
                return new Object[]{new Integer(1), xMPNode4};
            }
            if (string != null && string3.startsWith(string)) {
                if (xMPNode2 == null) {
                    xMPNode2 = xMPNode4;
                }
                ++n;
                continue;
            }
            if (!"x-default".equals(string3)) continue;
            xMPNode3 = xMPNode4;
        }
        if (n == 1) {
            return new Object[]{new Integer(2), xMPNode2};
        }
        if (n > 1) {
            return new Object[]{new Integer(3), xMPNode2};
        }
        if (xMPNode3 != null) {
            return new Object[]{new Integer(4), xMPNode3};
        }
        return new Object[]{new Integer(5), xMPNode.getChild(1)};
    }

    static int lookupLanguageItem(XMPNode xMPNode, String string) throws XMPException {
        if (!xMPNode.getOptions().isArray()) {
            throw new XMPException("Language item must be used on array", 102);
        }
        for (int i = 1; i <= xMPNode.getChildrenLength(); ++i) {
            XMPNode xMPNode2 = xMPNode.getChild(i);
            if (!xMPNode2.hasQualifier() || !"xml:lang".equals(xMPNode2.getQualifier(1).getName()) || !string.equals(xMPNode2.getQualifier(1).getValue())) continue;
            return i;
        }
        return -1;
    }
}

