/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.solr.search.SyntaxError;

class ScoreModeParser {
    private static final Map<String, ScoreMode> lowerAndCapitalCase = Collections.unmodifiableMap(new HashMap<String, ScoreMode>(){
        {
            for (ScoreMode s : ScoreMode.values()) {
                this.put(s.name().toLowerCase(Locale.ROOT), s);
                this.put(s.name(), s);
            }
        }
    });

    private ScoreModeParser() {
    }

    static ScoreMode parse(String score) throws SyntaxError {
        ScoreMode scoreMode = lowerAndCapitalCase.get(score);
        if (scoreMode == null) {
            throw new SyntaxError("Unable to parse ScoreMode from: " + score);
        }
        return scoreMode;
    }
}

