/*
 * Decompiled with CFR 0.152.
 */
package com.tomgibara.crinch.hashing;

import java.math.BigInteger;

public class HashRange {
    private static final BigInteger INT_MINIMUM = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INT_MAXIMUM = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger LONG_MINIMUM = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAXIMUM = BigInteger.valueOf(Long.MAX_VALUE);
    public static final HashRange FULL_INT_RANGE = new HashRange(INT_MINIMUM, INT_MAXIMUM);
    public static final HashRange POSITIVE_INT_RANGE = new HashRange(BigInteger.ONE, INT_MAXIMUM);
    public static final HashRange FULL_LONG_RANGE = new HashRange(LONG_MINIMUM, LONG_MAXIMUM);
    public static final HashRange POSITIVE_LONG_RANGE = new HashRange(BigInteger.ONE, LONG_MAXIMUM);
    private final BigInteger minimum;
    private final BigInteger maximum;
    private final boolean intBounded;
    private final boolean longBounded;
    private BigInteger size = null;
    private Boolean intSized = null;
    private Boolean longSized = null;

    public HashRange(BigInteger minimum, BigInteger maximum) {
        if (minimum == null) {
            throw new IllegalArgumentException();
        }
        if (maximum == null) {
            throw new IllegalArgumentException();
        }
        if (minimum.compareTo(maximum) > 0) {
            throw new IllegalArgumentException();
        }
        this.minimum = minimum;
        this.maximum = maximum;
        this.intBounded = minimum.compareTo(INT_MINIMUM) >= 0 && maximum.compareTo(INT_MAXIMUM) <= 0;
        this.longBounded = minimum.compareTo(LONG_MINIMUM) >= 0 && maximum.compareTo(LONG_MAXIMUM) <= 0;
    }

    public HashRange(int minimum, int maximum) {
        this(BigInteger.valueOf(minimum), BigInteger.valueOf(maximum));
    }

    public HashRange(long minimum, long maximum) {
        this(BigInteger.valueOf(minimum), BigInteger.valueOf(maximum));
    }

    public boolean isZeroBased() {
        return this.minimum.signum() == 0;
    }

    public boolean isIntBounded() {
        return this.intBounded;
    }

    public boolean isLongBounded() {
        return this.longBounded;
    }

    public BigInteger getMinimum() {
        return this.minimum;
    }

    public BigInteger getMaximum() {
        return this.maximum;
    }

    public BigInteger getSize() {
        return this.size == null ? (this.size = this.maximum.subtract(this.minimum).add(BigInteger.ONE)) : this.size;
    }

    public boolean isIntSized() {
        if (this.intSized == null) {
            this.intSized = this.getSize().compareTo(INT_MAXIMUM) <= 0;
        }
        return this.intSized;
    }

    public boolean isLongSized() {
        if (this.longSized == null) {
            this.longSized = this.getSize().compareTo(LONG_MAXIMUM) <= 0;
        }
        return this.longSized;
    }

    public HashRange zeroBased() {
        return this.isZeroBased() ? this : new HashRange(BigInteger.ZERO, this.maximum.subtract(this.minimum));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HashRange)) {
            return false;
        }
        HashRange that = (HashRange)obj;
        return this.minimum.equals(that.minimum) && this.maximum.equals(that.maximum);
    }

    public int hashCode() {
        return this.minimum.hashCode() ^ 7 * this.maximum.hashCode();
    }

    public String toString() {
        return "[" + this.minimum + ", " + this.maximum + "]";
    }
}

