/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.util.SimplePostTool;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobRepository {
    private static final long MAX_JAR_SIZE = Long.parseLong(System.getProperty("runtme.lib.size", String.valueOf(0x500000)));
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final Random RANDOM;
    static final Pattern BLOB_KEY_PATTERN_CHECKER;
    private final CoreContainer coreContainer;
    private Map<String, BlobContent> blobs = this.createMap();
    static String INVALID_JAR_MSG;

    ConcurrentHashMap<String, BlobContent> createMap() {
        return new ConcurrentHashMap<String, BlobContent>();
    }

    public BlobRepository(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    public BlobContentRef<ByteBuffer> getBlobIncRef(String key) {
        return this.getBlobIncRef(key, () -> this.addBlob(key));
    }

    BlobContentRef<Object> getBlobIncRef(String key, Decoder<Object> decoder) {
        return this.getBlobIncRef(key.concat(decoder.getName()), () -> this.addBlob(key, decoder));
    }

    BlobContentRef getBlobIncRef(String key, Decoder decoder, String url, String sha512) {
        StringBuffer keyBuilder = new StringBuffer(key);
        if (decoder != null) {
            keyBuilder.append(decoder.getName());
        }
        keyBuilder.append("/").append(sha512);
        return this.getBlobIncRef(keyBuilder.toString(), () -> new BlobContent(key, this.fetchBlobAndVerify(key, url, sha512), decoder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BlobContentRef<T> getBlobIncRef(String key, Callable<BlobContent<T>> blobCreator) {
        BlobContent<T> aBlob;
        if (this.coreContainer.isZooKeeperAware()) {
            Map<String, BlobContent> map = this.blobs;
            synchronized (map) {
                aBlob = this.blobs.get(key);
                if (aBlob == null) {
                    try {
                        aBlob = blobCreator.call();
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Blob loading failed: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Blob loading is not supported in non-cloud mode");
        BlobContentRef ref = new BlobContentRef(aBlob);
        Set set = ((BlobContent)aBlob).references;
        synchronized (set) {
            ((BlobContent)aBlob).references.add(ref);
        }
        return ref;
    }

    private BlobContent<ByteBuffer> addBlob(String key) {
        ByteBuffer b = this.fetchBlob(key);
        BlobContent<ByteBuffer> aBlob = new BlobContent<ByteBuffer>(key, b);
        this.blobs.put(key, aBlob);
        return aBlob;
    }

    private BlobContent<Object> addBlob(String key, Decoder<Object> decoder) {
        ByteBuffer b = this.fetchBlob(key);
        String keyPlusName = key + decoder.getName();
        BlobContent<Object> aBlob = new BlobContent<Object>(keyPlusName, b, decoder);
        this.blobs.put(keyPlusName, aBlob);
        return aBlob;
    }

    private ByteBuffer fetchBlobAndVerify(String key, String url, String sha512) {
        ByteBuffer byteBuffer = this.fetchFromUrl(key, url);
        String computedDigest = BlobRepository.sha512Digest(byteBuffer);
        if (!computedDigest.equals(sha512)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, StrUtils.formatString((String)INVALID_JAR_MSG, (Object[])new Object[]{url, sha512, computedDigest}));
        }
        return byteBuffer;
    }

    public static String sha512Digest(ByteBuffer byteBuffer) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        digest.update(byteBuffer);
        return String.format(Locale.ROOT, "%0128x", new BigInteger(1, digest.digest()));
    }

    ByteBuffer fetchBlob(String key) {
        Replica replica = this.getSystemCollReplica();
        String url = replica.getStr("base_url") + "/" + ".system" + "/blob/" + key + "?wt=filestream";
        return this.fetchFromUrl(key, url);
    }

    ByteBuffer fetchFromUrl(String key, String url) {
        ByteBuffer b;
        HttpClient httpClient = this.coreContainer.getUpdateShardHandler().getDefaultHttpClient();
        HttpGet httpGet = new HttpGet(url);
        HttpResponse response = null;
        HttpEntity entity = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "no such blob or version available: " + key);
            }
            try (InputStream is = entity.getContent();){
                b = SimplePostTool.inputStreamToByteArray(is, MAX_JAR_SIZE);
            }
        }
        catch (Exception e) {
            try {
                if (e instanceof SolrException) {
                    throw (SolrException)((Object)e);
                }
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "could not load : " + key, (Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.consumeFully(entity);
                throw throwable;
            }
        }
        Utils.consumeFully((HttpEntity)entity);
        return b;
    }

    private Replica getSystemCollReplica() {
        ZkStateReader zkStateReader = this.coreContainer.getZkController().getZkStateReader();
        ClusterState cs = zkStateReader.getClusterState();
        DocCollection coll = cs.getCollectionOrNull(".system");
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, ".system collection not available");
        }
        ArrayList slices = new ArrayList(coll.getActiveSlices());
        if (slices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No active slices for .system collection");
        }
        Collections.shuffle(slices, RANDOM);
        Replica replica = null;
        block0: for (Slice slice : slices) {
            ArrayList replicas = new ArrayList(slice.getReplicasMap().values());
            Collections.shuffle(replicas, RANDOM);
            for (Replica r : replicas) {
                if (r.getState() != Replica.State.ACTIVE) continue;
                if (zkStateReader.getClusterState().getLiveNodes().contains(r.get("node_name"))) {
                    replica = r;
                    continue block0;
                }
                log.info("replica {} says it is active but not a member of live nodes", r.get("node_name"));
            }
        }
        if (replica == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No active replica available for .system collection");
        }
        return replica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementBlobRefCount(BlobContentRef ref) {
        if (ref == null) {
            return;
        }
        Set set = ref.blob.references;
        synchronized (set) {
            if (!ref.blob.references.remove(ref)) {
                log.error("Multiple releases for the same reference");
            }
            if (ref.blob.references.isEmpty()) {
                this.blobs.remove(ref.blob.key);
            }
        }
    }

    static {
        BLOB_KEY_PATTERN_CHECKER = Pattern.compile(".*/\\d+");
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
        INVALID_JAR_MSG = "Invalid jar from {0} , expected sha512 hash : {1} , actual : {2}";
    }

    public static class BlobContentRef<T> {
        public final BlobContent<T> blob;

        private BlobContentRef(BlobContent<T> blob) {
            this.blob = blob;
        }
    }

    public static interface Decoder<T> {
        default public String getName() {
            return "";
        }

        public T decode(InputStream var1);
    }

    public static class BlobContent<T> {
        public final String key;
        private final T content;
        private final Set<BlobContentRef> references = new HashSet<BlobContentRef>();

        public BlobContent(String key, ByteBuffer buffer, Decoder<T> decoder) {
            this.key = key;
            this.content = decoder == null ? buffer : decoder.decode((InputStream)new ByteBufferInputStream(buffer));
        }

        public BlobContent(String key, ByteBuffer buffer) {
            this.key = key;
            this.content = buffer;
        }

        public T get() {
            return this.content;
        }
    }
}

