/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.calcite.runtime.GeoFunctions;
import org.apache.calcite.sql.type.SqlTypeName;

public class JavaToSqlTypeConversionRules {
    private static final JavaToSqlTypeConversionRules INSTANCE = new JavaToSqlTypeConversionRules();
    private final Map<Class<?>, SqlTypeName> rules = ImmutableMap.builder().put(Integer.class, (Object)SqlTypeName.INTEGER).put(Integer.TYPE, (Object)SqlTypeName.INTEGER).put(Long.class, (Object)SqlTypeName.BIGINT).put(Long.TYPE, (Object)SqlTypeName.BIGINT).put(Short.class, (Object)SqlTypeName.SMALLINT).put(Short.TYPE, (Object)SqlTypeName.SMALLINT).put(Byte.TYPE, (Object)SqlTypeName.TINYINT).put(Byte.class, (Object)SqlTypeName.TINYINT).put(Float.class, (Object)SqlTypeName.REAL).put(Float.TYPE, (Object)SqlTypeName.REAL).put(Double.class, (Object)SqlTypeName.DOUBLE).put(Double.TYPE, (Object)SqlTypeName.DOUBLE).put(Boolean.TYPE, (Object)SqlTypeName.BOOLEAN).put(Boolean.class, (Object)SqlTypeName.BOOLEAN).put(byte[].class, (Object)SqlTypeName.VARBINARY).put(String.class, (Object)SqlTypeName.VARCHAR).put(char[].class, (Object)SqlTypeName.VARCHAR).put(Character.class, (Object)SqlTypeName.CHAR).put(Character.TYPE, (Object)SqlTypeName.CHAR).put(java.util.Date.class, (Object)SqlTypeName.TIMESTAMP).put(Date.class, (Object)SqlTypeName.DATE).put(Timestamp.class, (Object)SqlTypeName.TIMESTAMP).put(Time.class, (Object)SqlTypeName.TIME).put(BigDecimal.class, (Object)SqlTypeName.DECIMAL).put(GeoFunctions.Geom.class, (Object)SqlTypeName.GEOMETRY).put(ResultSet.class, (Object)SqlTypeName.CURSOR).put(ColumnList.class, (Object)SqlTypeName.COLUMN_LIST).put(ArrayImpl.class, (Object)SqlTypeName.ARRAY).put(List.class, (Object)SqlTypeName.ARRAY).build();

    public static JavaToSqlTypeConversionRules instance() {
        return INSTANCE;
    }

    public SqlTypeName lookup(Class javaClass) {
        return this.rules.get(javaClass);
    }

    private static interface ColumnList
    extends List {
    }
}

