/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute.constraint;

import java.lang.annotation.Annotation;
import org.carrot2.util.attribute.constraint.Constraint;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;

@Root(name="implementing-classes")
class ImplementingClassesConstraint
extends Constraint {
    private Class<?>[] classes;
    @ElementArray(name="classes", entry="class")
    private String[] classesAsStrings;
    @Attribute
    private boolean strict;

    ImplementingClassesConstraint() {
    }

    @Override
    protected boolean isMet(Object value) {
        Class<?> target;
        if (value == null) {
            return true;
        }
        if (value instanceof Class) {
            target = (Class<?>)value;
            if (target.isInterface()) {
                return false;
            }
        } else {
            target = value.getClass();
        }
        for (Class<?> clazz : this.classes) {
            if (!clazz.isAssignableFrom(target)) continue;
            return true;
        }
        return !this.strict;
    }

    @Override
    protected void populateCustom(Annotation annotation) {
        ImplementingClasses implementingClasses = (ImplementingClasses)annotation;
        this.classes = implementingClasses.classes();
        this.strict = implementingClasses.strict();
        this.classesAsStrings = new String[this.classes.length];
        for (int i = 0; i < this.classes.length; ++i) {
            this.classesAsStrings[i] = this.classes[i].getCanonicalName();
        }
    }

    public static void main(String[] args) {
        System.out.println(String[][].class.getSimpleName());
    }
}

