/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.Var2Data;

public final class MPPUtility {
    private static final int[] PASSWORD_MASK = new int[]{60, 30, 48, 2, 6, 14, 8, 22, 44, 12, 38, 10, 62, 16, 34, 24};
    private static final int MINIMUM_PASSWORD_DATA_LENGTH = 64;
    private static final long EPOCH = 441676800000L;
    private static Date EPOCH_DATE = DateHelper.getTimestampFromLong(441676800000L);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int DURATION_UNITS_MASK = 31;

    private MPPUtility() {
    }

    public static final void decodeBuffer(byte[] byArray, byte by) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray[i] ^ by);
        }
    }

    public static final String decodePassword(byte[] byArray, byte by) {
        String string;
        if (byArray.length < 64) {
            string = null;
        } else {
            int n;
            char c;
            MPPUtility.decodeBuffer(byArray, by);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < PASSWORD_MASK.length && (c = (char)byArray[n = PASSWORD_MASK[i]]) != '\u0000'; ++i) {
                stringBuilder.append(c);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static final void getByteArray(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        System.arraycopy(byArray, n, byArray2, n3, n2);
    }

    public static final int getByte(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        return n2;
    }

    public static final int getShort(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 16; i += 8) {
            n2 |= (byArray[n3] & 0xFF) << i;
            ++n3;
        }
        return n2;
    }

    public static final int getInt(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 32; i += 8) {
            n2 |= (byArray[n3] & 0xFF) << i;
            ++n3;
        }
        return n2;
    }

    public static final long getLong(byte[] byArray, int n) {
        long l = 0L;
        int n2 = n;
        for (int i = 0; i < 64; i += 8) {
            l |= (long)(byArray[n2] & 0xFF) << i;
            ++n2;
        }
        return l;
    }

    public static final long getLong6(byte[] byArray, int n) {
        long l = 0L;
        int n2 = n;
        for (int i = 0; i < 48; i += 8) {
            l |= (long)(byArray[n2] & 0xFF) << i;
            ++n2;
        }
        return l;
    }

    public static final double getDouble(byte[] byArray, int n) {
        double d = Double.longBitsToDouble(MPPUtility.getLong(byArray, n));
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    public static final UUID getGUID(byte[] byArray, int n) {
        UUID uUID = null;
        if (byArray != null && byArray.length > 15) {
            long l = 0L;
            l |= (long)(byArray[n + 3] & 0xFF) << 56;
            l |= (long)(byArray[n + 2] & 0xFF) << 48;
            l |= (long)(byArray[n + 1] & 0xFF) << 40;
            l |= (long)(byArray[n + 0] & 0xFF) << 32;
            l |= (long)(byArray[n + 5] & 0xFF) << 24;
            l |= (long)(byArray[n + 4] & 0xFF) << 16;
            l |= (long)(byArray[n + 7] & 0xFF) << 8;
            l |= (long)(byArray[n + 6] & 0xFF) << 0;
            long l2 = 0L;
            l2 |= (long)(byArray[n + 8] & 0xFF) << 56;
            l2 |= (long)(byArray[n + 9] & 0xFF) << 48;
            l2 |= (long)(byArray[n + 10] & 0xFF) << 40;
            l2 |= (long)(byArray[n + 11] & 0xFF) << 32;
            l2 |= (long)(byArray[n + 12] & 0xFF) << 24;
            l2 |= (long)(byArray[n + 13] & 0xFF) << 16;
            l2 |= (long)(byArray[n + 14] & 0xFF) << 8;
            uUID = new UUID(l, l2 |= (long)(byArray[n + 15] & 0xFF) << 0);
        }
        return uUID;
    }

    public static final Date getDate(byte[] byArray, int n) {
        long l = MPPUtility.getShort(byArray, n);
        Date date = l == 65535L ? null : DateHelper.getDateFromLong(441676800000L + l * 86400000L);
        return date;
    }

    public static final Date getTime(byte[] byArray, int n) {
        int n2 = MPPUtility.getShort(byArray, n) / 10;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(EPOCH_DATE);
        calendar.set(11, n2 / 60);
        calendar.set(12, n2 % 60);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static final long getDuration(byte[] byArray, int n) {
        return (long)MPPUtility.getShort(byArray, n) * 60000L / 10L;
    }

    public static final Date getTimestamp(byte[] byArray, int n) {
        Date date;
        long l = MPPUtility.getShort(byArray, n + 2);
        if (l < 100L) {
            l = 0L;
        }
        if (l == 0L || l == 65535L) {
            date = null;
        } else {
            long l2 = MPPUtility.getShort(byArray, n);
            if (l2 == 65535L) {
                l2 = 0L;
            }
            date = DateHelper.getTimestampFromLong(441676800000L + l * 86400000L + l2 * 60000L / 10L);
        }
        return date;
    }

    public static final Date getTimestampFromTenths(byte[] byArray, int n) {
        long l = (long)MPPUtility.getInt(byArray, n) * 6000L;
        return DateHelper.getTimestampFromLong(441676800000L + l);
    }

    public static final String getUnicodeString(byte[] byArray, int n) {
        int n2 = MPPUtility.getUnicodeStringLengthInBytes(byArray, n);
        return n2 == 0 ? "" : new String(byArray, n, n2, CharsetHelper.UTF16LE);
    }

    public static final String getUnicodeString(byte[] byArray, int n, int n2) {
        int n3 = MPPUtility.getUnicodeStringLengthInBytes(byArray, n);
        if (n2 > 0 && n3 > n2) {
            n3 = n2;
        }
        return n3 == 0 ? "" : new String(byArray, n, n3, CharsetHelper.UTF16LE);
    }

    private static final int getUnicodeStringLengthInBytes(byte[] byArray, int n) {
        int n2;
        if (byArray == null || n >= byArray.length) {
            n2 = 0;
        } else {
            n2 = byArray.length - n;
            for (int i = n; i < byArray.length - 1; i += 2) {
                if (byArray[i] != 0 || byArray[i + 1] != 0) continue;
                n2 = i - n;
                break;
            }
        }
        return n2;
    }

    public static final String getString(byte[] byArray, int n) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n + n2 < byArray.length && (c = (char)byArray[n + n2]) != '\u0000') {
            stringBuilder.append(c);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static final Duration getDuration(int n, TimeUnit timeUnit) {
        return MPPUtility.getDuration((double)n, timeUnit);
    }

    public static final Color getColor(byte[] byArray, int n) {
        Color color = null;
        if (MPPUtility.getByte(byArray, n + 3) == 0) {
            int n2 = MPPUtility.getByte(byArray, n);
            int n3 = MPPUtility.getByte(byArray, n + 1);
            int n4 = MPPUtility.getByte(byArray, n + 2);
            color = new Color(n2, n3, n4);
        }
        return color;
    }

    public static final Duration getDuration(double d, TimeUnit timeUnit) {
        double d2;
        switch (timeUnit) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                d2 = d / 10.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                d2 = d / 600.0;
                break;
            }
            case DAYS: {
                d2 = d / 4800.0;
                break;
            }
            case ELAPSED_DAYS: {
                d2 = d / 14400.0;
                break;
            }
            case WEEKS: {
                d2 = d / 24000.0;
                break;
            }
            case ELAPSED_WEEKS: {
                d2 = d / 100800.0;
                break;
            }
            case MONTHS: {
                d2 = d / 96000.0;
                break;
            }
            case ELAPSED_MONTHS: {
                d2 = d / 432000.0;
                break;
            }
            default: {
                d2 = d;
            }
        }
        return Duration.getInstance(d2, timeUnit);
    }

    public static final TimeUnit getDurationTimeUnits(int n) {
        return MPPUtility.getDurationTimeUnits(n, null);
    }

    public static final TimeUnit getDurationTimeUnits(int n, TimeUnit timeUnit) {
        TimeUnit timeUnit2;
        switch (n & 0x1F) {
            case 3: {
                timeUnit2 = TimeUnit.MINUTES;
                break;
            }
            case 4: {
                timeUnit2 = TimeUnit.ELAPSED_MINUTES;
                break;
            }
            case 5: {
                timeUnit2 = TimeUnit.HOURS;
                break;
            }
            case 6: {
                timeUnit2 = TimeUnit.ELAPSED_HOURS;
                break;
            }
            case 8: {
                timeUnit2 = TimeUnit.ELAPSED_DAYS;
                break;
            }
            case 9: {
                timeUnit2 = TimeUnit.WEEKS;
                break;
            }
            case 10: {
                timeUnit2 = TimeUnit.ELAPSED_WEEKS;
                break;
            }
            case 11: {
                timeUnit2 = TimeUnit.MONTHS;
                break;
            }
            case 12: {
                timeUnit2 = TimeUnit.ELAPSED_MONTHS;
                break;
            }
            case 19: {
                timeUnit2 = TimeUnit.PERCENT;
                break;
            }
            case 20: {
                timeUnit2 = TimeUnit.ELAPSED_PERCENT;
                break;
            }
            case 7: {
                timeUnit2 = TimeUnit.DAYS;
                break;
            }
            case 21: {
                timeUnit2 = timeUnit == null ? TimeUnit.DAYS : timeUnit;
                break;
            }
            default: {
                timeUnit2 = TimeUnit.DAYS;
            }
        }
        return timeUnit2;
    }

    public static Duration getAdjustedDuration(ProjectProperties projectProperties, int n, TimeUnit timeUnit) {
        Duration duration = null;
        if (n != -1) {
            switch (timeUnit) {
                case DAYS: {
                    double d = projectProperties.getMinutesPerDay().doubleValue() * 10.0;
                    double d2 = 0.0;
                    if (d != 0.0) {
                        d2 = (double)n / d;
                    }
                    duration = Duration.getInstance(d2, timeUnit);
                    break;
                }
                case ELAPSED_DAYS: {
                    double d = 14400.0;
                    double d3 = (double)n / d;
                    duration = Duration.getInstance(d3, timeUnit);
                    break;
                }
                case WEEKS: {
                    double d = projectProperties.getMinutesPerWeek().doubleValue() * 10.0;
                    double d4 = 0.0;
                    if (d != 0.0) {
                        d4 = (double)n / d;
                    }
                    duration = Duration.getInstance(d4, timeUnit);
                    break;
                }
                case ELAPSED_WEEKS: {
                    double d = 100800.0;
                    double d5 = (double)n / d;
                    duration = Duration.getInstance(d5, timeUnit);
                    break;
                }
                case MONTHS: {
                    double d = projectProperties.getMinutesPerDay().doubleValue() * projectProperties.getDaysPerMonth().doubleValue() * 10.0;
                    double d6 = 0.0;
                    if (d != 0.0) {
                        d6 = (double)n / d;
                    }
                    duration = Duration.getInstance(d6, timeUnit);
                    break;
                }
                case ELAPSED_MONTHS: {
                    double d = 432000.0;
                    double d7 = (double)n / d;
                    duration = Duration.getInstance(d7, timeUnit);
                    break;
                }
                default: {
                    duration = MPPUtility.getDuration(n, timeUnit);
                }
            }
        }
        return duration;
    }

    public static TimeUnit getWorkTimeUnits(int n) {
        return TimeUnit.getInstance(n - 1);
    }

    public static CurrencySymbolPosition getSymbolPosition(int n) {
        CurrencySymbolPosition currencySymbolPosition;
        switch (n) {
            case 1: {
                currencySymbolPosition = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                currencySymbolPosition = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                currencySymbolPosition = CurrencySymbolPosition.AFTER_WITH_SPACE;
                break;
            }
            default: {
                currencySymbolPosition = CurrencySymbolPosition.BEFORE;
            }
        }
        return currencySymbolPosition;
    }

    public static final String removeAmpersands(String string) {
        if (string != null && string.indexOf(38) != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '&') continue;
                stringBuilder.append(c);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static final Double getPercentage(byte[] byArray, int n) {
        int n2 = MPPUtility.getShort(byArray, n);
        Double d = null;
        if (n2 >= 0 && n2 <= 100) {
            d = NumberHelper.getDouble(n2);
        }
        return d;
    }

    public static final byte[] cloneSubArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static final String hexdump(byte[] byArray, int n, int n2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null) {
            int n3;
            int n4 = n + n2;
            for (n3 = n; n3 < n4; ++n3) {
                stringBuilder.append(" ");
                stringBuilder.append(HEX_DIGITS[(byArray[n3] & 0xF0) >> 4]);
                stringBuilder.append(HEX_DIGITS[byArray[n3] & 0xF]);
            }
            if (bl) {
                stringBuilder.append("   ");
                for (n3 = n; n3 < n4; ++n3) {
                    char c = (char)byArray[n3];
                    if (c > '\u00c8' || c < '\u001b') {
                        c = ' ';
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static final String hexdump(byte[] byArray, boolean bl) {
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        return MPPUtility.hexdump(byArray, 0, n, bl);
    }

    public static final String hexdump(byte[] byArray, boolean bl, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null) {
            DecimalFormat decimalFormat = new DecimalFormat("00000");
            for (int i = 0; i < byArray.length; i += n) {
                if (i + n > byArray.length) {
                    n = byArray.length - i;
                }
                stringBuilder.append(string);
                stringBuilder.append(decimalFormat.format(i));
                stringBuilder.append(":");
                stringBuilder.append(MPPUtility.hexdump(byArray, i, n, bl));
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public static final String hexdump(byte[] byArray, int n, int n2, boolean bl, int n3, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byArray != null) {
            DecimalFormat decimalFormat = new DecimalFormat("00000");
            for (int i = n; i < n + n2; i += n3) {
                if (i + n3 > n + n2) {
                    n3 = n + n2 - i;
                }
                stringBuilder.append(string);
                stringBuilder.append(decimalFormat.format(i - n));
                stringBuilder.append(":");
                stringBuilder.append(MPPUtility.hexdump(byArray, i, n3, bl));
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public static final void fileHexDump(String string, byte[] byArray) {
        System.out.println("FILE HEX DUMP");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(MPPUtility.hexdump(byArray, true, 16, "").getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static final void fileHexDump(String string, InputStream inputStream) {
        try {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            MPPUtility.fileHexDump(string, byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static final void fileDump(String string, byte[] byArray) {
        System.out.println("FILE DUMP");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static final void dataDump(ProjectProperties projectProperties, byte[] byArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        System.out.println("DATA");
        if (byArray != null) {
            System.out.println(MPPUtility.hexdump(byArray, false, 16, ""));
            for (int i = 0; i < byArray.length; ++i) {
                int n;
                if (bl) {
                    try {
                        n = MPPUtility.getShort(byArray, i);
                        System.out.println(i + ":" + n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl2) {
                    try {
                        n = MPPUtility.getInt(byArray, i);
                        System.out.println(i + ":" + n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl3) {
                    try {
                        double d = MPPUtility.getDouble(byArray, i);
                        System.out.println(i + ":" + d);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl4) {
                    try {
                        Date date = MPPUtility.getTimestamp(byArray, i);
                        if (date != null) {
                            System.out.println(i + ":" + date.toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl5) {
                    try {
                        long l = MPPUtility.getDuration(byArray, i);
                        System.out.println(i + ":" + l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl6) {
                    try {
                        Date date = MPPUtility.getDate(byArray, i);
                        if (date != null) {
                            System.out.println(i + ":" + date.toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl7) {
                    try {
                        Date date = MPPUtility.getTime(byArray, i);
                        System.out.println(i + ":" + date.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl8) continue;
                try {
                    System.out.println(i + ":" + MPPUtility.getAdjustedDuration(projectProperties, MPPUtility.getInt(byArray, i), TimeUnit.DAYS));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static final void varDataDump(Var2Data var2Data, Integer n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        System.out.println("VARDATA");
        for (int i = 0; i < 500; ++i) {
            int n2;
            if (bl) {
                try {
                    n2 = var2Data.getShort(n, i);
                    System.out.println(i + ":" + n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl2) {
                try {
                    n2 = var2Data.getInt(n, i);
                    System.out.println(i + ":" + n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl3) {
                try {
                    double d = var2Data.getDouble(n, i);
                    System.out.println(i + ":" + d);
                    System.out.println(i + ":" + d / 60000.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl4) {
                try {
                    Date date = var2Data.getTimestamp(n, i);
                    if (date != null) {
                        System.out.println(i + ":" + date.toString());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl5) {
                try {
                    String string = var2Data.getUnicodeString(n, i);
                    if (string != null) {
                        System.out.println(i + ":" + string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl6) continue;
            try {
                String string = var2Data.getString(n, i);
                if (string == null) continue;
                System.out.println(i + ":" + string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void dumpBlockData(int n, int n2, byte[] byArray) {
        if (byArray != null) {
            System.out.println(MPPUtility.hexdump(byArray, 0, n, false));
            for (int i = n; i < byArray.length; i += n2) {
                System.out.println(MPPUtility.hexdump(byArray, i, n2, false));
            }
        }
    }

    public static Date getEpochDate() {
        return EPOCH_DATE;
    }
}

