/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.center;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.notifications.NotificationImpl;
import org.netbeans.modules.notifications.NotificationSettings;
import org.netbeans.modules.notifications.Utils;
import org.netbeans.modules.notifications.center.FiltersMenuButton;
import org.netbeans.modules.notifications.center.NotificationCenterManager;
import org.netbeans.modules.notifications.center.NotificationTable;
import org.netbeans.modules.notifications.center.NotificationTableModel;
import org.openide.awt.QuickSearch;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="NotificationCenterTopComponent", iconBase="org/netbeans/modules/notifications/resources/notificationsTC.png", persistenceType=0)
public final class NotificationCenterTopComponent
extends TopComponent {
    private static final int PREVIEW_DETAILS_REFRESH_DELAY = 300;
    private static final int TABLE_REFRESH_PERIOD = 60000;
    private final NotificationCenterManager notificationManager = NotificationCenterManager.getInstance();
    private JPanel detailsPanel;
    private NotificationTable notificationTable;
    private Timer previewRefreshTimer;
    private JScrollPane notificationScroll;
    private final Timer tableRefreshTimer;
    private final NotificationTable.ProcessKeyEventListener tableKeyListener;
    private JPanel pnlSearch;
    private JToggleButton btnSearch;
    private QuickSearch quickSearch;
    private final QuickSearch.Callback filterCallback = new QuickFilterCallback();
    private JLabel lblEmptyDetails;
    private final Font italicFont;
    private JSplitPane splitPane;
    private JToolBar toolBar;

    public NotificationCenterTopComponent() {
        this.tableRefreshTimer = new Timer(60000, new RefreshTimerListener());
        this.tableRefreshTimer.stop();
        this.tableKeyListener = new TableKeyListener();
        this.italicFont = new JLabel().getFont().deriveFont(2);
        this.setName(NbBundle.getMessage(NotificationCenterTopComponent.class, (String)"CTL_NotificationCenterTopComponent"));
        this.setToolTipText(NbBundle.getMessage(NotificationCenterTopComponent.class, (String)"HINT_NotificationCenterTopComponent"));
    }

    private void init() {
        this.initComponents();
        this.detailsPanel = new JPanel(new GridLayout(1, 1));
        Color color = Utils.getTextBackground();
        this.detailsPanel.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        this.lblEmptyDetails = new JLabel(NbBundle.getMessage(NotificationCenterTopComponent.class, (String)"LBL_EmptyDetails"), 0);
        this.lblEmptyDetails.setFont(this.italicFont);
        this.lblEmptyDetails.setEnabled(false);
        JScrollPane scrollPane = new JScrollPane(this.detailsPanel);
        this.splitPane.setRightComponent(scrollPane);
        this.toolBar.setFocusable(false);
        this.toolBar.setFloatable(false);
        this.btnSearch = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/notifications/resources/find16.png", (boolean)true));
        this.btnSearch.setToolTipText(NbBundle.getMessage(NotificationCenterTopComponent.class, (String)"LBL_SearchToolTip"));
        this.btnSearch.setFocusable(false);
        this.btnSearch.setSelected(NotificationSettings.isSearchVisible());
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationCenterTopComponent.this.setSearchVisible(NotificationCenterTopComponent.this.btnSearch.isSelected());
            }
        });
        this.toolBar.add(this.btnSearch);
        this.toolBar.add(new FiltersMenuButton(this.notificationManager.getActiveFilter()));
        this.initLeft();
        this.showDetails();
    }

    private void initLeft() {
        JPanel pnlLeft = new JPanel(new GridBagLayout());
        this.notificationTable = (NotificationTable)((Object)this.notificationManager.getComponent());
        this.initNotificationTable();
        this.notificationScroll = new JScrollPane((Component)((Object)this.notificationTable));
        this.pnlSearch = new JPanel(new GridBagLayout());
        GridBagConstraints searchConstrains = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.quickSearch = QuickSearch.attach((JComponent)this.pnlSearch, (Object)searchConstrains, (QuickSearch.Callback)this.filterCallback, (boolean)true);
        this.pnlSearch.add((Component)new JLabel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setSearchVisible(this.btnSearch.isSelected());
        pnlLeft.add((Component)this.pnlSearch, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        pnlLeft.add((Component)this.notificationScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.splitPane.setLeftComponent(pnlLeft);
    }

    private void initNotificationTable() {
        this.notificationTable.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationImpl notification = NotificationCenterTopComponent.this.getSelectedNotification();
                if (notification != null) {
                    notification.clear();
                }
            }
        });
        this.notificationTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NotificationCenterTopComponent.this.scheduleDetailsRefresh();
            }
        });
    }

    private void updateTableColumnSizes() {
        NotificationTable table = this.notificationTable;
        Font font = this.notificationScroll.getFont();
        FontMetrics fm = this.notificationScroll.getFontMetrics(font.deriveFont(1));
        int maxCharWidth = fm.charWidth('A');
        int inset = 10;
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn priorityColumn = columnModel.getColumn(0);
        String priorName = priorityColumn.getHeaderValue().toString();
        priorityColumn.setPreferredWidth(fm.stringWidth(priorName) + inset);
        TableColumn dateColumn = columnModel.getColumn(2);
        dateColumn.setPreferredWidth(15 * maxCharWidth + inset);
        TableColumn categoryColumn = columnModel.getColumn(3);
        categoryColumn.setPreferredWidth(7 * maxCharWidth + inset);
        TableColumn messageColumn = columnModel.getColumn(1);
        Border border = this.notificationScroll.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this.notificationScroll) : new Insets(0, 0, 0, 0);
        int remainingWidth = this.notificationScroll.getParent().getWidth() - insets.left - insets.right;
        remainingWidth -= 3 * columnModel.getColumnMargin();
        remainingWidth -= priorityColumn.getPreferredWidth();
        remainingWidth -= dateColumn.getPreferredWidth();
        messageColumn.setPreferredWidth(remainingWidth -= categoryColumn.getPreferredWidth());
    }

    private NotificationImpl getSelectedNotification() {
        int selectedRowIndex = this.notificationTable.convertRowIndexToModel(this.notificationTable.getSelectedRow());
        if (selectedRowIndex != -1 && selectedRowIndex < this.notificationTable.getRowCount()) {
            return ((NotificationTableModel)this.notificationTable.getModel()).getEntry(selectedRowIndex);
        }
        return null;
    }

    private void scheduleDetailsRefresh() {
        if (this.previewRefreshTimer == null) {
            this.previewRefreshTimer = new Timer(300, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationCenterTopComponent.this.showDetails();
                }
            });
            this.previewRefreshTimer.setRepeats(false);
        }
        this.previewRefreshTimer.restart();
    }

    private void showDetails() {
        NotificationImpl selected = this.getSelectedNotification();
        this.detailsPanel.removeAll();
        if (selected != null) {
            selected.markAsRead(true);
            JComponent popupComponent = selected.getDetailsComponent();
            this.detailsPanel.add(popupComponent);
        } else {
            this.detailsPanel.add(this.lblEmptyDetails);
        }
        this.detailsPanel.revalidate();
        this.detailsPanel.repaint();
    }

    private void setSearchVisible(boolean visible) {
        this.quickSearch.setAlwaysShown(visible);
        if (visible != this.btnSearch.isSelected()) {
            this.btnSearch.setSelected(visible);
        }
        this.revalidate();
        this.repaint();
        NotificationSettings.setSearchVisible(visible);
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.toolBar = new JToolBar();
        this.setLayout(new GridBagLayout());
        this.splitPane.setContinuousLayout(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.splitPane, gridBagConstraints);
        this.toolBar.setOrientation(1);
        this.toolBar.setRollover(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add(this.toolBar, gridBagConstraints);
    }

    public void componentOpened() {
        this.removeAll();
        this.init();
        this.notificationTable.addProcessKeyEventListener(this.tableKeyListener);
        this.tableRefreshTimer.restart();
    }

    public void componentClosed() {
        NotificationCenterManager.tcClosed();
        this.notificationTable.removeProcessKeyEventListener(this.tableKeyListener);
        this.tableRefreshTimer.stop();
    }

    public void addNotify() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationCenterTopComponent.this.splitPane.setDividerLocation(0.6);
                NotificationCenterTopComponent.this.splitPane.validate();
                NotificationCenterTopComponent.this.updateTableColumnSizes();
            }
        });
        super.addNotify();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(NotificationCenterTopComponent.class);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private class QuickFilterCallback
    implements QuickSearch.Callback {
        private QuickFilterCallback() {
        }

        public void quickSearchUpdate(String searchText) {
            NotificationCenterTopComponent.this.notificationManager.setMessageFilter(searchText);
            if (NotificationCenterTopComponent.this.quickSearch != null && !NotificationCenterTopComponent.this.quickSearch.isAlwaysShown()) {
                NotificationCenterTopComponent.this.setSearchVisible(true);
            }
        }

        public void showNextSelection(boolean forward) {
            NotificationCenterTopComponent.this.notificationTable.showNextSelection(forward);
        }

        public String findMaxPrefix(String prefix) {
            return prefix;
        }

        public void quickSearchConfirmed() {
        }

        public void quickSearchCanceled() {
            NotificationCenterTopComponent.this.notificationManager.setMessageFilter(null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NotificationCenterTopComponent.this.notificationTable.requestFocusInWindow();
                }
            });
        }
    }

    private class RefreshTimerListener
    implements ActionListener {
        private RefreshTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NotificationCenterTopComponent.this.notificationTable.revalidate();
            NotificationCenterTopComponent.this.notificationTable.repaint();
        }
    }

    private class TableKeyListener
    implements NotificationTable.ProcessKeyEventListener {
        private TableKeyListener() {
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            NotificationCenterTopComponent.this.quickSearch.processKeyEvent(e);
        }
    }
}

