/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.messaging.simp.broker.AbstractBrokerMessageHandler;
import org.springframework.messaging.simp.broker.SimpleBrokerMessageHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.simp.config.TaskExecutorRegistration;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.messaging.simp.user.DefaultUserDestinationResolver;
import org.springframework.messaging.simp.user.DefaultUserSessionRegistry;
import org.springframework.messaging.simp.user.UserDestinationMessageHandler;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.messaging.support.AbstractSubscribableChannel;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class AbstractMessageBrokerConfiguration
implements ApplicationContextAware {
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)AbstractMessageBrokerConfiguration.class.getClassLoader());
    private static final String MVC_VALIDATOR_NAME = "mvcValidator";
    private ChannelRegistration clientInboundChannelRegistration;
    private ChannelRegistration clientOutboundChannelRegistration;
    private MessageBrokerRegistry brokerRegistry;
    private ApplicationContext applicationContext;
    private static final AbstractBrokerMessageHandler noopBroker = new AbstractBrokerMessageHandler(null){

        @Override
        protected void startInternal() {
        }

        @Override
        protected void stopInternal() {
        }

        @Override
        protected void handleMessageInternal(Message<?> message) {
        }
    };

    protected AbstractMessageBrokerConfiguration() {
    }

    @Bean
    public AbstractSubscribableChannel clientInboundChannel() {
        ExecutorSubscribableChannel channel = new ExecutorSubscribableChannel((Executor)this.clientInboundChannelExecutor());
        ChannelRegistration r = this.getClientInboundChannelRegistration();
        if (r.hasInterceptors()) {
            channel.setInterceptors(r.getInterceptors());
        }
        return channel;
    }

    @Bean
    public ThreadPoolTaskExecutor clientInboundChannelExecutor() {
        TaskExecutorRegistration r = this.getClientInboundChannelRegistration().getTaskExecutorRegistration();
        ThreadPoolTaskExecutor executor = r != null ? r.getTaskExecutor() : new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("clientInboundChannel-");
        return executor;
    }

    protected final ChannelRegistration getClientInboundChannelRegistration() {
        if (this.clientInboundChannelRegistration == null) {
            ChannelRegistration registration = new ChannelRegistration();
            this.configureClientInboundChannel(registration);
            this.clientInboundChannelRegistration = registration;
        }
        return this.clientInboundChannelRegistration;
    }

    protected void configureClientInboundChannel(ChannelRegistration registration) {
    }

    @Bean
    public AbstractSubscribableChannel clientOutboundChannel() {
        ExecutorSubscribableChannel channel = new ExecutorSubscribableChannel((Executor)this.clientOutboundChannelExecutor());
        ChannelRegistration r = this.getClientOutboundChannelRegistration();
        if (r.hasInterceptors()) {
            channel.setInterceptors(r.getInterceptors());
        }
        return channel;
    }

    @Bean
    public ThreadPoolTaskExecutor clientOutboundChannelExecutor() {
        TaskExecutorRegistration r = this.getClientOutboundChannelRegistration().getTaskExecutorRegistration();
        ThreadPoolTaskExecutor executor = r != null ? r.getTaskExecutor() : new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("clientOutboundChannel-");
        return executor;
    }

    protected final ChannelRegistration getClientOutboundChannelRegistration() {
        if (this.clientOutboundChannelRegistration == null) {
            ChannelRegistration registration = new ChannelRegistration();
            this.configureClientOutboundChannel(registration);
            this.clientOutboundChannelRegistration = registration;
        }
        return this.clientOutboundChannelRegistration;
    }

    protected void configureClientOutboundChannel(ChannelRegistration registration) {
    }

    @Bean
    public AbstractSubscribableChannel brokerChannel() {
        ChannelRegistration r = this.getBrokerRegistry().getBrokerChannelRegistration();
        ExecutorSubscribableChannel channel = r.hasTaskExecutor() ? new ExecutorSubscribableChannel() : new ExecutorSubscribableChannel((Executor)this.brokerChannelExecutor());
        if (r.hasInterceptors()) {
            channel.setInterceptors(r.getInterceptors());
        }
        return channel;
    }

    @Bean
    public ThreadPoolTaskExecutor brokerChannelExecutor() {
        TaskExecutorRegistration r = this.getBrokerRegistry().getBrokerChannelRegistration().getTaskExecutorRegistration();
        ThreadPoolTaskExecutor executor = r != null ? r.getTaskExecutor() : new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("brokerChannel-");
        return executor;
    }

    protected final MessageBrokerRegistry getBrokerRegistry() {
        if (this.brokerRegistry == null) {
            MessageBrokerRegistry registry = new MessageBrokerRegistry(this.clientInboundChannel(), this.clientOutboundChannel());
            this.configureMessageBroker(registry);
            this.brokerRegistry = registry;
        }
        return this.brokerRegistry;
    }

    protected void configureMessageBroker(MessageBrokerRegistry registry) {
    }

    @Bean
    public SimpAnnotationMethodMessageHandler simpAnnotationMethodMessageHandler() {
        SimpAnnotationMethodMessageHandler handler = new SimpAnnotationMethodMessageHandler(this.clientInboundChannel(), this.clientOutboundChannel(), this.brokerMessagingTemplate());
        handler.setDestinationPrefixes(this.getBrokerRegistry().getApplicationDestinationPrefixes());
        handler.setMessageConverter(this.brokerMessageConverter());
        handler.setValidator(this.simpValidator());
        return handler;
    }

    @Bean
    public AbstractBrokerMessageHandler simpleBrokerMessageHandler() {
        SimpleBrokerMessageHandler handler = this.getBrokerRegistry().getSimpleBroker(this.brokerChannel());
        return handler != null ? handler : noopBroker;
    }

    @Bean
    public AbstractBrokerMessageHandler stompBrokerRelayMessageHandler() {
        StompBrokerRelayMessageHandler handler = this.getBrokerRegistry().getStompBrokerRelay(this.brokerChannel());
        return handler != null ? handler : noopBroker;
    }

    @Bean
    public UserDestinationMessageHandler userDestinationMessageHandler() {
        UserDestinationMessageHandler handler = new UserDestinationMessageHandler(this.clientInboundChannel(), this.brokerChannel(), this.userDestinationResolver());
        return handler;
    }

    @Bean
    public SimpMessagingTemplate brokerMessagingTemplate() {
        SimpMessagingTemplate template = new SimpMessagingTemplate(this.brokerChannel());
        String prefix = this.getBrokerRegistry().getUserDestinationPrefix();
        if (prefix != null) {
            template.setUserDestinationPrefix(prefix);
        }
        template.setMessageConverter(this.brokerMessageConverter());
        return template;
    }

    @Bean
    public CompositeMessageConverter brokerMessageConverter() {
        ArrayList<MessageConverter> converters = new ArrayList<MessageConverter>();
        if (this.configureMessageConverters(converters)) {
            if (jackson2Present) {
                converters.add(new MappingJackson2MessageConverter());
            }
            converters.add(new StringMessageConverter());
            converters.add(new ByteArrayMessageConverter());
        }
        return new CompositeMessageConverter(converters, this.getContentTypeResolver());
    }

    protected boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        return true;
    }

    protected ContentTypeResolver getContentTypeResolver() {
        DefaultContentTypeResolver contentTypeResolver = new DefaultContentTypeResolver();
        if (jackson2Present) {
            contentTypeResolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
        }
        return contentTypeResolver;
    }

    @Bean
    public UserDestinationResolver userDestinationResolver() {
        DefaultUserDestinationResolver resolver = new DefaultUserDestinationResolver(this.userSessionRegistry());
        String prefix = this.getBrokerRegistry().getUserDestinationPrefix();
        if (prefix != null) {
            resolver.setUserDestinationPrefix(prefix);
        }
        return resolver;
    }

    @Bean
    public UserSessionRegistry userSessionRegistry() {
        return new DefaultUserSessionRegistry();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected Validator simpValidator() {
        Validator validator = this.getValidator();
        if (validator == null) {
            if (this.applicationContext.containsBean(MVC_VALIDATOR_NAME)) {
                validator = (Validator)this.applicationContext.getBean(MVC_VALIDATOR_NAME, Validator.class);
            } else if (ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)this.getClass().getClassLoader())) {
                Class clazz;
                try {
                    String className = "org.springframework.validation.beanvalidation.OptionalValidatorFactoryBean";
                    clazz = ClassUtils.forName((String)className, (ClassLoader)AbstractMessageBrokerConfiguration.class.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new BeanInitializationException("Could not find default validator", (Throwable)e);
                }
                catch (LinkageError e) {
                    throw new BeanInitializationException("Could not find default validator", (Throwable)e);
                }
                validator = (Validator)BeanUtils.instantiate((Class)clazz);
            } else {
                validator = new Validator(){

                    public boolean supports(Class<?> clazz) {
                        return false;
                    }

                    public void validate(Object target, Errors errors) {
                    }
                };
            }
        }
        return validator;
    }

    public Validator getValidator() {
        return null;
    }
}

