/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.analyzer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.commands.CodingStandardsFixer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CodingStandardsFixerCustomizerPanel
extends JPanel {
    private static final long serialVersionUID = -575231773758741767L;
    public static final String ENABLED = "codingStandardsFixer.enabled";
    public static final String VERSION = "codingStandardsFixer.version";
    public static final String LEVEL = "codingStandardsFixer.level";
    public static final String CONFIG = "codingStandardsFixer.config";
    public static final String OPTIONS = "codingStandardsFixer.options";
    final Analyzer.CustomizerContext<Void, CodingStandardsFixerCustomizerPanel> context;
    final Preferences settings;
    private JComboBox<String> configComboBox;
    private JLabel configLabel;
    private JCheckBox enabledCheckBox;
    private JComboBox<String> levelComboBox;
    private JLabel levelLabel;
    private JLabel optionsLabel;
    private JTextField optionsTextField;
    private JComboBox<String> versionComboBox;
    private JLabel versionLabel;

    public CodingStandardsFixerCustomizerPanel(Analyzer.CustomizerContext<Void, CodingStandardsFixerCustomizerPanel> context) {
        assert (EventQueue.isDispatchThread());
        assert (context != null);
        this.context = context;
        this.settings = context.getSettings();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setEnabledCheckBox();
        this.setVersionComboBox();
        this.setLevelComboBox();
        this.setConfigComboBox();
        this.setOptionsTextField();
    }

    private void setEnabledCheckBox() {
        assert (EventQueue.isDispatchThread());
        this.enabledCheckBox.addItemListener(e -> {
            this.setAllComponetsEnabled(this.enabledCheckBox.isSelected());
            this.setCodingStandardsFixerEnabled();
        });
        boolean isEnabled = this.settings.getBoolean(ENABLED, false);
        this.enabledCheckBox.setSelected(isEnabled);
        this.setAllComponetsEnabled(isEnabled);
    }

    private void setVersionComboBox() {
        assert (EventQueue.isDispatchThread());
        DefaultComboBoxModel versionComboBoxModel = new DefaultComboBoxModel();
        CodingStandardsFixer.VERSIONS.forEach(version -> versionComboBoxModel.addElement(version));
        this.versionComboBox.setModel(versionComboBoxModel);
        this.versionComboBox.addItemListener(e -> this.setVersion());
        versionComboBoxModel.setSelectedItem(this.settings.get(VERSION, AnalysisOptions.getInstance().getCodingStandardsFixerVersion()));
    }

    private void setLevelComboBox() {
        assert (EventQueue.isDispatchThread());
        DefaultComboBoxModel levelComboBoxModel = new DefaultComboBoxModel();
        CodingStandardsFixer.ALL_LEVEL.forEach(level -> levelComboBoxModel.addElement(level));
        levelComboBoxModel.setSelectedItem(this.settings.get(LEVEL, AnalysisOptions.getInstance().getCodingStandardsFixerLevel()));
        this.levelComboBox.setModel(levelComboBoxModel);
        this.levelComboBox.addItemListener(e -> this.setLevel());
    }

    private void setConfigComboBox() {
        assert (EventQueue.isDispatchThread());
        DefaultComboBoxModel configComboBoxModel = new DefaultComboBoxModel();
        CodingStandardsFixer.ALL_CONFIG.forEach(config -> configComboBoxModel.addElement(config));
        configComboBoxModel.setSelectedItem(this.settings.get(CONFIG, AnalysisOptions.getInstance().getCodingStandardsFixerConfig()));
        this.configComboBox.setModel(configComboBoxModel);
        this.configComboBox.addItemListener(e -> this.setConfig());
    }

    private void setOptionsTextField() {
        assert (EventQueue.isDispatchThread());
        this.optionsTextField.setText(this.settings.get(OPTIONS, AnalysisOptions.getInstance().getCodingStandardsFixerOptions()));
        this.optionsTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                CodingStandardsFixerCustomizerPanel.this.setOptions();
            }
        });
    }

    private void setCodingStandardsFixerEnabled() {
        this.settings.putBoolean(ENABLED, this.enabledCheckBox.isSelected());
    }

    private void setVersion() {
        this.settings.put(VERSION, (String)this.versionComboBox.getSelectedItem());
    }

    private void setLevel() {
        this.settings.put(LEVEL, (String)this.levelComboBox.getSelectedItem());
    }

    private void setConfig() {
        this.settings.put(CONFIG, (String)this.configComboBox.getSelectedItem());
    }

    private void setOptions() {
        this.settings.put(OPTIONS, this.optionsTextField.getText());
    }

    private void setVersion1ComponentsVisible(boolean isVisible) {
        this.levelLabel.setVisible(isVisible);
        this.levelComboBox.setVisible(isVisible);
        this.configLabel.setVisible(isVisible);
        this.configComboBox.setVisible(isVisible);
    }

    private void setAllComponetsEnabled(boolean isEnabled) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (component == this.enabledCheckBox) continue;
            component.setEnabled(isEnabled);
        }
    }

    private void initComponents() {
        this.levelLabel = new JLabel();
        this.levelComboBox = new JComboBox();
        this.configLabel = new JLabel();
        this.configComboBox = new JComboBox();
        this.optionsLabel = new JLabel();
        this.optionsTextField = new JTextField();
        this.versionLabel = new JLabel();
        this.versionComboBox = new JComboBox();
        this.enabledCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.levelLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.levelLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.configLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.optionsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.versionLabel.text"));
        this.versionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodingStandardsFixerCustomizerPanel.this.versionComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.enabledCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.levelLabel).addComponent(this.configLabel).addComponent(this.optionsLabel).addComponent(this.versionLabel)).addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.levelComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.configComboBox, 0, -1, Short.MAX_VALUE)).addComponent(this.versionComboBox, -2, -1, -2)).addContainerGap()))).addGroup(layout.createSequentialGroup().addComponent(this.enabledCheckBox).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionComboBox, -2, -1, -2).addComponent(this.versionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.levelLabel).addComponent(this.levelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configComboBox, -2, -1, -2).addComponent(this.configLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsLabel).addComponent(this.optionsTextField, -2, -1, -2))));
    }

    private void versionComboBoxActionPerformed(ActionEvent evt) {
        switch ((String)this.versionComboBox.getSelectedItem()) {
            case "1": {
                this.setVersion1ComponentsVisible(true);
                break;
            }
            case "2": {
                this.setVersion1ComponentsVisible(false);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

