/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.api;

import java.util.Objects;
import org.openide.util.Parameters;

public class ExposedPort {
    private final int port;
    private final Type type;

    public ExposedPort(int port, Type type) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port number must be between 1 and 65535");
        }
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        this.port = port;
        this.type = type;
    }

    public int getPort() {
        return this.port;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + this.port;
        hash = 23 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExposedPort other = (ExposedPort)obj;
        if (this.port != other.port) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum Type {
        TCP,
        UDP;

    }
}

