/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class VarCompDeclaration
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.var.not.allowed.compound"));

    public Set<String> getCodes() {
        return Collections.unmodifiableSet(ERROR_CODES);
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        Tree.Kind parentKind = treePath.getParentPath().getLeaf().getKind();
        if (parentKind != Tree.Kind.BLOCK && parentKind != Tree.Kind.CASE) {
            return null;
        }
        return Collections.singletonList(new FixImpl(info, treePath).toEditorFix());
    }

    public String getId() {
        return VarCompDeclaration.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(VarCompDeclaration.class, (String)"FIX_VarCompDeclaration");
    }

    public String getDescription() {
        return NbBundle.getMessage(VarCompDeclaration.class, (String)"FIX_VarCompDeclaration");
    }

    public void cancel() {
    }

    private static final class FixImpl
    extends JavaFix {
        CompilationInfo info;
        TreePath path;

        public FixImpl(CompilationInfo info, TreePath path) {
            super(info, path);
            this.info = info;
            this.path = path;
        }

        protected String getText() {
            return NbBundle.getMessage(VarCompDeclaration.class, (String)"FIX_VarCompDeclaration");
        }

        public String toDebugString() {
            return NbBundle.getMessage(VarCompDeclaration.class, (String)"FIX_VarCompDeclaration");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath statementPath = ctx.getPath();
            Tree parent = statementPath.getParentPath().getLeaf();
            List<? extends StatementTree> statements = null;
            switch (parent.getKind()) {
                case BLOCK: {
                    statements = ((BlockTree)parent).getStatements();
                    break;
                }
                case CASE: {
                    statements = ((CaseTree)parent).getStatements();
                    break;
                }
            }
            WorkingCopy wc = ctx.getWorkingCopy();
            TreeMaker make = wc.getTreeMaker();
            int pos = statements.indexOf(statementPath.getLeaf());
            ArrayList<Tree> newStatements = new ArrayList<Tree>();
            if (pos > 0) {
                if (this.info.getTreeUtilities().isPartOfCompoundVariableDeclaration((Tree)statements.get(pos - 1)) && !this.info.getTreeUtilities().isEndOfCompoundVariableDeclaration((Tree)statements.get(pos - 1))) {
                    --pos;
                }
                newStatements.addAll(statements.subList(0, pos));
            }
            int current = 0;
            for (current = pos; current < statements.size(); ++current) {
                StatementTree t = statements.get(current);
                if (!(t instanceof VariableTree)) continue;
                VariableTree oldVariableTree = (VariableTree)t;
                VariableTree newVariableTree = make.Variable(oldVariableTree.getModifiers(), (CharSequence)oldVariableTree.getName(), make.Type("var"), oldVariableTree.getInitializer());
                newStatements.add(make.asReplacementOf((Tree)newVariableTree, (Tree)oldVariableTree));
                if (this.info.getTreeUtilities().isEndOfCompoundVariableDeclaration((Tree)t)) break;
            }
            if (current + 1 < statements.size()) {
                newStatements.addAll(statements.subList(current + 1, statements.size()));
            }
            Tree target = null;
            switch (parent.getKind()) {
                case BLOCK: {
                    target = make.Block(newStatements, ((BlockTree)parent).isStatic());
                    break;
                }
                case CASE: {
                    target = make.Case(((CaseTree)parent).getExpression(), newStatements);
                    break;
                }
            }
            wc.rewrite(parent, target);
        }
    }
}

