/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.modules.editor.bookmarks.BookmarkAPIAccessor;
import org.netbeans.modules.editor.bookmarks.BookmarkHistory;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.BookmarksPersistence;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.openide.awt.Actions;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class BookmarkUtils {
    private static final Logger LOG = Logger.getLogger(BookmarkUtils.class.getName());

    private BookmarkUtils() {
    }

    public static void setBookmarkNameUnderLock(BookmarkInfo bookmark, String bookmarkName) {
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            bookmark.setName(bookmarkName);
            lockedBookmarkManager.updateNameOrKey(bookmark, true, false);
        }
        finally {
            lockedBookmarkManager.unlock();
        }
    }

    public static void setBookmarkKeyUnderLock(BookmarkInfo bookmark, String bookmarkKey) {
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            bookmark.setKey(bookmarkKey);
            lockedBookmarkManager.updateNameOrKey(bookmark, false, true);
        }
        finally {
            lockedBookmarkManager.unlock();
        }
    }

    public static void removeBookmarkUnderLock(BookmarkInfo bookmark) {
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            lockedBookmarkManager.removeBookmarks(Collections.singletonList(bookmark));
            BookmarkHistory.get().remove(bookmark);
        }
        finally {
            lockedBookmarkManager.unlock();
        }
    }

    public static int offset2LineIndex(Document doc, int offset) {
        Element lineRoot = doc.getDefaultRootElement();
        int lineIndex = lineRoot.getElementIndex(offset);
        return lineIndex;
    }

    public static int lineIndex2Offset(Document doc, int lineIndex) {
        Element lineRoot = doc.getDefaultRootElement();
        int offset = lineIndex < lineRoot.getElementCount() ? lineRoot.getElement(lineIndex).getStartOffset() : doc.getLength();
        return offset;
    }

    public static void postOpenEditor(BookmarkInfo bookmark) {
        try {
            StyledDocument doc;
            final EditorCookie ec = BookmarkUtils.findEditorCookie(bookmark);
            if (ec != null && (doc = ec.openDocument()) != null) {
                BookmarkUtils.updateCurrentLineIndex(bookmark, doc);
                BookmarkHistory.get().add(bookmark);
                final int lineIndex = bookmark.getCurrentLineIndex();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BookmarkUtils.openEditor(ec, lineIndex);
                    }
                });
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
    }

    public static void openEditor(EditorCookie ec, int lineIndex) {
        Line.Set lineSet = ec.getLineSet();
        if (lineSet != null) {
            try {
                Line line = lineSet.getCurrent(lineIndex);
                if (line != null) {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                }
            }
            catch (IndexOutOfBoundsException ex) {
                ec.open();
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(BookmarkUtils.class, (String)"MSG_InvalidLineNumnber", (Object)lineIndex));
            }
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes.length > 0) {
                panes[0].requestFocusInWindow();
            }
        }
    }

    public static void updateCurrentLineIndex(BookmarkInfo info, Document doc) {
        Bookmark b = BookmarkAPIAccessor.INSTANCE.getBookmark(doc, info);
        if (b != null) {
            info.setCurrentLineIndex(b.getLineNumber());
        }
    }

    public static EditorCookie findEditorCookie(BookmarkInfo info) {
        FileObject fo;
        EditorCookie ec = null;
        FileBookmarks fileBookmarks = info.getFileBookmarks();
        if (fileBookmarks != null && (fo = fileBookmarks.getFileObject()) != null) {
            try {
                DataObject dob = DataObject.find((FileObject)fo);
                ec = (EditorCookie)dob.getCookie(EditorCookie.class);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return ec;
    }

    public static Project findProject(URI projectURI) {
        if (projectURI != null) {
            try {
                FileObject prjFO = URLMapper.findFileObject((URL)projectURI.toURL());
                if (prjFO != null && prjFO.isFolder()) {
                    return ProjectManager.getDefault().findProject(prjFO);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static URI getRelativeURI(ProjectBookmarks projectBookmarks, URI fileURI) {
        URI projectURI = projectBookmarks.getProjectURI();
        return projectURI != null ? projectURI.relativize(fileURI) : fileURI;
    }

    public static KeyStroke findKeyStroke(KeyBindingSettings kbs, String actionName) {
        if (kbs != null) {
            for (MultiKeyBinding kb : kbs.getKeyBindings()) {
                if (!actionName.equals(kb.getActionName()) || kb.getKeyStrokeCount() != 1) continue;
                return kb.getKeyStroke(0);
            }
        }
        return null;
    }

    public static KeyStroke findKeyStroke(String actionID) {
        Action a = Actions.forID((String)"Edit", (String)actionID);
        if (a != null) {
            return (KeyStroke)a.getValue("AcceleratorKey");
        }
        return null;
    }

    public static RequestProcessor.Task postTask(Runnable run) {
        return BookmarksPersistence.get().postTask(run);
    }
}

