/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.netbeans.modules.fish.payara.micro.project.MicroVersion;

public class VersionRepository {
    private static VersionRepository versionRepository;
    private static final List<MicroVersion> MICRO_VERSIONS;

    private VersionRepository() {
        MICRO_VERSIONS.add(new MicroVersion("5.192", "8.0"));
        MICRO_VERSIONS.add(new MicroVersion("5.191", "8.0"));
        MICRO_VERSIONS.add(new MicroVersion("5.184", "8.0"));
        MICRO_VERSIONS.add(new MicroVersion("5.183", "8.0"));
        MICRO_VERSIONS.add(new MicroVersion("5.182", "8.0"));
        MICRO_VERSIONS.add(new MicroVersion("5.181", "8.0"));
        MICRO_VERSIONS.add(new MicroVersion("4.1.2.181", "7.0"));
        MICRO_VERSIONS.add(new MicroVersion("4.1.2.174", "7.0"));
    }

    public static VersionRepository getInstance() {
        if (versionRepository == null) {
            versionRepository = new VersionRepository();
        }
        return versionRepository;
    }

    public List<MicroVersion> getMicroVersion() {
        return Collections.unmodifiableList(MICRO_VERSIONS);
    }

    public static Optional<MicroVersion> toMicroVersion(String microVersion) {
        return MICRO_VERSIONS.stream().filter(micro -> micro.getVersion().equals(microVersion)).findAny();
    }

    public String getJavaEEVersion(String microVersion) {
        return MICRO_VERSIONS.stream().filter(micro -> micro.getVersion().equals(microVersion)).map(MicroVersion::getJavaeeVersion).findAny().get();
    }

    static {
        MICRO_VERSIONS = new ArrayList<MicroVersion>();
    }
}

