/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.spi.ArchiveRootProvider;
import org.openide.util.Pair;

public class NBJRTArchiveRootProvider
implements ArchiveRootProvider {
    private static final Logger LOG = Logger.getLogger(NBJRTArchiveRootProvider.class.getName());

    public boolean isArchiveFile(@NonNull URL url, boolean strict) {
        FileObject fo = URLMapper.findFileObject((URL)url);
        return fo == null ? false : this.isArchiveFile(fo, strict);
    }

    public boolean isArchiveFile(FileObject fo, boolean strict) {
        if (!fo.isFolder()) {
            return false;
        }
        File file = FileUtil.toFile((FileObject)fo);
        return file == null ? false : NBJRTUtil.getNIOProvider(file) != null;
    }

    public boolean isArchiveArtifact(@NonNull URL url) {
        return "nbjrt".equals(url.getProtocol());
    }

    @CheckForNull
    public URL getArchiveFile(@NonNull URL url) {
        Pair<URL, String> p = NBJRTUtil.parseURL(url);
        return p != null ? (URL)p.first() : null;
    }

    @NonNull
    public URL getArchiveRoot(@NonNull URL url) {
        try {
            return new URL(String.format("%s:%s!/", "nbjrt", url));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

