/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.VoidStaxUnmarshaller;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        log.trace((Object)"Parsing service response XML");
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(response.getContent());
        try {
            AmazonWebServiceResponse<T> awsResponse = new AmazonWebServiceResponse<T>();
            StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader);
            unmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
            unmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            awsResponse.setResult(result);
            Map<String, String> metadata = unmarshallerContext.getMetadata();
            awsResponse.setResponseMetadata(new ResponseMetadata(metadata));
            log.trace((Object)"Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse = awsResponse;
            return amazonWebServiceResponse;
        }
        finally {
            try {
                eventReader.close();
            }
            catch (Exception e) {}
        }
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
    }
}

