/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.Collections;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.CreateStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

class CreateStatementAnalyzer
extends SQLStatementAnalyzer {
    private int bodyStartOffset;
    private int bodyEndOffset;

    public static CreateStatement analyze(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        seq.moveStart();
        if (!seq.moveNext()) {
            return null;
        }
        CreateStatementAnalyzer sa = new CreateStatementAnalyzer(seq, quoter);
        sa.parse();
        return new CreateStatement(sa.startOffset, seq.offset() + seq.token().length(), sa.offset2Context, sa.bodyStartOffset, sa.bodyEndOffset, null, Collections.unmodifiableList(sa.subqueries));
    }

    private CreateStatementAnalyzer(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        super(seq, quoter);
    }

    private void parse() {
        this.startOffset = this.seq.offset();
        do {
            switch (this.context) {
                case START: {
                    if (!SQLStatementAnalyzer.isKeyword("CREATE", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.CREATE);
                    break;
                }
                case CREATE: {
                    if (SQLStatementAnalyzer.isKeyword("PROCEDURE", (TokenSequence<SQLTokenId>)this.seq)) {
                        this.moveToContext(SQLStatement.Context.CREATE_PROCEDURE);
                        break;
                    }
                    if (SQLStatementAnalyzer.isKeyword("FUNCTION", (TokenSequence<SQLTokenId>)this.seq)) {
                        this.moveToContext(SQLStatement.Context.CREATE_FUNCTION);
                        break;
                    }
                    if (SQLStatementAnalyzer.isKeyword("TABLE", (TokenSequence<SQLTokenId>)this.seq)) {
                        this.moveToContext(SQLStatement.Context.CREATE_TABLE);
                        break;
                    }
                    if (SQLStatementAnalyzer.isKeyword("TEMPORARY", (TokenSequence<SQLTokenId>)this.seq)) {
                        this.moveToContext(SQLStatement.Context.CREATE_TEMPORARY_TABLE);
                        break;
                    }
                    if (SQLStatementAnalyzer.isKeyword("DATABASE", (TokenSequence<SQLTokenId>)this.seq)) {
                        this.moveToContext(SQLStatement.Context.CREATE_DATABASE);
                        break;
                    }
                    if (SQLStatementAnalyzer.isKeyword("SCHEMA", (TokenSequence<SQLTokenId>)this.seq)) {
                        this.moveToContext(SQLStatement.Context.CREATE_SCHEMA);
                        break;
                    }
                    if (!SQLStatementAnalyzer.isKeyword("VIEW", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.CREATE_VIEW);
                    break;
                }
                case CREATE_PROCEDURE: 
                case CREATE_FUNCTION: {
                    if (!SQLStatementAnalyzer.isKeyword("BEGIN", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.BEGIN);
                    this.bodyStartOffset = this.seq.offset() + this.seq.token().length();
                    break;
                }
                case BEGIN: {
                    if (!SQLStatementAnalyzer.isKeyword("END", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.END);
                    this.bodyEndOffset = this.seq.offset();
                    break;
                }
                case CREATE_TEMPORARY_TABLE: {
                    if (!SQLStatementAnalyzer.isKeyword("TABLE", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.CREATE_TABLE);
                    break;
                }
                case CREATE_VIEW: {
                    if (!SQLStatementAnalyzer.isKeyword("AS", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.CREATE_VIEW_AS);
                    break;
                }
                case CREATE_VIEW_AS: {
                    if (!SQLStatementAnalyzer.isKeyword("SELECT", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.SELECT);
                    break;
                }
            }
        } while (this.nextToken());
        if (this.context == SQLStatement.Context.BEGIN) {
            this.bodyEndOffset = this.seq.offset() + this.seq.token().length();
        }
    }
}

