/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.ssl;

import com.sun.enterprise.web.connector.grizzly.OutputWriter;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLUtils;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLWorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public final class SSLOutputWriter {
    public static void flushChannel(SocketChannel socketChannel, ByteBuffer bb) throws IOException {
        SSLWorkerThread workerThread = (SSLWorkerThread)Thread.currentThread();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        ByteBuffer outputBB = workerThread.getOutputBB();
        SSLOutputWriter.flushChannel(socketChannel, bb, outputBB, sslEngine);
    }

    public static void flushChannel(SocketChannel socketChannel, ByteBuffer bb, ByteBuffer outputBB, SSLEngine sslEngine) throws IOException {
        while (bb.hasRemaining()) {
            SSLEngineResult result = SSLUtils.wrap(bb, outputBB, sslEngine);
            switch (result.getStatus()) {
                case OK: {
                    if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                    SSLUtils.executeDelegatedTask(sslEngine);
                    break;
                }
                default: {
                    throw new IOException("SSLOutputWriter: " + (Object)((Object)result.getStatus()));
                }
            }
            if (!outputBB.hasRemaining()) continue;
            OutputWriter.flushChannel(socketChannel, outputBB);
        }
        outputBB.clear();
    }
}

