/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.lsp.client.Bundle;
import org.netbeans.modules.lsp.client.LanguageServerProviderAccessor;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.LanguageClientImpl;
import org.netbeans.modules.lsp.client.spi.LanguageServerProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class LSPBindings {
    private static final RequestProcessor WORKER = new RequestProcessor(LanguageClientImpl.class.getName(), 1, false, false);
    private static final int DELAY = 500;
    private static final Map<Project, Map<String, LSPBindings>> project2MimeType2Server = new WeakHashMap<Project, Map<String, LSPBindings>>();
    private static final Map<FileObject, Map<String, LSPBindings>> workspace2Extension2Server = new HashMap<FileObject, Map<String, LSPBindings>>();
    private final Map<FileObject, Map<BackgroundTask, RequestProcessor.Task>> backgroundTasks = new WeakHashMap<FileObject, Map<BackgroundTask, RequestProcessor.Task>>();
    private static final Logger LOG = Logger.getLogger(LSPBindings.class.getName());
    private final LanguageServer server;
    private final InitializeResult initResult;
    private final Process process;

    public static synchronized LSPBindings getBindings(FileObject file) {
        Project prj;
        LSPBindings bindings;
        for (Map.Entry<FileObject, Map<String, LSPBindings>> e : workspace2Extension2Server.entrySet()) {
            if (!FileUtil.isParentOf((FileObject)e.getKey(), (FileObject)file)) continue;
            bindings = e.getValue().get(file.getExt());
            if (bindings == null) break;
            return bindings;
        }
        if ((prj = FileOwnerQuery.getOwner((FileObject)file)) == null) {
            return null;
        }
        String mimeType = FileUtil.getMIMEType((FileObject)file);
        if (mimeType == null) {
            return null;
        }
        bindings = project2MimeType2Server.computeIfAbsent(prj, p -> new HashMap()).computeIfAbsent(mimeType, mt -> {
            for (LanguageServerProvider provider : MimeLookup.getLookup((String)mimeType).lookupAll(LanguageServerProvider.class)) {
                LanguageServerProvider.LanguageServerDescription desc = provider.startServer(Lookups.singleton((Object)prj));
                if (desc == null) continue;
                try {
                    LanguageClientImpl lci = new LanguageClientImpl();
                    InputStream in = LanguageServerProviderAccessor.getINSTANCE().getInputStream(desc);
                    OutputStream out = LanguageServerProviderAccessor.getINSTANCE().getOutputStream(desc);
                    Launcher<LanguageServer> launcher = LSPLauncher.createClientLauncher(lci, in, out);
                    launcher.startListening();
                    LanguageServer server = (LanguageServer)launcher.getRemoteProxy();
                    InitializeResult result = LSPBindings.initServer(server, prj.getProjectDirectory());
                    LSPBindings b = new LSPBindings(server, result, LanguageServerProviderAccessor.getINSTANCE().getProcess(desc));
                    lci.setBindings(b);
                    return b;
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
            return new LSPBindings(null, null, null);
        });
        if (bindings.process != null && !bindings.process.isAlive()) {
            return null;
        }
        return bindings.server != null ? bindings : null;
    }

    public static void addBindings(FileObject root, int port, String ... extensions) {
        BaseProgressUtils.showProgressDialogAndRun(() -> {
            try {
                Socket s = new Socket(InetAddress.getLocalHost(), port);
                LanguageClientImpl lc = new LanguageClientImpl();
                InputStream in = s.getInputStream();
                final OutputStream out = s.getOutputStream();
                Launcher<LanguageServer> launcher = LSPLauncher.createClientLauncher(lc, in, new OutputStream(){

                    @Override
                    public void write(int w) throws IOException {
                        out.write(w);
                        if (w == 10) {
                            out.flush();
                        }
                    }
                });
                launcher.startListening();
                LanguageServer server = (LanguageServer)launcher.getRemoteProxy();
                InitializeResult result = LSPBindings.initServer(server, root);
                LSPBindings bindings = new LSPBindings(server, result, null);
                lc.setBindings(bindings);
                workspace2Extension2Server.put(root, Arrays.stream(extensions).collect(Collectors.toMap(k -> k, v -> bindings)));
            }
            catch (IOException | InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }, (String)Bundle.LBL_Connecting());
    }

    private static InitializeResult initServer(LanguageServer server, FileObject root) throws InterruptedException, ExecutionException {
        InitializeParams initParams = new InitializeParams();
        initParams.setRootUri(Utils.toURI(root));
        initParams.setRootPath(FileUtil.toFile((FileObject)root).getAbsolutePath());
        initParams.setProcessId(0);
        TextDocumentClientCapabilities tdcc = new TextDocumentClientCapabilities();
        DocumentSymbolCapabilities dsc = new DocumentSymbolCapabilities();
        dsc.setHierarchicalDocumentSymbolSupport(true);
        tdcc.setDocumentSymbol(dsc);
        initParams.setCapabilities(new ClientCapabilities(new WorkspaceClientCapabilities(), tdcc, null));
        return server.initialize(initParams).get();
    }

    private LSPBindings(LanguageServer server, InitializeResult initResult, Process process) {
        this.server = server;
        this.initResult = initResult;
        this.process = process;
    }

    public TextDocumentService getTextDocumentService() {
        return this.server.getTextDocumentService();
    }

    public WorkspaceService getWorkspaceService() {
        return this.server.getWorkspaceService();
    }

    public InitializeResult getInitResult() {
        return this.initResult;
    }

    public static void addBackgroundTask(FileObject file, BackgroundTask task) {
        LSPBindings bindings = LSPBindings.getBindings(file);
        if (bindings == null) {
            return;
        }
        RequestProcessor.Task req = WORKER.create(() -> task.run(bindings, file));
        bindings.backgroundTasks.computeIfAbsent(file, f -> new LinkedHashMap()).put(task, req);
        bindings.scheduleBackgroundTask(req);
    }

    public static void removeBackgroundTask(FileObject file, BackgroundTask task) {
        LSPBindings bindings = LSPBindings.getBindings(file);
        if (bindings == null) {
            return;
        }
        RequestProcessor.Task req = (RequestProcessor.Task)bindings.backgroundTasks.computeIfAbsent(file, f -> new LinkedHashMap()).remove(task);
        if (req != null) {
            req.cancel();
        }
    }

    public void runOnBackground(Runnable r) {
        WORKER.post(r);
    }

    public void scheduleBackgroundTask(RequestProcessor.Task req) {
        WORKER.post((Runnable)req, 500);
    }

    public void scheduleBackgroundTasks(FileObject file) {
        this.backgroundTasks.computeIfAbsent(file, f -> new IdentityHashMap()).values().stream().forEach(this::scheduleBackgroundTask);
    }

    public static class Cleanup
    implements Runnable {
        @Override
        public void run() {
            for (Map mime2Bindings : project2MimeType2Server.values()) {
                for (LSPBindings b : mime2Bindings.values()) {
                    if (b == null || b.process == null) continue;
                    b.process.destroy();
                }
            }
            for (Map mime2Bindings : workspace2Extension2Server.values()) {
                for (LSPBindings b : mime2Bindings.values()) {
                    if (b == null || b.process == null) continue;
                    b.process.destroy();
                }
            }
        }
    }

    public static interface BackgroundTask {
        public void run(LSPBindings var1, FileObject var2);
    }
}

