/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.readers;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.helpers.PublicId;
import org.apache.xml.resolver.readers.SAXCatalogParser;
import org.apache.xml.resolver.readers.SAXCatalogReader;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class OASISXMLCatalogReader
extends SAXCatalogReader
implements SAXCatalogParser {
    protected Catalog catalog = null;
    public static final String namespaceName = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    public static final String tr9401NamespaceName = "urn:oasis:names:tc:entity:xmlns:tr9401:catalog";
    protected Stack baseURIStack = new Stack();
    protected Stack overrideStack = new Stack();
    protected Stack namespaceStack = new Stack();

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
        this.debug = catalog.getCatalogManager().debug;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public OASISXMLCatalogReader() {
    }

    public OASISXMLCatalogReader(SAXParserFactory sAXParserFactory, Catalog catalog) {
        super(sAXParserFactory);
        this.setCatalog(catalog);
    }

    protected boolean inExtensionNamespace() {
        boolean bl = false;
        Enumeration enumeration = this.namespaceStack.elements();
        while (!bl && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string == null) {
                bl = true;
                continue;
            }
            bl = !string.equals(tr9401NamespaceName) && !string.equals(namespaceName);
        }
        return bl;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.baseURIStack.push(this.catalog.getCurrentBase());
        this.overrideStack.push(this.catalog.getDefaultOverride());
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block81: {
            CatalogEntry catalogEntry;
            Object object;
            boolean bl;
            Vector<String> vector;
            int n;
            block79: {
                n = -1;
                vector = new Vector<String>();
                this.namespaceStack.push(string);
                bl = this.inExtensionNamespace();
                if (string != null && namespaceName.equals(string) && !bl) {
                    if (attributes.getValue("xml:base") != null) {
                        block77: {
                            object = attributes.getValue("xml:base");
                            n = Catalog.BASE;
                            vector.add((String)object);
                            this.baseURIStack.push(object);
                            this.debug.message(4, "xml:base", (String)object);
                            try {
                                catalogEntry = new CatalogEntry(n, vector);
                                this.catalog.addEntry(catalogEntry);
                            }
                            catch (CatalogException catalogException) {
                                if (catalogException.getExceptionType() == 3) {
                                    this.debug.message(1, "Invalid catalog entry type", string2);
                                }
                                if (catalogException.getExceptionType() != 2) break block77;
                                this.debug.message(1, "Invalid catalog entry (base)", string2);
                            }
                        }
                        n = -1;
                        vector = new Vector();
                    } else {
                        this.baseURIStack.push(this.baseURIStack.peek());
                    }
                    if ((string2.equals("catalog") || string2.equals("group")) && attributes.getValue("prefer") != null) {
                        block78: {
                            object = attributes.getValue("prefer");
                            if (((String)object).equals("public")) {
                                object = "yes";
                            } else if (((String)object).equals("system")) {
                                object = "no";
                            } else {
                                this.debug.message(1, "Invalid prefer: must be 'system' or 'public'", string2);
                                object = this.catalog.getDefaultOverride();
                            }
                            n = Catalog.OVERRIDE;
                            vector.add((String)object);
                            this.overrideStack.push(object);
                            this.debug.message(4, "override", (String)object);
                            try {
                                catalogEntry = new CatalogEntry(n, vector);
                                this.catalog.addEntry(catalogEntry);
                            }
                            catch (CatalogException catalogException) {
                                if (catalogException.getExceptionType() == 3) {
                                    this.debug.message(1, "Invalid catalog entry type", string2);
                                }
                                if (catalogException.getExceptionType() != 2) break block78;
                                this.debug.message(1, "Invalid catalog entry (override)", string2);
                            }
                        }
                        n = -1;
                        vector = new Vector();
                    } else {
                        this.overrideStack.push(this.overrideStack.peek());
                    }
                    if (string2.equals("delegatePublic")) {
                        if (this.checkAttributes(attributes, "publicIdStartString", "catalog")) {
                            n = Catalog.DELEGATE_PUBLIC;
                            vector.add(attributes.getValue("publicIdStartString"));
                            vector.add(attributes.getValue("catalog"));
                            this.debug.message(4, "delegatePublic", PublicId.normalize(attributes.getValue("publicIdStartString")), attributes.getValue("catalog"));
                        }
                    } else if (string2.equals("delegateSystem")) {
                        if (this.checkAttributes(attributes, "systemIdStartString", "catalog")) {
                            n = Catalog.DELEGATE_SYSTEM;
                            vector.add(attributes.getValue("systemIdStartString"));
                            vector.add(attributes.getValue("catalog"));
                            this.debug.message(4, "delegateSystem", attributes.getValue("systemIdStartString"), attributes.getValue("catalog"));
                        }
                    } else if (string2.equals("delegateURI")) {
                        if (this.checkAttributes(attributes, "uriStartString", "catalog")) {
                            n = Catalog.DELEGATE_URI;
                            vector.add(attributes.getValue("uriStartString"));
                            vector.add(attributes.getValue("catalog"));
                            this.debug.message(4, "delegateURI", attributes.getValue("uriStartString"), attributes.getValue("catalog"));
                        }
                    } else if (string2.equals("rewriteSystem")) {
                        if (this.checkAttributes(attributes, "systemIdStartString", "rewritePrefix")) {
                            n = Catalog.REWRITE_SYSTEM;
                            vector.add(attributes.getValue("systemIdStartString"));
                            vector.add(attributes.getValue("rewritePrefix"));
                            this.debug.message(4, "rewriteSystem", attributes.getValue("systemIdStartString"), attributes.getValue("rewritePrefix"));
                        }
                    } else if (string2.equals("systemSuffix")) {
                        if (this.checkAttributes(attributes, "systemIdSuffix", "uri")) {
                            n = Catalog.SYSTEM_SUFFIX;
                            vector.add(attributes.getValue("systemIdSuffix"));
                            vector.add(attributes.getValue("uri"));
                            this.debug.message(4, "systemSuffix", attributes.getValue("systemIdSuffix"), attributes.getValue("uri"));
                        }
                    } else if (string2.equals("rewriteURI")) {
                        if (this.checkAttributes(attributes, "uriStartString", "rewritePrefix")) {
                            n = Catalog.REWRITE_URI;
                            vector.add(attributes.getValue("uriStartString"));
                            vector.add(attributes.getValue("rewritePrefix"));
                            this.debug.message(4, "rewriteURI", attributes.getValue("uriStartString"), attributes.getValue("rewritePrefix"));
                        }
                    } else if (string2.equals("uriSuffix")) {
                        if (this.checkAttributes(attributes, "uriSuffix", "uri")) {
                            n = Catalog.URI_SUFFIX;
                            vector.add(attributes.getValue("uriSuffix"));
                            vector.add(attributes.getValue("uri"));
                            this.debug.message(4, "uriSuffix", attributes.getValue("uriSuffix"), attributes.getValue("uri"));
                        }
                    } else if (string2.equals("nextCatalog")) {
                        if (this.checkAttributes(attributes, "catalog")) {
                            n = Catalog.CATALOG;
                            vector.add(attributes.getValue("catalog"));
                            this.debug.message(4, "nextCatalog", attributes.getValue("catalog"));
                        }
                    } else if (string2.equals("public")) {
                        if (this.checkAttributes(attributes, "publicId", "uri")) {
                            n = Catalog.PUBLIC;
                            vector.add(attributes.getValue("publicId"));
                            vector.add(attributes.getValue("uri"));
                            this.debug.message(4, "public", PublicId.normalize(attributes.getValue("publicId")), attributes.getValue("uri"));
                        }
                    } else if (string2.equals("system")) {
                        if (this.checkAttributes(attributes, "systemId", "uri")) {
                            n = Catalog.SYSTEM;
                            vector.add(attributes.getValue("systemId"));
                            vector.add(attributes.getValue("uri"));
                            this.debug.message(4, "system", attributes.getValue("systemId"), attributes.getValue("uri"));
                        }
                    } else if (string2.equals("uri")) {
                        if (this.checkAttributes(attributes, "name", "uri")) {
                            n = Catalog.URI;
                            vector.add(attributes.getValue("name"));
                            vector.add(attributes.getValue("uri"));
                            this.debug.message(4, "uri", attributes.getValue("name"), attributes.getValue("uri"));
                        }
                    } else if (!string2.equals("catalog") && !string2.equals("group")) {
                        this.debug.message(1, "Invalid catalog entry type", string2);
                    }
                    if (n >= 0) {
                        try {
                            object = new CatalogEntry(n, vector);
                            this.catalog.addEntry((CatalogEntry)object);
                        }
                        catch (CatalogException catalogException) {
                            if (catalogException.getExceptionType() == 3) {
                                this.debug.message(1, "Invalid catalog entry type", string2);
                            }
                            if (catalogException.getExceptionType() != 2) break block79;
                            this.debug.message(1, "Invalid catalog entry", string2);
                        }
                    }
                }
            }
            if (string != null && tr9401NamespaceName.equals(string) && !bl) {
                if (attributes.getValue("xml:base") != null) {
                    block80: {
                        object = attributes.getValue("xml:base");
                        n = Catalog.BASE;
                        vector.add((String)object);
                        this.baseURIStack.push(object);
                        this.debug.message(4, "xml:base", (String)object);
                        try {
                            catalogEntry = new CatalogEntry(n, vector);
                            this.catalog.addEntry(catalogEntry);
                        }
                        catch (CatalogException catalogException) {
                            if (catalogException.getExceptionType() == 3) {
                                this.debug.message(1, "Invalid catalog entry type", string2);
                            }
                            if (catalogException.getExceptionType() != 2) break block80;
                            this.debug.message(1, "Invalid catalog entry (base)", string2);
                        }
                    }
                    n = -1;
                    vector = new Vector();
                } else {
                    this.baseURIStack.push(this.baseURIStack.peek());
                }
                if (string2.equals("doctype")) {
                    n = Catalog.DOCTYPE;
                    vector.add(attributes.getValue("name"));
                    vector.add(attributes.getValue("uri"));
                } else if (string2.equals("document")) {
                    n = Catalog.DOCUMENT;
                    vector.add(attributes.getValue("uri"));
                } else if (string2.equals("dtddecl")) {
                    n = Catalog.DTDDECL;
                    vector.add(attributes.getValue("publicId"));
                    vector.add(attributes.getValue("uri"));
                } else if (string2.equals("entity")) {
                    n = Catalog.ENTITY;
                    vector.add(attributes.getValue("name"));
                    vector.add(attributes.getValue("uri"));
                } else if (string2.equals("linktype")) {
                    n = Catalog.LINKTYPE;
                    vector.add(attributes.getValue("name"));
                    vector.add(attributes.getValue("uri"));
                } else if (string2.equals("notation")) {
                    n = Catalog.NOTATION;
                    vector.add(attributes.getValue("name"));
                    vector.add(attributes.getValue("uri"));
                } else if (string2.equals("sgmldecl")) {
                    n = Catalog.SGMLDECL;
                    vector.add(attributes.getValue("uri"));
                } else {
                    this.debug.message(1, "Invalid catalog entry type", string2);
                }
                if (n >= 0) {
                    try {
                        object = new CatalogEntry(n, vector);
                        this.catalog.addEntry((CatalogEntry)object);
                    }
                    catch (CatalogException catalogException) {
                        if (catalogException.getExceptionType() == 3) {
                            this.debug.message(1, "Invalid catalog entry type", string2);
                        }
                        if (catalogException.getExceptionType() != 2) break block81;
                        this.debug.message(1, "Invalid catalog entry", string2);
                    }
                }
            }
        }
    }

    public boolean checkAttributes(Attributes attributes, String string) {
        if (attributes.getValue(string) == null) {
            this.debug.message(1, "Error: required attribute " + string + " missing.");
            return false;
        }
        return true;
    }

    public boolean checkAttributes(Attributes attributes, String string, String string2) {
        return this.checkAttributes(attributes, string) && this.checkAttributes(attributes, string2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        block11: {
            CatalogEntry catalogEntry;
            String string4;
            String string5;
            boolean bl;
            Vector<String> vector;
            int n;
            block10: {
                n = -1;
                vector = new Vector<String>();
                bl = this.inExtensionNamespace();
                if (string != null && !bl && (namespaceName.equals(string) || tr9401NamespaceName.equals(string))) {
                    string5 = (String)this.baseURIStack.pop();
                    string4 = (String)this.baseURIStack.peek();
                    if (!string4.equals(string5)) {
                        n = Catalog.BASE;
                        vector.add(string4);
                        this.debug.message(4, "(reset) xml:base", string4);
                        try {
                            catalogEntry = new CatalogEntry(n, vector);
                            this.catalog.addEntry(catalogEntry);
                        }
                        catch (CatalogException catalogException) {
                            if (catalogException.getExceptionType() == 3) {
                                this.debug.message(1, "Invalid catalog entry type", string2);
                            }
                            if (catalogException.getExceptionType() != 2) break block10;
                            this.debug.message(1, "Invalid catalog entry (rbase)", string2);
                        }
                    }
                }
            }
            if (string != null && namespaceName.equals(string) && !bl && (string2.equals("catalog") || string2.equals("group"))) {
                string5 = (String)this.overrideStack.pop();
                string4 = (String)this.overrideStack.peek();
                if (!string4.equals(string5)) {
                    n = Catalog.OVERRIDE;
                    vector.add(string4);
                    this.overrideStack.push(string4);
                    this.debug.message(4, "(reset) override", string4);
                    try {
                        catalogEntry = new CatalogEntry(n, vector);
                        this.catalog.addEntry(catalogEntry);
                    }
                    catch (CatalogException catalogException) {
                        if (catalogException.getExceptionType() == 3) {
                            this.debug.message(1, "Invalid catalog entry type", string2);
                        }
                        if (catalogException.getExceptionType() != 2) break block11;
                        this.debug.message(1, "Invalid catalog entry (roverride)", string2);
                    }
                }
            }
        }
        this.namespaceStack.pop();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }
}

