/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.vars;

import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;

public final class TruffleScope {
    private final JPDADebugger debugger;
    private final String name;
    private final boolean function;
    private final ObjectVariable debugScope;
    private TruffleVariable[] arguments;
    private TruffleVariable[] variables;

    public TruffleScope(String name, boolean function, TruffleVariable[] arguments, TruffleVariable[] variables) {
        this.name = name;
        this.function = function;
        this.arguments = arguments;
        this.variables = variables;
        this.debugger = null;
        this.debugScope = null;
    }

    public TruffleScope(String name, boolean function, boolean hasArgs, boolean hasVars, JPDADebugger debugger, ObjectVariable debugScope) {
        this.name = name;
        this.function = function;
        if (!hasArgs) {
            this.arguments = new TruffleVariable[0];
        }
        if (!hasVars) {
            this.variables = new TruffleVariable[0];
        }
        this.debugger = debugger;
        this.debugScope = debugScope;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFunction() {
        return this.function;
    }

    public synchronized TruffleVariable[] getArguments() {
        if (this.arguments == null) {
            this.loadArgsAndVars();
        }
        return this.arguments;
    }

    public synchronized TruffleVariable[] getVariables() {
        if (this.variables == null) {
            this.loadArgsAndVars();
        }
        return this.variables;
    }

    private void loadArgsAndVars() {
        assert (Thread.holdsLock(this));
        TruffleVariable[][] argsAndVars = TruffleAccess.getScopeArgsAndVars(this.debugger, this.debugScope);
        this.arguments = argsAndVars[0];
        this.variables = argsAndVars[1];
    }
}

