/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.axi.visitor.DefaultVisitor;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;

public abstract class SchemaGenerator
extends DefaultVisitor {
    private Mode mode;
    public static Pattern DEFAULT_DESIGN_PATTERN = Pattern.RUSSIAN_DOLL;

    public SchemaGenerator(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public abstract void updateSchema(SchemaModel var1) throws BadLocationException, IOException;

    public abstract void transformSchema(SchemaModel var1) throws IOException;

    @Override
    public void visit(Element element) {
        this.visitChildren(element);
    }

    @Override
    public void visit(Attribute attribute) {
        this.visitChildren(attribute);
    }

    @Override
    public void visit(Compositor compositor) {
        this.visitChildren(compositor);
    }

    protected void visitChildren(AXIComponent component) {
        for (AXIComponent child : component.getChildren()) {
            child.accept(this);
        }
    }

    public static interface PrimitiveCart {
        public void add(Datatype var1, SchemaComponent var2);

        public Set<Map.Entry<SchemaComponent, Datatype>> getEntries();

        public GlobalSimpleType getDefaultPrimitive();

        public GlobalSimpleType getPrimitiveType(String var1);
    }

    public static interface UniqueId {
        public int nextId();
    }

    public static enum Mode {
        TRANSFORM,
        UPDATE;

    }

    public static enum Pattern {
        RUSSIAN_DOLL,
        VENITIAN_BLIND,
        GARDEN_OF_EDEN,
        SALAMI_SLICE,
        MIXED;

    }
}

