/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.create;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.codeception.commands.Codecept;
import org.netbeans.modules.php.spi.testing.create.CreateTestsResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public final class TestCreator {
    private static final Logger LOGGER = Logger.getLogger(TestCreator.class.getName());
    public static final String GENERATE_COMMAND_PARAM = "GENERATE_COMMAND_PARAM";
    public static final String SUITE_PARAM = "SUITE_PARAM";
    @SuppressWarnings(value={"MS_MUTABLE_COLLECTION"}, justification="It is immutable")
    public static final List<Codecept.GenerateCommand> TEST_COMMANDS = Arrays.asList(Codecept.GenerateCommand.Test, Codecept.GenerateCommand.Phpunit, Codecept.GenerateCommand.Cept, Codecept.GenerateCommand.Cest);
    private final PhpModule phpModule;

    public TestCreator(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public CreateTestsResult createTests(List<FileObject> files, Map<String, Object> configurationPanelProperties) {
        HashSet<FileObject> failed = new HashSet<FileObject>();
        HashSet<FileObject> succeeded = new HashSet<FileObject>();
        Pair commandSuite = Pair.of((Object)((Object)((Codecept.GenerateCommand)((Object)configurationPanelProperties.get(GENERATE_COMMAND_PARAM)))), (Object)((String)configurationPanelProperties.get(SUITE_PARAM)));
        if (commandSuite.first() != null && commandSuite.second() != null) {
            try {
                Codecept codeception = Codecept.getForPhpModule(this.phpModule, true);
                if (codeception != null) {
                    for (FileObject fo : files) {
                        this.generateTest(codeception, this.phpModule, fo, (Pair<Codecept.GenerateCommand, String>)commandSuite, failed, succeeded);
                    }
                }
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
                UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/Codeception");
            }
        }
        return new CreateTestsResult(succeeded, failed);
    }

    private void generateTest(Codecept codeception, PhpModule phpModule, FileObject fo, Pair<Codecept.GenerateCommand, String> commandSuite, Set<FileObject> failed, Set<FileObject> succeeded) throws ExecutionException {
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        assert (editorSupport != null) : "Editor support must exist";
        Collection classes = editorSupport.getClasses(fo);
        if (classes.isEmpty()) {
            failed.add(fo);
            return;
        }
        for (PhpClass phpClass : classes) {
            FileObject testFile = codeception.generateTest(phpModule, fo, (Codecept.GenerateCommand)((Object)commandSuite.first()), (String)commandSuite.second(), phpClass.getFullyQualifiedName());
            if (testFile != null) {
                succeeded.add(testFile);
                continue;
            }
            failed.add(fo);
        }
    }
}

