/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.sync;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.sync.SyncRepresentation;
import org.netbeans.modules.xml.sync.Synchronizator;
import org.netbeans.modules.xml.util.Util;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.xml.sax.InputSource;

public class FileRepresentation
extends SyncRepresentation {
    private final DataObject dataObject;
    private Date lastSave;

    public FileRepresentation(DataObject dataObject, Synchronizator sync) {
        super(sync);
        this.dataObject = dataObject;
        this.lastSave = this.getFileObject().lastModified();
    }

    private FileObject getFileObject() {
        return this.dataObject.getPrimaryFile();
    }

    @Override
    public boolean represents(Class type) {
        return FileObject.class.isAssignableFrom(type);
    }

    @Override
    public void update(Object change) {
    }

    @Override
    public Class getUpdateClass() {
        return null;
    }

    @Override
    public boolean isModified() {
        return this.lastSave.getTime() < this.getFileObject().lastModified().getTime();
    }

    @Override
    public String getDisplayName() {
        return Util.THIS.getString(FileRepresentation.class, "PROP_File_representation");
    }

    @Override
    public Object getChange(Class type) {
        if (type == null || type.isAssignableFrom(InputSource.class)) {
            try {
                InputSource source = new InputSource(this.getFileObject().getURL().toExternalForm());
                BufferedInputStream in = new BufferedInputStream(this.getFileObject().getInputStream());
                String encoding = EncodingUtil.detectEncoding((InputStream)in);
                if (encoding == null) {
                    encoding = "UTF8";
                }
                source.setCharacterStream(new InputStreamReader((InputStream)in, encoding));
                return source;
            }
            catch (IOException ex) {
                return null;
            }
        }
        if (type.isAssignableFrom(InputStream.class)) {
            try {
                return this.getFileObject().getInputStream();
            }
            catch (IOException ex) {
                return null;
            }
        }
        throw new RuntimeException("FileRepresentation does not support: " + type);
    }

    @Override
    public int level() {
        return 0;
    }

    private class FileListener
    extends FileChangeAdapter {
        private FileListener() {
        }

        public void fileChanged(FileEvent fe) {
            FileRepresentation.this.getSynchronizator().representationChanged(FileObject.class);
        }
    }
}

