/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.copylibstask;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class CopyLibs
extends Jar {
    private static final String LIB = "lib";
    private static final String ATTR_CLASS_PATH = "Class-Path";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String INDEX = "META-INF/INDEX.LIST";
    private static final String UTF_8 = "UTF-8";
    private static final String UTF8 = "UTF8";
    private static final String URL_SEPARATOR = "/";
    private static final String CP_SEPARATOR = " ";
    Path runtimePath;
    Path excludeFromCopy;
    private boolean rebase = true;

    public void setRuntimeClassPath(Path path) {
        assert (path != null);
        this.runtimePath = path;
    }

    public Path getRuntimeClassPath() {
        return this.runtimePath;
    }

    public void setExcludeFromCopy(Path path) {
        assert (path != null);
        this.excludeFromCopy = path;
    }

    public Path getExcludeFromCopy() {
        return this.excludeFromCopy;
    }

    public boolean isRebase() {
        return this.rebase;
    }

    public void setRebase(boolean rebase) {
        this.rebase = rebase;
    }

    public void setEncoding(String encoding) {
        if (!CopyLibs.isUTF8(encoding)) {
            this.getProject().log("It is not recommended to change encoding from UTF-8 as the created archive will be unreadable for Java. ", 1);
        }
        super.setEncoding(encoding);
    }

    public void addConfiguredManifest(Manifest newManifest) throws ManifestException {
        String value;
        Manifest.Attribute cpAttr;
        if (newManifest != null && this.runtimePath != null && (cpAttr = newManifest.getMainSection().getAttribute(ATTR_CLASS_PATH)) != null && (value = cpAttr.getValue()) != null) {
            HashSet<String> folders = new HashSet<String>();
            for (Resource res : this.runtimePath) {
                String simpleName = CopyLibs.basename(res.getName(), File.separator);
                if (res.isDirectory()) {
                    folders.add(simpleName);
                    continue;
                }
                folders.remove(simpleName);
            }
            CharSequence[] parts = value.split(CP_SEPARATOR);
            boolean changed = false;
            for (int i = 0; i < parts.length; ++i) {
                String name = parts[i];
                String simpleName = CopyLibs.basename(name, URL_SEPARATOR);
                if (!folders.contains(simpleName) || name.endsWith(URL_SEPARATOR)) continue;
                parts[i] = name + URL_SEPARATOR;
                changed = true;
            }
            if (changed) {
                value = CopyLibs.stringJoin(CP_SEPARATOR, parts);
                cpAttr.setValue(value);
            }
        }
        super.addConfiguredManifest(newManifest);
    }

    public void execute() throws BuildException {
        if (this.runtimePath == null) {
            throw new BuildException("RuntimeClassPath must be set.");
        }
        String[] pathElements = this.runtimePath.list();
        ArrayList<File> filesToCopy = new ArrayList<File>(pathElements.length);
        for (String pathElement : pathElements) {
            File f = new File(pathElement);
            if (!f.canRead()) {
                this.log(String.format("Not copying library %s , it can't be read.", f.getAbsolutePath()), 1);
                continue;
            }
            if (f.isDirectory()) {
                this.log(String.format("Not copying library %s , it's a directory.", f.getAbsolutePath()), 1);
                continue;
            }
            filesToCopy.add(f);
        }
        File destFile = this.getDestFile();
        File destFolder = destFile.getParentFile();
        assert (destFolder != null && destFolder.canWrite());
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.java.j2seproject.copylibstask.Bundle");
            assert (bundle != null);
            File readme = new File(destFolder, bundle.getString("TXT_README_FILE_NAME"));
            if (!readme.exists()) {
                readme.createNewFile();
            }
            try (String[] out = new PrintWriter(new FileWriter(readme));){
                String content = bundle.getString("TXT_README_FILE_CONTENT");
                out.println(MessageFormat.format(content, destFile.getName()));
            }
        }
        catch (IOException ioe) {
            this.log("Cannot generate readme file.", 3);
        }
        if (!filesToCopy.isEmpty()) {
            File libFolder = new File(destFolder, LIB);
            if (!libFolder.exists()) {
                libFolder.mkdir();
                this.log("Create lib folder " + libFolder.toString() + ".", 3);
            }
            assert (libFolder.canWrite());
            HashSet<File> ignoreList = new HashSet<File>();
            if (this.excludeFromCopy != null) {
                for (String excludeElement : this.excludeFromCopy.list()) {
                    ignoreList.add(new File(excludeElement));
                }
            }
            FileUtils utils = FileUtils.getFileUtils();
            this.log("Copy libraries to " + libFolder.toString() + ".");
            for (File fileToCopy : filesToCopy) {
                if (ignoreList.contains(fileToCopy)) {
                    this.log(String.format("Not copying library %s, due to exclude.", fileToCopy), 2);
                    continue;
                }
                this.log("Copy " + fileToCopy.getName() + " to " + libFolder + ".", 3);
                try {
                    File libFile = new File(libFolder, fileToCopy.getName());
                    if (this.rebase(fileToCopy, libFile)) continue;
                    libFile.delete();
                    utils.copyFile(fileToCopy, libFile);
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
            }
            FileSet fs = new FileSet();
            fs.setDir(libFolder);
            Path p = new Path(this.getProject());
            p.addFileset(fs);
            this.addConfiguredIndexJars(p);
        } else {
            this.log("Nothing to copy.");
        }
        super.execute();
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private boolean rebase(File source, File target) {
        if (!this.rebase) {
            return false;
        }
        try {
            Manifest manifest = null;
            try (ZipFile zf = new ZipFile(source, this.getEncoding());){
                if (zf.getEntry(INDEX) != null) {
                    boolean bl = false;
                    return bl;
                }
                ZipEntry manifestEntry = zf.getEntry(MANIFEST);
                if (manifestEntry != null) {
                    try (InputStreamReader in = new InputStreamReader(zf.getInputStream(manifestEntry), Charset.forName(UTF_8));){
                        manifest = new Manifest((Reader)in);
                    }
                }
                if (manifest == null) {
                    boolean in = false;
                    return in;
                }
                Manifest.Section mainSection = manifest.getMainSection();
                String classPath = mainSection.getAttributeValue(ATTR_CLASS_PATH);
                if (classPath == null) {
                    boolean bl = false;
                    return bl;
                }
                if (CopyLibs.isSigned(manifest)) {
                    boolean bl = false;
                    return bl;
                }
                StringBuilder result = new StringBuilder();
                boolean changed = false;
                for (String path : classPath.split(CP_SEPARATOR)) {
                    int index;
                    if (result.length() > 0) {
                        result.append(' ');
                    }
                    if ((index = path.lastIndexOf(47)) >= 0 && index < path.length() - 1) {
                        path = path.substring(index + 1);
                        changed = true;
                    }
                    result.append(path);
                }
                if (!changed) {
                    boolean bl = false;
                    return bl;
                }
                Enumeration zent = zf.getEntries();
                try (ZipOutputStream out = new ZipOutputStream(target);){
                    out.setEncoding(this.getEncoding());
                    while (zent.hasMoreElements()) {
                        ZipEntry entry = (ZipEntry)zent.nextElement();
                        InputStream in = zf.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            if (MANIFEST.equals(entry.getName())) {
                                out.putNextEntry(entry);
                                mainSection.removeAttribute(ATTR_CLASS_PATH);
                                mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_CLASS_PATH, result.toString()));
                                PrintWriter manifestOut = new PrintWriter(new OutputStreamWriter((OutputStream)out, Charset.forName(UTF_8)));
                                manifest.write(manifestOut);
                                manifestOut.flush();
                                continue;
                            }
                            out.putNextEntry(entry);
                            CopyLibs.copy(in, (OutputStream)out);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        catch (IOException | ManifestException e) {
            this.log("Cannot fix dependencies for: " + target.getAbsolutePath(), 1);
            return false;
        }
    }

    private static boolean isSigned(Manifest manifest) {
        Manifest.Section section = manifest.getSection(MANIFEST);
        if (section != null) {
            Enumeration sectionKeys = section.getAttributeKeys();
            while (sectionKeys.hasMoreElements()) {
                if (!((String)sectionKeys.nextElement()).endsWith("-Digest")) continue;
                return true;
            }
        }
        return false;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] BUFFER = new byte[4096];
        int len;
        while ((len = in.read(BUFFER)) != -1) {
            out.write(BUFFER, 0, len);
        }
        return;
    }

    private static boolean isUTF8(String encoding) {
        return UTF_8.equalsIgnoreCase(encoding) || UTF8.equalsIgnoreCase(encoding);
    }

    private static String basename(String name, String separator) {
        int endIndex = name.endsWith(separator) ? name.length() - 1 : name.length();
        int startIndex = name.lastIndexOf(separator.charAt(0), endIndex - 1);
        return endIndex == name.length() && startIndex == -1 ? name : name.substring(startIndex + 1, endIndex);
    }

    private static String stringJoin(CharSequence delimiter, CharSequence ... elements) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (CharSequence element : elements) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(element);
        }
        return sb.toString();
    }
}

