/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.expression;

import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.jpath.adapter.ConversionException;
import org.apache.taglibs.standard.lang.jpath.adapter.Convert;
import org.apache.taglibs.standard.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.standard.lang.jpath.adapter.JSPDate;
import org.apache.taglibs.standard.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.standard.lang.jpath.expression.Parser;
import org.apache.taglibs.standard.lang.jpath.expression.SimpleNode;

public class RollDateFunction
extends SimpleNode {
    public RollDateFunction(int id) {
        super(id);
    }

    public RollDateFunction(Parser p, int id) {
        super(p, id);
    }

    public String toNormalizedString() {
        boolean first = true;
        String normalized = "date-roll(";
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!first) {
                    normalized = normalized + ",";
                }
                first = false;
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                normalized = normalized + n.toNormalizedString();
            }
        }
        normalized = normalized + ")";
        return normalized;
    }

    public Object evaluate(PageContext pageContext, IterationContext icontext) throws EvaluationException {
        JSPDate result;
        try {
            result = Convert.toJSPDate(this.jjtGetChild(0).evaluate(pageContext, icontext));
            String arg2 = Convert.toString(this.jjtGetChild(1).evaluate(pageContext, icontext));
            int arg3 = Convert.toDouble(this.jjtGetChild(2).evaluate(pageContext, icontext)).intValue();
            int field = this.getCalendarConstant(arg2);
            result.roll(field, arg3);
        }
        catch (ConversionException ce) {
            throw new EvaluationException(this, ce.getMessage());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private int getCalendarConstant(String field) throws EvaluationException {
        void var2_2;
        int result;
        if (field.equals("era")) {
            result = 0;
        } else if (field.equals("year")) {
            result = 1;
        } else if (field.equals("month")) {
            result = 2;
        } else if (field.equals("weekOfYear")) {
            result = 3;
        } else if (field.equals("date")) {
            result = 5;
        } else if (field.equals("dayOfMonth")) {
            result = 5;
        } else if (field.equals("dayOfYear")) {
            result = 6;
        } else if (field.equals("dayOfWeek")) {
            result = 7;
        } else if (field.equals("dayOfWeekInMonth")) {
            result = 8;
        } else if (field.equals("amPm")) {
            result = 9;
        } else if (field.equals("hour")) {
            result = 10;
        } else if (field.equals("hourOfDay")) {
            result = 11;
        } else if (field.equals("minute")) {
            result = 12;
        } else if (field.equals("second")) {
            result = 13;
        } else if (field.equals("millisecond")) {
            result = 14;
        } else {
            throw new EvaluationException(this, "An invalid date field was supplied");
        }
        return (int)var2_2;
    }
}

