/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.util.List;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;

public final class TestsuiteNodeChildren
extends ChildFactory<Testcase> {
    private Report report;
    private int filterMask;

    public TestsuiteNodeChildren(Report report, int filterMask) {
        this.report = report;
        this.filterMask = filterMask;
    }

    protected boolean createKeys(List<Testcase> toPopulate) {
        if (this.report != null) {
            for (Testcase testcase : this.report.getTests()) {
                if (testcase.getStatus().isMaskApplied(this.filterMask)) continue;
                toPopulate.add(testcase);
            }
        }
        return true;
    }

    protected Node createNodeForKey(Testcase testcase) {
        if (testcase.getStatus().isMaskApplied(this.filterMask)) {
            return null;
        }
        return Manager.getInstance().getNodeFactory().createTestMethodNode(testcase, this.report.getProject());
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void notifyTestSuiteFinished() {
        this.refresh(false);
    }

    public void setFilterMask(int filterMask) {
        int diff = this.filterMask ^ filterMask;
        if (filterMask == this.filterMask) {
            return;
        }
        this.filterMask = filterMask;
        if (this.report != null) {
            for (Testcase testcase : this.report.getTests()) {
                if (!testcase.getStatus().isMaskApplied(diff)) continue;
                this.refresh(false);
                break;
            }
        }
    }
}

