/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.vcs.HookUtils;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FormatPanel
extends JPanel {
    private final VCSHooksConfig.Format defaultIssueInfoTemplate;
    private final VCSHooksConfig.Format defaultRevisionTemplate;
    private final String[] supportedIssueInfoVariables;
    private final String[] supportedRevisionVariables;
    private JRadioButton aboveCommitRadio;
    private JRadioButton belowCommitRadio;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JTextArea issueInfoTextArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel placeholder;
    private JButton resetCommitButton;
    private JButton resetIssueButton;
    private JTextArea revisionTextArea;
    private JLabel warningLabel;

    FormatPanel(VCSHooksConfig.Format revisionTemplate, VCSHooksConfig.Format defaultRevisionTemplate, String[] supportedRevisionVariables, VCSHooksConfig.Format issueInfoTemplate, VCSHooksConfig.Format defaultIssueInfoTemplate, String[] supportedIssueInfoVariables) {
        this.initComponents();
        this.warningLabel.setVisible(false);
        this.defaultIssueInfoTemplate = defaultIssueInfoTemplate;
        this.supportedIssueInfoVariables = supportedIssueInfoVariables;
        this.defaultRevisionTemplate = defaultRevisionTemplate;
        this.supportedRevisionVariables = supportedRevisionVariables;
        this.setRevisionTemplate(revisionTemplate);
        this.setIssueInfoTemplate(issueInfoTemplate);
        this.issueInfoTextArea.getDocument().addDocumentListener(new MsgListener(this.issueInfoTextArea));
        this.revisionTextArea.getDocument().addDocumentListener(new MsgListener(this.revisionTextArea));
    }

    VCSHooksConfig.Format getCommitFormat() {
        return new VCSHooksConfig.Format(this.aboveCommitRadio.isSelected(), this.issueInfoTextArea.getText());
    }

    VCSHooksConfig.Format getIssueFormat() {
        return new VCSHooksConfig.Format(false, this.revisionTextArea.getText());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.issueInfoTextArea = new JTextArea();
        this.jLabel2 = new JLabel();
        this.aboveCommitRadio = new JRadioButton();
        this.belowCommitRadio = new JRadioButton();
        this.resetCommitButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.revisionTextArea = new JTextArea();
        this.resetIssueButton = new JButton();
        this.jLabel4 = new JLabel();
        this.warningLabel = new JLabel();
        this.placeholder = new JLabel();
        this.jLabel1.setLabelFor(this.issueInfoTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jLabel1.text"));
        this.issueInfoTextArea.setColumns(20);
        this.issueInfoTextArea.setFont(new Font("Monospaced", 0, 13));
        this.issueInfoTextArea.setRows(5);
        this.issueInfoTextArea.setToolTipText(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.issueInfoTextArea.toolTipText"));
        this.jScrollPane1.setViewportView(this.issueInfoTextArea);
        this.issueInfoTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jTextArea1.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jLabel2.text"));
        this.buttonGroup1.add(this.aboveCommitRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.aboveCommitRadio, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.aboveCommitRadio.text"));
        this.buttonGroup1.add(this.belowCommitRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.belowCommitRadio, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.belowCommitRadio.text"));
        this.belowCommitRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormatPanel.this.belowCommitRadioActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.resetCommitButton, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.resetCommitButton.text"));
        this.resetCommitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormatPanel.this.resetCommitButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setLabelFor(this.revisionTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jLabel3.text"));
        this.revisionTextArea.setColumns(20);
        this.revisionTextArea.setFont(new Font("Monospaced", 0, 13));
        this.revisionTextArea.setRows(5);
        this.revisionTextArea.setToolTipText(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.revisionTextArea.toolTipText"));
        this.jScrollPane2.setViewportView(this.revisionTextArea);
        Mnemonics.setLocalizedText((AbstractButton)this.resetIssueButton, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.resetIssueButton.text"));
        this.resetIssueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormatPanel.this.resetIssueButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jLabel4.text"));
        this.warningLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/bugtracking/bridge/resources/warning.gif")));
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.warningLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.placeholder, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.placeholder.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aboveCommitRadio).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.resetIssueButton).addComponent(this.belowCommitRadio))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 89, Short.MAX_VALUE).addComponent(this.resetCommitButton)).addComponent(this.jLabel4).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 236, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 236, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -1, 233, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.warningLabel, -1, 461, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.placeholder, -2, 14, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 131, -2).addComponent(this.jScrollPane2, -2, 131, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.aboveCommitRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.belowCommitRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetIssueButton)).addComponent(this.resetCommitButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.warningLabel).addComponent(this.placeholder)).addContainerGap()));
        this.aboveCommitRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.aboveRadio.AccessibleContext.accessibleDescription"));
        this.belowCommitRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.beloveRadio.AccessibleContext.accessibleDescription"));
        this.resetCommitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jButton1.AccessibleContext.accessibleDescription"));
        this.resetIssueButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.resetIssueButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.AccessibleContext.accessibleDescription"));
    }

    private void belowCommitRadioActionPerformed(ActionEvent evt) {
    }

    private void resetCommitButtonActionPerformed(ActionEvent evt) {
        this.setRevisionTemplate(this.defaultRevisionTemplate);
    }

    private void resetIssueButtonActionPerformed(ActionEvent evt) {
        this.setIssueInfoTemplate(this.defaultIssueInfoTemplate);
    }

    private void setRevisionTemplate(VCSHooksConfig.Format format) {
        this.revisionTextArea.setText(format.getFormat());
    }

    private void setIssueInfoTemplate(VCSHooksConfig.Format format) {
        this.issueInfoTextArea.setText(format.getFormat());
        this.aboveCommitRadio.setSelected(format.isAbove());
        this.belowCommitRadio.setSelected(!format.isAbove());
    }

    private void validateText(JTextArea textArea) {
        assert (textArea == this.revisionTextArea || textArea == this.issueInfoTextArea);
        String[] variables = textArea == this.revisionTextArea ? this.supportedRevisionVariables : this.supportedIssueInfoVariables;
        boolean valid = !HookUtils.containsUnsupportedVariables(textArea.getText(), variables);
        this.warningLabel.setText(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.warningLabel.text", (Object)this.list(variables)));
        this.warningLabel.setVisible(!valid);
    }

    private String list(String[] str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            sb.append("{");
            sb.append(str[i]);
            sb.append("}");
            if (i >= str.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private class MsgListener
    implements DocumentListener {
        private final JTextArea textArea;

        public MsgListener(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FormatPanel.this.validateText(this.textArea);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FormatPanel.this.validateText(this.textArea);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            FormatPanel.this.validateText(this.textArea);
        }
    }
}

