/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser.processors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.javafx2.editor.parser.BuildEnvironment;
import org.netbeans.modules.javafx2.editor.parser.ModelBuilderStep;
import org.netbeans.modules.javafx2.editor.parser.processors.Bundle;

public class NamedInstancesCollector
extends FxNodeVisitor.ModelTreeTraversal
implements ModelBuilderStep {
    private Map<String, FxInstance> instances = null;
    private BuildEnvironment env;
    private FxNode parentNode;

    public NamedInstancesCollector() {
    }

    public NamedInstancesCollector(BuildEnvironment env) {
        this.env = env;
    }

    @Override
    protected void visitBaseInstance(FxInstance i) {
        if (i.getId() == null) {
            if (this.parentNode != null && this.parentNode.getKind() == FxNode.Kind.Element && "define".equals(this.parentNode.getSourceName())) {
                TextPositions pos = this.env.getTreeUtilities().positions(i);
                this.env.addError(new ErrorMark(pos.getStart(), pos.getContentStart() - pos.getStart(), "define-must-provide-id", Bundle.ERR_defineMustProvideId(i.getSourceName()), i));
            }
            super.visitBaseInstance(i);
            return;
        }
        if (this.instances == null) {
            this.instances = Collections.singletonMap(i.getId(), i);
        } else {
            Map<String, FxInstance> newInstances;
            if (this.instances.size() == 1) {
                newInstances = new HashMap<String, FxInstance>();
                newInstances.putAll(this.instances);
                this.instances = newInstances;
            } else {
                newInstances = this.instances;
            }
            if (newInstances.containsKey(i.getId())) {
                TextPositions pos = this.env.getTreeUtilities().positions(i);
                this.env.addError(new ErrorMark(pos.getStart(), pos.getContentStart() - pos.getStart(), "duplicate-id", Bundle.ERR_duplicateIdentifier(), i));
            } else {
                newInstances.put(i.getId(), i);
            }
        }
        super.visitBaseInstance(i);
    }

    @Override
    public void visitNode(FxNode node) {
        FxNode previous = this.parentNode;
        this.parentNode = node;
        super.visitNode(node);
        this.parentNode = previous;
    }

    @Override
    public void visitSource(FxModel source) {
        super.visitSource(source);
        if (this.instances != null) {
            this.env.getAccessor().setNamedInstances(source, this.instances);
        }
    }

    @Override
    public FxNodeVisitor createVisitor(BuildEnvironment env) {
        return new NamedInstancesCollector(env);
    }
}

