/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterFactory;
import org.primefaces.expression.SearchExpressionFacade;

public class DataExporter
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression type;
    private ValueExpression fileName;
    private ValueExpression encoding;
    private ValueExpression pageOnly;
    private ValueExpression selectionOnly;
    private MethodExpression preProcessor;
    private MethodExpression postProcessor;

    public DataExporter() {
    }

    public DataExporter(ValueExpression target, ValueExpression type, ValueExpression fileName, ValueExpression pageOnly, ValueExpression selectionOnly, ValueExpression encoding, MethodExpression preProcessor, MethodExpression postProcessor) {
        this.target = target;
        this.type = type;
        this.fileName = fileName;
        this.pageOnly = pageOnly;
        this.selectionOnly = selectionOnly;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.encoding = encoding;
    }

    public void processAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        String tableId = (String)this.target.getValue(elContext);
        String exportAs = (String)this.type.getValue(elContext);
        String outputFileName = (String)this.fileName.getValue(elContext);
        String encodingType = "UTF-8";
        if (this.encoding != null) {
            encodingType = (String)this.encoding.getValue(elContext);
        }
        boolean isPageOnly = false;
        if (this.pageOnly != null) {
            isPageOnly = this.pageOnly.isLiteralText() ? Boolean.valueOf(this.pageOnly.getValue(context.getELContext()).toString()) : (Boolean)this.pageOnly.getValue(context.getELContext());
        }
        boolean isSelectionOnly = false;
        if (this.selectionOnly != null) {
            isSelectionOnly = this.selectionOnly.isLiteralText() ? Boolean.valueOf(this.selectionOnly.getValue(context.getELContext()).toString()) : (Boolean)this.selectionOnly.getValue(context.getELContext());
        }
        try {
            Exporter exporter = ExporterFactory.getExporterForType(exportAs);
            UIComponent component = SearchExpressionFacade.resolveComponent(context, event.getComponent(), tableId);
            if (!(component instanceof DataTable)) {
                throw new FacesException("Unsupported datasource target:\"" + component.getClass().getName() + "\", exporter must target a PrimeFaces DataTable.");
            }
            DataTable table = (DataTable)component;
            exporter.export(context, table, outputFileName, isPageOnly, isSelectionOnly, encodingType, this.preProcessor, this.postProcessor);
            context.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private int[] resolveExcludedColumnIndexes(Object columnsToExclude) {
        if (columnsToExclude == null || columnsToExclude.equals("")) {
            return null;
        }
        String[] columnIndexesAsString = ((String)columnsToExclude).split(",");
        int[] indexes = new int[columnIndexesAsString.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = Integer.parseInt(columnIndexesAsString[i].trim());
        }
        return indexes;
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (ValueExpression)values[0];
        this.type = (ValueExpression)values[1];
        this.fileName = (ValueExpression)values[2];
        this.pageOnly = (ValueExpression)values[3];
        this.selectionOnly = (ValueExpression)values[4];
        this.preProcessor = (MethodExpression)values[5];
        this.postProcessor = (MethodExpression)values[6];
        this.encoding = (ValueExpression)values[7];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.target, this.type, this.fileName, this.pageOnly, this.selectionOnly, this.preProcessor, this.postProcessor, this.encoding};
        return values;
    }
}

