/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.task;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class GTest {
    String prefix = "http://localhost:8080/test";
    String host = "localhost";
    int port = 8080;
    int debug = 0;
    String description = "No description";
    String request;
    Hashtable requestHeaders;
    String content;
    boolean magnitude = true;
    boolean exactMatch = false;
    String goldenFile;
    String responseMatch;
    Hashtable expectHeaders;
    String returnCode = "";
    String responseLine;
    String responseBody;
    Hashtable headers;

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setHost(String h) {
        this.host = h;
    }

    public void setPort(String portS) {
        this.port = Integer.valueOf(portS);
    }

    public void setExactMatch(String exact) {
        this.exactMatch = Boolean.valueOf(exact);
    }

    public void setPortInt(int i) {
        this.port = i;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setContent(String s) {
        this.content = s;
    }

    public void setDebug(String debugS) {
        this.debug = Integer.valueOf(debugS);
    }

    public void setMagnitude(String magnitudeS) {
        this.magnitude = Boolean.valueOf(magnitudeS);
    }

    public void setGoldenFile(String s) {
        this.goldenFile = s;
    }

    public void setExpectHeaders(String s) {
        this.expectHeaders = new Hashtable();
        this.parseHeader(s, this.expectHeaders);
    }

    public void setResponseMatch(String s) {
        this.responseMatch = s;
    }

    public void setRequest(String s) {
        this.request = s;
    }

    public void setReturnCode(String s) {
        this.returnCode = s;
    }

    public void setHeaders(String s) {
        this.requestHeaders = new Hashtable();
        this.parseHeader(s, this.requestHeaders);
    }

    public void execute() throws Exception {
        try {
            this.dispatch(this.request, null);
            boolean result = this.checkResponse(this.magnitude);
            if (result) {
                if ("No description".equals(this.description)) {
                    System.out.println("OK " + this.request);
                } else {
                    System.out.println("OK " + this.description + " (" + this.request + ")");
                }
            } else if ("No description".equals(this.description)) {
                System.out.println("FAIL " + this.request);
            } else {
                System.out.println("FAIL " + this.description + " (" + this.request + ")");
            }
        }
        catch (Exception ex) {
            if ("No description".equals(this.description)) {
                System.out.println("FAIL " + this.request);
            } else {
                System.out.println("FAIL " + this.description + " (" + this.request + ")");
            }
            ex.printStackTrace();
        }
    }

    private boolean checkResponse(boolean testCondition) throws Exception {
        boolean responseStatus = true;
        if (this.request.indexOf("HTTP/1.") > -1) {
            boolean match;
            boolean bl = match = this.responseLine != null && this.responseLine.indexOf(this.returnCode) > -1;
            if (match != testCondition) {
                responseStatus = false;
                System.out.println("ERROR in: " + this.request);
                System.out.println("    Expecting: " + this.returnCode);
                System.out.println("    Got      : " + this.responseLine);
            }
        }
        if (this.expectHeaders != null) {
            if (this.headers == null) {
                System.out.println("ERROR no response header, expecting header");
            }
            Enumeration e = this.expectHeaders.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)this.expectHeaders.get(key);
                String respValue = (String)this.headers.get(key);
                if (respValue != null && respValue.indexOf(value) >= 0) continue;
                System.out.println("ERROR expecting header " + key + ":" + value + " GOT: " + respValue + " HEADERS(" + this.headers + ")");
                return false;
            }
        }
        if (this.responseMatch != null) {
            if (this.responseBody == null) {
                System.out.println("ERROR: got no response, expecting " + this.responseMatch);
                return false;
            }
            if (this.responseBody.indexOf(this.responseMatch) < 0) {
                responseStatus = false;
                System.out.println("ERROR: expecting match on " + this.responseMatch);
                System.out.println("GOT: ");
                System.out.println(this.responseBody);
            }
        }
        if (this.goldenFile == null) {
            return responseStatus;
        }
        StringBuffer expResult = this.getExpectedResult();
        boolean cmp = true;
        cmp = this.exactMatch ? this.compare(this.responseBody, expResult.toString()) : this.compareWeek(this.responseBody, expResult.toString());
        if (cmp != testCondition) {
            responseStatus = false;
            System.out.println("ERROR (" + cmp + "," + testCondition + ")in : " + this.request);
            System.out.println("====================Expecting: ");
            System.out.println(expResult);
            System.out.println("====================Got:");
            System.out.println(this.responseBody);
            System.out.println("====================");
        }
        return responseStatus;
    }

    private void dispatch(String request, Hashtable requestHeaders) throws Exception {
        Socket s = null;
        s = new Socket(this.host, this.port);
        InputStream is = s.getInputStream();
        s.setSoLinger(true, 1000);
        OutputStream os = s.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(os);
        PrintWriter pw = new PrintWriter(out);
        try {
            pw.println(request);
            if (this.content != null) {
                pw.println("Content-Length: " + this.content.length());
            }
            if (request.indexOf("HTTP/1.") > -1) {
                pw.println("");
            }
            if (this.content != null) {
                pw.print(this.content);
            }
            pw.flush();
        }
        catch (Exception ex1) {
            System.out.println("Error writing request " + ex1);
        }
        try {
            StringBuffer result;
            if (request.indexOf("HTTP/1.") > -1) {
                this.responseLine = this.read(is);
                if (this.debug > 0) {
                    System.out.println("RESPONSE: " + this.responseLine);
                }
                this.headers = this.parseHeaders(is);
            }
            if ((result = this.readBody(is)) != null) {
                this.responseBody = result.toString();
            }
            if (this.debug > 0) {
                System.out.println("BODY: " + this.responseBody);
            }
        }
        catch (SocketException ex) {
            System.out.println("Socket Exception: " + ex);
            ex.printStackTrace();
            s.close();
            return;
        }
        s.close();
    }

    private StringBuffer getExpectedResult() throws IOException {
        StringBuffer expResult = new StringBuffer("NONE");
        try {
            FileInputStream in = new FileInputStream(this.goldenFile);
            return this.readBody(in);
        }
        catch (Exception ex) {
            System.out.println("\tGolden file not found: " + this.goldenFile);
            return expResult;
        }
    }

    private boolean compare(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        if (str1.length() != str2.length()) {
            System.out.println("Wrong size " + str1.length() + " " + str2.length());
            return false;
        }
        int i = 0;
        while (i < str1.length()) {
            if (str1.charAt(i) != str2.charAt(i)) {
                System.out.println("Error at " + i + " " + str1.charAt(1) + str2.charAt(i));
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean compareWeek(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        StringTokenizer st1 = new StringTokenizer(str1);
        StringTokenizer st2 = new StringTokenizer(str2);
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            String tok2;
            String tok1 = st1.nextToken();
            if (tok1.equals(tok2 = st2.nextToken())) continue;
            System.out.println("\tFAIL*** : Rtok1 = " + tok1 + ", Etok2 = " + tok2);
            return false;
        }
        return !st1.hasMoreTokens() && !st2.hasMoreTokens();
    }

    StringBuffer readBody(InputStream input) {
        StringBuffer sb = new StringBuffer();
        while (true) {
            try {
                int ch = input.read();
                if (ch < 0) {
                    if (sb.length() != 0) break;
                    return null;
                }
                sb.append((char)ch);
            }
            catch (IOException ex) {
                return sb;
            }
        }
        return sb;
    }

    private Hashtable parseHeaders(InputStream is) throws IOException {
        String line;
        Hashtable headers = new Hashtable();
        while ((line = this.read(is)) != null && line.length() >= 1) {
            this.parseHeader(line, headers);
            if (this.debug <= 0) continue;
            System.out.println("HEADER: " + line + "X");
        }
        return headers;
    }

    private void parseHeader(String line, Hashtable headers) {
        int colon = line.indexOf(":");
        if (colon < 0) {
            System.out.println("ERROR: Wrong Header Line: " + line);
            return;
        }
        String name = line.substring(0, colon).trim();
        String value = line.substring(colon + 1).trim();
        headers.put(name, value);
    }

    private String read(InputStream input) throws IOException {
        int n;
        StringBuffer sb = new StringBuffer();
        while (true) {
            try {
                int ch = input.read();
                if (ch < 0) {
                    if (sb.length() != 0) break;
                    if (this.debug > 0) {
                        System.out.println("Error reading line " + ch + " " + sb.toString());
                    }
                    return "";
                }
                if (ch == 10) break;
                sb.append((char)ch);
            }
            catch (IOException ex) {
                System.out.println("Error reading : " + ex);
                this.debug = 1;
                if (this.debug > 0) {
                    System.out.println("Partial read: " + sb.toString());
                }
                ex.printStackTrace();
            }
        }
        if ((n = sb.length()) > 0 && sb.charAt(n - 1) == '\r') {
            sb.setLength(n - 1);
        }
        return sb.toString();
    }
}

