/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.TypeDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileEnumDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ObjectTypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SignatureParser;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.AggregateFieldsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateInstructionsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.InitEnumVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.InitInnerClassVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.InitInstanceFieldVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.InitStaticFieldVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.RemoveDefaultConstructorVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SortMembersVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.UpdateBridgeMethodVisitor;

public class UpdateJavaSyntaxTreeVisitor
extends AbstractJavaSyntaxVisitor {
    protected static final AggregateFieldsVisitor AGGREGATE_FIELDS_VISITOR = new AggregateFieldsVisitor();
    protected static final SortMembersVisitor SORT_MEMBERS_VISITOR = new SortMembersVisitor();
    protected InitInnerClassVisitor initInnerClassVisitor = new InitInnerClassVisitor();
    protected InitStaticFieldVisitor initStaticFieldVisitor = new InitStaticFieldVisitor();
    protected InitInstanceFieldVisitor initInstanceFieldVisitor = new InitInstanceFieldVisitor();
    protected InitEnumVisitor initEnumVisitor = new InitEnumVisitor();
    protected UpdateBridgeMethodVisitor replaceBridgeMethodVisitor = new UpdateBridgeMethodVisitor();
    protected CreateInstructionsVisitor createInstructionsVisitor;
    protected RemoveDefaultConstructorVisitor removeDefaultConstructorVisitor;
    protected TypeDeclaration typeDeclaration;

    public UpdateJavaSyntaxTreeVisitor(ObjectTypeMaker objectTypeMaker, SignatureParser signatureParser) {
        this.createInstructionsVisitor = new CreateInstructionsVisitor(objectTypeMaker, signatureParser);
        this.removeDefaultConstructorVisitor = new RemoveDefaultConstructorVisitor(signatureParser);
    }

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.typeDeclaration = declaration;
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        if (bodyDeclaration.getInnerTypeDeclarations() != null) {
            TypeDeclaration td = this.typeDeclaration;
            this.acceptListDeclaration(bodyDeclaration.getInnerTypeDeclarations());
            this.typeDeclaration = td;
        }
        this.initStaticFieldVisitor.setInternalTypeName(this.typeDeclaration.getInternalName());
        this.createInstructionsVisitor.visit(declaration);
        this.initInnerClassVisitor.visit(declaration);
        this.initStaticFieldVisitor.visit(declaration);
        this.initInstanceFieldVisitor.visit(declaration);
        this.removeDefaultConstructorVisitor.visit(declaration);
        AGGREGATE_FIELDS_VISITOR.visit(declaration);
        SORT_MEMBERS_VISITOR.visit(declaration);
        if (bodyDeclaration.getOuterBodyDeclaration() == null && bodyDeclaration.getInnerTypeDeclarations() != null && this.replaceBridgeMethodVisitor.init(bodyDeclaration)) {
            this.replaceBridgeMethodVisitor.visit(bodyDeclaration);
        }
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.typeDeclaration = declaration;
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        ClassFileEnumDeclaration cfed = (ClassFileEnumDeclaration)declaration;
        this.typeDeclaration = declaration;
        cfed.setFlags(cfed.getFlags() ^ 0x18);
        cfed.getBodyDeclaration().accept(this);
        this.initEnumVisitor.visit(cfed.getBodyDeclaration());
        cfed.setConstants(this.initEnumVisitor.getConstants());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.typeDeclaration = declaration;
        this.safeAccept(declaration.getBodyDeclaration());
    }
}

