/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.ArrayVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclaration;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.EnumConstantReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.NewArray;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.reference.InnerObjectReference;
import org.jd.core.v1.model.javasyntax.reference.ObjectReference;
import org.jd.core.v1.model.javasyntax.statement.AssertStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.ByteCodeStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.model.javasyntax.type.ArrayTypeArguments;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeBounds;
import org.jd.core.v1.model.javasyntax.type.TypeParameterWithTypeBounds;
import org.jd.core.v1.model.javasyntax.type.Types;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SignatureParser;
import org.jd.core.v1.util.DefaultList;

public class UpdateIntegerConstantTypeVisitor
extends AbstractJavaSyntaxVisitor {
    protected static final HashMap<String, List<Type>> TYPES = new HashMap();
    protected static final DimensionTypes DIMENSION_TYPES = new DimensionTypes();
    protected static final ObjectTypeReferenceExpression TYPE_CHARACTER_REFERENCE = new ObjectTypeReferenceExpression(ObjectType.TYPE_CHARACTER);
    protected static final ObjectTypeReferenceExpression TYPE_BYTE_REFERENCE = new ObjectTypeReferenceExpression(ObjectType.TYPE_BYTE);
    protected static final ObjectTypeReferenceExpression TYPE_SHORT_REFERENCE = new ObjectTypeReferenceExpression(ObjectType.TYPE_SHORT);
    protected static final ObjectTypeReferenceExpression TYPE_INTEGER_REFERENCE = new ObjectTypeReferenceExpression(ObjectType.TYPE_INTEGER);
    protected SignatureParser signatureParser;
    protected Type returnedType;
    protected Type arrayVariableInitializerType;

    public UpdateIntegerConstantTypeVisitor(SignatureParser signatureParser, Type returnedType) {
        this.signatureParser = signatureParser;
        this.returnedType = returnedType;
    }

    @Override
    public void visit(AssertStatement statement) {
        statement.setCondition(this.updateBooleanExpression(statement.getCondition()));
    }

    @Override
    public void visit(DoWhileStatement statement) {
        statement.setCondition(this.safeUpdateBooleanExpression(statement.getCondition()));
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(ForStatement statement) {
        this.safeAccept(statement.getDeclaration());
        this.safeAccept(statement.getInit());
        statement.setCondition(this.safeUpdateBooleanExpression(statement.getCondition()));
        this.safeAccept(statement.getUpdate());
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(IfStatement statement) {
        statement.setCondition(this.updateBooleanExpression(statement.getCondition()));
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(IfElseStatement statement) {
        statement.setCondition(this.updateBooleanExpression(statement.getCondition()));
        this.safeAccept(statement.getStatements());
        statement.getElseStatements().accept(this);
    }

    @Override
    public void visit(WhileStatement statement) {
        statement.setCondition(this.updateBooleanExpression(statement.getCondition()));
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(ReturnExpressionStatement statement) {
        statement.setExpression(this.updateExpression(this.returnedType, statement.getExpression()));
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        Expression left = expression.getLeftExpression();
        Expression right = expression.getRightExpression();
        switch (expression.getOperator()) {
            case "&": 
            case "|": 
            case "^": {
                left.accept(this);
                right.accept(this);
                break;
            }
            case "=": {
                left.accept(this);
                expression.setRightExpression(this.updateExpression(left.getType(), right));
                break;
            }
            case ">": 
            case ">=": 
            case "<": 
            case "<=": 
            case "==": 
            case "!=": {
                Type leftType = left.getType();
                Type rightType = right.getType();
                if (leftType.getDimension() == 0 && rightType.getDimension() == 0) {
                    if (leftType.isPrimitive()) {
                        if (rightType.isPrimitive()) {
                            Type type;
                            if (leftType == rightType) {
                                type = leftType;
                            } else {
                                type = PrimitiveTypeUtil.getCommonPrimitiveType((PrimitiveType)leftType, (PrimitiveType)rightType);
                                if (type == null) {
                                    type = PrimitiveType.TYPE_INT;
                                }
                            }
                            expression.setLeftExpression(this.updateExpression(type, left));
                            expression.setRightExpression(this.updateExpression(type, right));
                            break;
                        }
                        expression.setLeftExpression(this.updateExpression(rightType, left));
                        right.accept(this);
                        break;
                    }
                    if (!rightType.isPrimitive()) break;
                    left.accept(this);
                    expression.setRightExpression(this.updateExpression(leftType, right));
                    break;
                }
                left.accept(this);
                right.accept(this);
                break;
            }
            default: {
                expression.setRightExpression(this.updateExpression(expression.getType(), right));
                expression.setLeftExpression(this.updateExpression(expression.getType(), left));
            }
        }
    }

    @Override
    public void visit(LambdaIdentifiersExpression expression) {
        Type rt = this.returnedType;
        this.returnedType = expression.getReturnedType();
        this.safeAccept(expression.getStatements());
        this.returnedType = rt;
    }

    @Override
    public void visit(SuperConstructorInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            expression.setParameters(this.updateExpressions(this.signatureParser.parseParameterTypes(expression.getDescriptor()), parameters));
        }
    }

    @Override
    public void visit(ConstructorInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            expression.setParameters(this.updateExpressions(this.signatureParser.parseParameterTypes(expression.getDescriptor()), parameters));
        }
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            String internalTypeName = expression.getInternalTypeName();
            String name = expression.getName();
            String descriptor = expression.getDescriptor();
            List<Type> types = TYPES.get(internalTypeName + ':' + name + descriptor);
            if (types == null) {
                types = this.signatureParser.parseParameterTypes(descriptor);
            }
            expression.setParameters(this.updateExpressions(types, parameters));
        }
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(NewExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            String internalTypeName = expression.getObjectType().getInternalName();
            String descriptor = expression.getDescriptor();
            List<Type> types = TYPES.get(internalTypeName + ":<init>" + descriptor);
            if (types == null) {
                types = this.signatureParser.parseParameterTypes(descriptor);
            }
            expression.setParameters(this.updateExpressions(types, parameters));
        }
    }

    @Override
    public void visit(NewArray expression) {
        BaseExpression dimensions = expression.getDimensionExpressionList();
        if (dimensions != null) {
            this.updateExpressions(DIMENSION_TYPES, dimensions);
        }
    }

    @Override
    public void visit(ArrayExpression expression) {
        expression.getExpression().accept(this);
        expression.setIndex(this.updateExpression(PrimitiveType.TYPE_INT, expression.getIndex()));
    }

    @Override
    public void visit(CastExpression expression) {
        expression.setExpression(this.updateExpression(expression.getType(), expression.getExpression()));
    }

    @Override
    public void visit(TernaryOperatorExpression expression) {
        Type trueType = expression.getExpressionTrue().getType();
        Type falseType = expression.getExpressionFalse().getType();
        expression.setCondition(this.updateBooleanExpression(expression.getCondition()));
        if (trueType.isPrimitive()) {
            if (falseType.isPrimitive()) {
                expression.setExpressionTrue(this.updateExpression(PrimitiveType.TYPE_INT, expression.getExpressionTrue()));
                expression.setExpressionFalse(this.updateExpression(PrimitiveType.TYPE_INT, expression.getExpressionFalse()));
            } else {
                expression.getExpressionTrue().accept(this);
                expression.setExpressionTrue(this.updateExpression(falseType, expression.getExpressionTrue()));
            }
        } else if (falseType.isPrimitive()) {
            expression.setExpressionFalse(this.updateExpression(trueType, expression.getExpressionFalse()));
            expression.getExpressionFalse().accept(this);
        } else {
            expression.getExpressionTrue().accept(this);
            expression.getExpressionFalse().accept(this);
        }
    }

    @Override
    public void visit(ArrayVariableInitializer declaration) {
        Type t = this.arrayVariableInitializerType;
        this.arrayVariableInitializerType = declaration.getType();
        this.acceptListDeclaration(declaration);
        this.arrayVariableInitializerType = t;
    }

    @Override
    public void visit(LocalVariableDeclaration declaration) {
        Type t = this.arrayVariableInitializerType;
        this.arrayVariableInitializerType = declaration.getType();
        declaration.getLocalVariableDeclarators().accept(this);
        this.arrayVariableInitializerType = t;
    }

    @Override
    public void visit(FieldDeclaration declaration) {
        Type t = this.arrayVariableInitializerType;
        this.arrayVariableInitializerType = declaration.getType();
        declaration.getFieldDeclarators().accept(this);
        this.arrayVariableInitializerType = t;
    }

    @Override
    public void visit(ExpressionVariableInitializer declaration) {
        if (declaration != null) {
            declaration.setExpression(this.updateExpression(this.arrayVariableInitializerType, declaration.getExpression()));
        }
    }

    protected BaseExpression updateExpressions(List<Type> types, BaseExpression expressions) {
        if (expressions.isList()) {
            DefaultList list = expressions.getList();
            for (int i = list.size() - 1; i >= 0; --i) {
                Expression parameter;
                Expression updatedParameter;
                Type type = types.get(i);
                if (type.getDimension() != 0 || !type.isPrimitive() || (updatedParameter = this.updateExpression(type, parameter = (Expression)list.get(i))).getClass() != IntegerConstantExpression.class) continue;
                switch (PrimitiveTypeUtil.getStandardPrimitiveTypeFlags(((PrimitiveType)type).getFlags())) {
                    case 16: 
                    case 32: {
                        list.set(i, new CastExpression(type, updatedParameter));
                    }
                }
            }
        } else {
            Expression updatedParameter;
            Type type = types.get(0);
            if (type.getDimension() == 0 && type.isPrimitive() && (updatedParameter = this.updateExpression(type, (Expression)expressions)).getClass() == IntegerConstantExpression.class) {
                switch (PrimitiveTypeUtil.getStandardPrimitiveTypeFlags(((PrimitiveType)type).getFlags())) {
                    case 16: 
                    case 32: {
                        expressions = new CastExpression(type, updatedParameter);
                    }
                }
            }
        }
        expressions.accept(this);
        return expressions;
    }

    protected Expression updateExpression(Type type, Expression expression) {
        assert (type != PrimitiveType.TYPE_VOID);
        if (type != expression.getType()) {
            Class<?> clazz = expression.getClass();
            if (clazz == IntegerConstantExpression.class) {
                if (type == ObjectType.TYPE_STRING) {
                    type = PrimitiveType.TYPE_CHAR;
                }
                if (type.isPrimitive()) {
                    PrimitiveType primitiveType = (PrimitiveType)type;
                    IntegerConstantExpression ice = (IntegerConstantExpression)expression;
                    PrimitiveType icePrimitiveType = (PrimitiveType)ice.getType();
                    int value = ice.getValue();
                    int lineNumber = ice.getLineNumber();
                    switch (PrimitiveTypeUtil.getStandardPrimitiveTypeFlags(primitiveType.getFlags())) {
                        case 1: {
                            return new BooleanExpression(lineNumber, value != 0);
                        }
                        case 2: {
                            switch (value) {
                                case 0: {
                                    return new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_CHAR, TYPE_CHARACTER_REFERENCE, "java/lang/Character", "MIN_VALUE", "C");
                                }
                                case 65535: {
                                    return new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_CHAR, TYPE_CHARACTER_REFERENCE, "java/lang/Character", "MAX_VALUE", "C");
                                }
                            }
                            if ((icePrimitiveType.getFlags() & primitiveType.getFlags()) != 0) {
                                ice.setType(type);
                                break;
                            }
                            ice.setType(PrimitiveType.TYPE_INT);
                            break;
                        }
                        case 16: {
                            switch (value) {
                                case -128: {
                                    return new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_BYTE, TYPE_BYTE_REFERENCE, "java/lang/Byte", "MIN_VALUE", "B");
                                }
                                case 127: {
                                    return new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_BYTE, TYPE_BYTE_REFERENCE, "java/lang/Byte", "MAX_VALUE", "B");
                                }
                            }
                            if ((icePrimitiveType.getFlags() & primitiveType.getFlags()) != 0) {
                                ice.setType(type);
                                break;
                            }
                            ice.setType(PrimitiveType.TYPE_INT);
                            break;
                        }
                        case 32: {
                            switch (value) {
                                case -32768: {
                                    return new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_SHORT, TYPE_SHORT_REFERENCE, "java/lang/Short", "MIN_VALUE", "S");
                                }
                                case 32767: {
                                    return new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_SHORT, TYPE_SHORT_REFERENCE, "java/lang/Short", "MAX_VALUE", "S");
                                }
                            }
                            if ((icePrimitiveType.getFlags() & primitiveType.getFlags()) != 0) {
                                ice.setType(type);
                                break;
                            }
                            ice.setType(PrimitiveType.TYPE_INT);
                            break;
                        }
                        case 64: {
                            switch (value) {
                                case -2147483648: {
                                    return new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_INT, TYPE_INTEGER_REFERENCE, "java/lang/Integer", "MIN_VALUE", "I");
                                }
                                case 0x7FFFFFFF: {
                                    return new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_INT, TYPE_INTEGER_REFERENCE, "java/lang/Integer", "MAX_VALUE", "I");
                                }
                            }
                            if ((icePrimitiveType.getFlags() & primitiveType.getFlags()) != 0) {
                                ice.setType(type);
                                break;
                            }
                            ice.setType(PrimitiveType.TYPE_INT);
                        }
                    }
                    return expression;
                }
            } else if (clazz == TernaryOperatorExpression.class && type.isPrimitive()) {
                TernaryOperatorExpression toe = (TernaryOperatorExpression)expression;
                toe.setType(type);
                toe.setCondition(this.updateBooleanExpression(toe.getCondition()));
                toe.setExpressionTrue(this.updateExpression(type, toe.getExpressionTrue()));
                toe.setExpressionFalse(this.updateExpression(type, toe.getExpressionFalse()));
                return expression;
            }
        }
        expression.accept(this);
        return expression;
    }

    protected Expression safeUpdateBooleanExpression(Expression expression) {
        return expression == null ? null : this.updateBooleanExpression(expression);
    }

    protected Expression updateBooleanExpression(Expression expression) {
        if (PrimitiveType.TYPE_BOOLEAN != expression.getType()) {
            Class<?> clazz = expression.getClass();
            if (clazz == IntegerConstantExpression.class) {
                IntegerConstantExpression ice = (IntegerConstantExpression)expression;
                return new BooleanExpression(ice.getLineNumber(), ice.getValue() != 0);
            }
            if (clazz == TernaryOperatorExpression.class) {
                TernaryOperatorExpression toe = (TernaryOperatorExpression)expression;
                toe.setType(PrimitiveType.TYPE_BOOLEAN);
                toe.setCondition(this.updateBooleanExpression(toe.getCondition()));
                toe.setExpressionTrue(this.updateBooleanExpression(toe.getExpressionTrue()));
                toe.setExpressionFalse(this.updateBooleanExpression(toe.getExpressionFalse()));
                return expression;
            }
        }
        expression.accept(this);
        return expression;
    }

    @Override
    public void visit(FloatConstantExpression expression) {
    }

    @Override
    public void visit(IntegerConstantExpression expression) {
    }

    @Override
    public void visit(ConstructorReferenceExpression expression) {
    }

    @Override
    public void visit(DoubleConstantExpression expression) {
    }

    @Override
    public void visit(EnumConstantReferenceExpression expression) {
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
    }

    @Override
    public void visit(LongConstantExpression expression) {
    }

    @Override
    public void visit(BreakStatement statement) {
    }

    @Override
    public void visit(ByteCodeStatement statement) {
    }

    @Override
    public void visit(ContinueStatement statement) {
    }

    @Override
    public void visit(NullExpression expression) {
    }

    @Override
    public void visit(ObjectTypeReferenceExpression expression) {
    }

    @Override
    public void visit(SuperExpression expression) {
    }

    @Override
    public void visit(ThisExpression expression) {
    }

    @Override
    public void visit(TypeReferenceDotClassExpression expression) {
    }

    @Override
    public void visit(ObjectReference reference) {
    }

    @Override
    public void visit(InnerObjectReference reference) {
    }

    @Override
    public void visit(ArrayTypeArguments type) {
    }

    @Override
    public void visit(WildcardExtendsTypeArgument type) {
    }

    @Override
    public void visit(ObjectType type) {
    }

    @Override
    public void visit(InnerObjectType type) {
    }

    @Override
    public void visit(WildcardSuperTypeArgument type) {
    }

    @Override
    public void visit(Types list) {
    }

    @Override
    public void visit(TypeBounds list) {
    }

    @Override
    public void visit(TypeParameterWithTypeBounds type) {
    }

    @Override
    public void visit(BodyDeclaration declaration) {
    }

    static {
        List<Type> c = Arrays.asList(PrimitiveType.TYPE_CHAR);
        List<Type> ci = Arrays.asList(PrimitiveType.TYPE_CHAR, PrimitiveType.TYPE_INT);
        TYPES.put("java/lang/String:indexOf(I)I", c);
        TYPES.put("java/lang/String:indexOf(II)I", ci);
        TYPES.put("java/lang/String:lastIndexOf(I)I", c);
        TYPES.put("java/lang/String:lastIndexOf(II)I", ci);
    }

    protected static class DimensionTypes
    extends AbstractList<Type> {
        protected DimensionTypes() {
        }

        @Override
        public Type get(int i) {
            return PrimitiveType.TYPE_INT;
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

