/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable;

import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ObjectTypeMaker;

public class ObjectLocalVariable
extends AbstractLocalVariable {
    protected ObjectTypeMaker objectTypeMaker;
    protected ObjectType fromType;
    protected ObjectType toType;
    protected Type arrayType;

    public ObjectLocalVariable(ObjectTypeMaker objectTypeMaker, int index, int offset, ObjectType type, String name) {
        super(index, offset, name, type.getDimension());
        this.objectTypeMaker = objectTypeMaker;
        if (this.dimension == 0) {
            this.fromType = this.toType = type;
        } else {
            this.arrayType = type;
        }
    }

    public ObjectLocalVariable(ObjectTypeMaker objectTypeMaker, int index, int offset, Type type, String name) {
        super(index, offset, name, type.getDimension());
        this.objectTypeMaker = objectTypeMaker;
        if (this.dimension == 0) {
            this.fromType = this.toType = (ObjectType)type;
        } else {
            this.arrayType = type;
        }
    }

    public ObjectLocalVariable(ObjectTypeMaker objectTypeMaker, int index, int offset, ObjectType type, String name, boolean declared) {
        super(index, offset, name, type.getDimension(), declared);
        this.objectTypeMaker = objectTypeMaker;
        if (this.dimension == 0) {
            this.fromType = this.toType = type;
        } else {
            this.arrayType = type;
        }
    }

    public ObjectLocalVariable(ObjectTypeMaker objectTypeMaker, int index, int offset, Type type) {
        super(index, offset, type.getDimension());
        this.objectTypeMaker = objectTypeMaker;
        if (this.dimension == 0) {
            this.fromType = this.toType = (ObjectType)type;
        } else {
            this.arrayType = type;
        }
    }

    public ObjectLocalVariable(ObjectTypeMaker objectTypeMaker, int index, int offset, ObjectLocalVariable objectLocalVariable) {
        super(index, offset, objectLocalVariable.getDimension());
        this.objectTypeMaker = objectTypeMaker;
        this.toType = objectLocalVariable.toType;
        this.arrayType = objectLocalVariable.arrayType;
    }

    @Override
    public Type getType() {
        return this.dimension == 0 ? this.toType : this.arrayType;
    }

    @Override
    public boolean isAssignable(AbstractLocalVariable other) {
        if (other.getClass() == ObjectLocalVariable.class) {
            if (this.toType == ObjectType.TYPE_UNDEFINED_OBJECT) {
                return true;
            }
            if (this.dimension == other.getDimension()) {
                ObjectLocalVariable olv = (ObjectLocalVariable)other;
                if (this.dimension == 0) {
                    if (olv.fromType == null) {
                        return this.isAssignable(olv.toType);
                    }
                    return this.isAssignable(olv.fromType);
                }
                return this.arrayType.equals(olv.arrayType);
            }
        }
        return false;
    }

    @Override
    public boolean isAssignable(Type otherType) {
        if (otherType == ObjectType.TYPE_UNDEFINED_OBJECT) {
            return true;
        }
        if (this.toType == ObjectType.TYPE_UNDEFINED_OBJECT) {
            return true;
        }
        if (this.dimension == otherType.getDimension()) {
            if (this.dimension == 0) {
                if (otherType.isObject()) {
                    return this.objectTypeMaker.isAssignable(this.toType, (ObjectType)otherType);
                }
            } else {
                return this.arrayType.equals(otherType);
            }
        }
        return false;
    }

    @Override
    public void leftReduce(AbstractLocalVariable other) {
        ObjectType otherToType;
        if (other.getClass() == ObjectLocalVariable.class && (otherToType = ((ObjectLocalVariable)other).toType) != null && otherToType != ObjectType.TYPE_UNDEFINED_OBJECT) {
            ObjectType otherType = ((ObjectLocalVariable)other).fromType;
            if (otherType == null) {
                otherType = otherToType;
            }
            if (this.toType == ObjectType.TYPE_UNDEFINED_OBJECT) {
                this.leftReduce(otherType);
            } else if (this.dimension == 0 && this.dimension == other.getDimension()) {
                this.leftReduce(otherType);
            }
        }
    }

    @Override
    public void leftReduce(Type otherType) {
        if (otherType != ObjectType.TYPE_UNDEFINED_OBJECT) {
            if (this.toType == ObjectType.TYPE_UNDEFINED_OBJECT) {
                if (otherType.getDimension() == 0) {
                    if (otherType.isObject()) {
                        this.fromType = this.toType = (ObjectType)otherType;
                    }
                } else {
                    this.dimension = otherType.getDimension();
                    this.arrayType = otherType;
                }
            } else if (this.dimension == 0 && otherType.getDimension() == 0 && otherType.isObject()) {
                ObjectType otherObjectType = (ObjectType)otherType;
                if (!this.toType.getInternalName().equals(otherObjectType.getInternalName()) && this.objectTypeMaker.isAssignable(otherObjectType, this.toType)) {
                    if (this.toType.getTypeArguments() == null) {
                        this.toType = otherObjectType;
                    } else if (otherObjectType.getTypeArguments() == null) {
                        this.toType = otherObjectType.createType(this.toType.getTypeArguments());
                    } else if (this.toType.getTypeArguments().equals(otherObjectType.getTypeArguments())) {
                        this.toType = otherObjectType;
                    }
                }
            }
        }
    }

    @Override
    public void rightReduce(AbstractLocalVariable other) {
        if (this.dimension == 0 && other.getClass() == ObjectLocalVariable.class) {
            ObjectLocalVariable olv = (ObjectLocalVariable)other;
            if (this.toType == ObjectType.TYPE_UNDEFINED_OBJECT) {
                this.dimension = olv.dimension;
                this.fromType = olv.fromType;
                this.toType = olv.toType;
            } else {
                assert (olv.getDimension() == 0);
                this.rightReduce(olv.toType);
            }
        }
    }

    @Override
    public void rightReduce(Type otherType) {
        if (this.dimension == 0) {
            if (otherType.isObject()) {
                if (otherType != ObjectType.TYPE_OBJECT && otherType != ObjectType.TYPE_UNDEFINED_OBJECT) {
                    if (this.toType == ObjectType.TYPE_UNDEFINED_OBJECT) {
                        this.dimension = otherType.getDimension();
                        if (this.dimension == 0) {
                            this.fromType = null;
                            this.toType = (ObjectType)otherType;
                        } else {
                            this.arrayType = otherType;
                        }
                    } else if (!otherType.equals(ObjectType.TYPE_OBJECT)) {
                        assert (otherType.getDimension() == 0 && otherType.isObject());
                        ObjectType otherObjectType = (ObjectType)otherType;
                        if (this.fromType == null) {
                            if (this.toType.getTypeArguments() == null) {
                                this.fromType = otherObjectType;
                            } else if (otherObjectType.getTypeArguments() == null) {
                                this.fromType = otherObjectType.createType(this.toType.getTypeArguments());
                            } else if (this.toType.getTypeArguments().equals(otherObjectType.getTypeArguments())) {
                                this.fromType = otherObjectType;
                            }
                        } else if (!this.fromType.getInternalName().equals(otherObjectType.getInternalName()) && this.objectTypeMaker.isAssignable(this.fromType, otherObjectType)) {
                            if (this.fromType.getTypeArguments() == null) {
                                this.fromType = otherObjectType;
                            } else if (otherObjectType.getTypeArguments() == null) {
                                this.fromType = otherObjectType.createType(this.fromType.getTypeArguments());
                            } else if (this.fromType.getTypeArguments().equals(otherObjectType.getTypeArguments())) {
                                this.fromType = otherObjectType;
                            }
                        }
                    }
                }
            } else if (otherType.isPrimitive() && this.toType == ObjectType.TYPE_UNDEFINED_OBJECT) {
                this.dimension = otherType.getDimension();
                if (this.dimension > 0) {
                    this.arrayType = otherType;
                    this.dimension = otherType.getDimension();
                }
            }
        }
    }

    @Override
    public void accept(LocalVariableVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectLocalVariable{");
        if (this.dimension == 0) {
            if (this.fromType == null) {
                sb.append('?');
            } else if (this.fromType.getQualifiedName() == null) {
                sb.append(this.fromType.getName());
            } else {
                sb.append(this.fromType.getQualifiedName());
            }
            if (!this.toType.equals(this.fromType)) {
                sb.append(" ... ");
                sb.append(this.toType.getQualifiedName() == null ? this.toType.getName() : this.toType.getQualifiedName());
            }
        } else if (this.arrayType.isObject()) {
            sb.append(((ObjectType)this.arrayType).getInternalName());
            sb.append(new String(new char[this.dimension]).replaceAll("\u0000", "[]"));
        } else {
            sb.append(((PrimitiveType)this.arrayType).getName());
            sb.append(new String(new char[this.dimension]).replaceAll("\u0000", "[]"));
        }
        sb.append(' ').append(this.name).append(", index=").append(this.index);
        if (this.next != null) {
            sb.append(", next=").append(this.next);
        }
        return sb.append("}").toString();
    }
}

