/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.declaration.BaseMemberDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.TypeDeclaration;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMemberDeclaration;
import org.jd.core.v1.util.DefaultList;

public class ClassFileBodyDeclaration
extends BodyDeclaration
implements ClassFileMemberDeclaration {
    protected List<ClassFileFieldDeclaration> fieldDeclarations;
    protected List<ClassFileConstructorOrMethodDeclaration> methodDeclarations;
    protected List<ClassFileMemberDeclaration> innerTypeDeclarations;
    protected Map<String, ClassFileMemberDeclaration> innerTypeMap = Collections.emptyMap();
    protected int firstLineNumber;
    protected ObjectType outerType;
    protected DefaultList<String> outerLocalVariableNames;
    protected ClassFileBodyDeclaration outerBodyDeclaration;

    public ClassFileBodyDeclaration(String internalTypeName) {
        super(internalTypeName, null);
    }

    public ClassFileBodyDeclaration(String internalTypeName, ClassFileBodyDeclaration outerBodyDeclaration) {
        super(internalTypeName, null);
        this.outerBodyDeclaration = outerBodyDeclaration;
    }

    public void setMemberDeclarations(BaseMemberDeclaration memberDeclarations) {
        this.memberDeclarations = memberDeclarations;
    }

    public List<ClassFileFieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }

    public void setFieldDeclarations(List<ClassFileFieldDeclaration> fieldDeclarations) {
        if (fieldDeclarations != null) {
            this.fieldDeclarations = fieldDeclarations;
            this.updateFirstLineNumber(this.fieldDeclarations);
        }
    }

    public List<ClassFileConstructorOrMethodDeclaration> getMethodDeclarations() {
        return this.methodDeclarations;
    }

    public void setMethodDeclarations(List<ClassFileConstructorOrMethodDeclaration> methodDeclarations) {
        if (methodDeclarations != null) {
            this.methodDeclarations = methodDeclarations;
            this.updateFirstLineNumber(this.methodDeclarations);
        }
    }

    public List<ClassFileMemberDeclaration> getInnerTypeDeclarations() {
        return this.innerTypeDeclarations;
    }

    public void setInnerTypeDeclarations(List<ClassFileMemberDeclaration> innerTypeDeclarations) {
        if (innerTypeDeclarations != null) {
            this.innerTypeDeclarations = innerTypeDeclarations;
            this.updateFirstLineNumber(this.innerTypeDeclarations);
            this.innerTypeMap = new HashMap<String, ClassFileMemberDeclaration>();
            for (ClassFileMemberDeclaration innerType : innerTypeDeclarations) {
                TypeDeclaration td = (TypeDeclaration)((Object)innerType);
                this.innerTypeMap.put(td.getInternalName(), innerType);
            }
        }
    }

    public ClassFileMemberDeclaration getInnerTypeDeclaration(String internalName) {
        ClassFileMemberDeclaration declaration = this.innerTypeMap.get(internalName);
        if (declaration == null && this.outerBodyDeclaration != null) {
            return this.outerBodyDeclaration.getInnerTypeDeclaration(internalName);
        }
        return declaration;
    }

    public ClassFileMemberDeclaration removeInnerType(String internalName) {
        ClassFileMemberDeclaration removed = this.innerTypeMap.remove(internalName);
        this.innerTypeDeclarations.remove(removed);
        return removed;
    }

    protected void updateFirstLineNumber(List<? extends ClassFileMemberDeclaration> members) {
        for (ClassFileMemberDeclaration classFileMemberDeclaration : members) {
            int lineNumber = classFileMemberDeclaration.getFirstLineNumber();
            if (lineNumber <= 0) continue;
            if (this.firstLineNumber == 0) {
                this.firstLineNumber = lineNumber;
                break;
            }
            if (this.firstLineNumber <= lineNumber) break;
            this.firstLineNumber = lineNumber;
            break;
        }
    }

    @Override
    public int getFirstLineNumber() {
        return this.firstLineNumber;
    }

    public ObjectType getOuterType() {
        return this.outerType;
    }

    public void setOuterType(ObjectType outerType) {
        this.outerType = outerType;
    }

    public DefaultList<String> getOuterLocalVariableNames() {
        return this.outerLocalVariableNames;
    }

    public void setOuterLocalVariableNames(DefaultList<String> outerLocalVariableNames) {
        this.outerLocalVariableNames = outerLocalVariableNames;
    }

    public ClassFileBodyDeclaration getOuterBodyDeclaration() {
        return this.outerBodyDeclaration;
    }

    public String toString() {
        return "ClassFileBodyDeclaration{firstLineNumber=" + this.firstLineNumber + "}";
    }
}

