/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.reference;

import javax.annotation.Nonnull;
import org.jf.dexlib2.base.reference.BaseMethodHandleReference;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.reference.DexBackedFieldReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.util.ExceptionWithContext;

public class DexBackedMethodHandleReference
extends BaseMethodHandleReference {
    @Nonnull
    public final DexBackedDexFile dexFile;
    public final int methodHandleIndex;
    public final int methodHandleOffset;

    public DexBackedMethodHandleReference(DexBackedDexFile dexFile, int methodHandleIndex) {
        this.dexFile = dexFile;
        this.methodHandleIndex = methodHandleIndex;
        this.methodHandleOffset = dexFile.getMethodHandleItemOffset(methodHandleIndex);
    }

    @Override
    public int getMethodHandleType() {
        return this.dexFile.readUshort(this.methodHandleOffset + 0);
    }

    @Override
    @Nonnull
    public Reference getMemberReference() {
        int memberIndex = this.dexFile.readUshort(this.methodHandleOffset + 4);
        switch (this.getMethodHandleType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new DexBackedFieldReference(this.dexFile, memberIndex);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new DexBackedMethodReference(this.dexFile, memberIndex);
            }
        }
        throw new ExceptionWithContext("Invalid method handle type: %d", this.getMethodHandleType());
    }
}

