/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.HeaderItem;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.reference.DexBackedFieldReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedStringReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedTypeReference;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.dexbacked.util.FixedSizeSet;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.util.DexUtil;
import org.jf.util.ExceptionWithContext;

public class DexBackedDexFile
extends BaseDexBuffer
implements DexFile {
    @Nonnull
    private final Opcodes opcodes;
    private final int stringCount;
    private final int stringStartOffset;
    private final int typeCount;
    private final int typeStartOffset;
    private final int protoCount;
    private final int protoStartOffset;
    private final int fieldCount;
    private final int fieldStartOffset;
    private final int methodCount;
    private final int methodStartOffset;
    private final int classCount;
    private final int classStartOffset;
    private final int mapOffset;

    protected DexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull byte[] buf, int offset, boolean verifyMagic) {
        super(buf, offset);
        int dexVersion = verifyMagic ? DexUtil.verifyDexHeader(buf, offset) : HeaderItem.getVersion(buf, offset);
        this.opcodes = opcodes == null ? Opcodes.forDexVersion(dexVersion) : opcodes;
        this.stringCount = this.readSmallUint(56);
        this.stringStartOffset = this.readSmallUint(60);
        this.typeCount = this.readSmallUint(64);
        this.typeStartOffset = this.readSmallUint(68);
        this.protoCount = this.readSmallUint(72);
        this.protoStartOffset = this.readSmallUint(76);
        this.fieldCount = this.readSmallUint(80);
        this.fieldStartOffset = this.readSmallUint(84);
        this.methodCount = this.readSmallUint(88);
        this.methodStartOffset = this.readSmallUint(92);
        this.classCount = this.readSmallUint(96);
        this.classStartOffset = this.readSmallUint(100);
        this.mapOffset = this.readSmallUint(52);
    }

    public DexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull BaseDexBuffer buf) {
        this(opcodes, buf.buf, buf.baseOffset);
    }

    public DexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull byte[] buf, int offset) {
        this(opcodes, buf, offset, false);
    }

    public DexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull byte[] buf) {
        this(opcodes, buf, 0, true);
    }

    @Nonnull
    public static DexBackedDexFile fromInputStream(@Nullable Opcodes opcodes, @Nonnull InputStream is) throws IOException {
        DexUtil.verifyDexHeader(is);
        byte[] buf = ByteStreams.toByteArray((InputStream)is);
        return new DexBackedDexFile(opcodes, buf, 0, false);
    }

    @Override
    @Nonnull
    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    public boolean isOdexFile() {
        return false;
    }

    public boolean hasOdexOpcodes() {
        return false;
    }

    @Nonnull
    public Set<? extends DexBackedClassDef> getClasses() {
        return new FixedSizeSet<DexBackedClassDef>(){

            @Override
            @Nonnull
            public DexBackedClassDef readItem(int index) {
                return new DexBackedClassDef(DexBackedDexFile.this, DexBackedDexFile.this.getClassDefItemOffset(index));
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.classCount;
            }
        };
    }

    public int getStringIdItemOffset(int stringIndex) {
        if (stringIndex < 0 || stringIndex >= this.stringCount) {
            throw new InvalidItemIndex(stringIndex, "String index out of bounds: %d", stringIndex);
        }
        return this.stringStartOffset + stringIndex * 4;
    }

    public int getTypeIdItemOffset(int typeIndex) {
        if (typeIndex < 0 || typeIndex >= this.typeCount) {
            throw new InvalidItemIndex(typeIndex, "Type index out of bounds: %d", typeIndex);
        }
        return this.typeStartOffset + typeIndex * 4;
    }

    public int getFieldIdItemOffset(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.fieldCount) {
            throw new InvalidItemIndex(fieldIndex, "Field index out of bounds: %d", fieldIndex);
        }
        return this.fieldStartOffset + fieldIndex * 8;
    }

    public int getMethodIdItemOffset(int methodIndex) {
        if (methodIndex < 0 || methodIndex >= this.methodCount) {
            throw new InvalidItemIndex(methodIndex, "Method index out of bounds: %d", methodIndex);
        }
        return this.methodStartOffset + methodIndex * 8;
    }

    public int getProtoIdItemOffset(int protoIndex) {
        if (protoIndex < 0 || protoIndex >= this.protoCount) {
            throw new InvalidItemIndex(protoIndex, "Proto index out of bounds: %d", protoIndex);
        }
        return this.protoStartOffset + protoIndex * 12;
    }

    public int getClassDefItemOffset(int classIndex) {
        if (classIndex < 0 || classIndex >= this.classCount) {
            throw new InvalidItemIndex(classIndex, "Class index out of bounds: %d", classIndex);
        }
        return this.classStartOffset + classIndex * 32;
    }

    public int getCallSiteIdItemOffset(int callSiteIndex) {
        MapItem mapItem = this.getMapItemForSection(7);
        if (mapItem == null || callSiteIndex >= mapItem.getItemCount()) {
            throw new InvalidItemIndex(callSiteIndex, "Call site index out of bounds: %d", callSiteIndex);
        }
        return mapItem.getOffset() + callSiteIndex * 4;
    }

    public int getMethodHandleItemOffset(int methodHandleIndex) {
        MapItem mapItem = this.getMapItemForSection(8);
        if (mapItem == null || methodHandleIndex >= mapItem.getItemCount()) {
            throw new InvalidItemIndex(methodHandleIndex, "Method handle index out of bounds: %d", methodHandleIndex);
        }
        return mapItem.getOffset() + methodHandleIndex * 8;
    }

    public int getClassCount() {
        return this.classCount;
    }

    public int getStringCount() {
        return this.stringCount;
    }

    public int getTypeCount() {
        return this.typeCount;
    }

    public int getProtoCount() {
        return this.protoCount;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    public int getCallSiteCount() {
        MapItem mapItem = this.getMapItemForSection(7);
        if (mapItem == null) {
            return 0;
        }
        return mapItem.getItemCount();
    }

    public int getMethodHandleCount() {
        MapItem mapItem = this.getMapItemForSection(8);
        if (mapItem == null) {
            return 0;
        }
        return mapItem.getItemCount();
    }

    @Nonnull
    public String getString(int stringIndex) {
        int stringOffset = this.getStringIdItemOffset(stringIndex);
        int stringDataOffset = this.readSmallUint(stringOffset);
        DexReader reader = this.readerAt(stringDataOffset);
        int utf16Length = reader.readSmallUleb128();
        return reader.readString(utf16Length);
    }

    @Nullable
    public String getOptionalString(int stringIndex) {
        if (stringIndex == -1) {
            return null;
        }
        return this.getString(stringIndex);
    }

    @Nonnull
    public String getType(int typeIndex) {
        int typeOffset = this.getTypeIdItemOffset(typeIndex);
        int stringIndex = this.readSmallUint(typeOffset);
        return this.getString(stringIndex);
    }

    @Nullable
    public String getOptionalType(int typeIndex) {
        if (typeIndex == -1) {
            return null;
        }
        return this.getType(typeIndex);
    }

    public List<DexBackedStringReference> getStrings() {
        return new AbstractList<DexBackedStringReference>(){

            @Override
            public DexBackedStringReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getStringCount()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedStringReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getStringCount();
            }
        };
    }

    public List<DexBackedTypeReference> getTypes() {
        return new AbstractList<DexBackedTypeReference>(){

            @Override
            public DexBackedTypeReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getTypeCount()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedTypeReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getTypeCount();
            }
        };
    }

    public List<DexBackedMethodReference> getMethods() {
        return new AbstractList<DexBackedMethodReference>(){

            @Override
            public DexBackedMethodReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getMethodCount()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedMethodReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getMethodCount();
            }
        };
    }

    public List<DexBackedFieldReference> getFields() {
        return new AbstractList<DexBackedFieldReference>(){

            @Override
            public DexBackedFieldReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getFieldCount()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedFieldReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getFieldCount();
            }
        };
    }

    public List<? extends Reference> getReferences(int referenceType) {
        switch (referenceType) {
            case 0: {
                return this.getStrings();
            }
            case 1: {
                return this.getTypes();
            }
            case 3: {
                return this.getMethods();
            }
            case 2: {
                return this.getFields();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid reference type: %d", referenceType));
    }

    @Override
    @Nonnull
    public DexReader readerAt(int offset) {
        return new DexReader(this, offset);
    }

    public List<MapItem> getMapItems() {
        final int mapSize = this.readSmallUint(this.mapOffset);
        return new FixedSizeList<MapItem>(){

            @Override
            public MapItem readItem(int index) {
                int mapItemOffset = DexBackedDexFile.this.mapOffset + 4 + index * 12;
                return new MapItem(DexBackedDexFile.this, mapItemOffset);
            }

            @Override
            public int size() {
                return mapSize;
            }
        };
    }

    @Nullable
    public MapItem getMapItemForSection(int itemType) {
        for (MapItem mapItem : this.getMapItems()) {
            if (mapItem.getType() != itemType) continue;
            return mapItem;
        }
        return null;
    }

    public static class InvalidItemIndex
    extends ExceptionWithContext {
        private final int itemIndex;

        public InvalidItemIndex(int itemIndex) {
            super("", new Object[0]);
            this.itemIndex = itemIndex;
        }

        public InvalidItemIndex(int itemIndex, String message, Object ... formatArgs) {
            super(message, formatArgs);
            this.itemIndex = itemIndex;
        }

        public int getInvalidIndex() {
            return this.itemIndex;
        }
    }

    public static class NotADexFile
    extends RuntimeException {
        public NotADexFile() {
        }

        public NotADexFile(Throwable cause) {
            super(cause);
        }

        public NotADexFile(String message) {
            super(message);
        }

        public NotADexFile(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

