/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.BlockUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InsnRemover {
    private final MethodNode mth;
    private final List<InsnNode> toRemove;
    private List<InsnNode> instrList;

    public InsnRemover(MethodNode mth) {
        this(mth, null);
    }

    public InsnRemover(MethodNode mth, BlockNode block) {
        this.mth = mth;
        this.toRemove = new ArrayList<InsnNode>();
        if (block != null) {
            this.instrList = block.getInstructions();
        }
    }

    public void setBlock(BlockNode block) {
        this.instrList = block.getInstructions();
    }

    public void addAndUnbind(InsnNode insn) {
        this.toRemove.add(insn);
        InsnRemover.unbindInsn(this.mth, insn);
    }

    public void addWithoutUnbind(InsnNode insn) {
        this.toRemove.add(insn);
    }

    public void perform() {
        if (this.toRemove.isEmpty()) {
            return;
        }
        InsnRemover.removeAll(this.instrList, this.toRemove);
        this.toRemove.clear();
    }

    public static void unbindInsn(MethodNode mth, InsnNode insn) {
        for (InsnArg arg : insn.getArguments()) {
            InsnRemover.unbindArgUsage(mth, arg);
        }
        if (insn.getType() == InsnType.PHI) {
            for (InsnArg arg : insn.getArguments()) {
                if (!(arg instanceof RegisterArg)) continue;
                ((RegisterArg)arg).getSVar().updateUsedInPhiList();
            }
        }
        InsnRemover.unbindResult(mth, insn);
        insn.add(AFlag.REMOVE);
    }

    public static void unbindResult(MethodNode mth, InsnNode insn) {
        SSAVar ssaVar;
        RegisterArg r = insn.getResult();
        if (r != null && r.getSVar() != null && mth != null && (ssaVar = r.getSVar()).getUseCount() == 0) {
            mth.removeSVar(ssaVar);
        }
    }

    public static void unbindArgUsage(MethodNode mth, InsnArg arg) {
        if (arg instanceof RegisterArg) {
            RegisterArg reg = (RegisterArg)arg;
            SSAVar sVar = reg.getSVar();
            if (sVar != null) {
                sVar.removeUse(reg);
            }
        } else if (arg instanceof InsnWrapArg) {
            InsnWrapArg wrap = (InsnWrapArg)arg;
            InsnRemover.unbindInsn(mth, wrap.getWrapInsn());
        }
    }

    private static void removeAll(List<InsnNode> insns, List<InsnNode> toRemove) {
        if (toRemove == null || toRemove.isEmpty()) {
            return;
        }
        block0: for (InsnNode rem : toRemove) {
            int insnsCount = insns.size();
            for (int i = 0; i < insnsCount; ++i) {
                if (insns.get(i) != rem) continue;
                insns.remove(i);
                continue block0;
            }
        }
    }

    public static void remove(MethodNode mth, InsnNode insn) {
        BlockNode block = BlockUtils.getBlockByInsn(mth, insn);
        if (block != null) {
            InsnRemover.remove(mth, block, insn);
        }
    }

    public static void remove(MethodNode mth, BlockNode block, InsnNode insn) {
        InsnRemover.unbindInsn(mth, insn);
        Iterator<InsnNode> it = block.getInstructions().iterator();
        while (it.hasNext()) {
            InsnNode ir = it.next();
            if (ir != insn) continue;
            it.remove();
            return;
        }
    }

    public static void removeAllAndUnbind(MethodNode mth, BlockNode block, List<InsnNode> insns) {
        for (InsnNode insn : insns) {
            InsnRemover.unbindInsn(mth, insn);
        }
        InsnRemover.removeAll(block.getInstructions(), insns);
    }

    public static void remove(MethodNode mth, BlockNode block, int index) {
        List<InsnNode> instructions = block.getInstructions();
        InsnRemover.unbindInsn(mth, instructions.get(index));
        instructions.remove(index);
    }
}

