/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;

@JadxVisitor(name="FixAccessModifiers", desc="Change class and method access modifiers if needed", runAfter={ModVisitor.class})
public class FixAccessModifiers
extends AbstractVisitor {
    private boolean respectAccessModifiers;

    @Override
    public void init(RootNode root) {
        this.respectAccessModifiers = root.getArgs().isRespectBytecodeAccModifiers();
    }

    @Override
    public void visit(MethodNode mth) {
        if (this.respectAccessModifiers) {
            return;
        }
        int newVisFlag = FixAccessModifiers.fixVisibility(mth);
        if (newVisFlag != -1) {
            FixAccessModifiers.changeVisibility(mth, newVisFlag);
        }
    }

    public static void changeVisibility(ICodeNode node, int newVisFlag) {
        AccessInfo accessFlags = node.getAccessFlags();
        AccessInfo newAccFlags = accessFlags.changeVisibility(newVisFlag);
        if (newAccFlags != accessFlags) {
            node.setAccessFlags(newAccFlags);
            node.addAttr(AType.COMMENTS, "access modifiers changed from: " + accessFlags.getVisibility().rawString());
        }
    }

    private static int fixVisibility(MethodNode mth) {
        if (mth.isVirtual()) {
            return 1;
        }
        AccessInfo accessFlags = mth.getAccessFlags();
        if (accessFlags.isAbstract()) {
            return 1;
        }
        if (accessFlags.isConstructor() && accessFlags.isPublic() && mth.getParentClass().isEnum()) {
            return 0;
        }
        if (accessFlags.isConstructor() || accessFlags.isStatic()) {
            return -1;
        }
        return 2;
    }
}

