/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.CodePosition;
import jadx.api.JavaNode;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.CodeLinkGenerator;
import jadx.gui.ui.codearea.FindUsageAction;
import jadx.gui.ui.codearea.GoToDeclarationAction;
import jadx.gui.ui.codearea.JadxTokenMaker;
import jadx.gui.utils.JumpPosition;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeArea
extends AbstractCodeArea {
    private static final Logger LOG = LoggerFactory.getLogger(CodeArea.class);
    private static final long serialVersionUID = 6312736869579635796L;

    CodeArea(ContentPanel contentPanel) {
        super(contentPanel);
        this.setMarkOccurrences(true);
        this.setEditable(false);
        this.loadSettings();
        Caret caret = this.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(2);
        }
        caret.setVisible(true);
        this.setSyntaxEditingStyle(this.node.getSyntaxName());
        if (this.node instanceof JClass) {
            JClass jClsNode = (JClass)this.node;
            ((RSyntaxDocument)this.getDocument()).setSyntaxStyle((TokenMaker)new JadxTokenMaker(this, jClsNode));
            this.setHyperlinksEnabled(true);
            CodeLinkGenerator codeLinkProcessor = new CodeLinkGenerator(contentPanel, this, jClsNode);
            this.setLinkGenerator(codeLinkProcessor);
            this.addHyperlinkListener(codeLinkProcessor);
            this.addMenuItems(jClsNode);
        }
        this.registerWordHighlighter();
    }

    @Override
    public void load() {
        if (this.getText().isEmpty()) {
            this.setText(this.node.getContent());
            this.setCaretPosition(0);
        }
    }

    private void registerWordHighlighter() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() % 2 == 0 && !evt.isConsumed()) {
                    evt.consume();
                    String str = CodeArea.this.getSelectedText();
                    if (str != null) {
                        CodeArea.this.highlightAllMatches(str);
                    }
                } else {
                    CodeArea.this.highlightAllMatches(null);
                }
            }
        });
    }

    private void highlightAllMatches(@Nullable String str) {
        SearchContext context = new SearchContext(str);
        context.setMarkAll(true);
        context.setMatchCase(true);
        context.setWholeWord(true);
        SearchEngine.markAll((RTextArea)this, (SearchContext)context);
    }

    private void addMenuItems(JClass jCls) {
        FindUsageAction findUsage = new FindUsageAction(this.contentPanel, this, jCls);
        GoToDeclarationAction goToDeclaration = new GoToDeclarationAction(this.contentPanel, this, jCls);
        JPopupMenu popup = this.getPopupMenu();
        popup.addSeparator();
        popup.add(findUsage);
        popup.add(goToDeclaration);
        popup.addPopupMenuListener(findUsage);
        popup.addPopupMenuListener(goToDeclaration);
    }

    public static RSyntaxTextArea getDefaultArea(MainWindow mainWindow) {
        RSyntaxTextArea area = new RSyntaxTextArea();
        CodeArea.loadCommonSettings(mainWindow, area);
        return area;
    }

    public JumpPosition getDefPosForNodeAtOffset(JClass jCls, int offset) {
        JavaNode foundNode = this.getJavaNodeAtOffset(jCls, offset);
        if (foundNode == null) {
            return null;
        }
        CodePosition pos = jCls.getCls().getDefinitionPosition(foundNode);
        if (pos == null) {
            return null;
        }
        JNode jNode = this.contentPanel.getTabbedPane().getMainWindow().getCacheObject().getNodeCache().makeFrom(foundNode);
        return new JumpPosition(jNode.getRootClass(), pos.getLine());
    }

    public JavaNode getJavaNodeAtOffset(JClass jCls, int offset) {
        try {
            int line = this.getLineOfOffset(offset);
            int lineOffset = offset - this.getLineStartOffset(line);
            return jCls.getCls().getJavaNodeAtPosition(line + 1, lineOffset + 1);
        }
        catch (Exception e) {
            LOG.error("Can't get java node by offset: {}", (Object)offset, (Object)e);
            return null;
        }
    }
}

