/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ConsThread;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.FormatProperties;
import jalview.Popup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;

public class InputPopup
extends Popup {
    TextArea ta = new TextArea(25, 80);
    Label format;
    Choice f;

    public InputPopup(Frame frame, String string) {
        super(frame, string);
        this.ta.setFont(new Font("Courier", 0, 12));
        this.format = new Label("Alignment format");
        this.f = new Choice();
        int n = 0;
        while (n < FormatProperties.formats.size()) {
            this.f.addItem((String)FormatProperties.formats.elementAt(n));
            ++n;
        }
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.ta, this.gb, this.gbc, 0, 0, 4, 4);
        this.add(this.format, this.gb, this.gbc, 0, 4, 1, 1);
        this.add(this.f, this.gb, this.gbc, 1, 4, 1, 1);
        this.add(this.status, this.gb, this.gbc, 0, 5, 1, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 6, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 6, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.apply && event.id == 1001) {
            DrawableSequence[] drawableSequenceArray = null;
            String string = this.ta.getText();
            if (FormatProperties.contains(this.f.getSelectedItem())) {
                drawableSequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read(this.f.getSelectedItem(), string));
            } else {
                System.out.println("Format not supported");
            }
            if (drawableSequenceArray != null) {
                AlignFrame alignFrame = new AlignFrame(this.parent.getParent(), drawableSequenceArray);
                System.out.println("Size = " + alignFrame.ap.seqPanel.align.size());
                if (alignFrame.ap.seqPanel.align.size() > 0) {
                    alignFrame.resize(700, 500);
                    alignFrame.show();
                    ConsThread consThread = new ConsThread(alignFrame);
                    consThread.start();
                    ((Component)this).hide();
                    this.dispose();
                } else {
                    alignFrame.dispose();
                    this.status.setText("Can't read input - check format");
                }
            } else {
                this.status.setText("No sequences found");
            }
            return true;
        }
        return super.handleEvent(event);
    }
}

