/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import java.io.ByteArrayOutputStream;

public class EMSA_PKCS1_V1_5
implements Cloneable {
    private static final byte[] MD2_PREFIX;
    private static final byte[] MD5_PREFIX;
    private static final byte[] SHA160_PREFIX;
    private static final byte[] SHA256_PREFIX;
    private static final byte[] SHA384_PREFIX;
    private static final byte[] SHA512_PREFIX;
    private IMessageDigest hash;
    private int hLen;
    private byte[] prefix;

    static {
        byte[] byArray = new byte[18];
        byArray[0] = 48;
        byArray[1] = 32;
        byArray[2] = 48;
        byArray[3] = 12;
        byArray[4] = 6;
        byArray[5] = 8;
        byArray[6] = 42;
        byArray[7] = -122;
        byArray[8] = 72;
        byArray[9] = -122;
        byArray[10] = -9;
        byArray[11] = 13;
        byArray[12] = 2;
        byArray[13] = 2;
        byArray[14] = 5;
        byArray[16] = 4;
        byArray[17] = 16;
        MD2_PREFIX = byArray;
        byte[] byArray2 = new byte[18];
        byArray2[0] = 48;
        byArray2[1] = 32;
        byArray2[2] = 48;
        byArray2[3] = 12;
        byArray2[4] = 6;
        byArray2[5] = 8;
        byArray2[6] = 42;
        byArray2[7] = -122;
        byArray2[8] = 72;
        byArray2[9] = -122;
        byArray2[10] = -9;
        byArray2[11] = 13;
        byArray2[12] = 2;
        byArray2[13] = 5;
        byArray2[14] = 5;
        byArray2[16] = 4;
        byArray2[17] = 16;
        MD5_PREFIX = byArray2;
        byte[] byArray3 = new byte[15];
        byArray3[0] = 48;
        byArray3[1] = 33;
        byArray3[2] = 48;
        byArray3[3] = 9;
        byArray3[4] = 6;
        byArray3[5] = 5;
        byArray3[6] = 43;
        byArray3[7] = 14;
        byArray3[8] = 3;
        byArray3[9] = 2;
        byArray3[10] = 26;
        byArray3[11] = 5;
        byArray3[13] = 4;
        byArray3[14] = 20;
        SHA160_PREFIX = byArray3;
        byte[] byArray4 = new byte[19];
        byArray4[0] = 48;
        byArray4[1] = 49;
        byArray4[2] = 48;
        byArray4[3] = 13;
        byArray4[4] = 6;
        byArray4[5] = 9;
        byArray4[6] = 96;
        byArray4[7] = -122;
        byArray4[8] = 72;
        byArray4[9] = 1;
        byArray4[10] = 101;
        byArray4[11] = 3;
        byArray4[12] = 4;
        byArray4[13] = 2;
        byArray4[14] = 1;
        byArray4[15] = 5;
        byArray4[17] = 4;
        byArray4[18] = 32;
        SHA256_PREFIX = byArray4;
        byte[] byArray5 = new byte[19];
        byArray5[0] = 48;
        byArray5[1] = 65;
        byArray5[2] = 48;
        byArray5[3] = 13;
        byArray5[4] = 6;
        byArray5[5] = 9;
        byArray5[6] = 96;
        byArray5[7] = -122;
        byArray5[8] = 72;
        byArray5[9] = 1;
        byArray5[10] = 101;
        byArray5[11] = 3;
        byArray5[12] = 4;
        byArray5[13] = 2;
        byArray5[14] = 2;
        byArray5[15] = 5;
        byArray5[17] = 4;
        byArray5[18] = 48;
        SHA384_PREFIX = byArray5;
        byte[] byArray6 = new byte[19];
        byArray6[0] = 48;
        byArray6[1] = 81;
        byArray6[2] = 48;
        byArray6[3] = 13;
        byArray6[4] = 6;
        byArray6[5] = 9;
        byArray6[6] = 96;
        byArray6[7] = -122;
        byArray6[8] = 72;
        byArray6[9] = 1;
        byArray6[10] = 101;
        byArray6[11] = 3;
        byArray6[12] = 4;
        byArray6[13] = 2;
        byArray6[14] = 3;
        byArray6[15] = 5;
        byArray6[17] = 4;
        byArray6[18] = 64;
        SHA512_PREFIX = byArray6;
    }

    private EMSA_PKCS1_V1_5(IMessageDigest hash) {
        this.hash = hash;
        this.hLen = hash.hashSize();
        String name = hash.name();
        if (name.equals("md2")) {
            this.prefix = MD2_PREFIX;
        } else if (name.equals("md5")) {
            this.prefix = MD5_PREFIX;
        } else if (name.equals("sha-160")) {
            this.prefix = SHA160_PREFIX;
        } else if (name.equals("sha-256")) {
            this.prefix = SHA256_PREFIX;
        } else if (name.equals("sha-384")) {
            this.prefix = SHA384_PREFIX;
        } else if (name.equals("sha-512")) {
            this.prefix = SHA512_PREFIX;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static final EMSA_PKCS1_V1_5 getInstance(String mdName) {
        IMessageDigest hash = HashFactory.getInstance(mdName);
        String name = hash.name();
        if (!(name.equals("md2") || name.equals("md5") || name.equals("sha-160") || name.equals("sha-256") || name.equals("sha-384") || name.equals("sha-512"))) {
            throw new UnsupportedOperationException("hash with no OID: " + name);
        }
        return new EMSA_PKCS1_V1_5(hash);
    }

    public Object clone() {
        return EMSA_PKCS1_V1_5.getInstance(this.hash.name());
    }

    public byte[] encode(byte[] mHash, int emLen) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.prefix, 0, this.prefix.length);
        baos.write(mHash, 0, mHash.length);
        byte[] T = baos.toByteArray();
        int tLen = T.length;
        if (emLen < tLen + 11) {
            throw new IllegalArgumentException("emLen too short");
        }
        byte[] PS = new byte[emLen - tLen - 3];
        int i = 0;
        while (i < PS.length) {
            PS[i] = -1;
            ++i;
        }
        baos.reset();
        baos.write(0);
        baos.write(1);
        baos.write(PS, 0, PS.length);
        baos.write(0);
        baos.write(T, 0, tLen);
        byte[] result = baos.toByteArray();
        baos.reset();
        return result;
    }
}

