//
// SecureSMTPClientSession.h
//
// $Id: //poco/1.4/NetSSL_OpenSSL/include/Poco/Net/SecureSMTPClientSession.h#1 $
//
// Library: NetSSL_OpenSSL
// Package: Mail
// Module:  SecureSMTPClientSession
//
// Definition of the SecureSMTPClientSession class.
//
// Copyright (c) 2010, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Net_SecureSMTPClientSession_INCLUDED
#define Net_SecureSMTPClientSession_INCLUDED


#include "Poco/Net/NetSSL.h"
#include "Poco/Net/SMTPClientSession.h"
#include "Poco/Net/Context.h"


namespace Poco {
namespace Net {


class NetSSL_API SecureSMTPClientSession: public SMTPClientSession
	/// This class implements an Simple Mail
	/// Transfer Procotol (SMTP, RFC 2821)
	/// client for sending e-mail messages that
	/// supports the STARTTLS command for secure
	/// connections.
	///
	/// Usage is as follows:
	///   1. Create a SecureSMTPClientSession object.
	///   2. Call login() or login(hostname).
	///   3. Call startTLS() to switch to a secure connection.
	///      Check the return value to see if a secure connection
	///      has actually been established (not all servers may
	///      support STARTTLS).
	///   4. Call any of the login() methods to securely authenticate
	///      with a username and password.
	///   5. Send the message(s).
{
public:
	explicit SecureSMTPClientSession(const StreamSocket& socket);
		/// Creates the SecureSMTPClientSession using
		/// the given socket, which must be connected
		/// to a SMTP server.

	SecureSMTPClientSession(const std::string& host, Poco::UInt16 port = SMTP_PORT);
		/// Creates the SecureSMTPClientSession using a socket connected
		/// to the given host and port.

	virtual ~SecureSMTPClientSession();
		/// Destroys the SMTPClientSession.

	bool startTLS();
		/// Sends a STARTTLS command and, if successful, 
		/// creates a secure SSL/TLS connection over the
		/// existing socket connection.
		///
		/// Must be called after login() or login(hostname).
		/// If successful, login() can be called again
		/// to authenticate the user.
		///
		/// Returns true if the STARTTLS command was successful,
		/// false otherwise.

	bool startTLS(Context::Ptr pContext);
		/// Sends a STARTTLS command and, if successful, 
		/// creates a secure SSL/TLS connection over the
		/// existing socket connection.
		///
		/// Uses the given Context object for creating
		/// the SSL/TLS connection.
		///
		/// Must be called after login() or login(hostname).
		/// If successful, login() can be called again
		/// to authenticate the user.
		///
		/// Returns true if the STARTTLS command was successful,
		/// false otherwise.
};


} } // namespace Poco::Net


#endif // Net_SecureSMTPClientSession_INCLUDED
