#define SHIFTJIS_NULL -1
MVMint16 shift_jis_index_to_cp_array_offset (MVMThreadContext *tc, MVMint16 index);
MVMGrapheme32 shift_jis_index_to_cp (MVMThreadContext *tc, MVMint16 index);
struct shiftjis_offset {
    MVMuint16 location;
    MVMuint16 offset;
};
/* Start code generated from ./tools/generate_encoding_codetables.p6 */
#define SHIFTJIS_OFFSET_VALUES_ELEMS 21
#define SHIFTJIS_INDEX_TO_CP_CODEPOINTS_ELEMS 7350
#define SHIFTJIS_MAX_INDEX 11103
const static struct shiftjis_offset shiftjis_offset_values[21] = {
    { 107,   11},
    { 126,    8},
    { 141,   11},
    { 167,    7},
    { 182,    4},
    { 187,   15},
    { 212,    7},
    { 245,    6},
    { 277,    4},
    { 364,   11},
    { 461,    8},
    { 493,    8},
    { 525,   38},
    { 596,   15},
    { 644,   13},
    { 689,  438},
    {1157,    1},
    {1181,    8},
    {1219,  190},
    {4374,   43},
    {7807, 2908}
};
const static MVMuint16 shiftjis_index_to_cp_codepoints[7350] = {
12288,12289,12290,65292,65294,12539,65306,65307,65311,65281,12443,12444,180,
65344,168,65342,65507,65343,12541,12542,12445,12446,12291,20189,12293,12294,
12295,12540,8213,8208,65295,65340,65374,8741,65372,8230,8229,8216,8217,8220,
8221,65288,65289,12308,12309,65339,65341,65371,65373,12296,12297,12298,12299,
12300,12301,12302,12303,12304,12305,65291,65293,177,215,247,65309,8800,65308,
65310,8806,8807,8734,8756,9794,9792,176,8242,8243,8451,65509,65284,65504,65505,
65285,65283,65286,65290,65312,167,9734,9733,9675,9679,9678,9671,9670,9633,9632,
9651,9650,9661,9660,8251,12306,8594,8592,8593,8595,12307,8712,8715,8838,8839,
8834,8835,8746,8745,8743,8744,65506,8658,8660,8704,8707,8736,8869,8978,8706,
8711,8801,8786,8810,8811,8730,8765,8733,8757,8747,8748,8491,8240,9839,9837,9834,
8224,8225,182,9711,65296,65297,65298,65299,65300,65301,65302,65303,65304,65305,
65313,65314,65315,65316,65317,65318,65319,65320,65321,65322,65323,65324,65325,
65326,65327,65328,65329,65330,65331,65332,65333,65334,65335,65336,65337,65338,
65345,65346,65347,65348,65349,65350,65351,65352,65353,65354,65355,65356,65357,
65358,65359,65360,65361,65362,65363,65364,65365,65366,65367,65368,65369,65370,
12353,12354,12355,12356,12357,12358,12359,12360,12361,12362,12363,12364,12365,
12366,12367,12368,12369,12370,12371,12372,12373,12374,12375,12376,12377,12378,
12379,12380,12381,12382,12383,12384,12385,12386,12387,12388,12389,12390,12391,
12392,12393,12394,12395,12396,12397,12398,12399,12400,12401,12402,12403,12404,
12405,12406,12407,12408,12409,12410,12411,12412,12413,12414,12415,12416,12417,
12418,12419,12420,12421,12422,12423,12424,12425,12426,12427,12428,12429,12430,
12431,12432,12433,12434,12435,12449,12450,12451,12452,12453,12454,12455,12456,
12457,12458,12459,12460,12461,12462,12463,12464,12465,12466,12467,12468,12469,
12470,12471,12472,12473,12474,12475,12476,12477,12478,12479,12480,12481,12482,
12483,12484,12485,12486,12487,12488,12489,12490,12491,12492,12493,12494,12495,
12496,12497,12498,12499,12500,12501,12502,12503,12504,12505,12506,12507,12508,
12509,12510,12511,12512,12513,12514,12515,12516,12517,12518,12519,12520,12521,
12522,12523,12524,12525,12526,12527,12528,12529,12530,12531,12532,12533,12534,
913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,931,932,933,
934,935,936,937,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,
961,963,964,965,966,967,968,969,1040,1041,1042,1043,1044,1045,1025,1046,1047,
1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,
1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,1077,1105,1078,
1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,
1095,1096,1097,1098,1099,1100,1101,1102,1103,9472,9474,9484,9488,9496,9492,9500,
9516,9508,9524,9532,9473,9475,9487,9491,9499,9495,9507,9523,9515,9531,9547,9504,
9519,9512,9527,9535,9501,9520,9509,9528,9538,9312,9313,9314,9315,9316,9317,9318,
9319,9320,9321,9322,9323,9324,9325,9326,9327,9328,9329,9330,9331,8544,8545,8546,
8547,8548,8549,8550,8551,8552,8553,13129,13076,13090,13133,13080,13095,13059,
13110,13137,13143,13069,13094,13091,13099,13130,13115,13212,13213,13214,13198,
13199,13252,13217,13179,12317,12319,8470,13261,8481,12964,12965,12966,12967,
12968,12849,12850,12857,13182,13181,13180,8786,8801,8747,8750,8721,8730,8869,
8736,8735,8895,8757,8745,8746,20124,21782,23043,38463,21696,24859,25384,23030,
36898,33909,33564,31312,24746,25569,28197,26093,33894,33446,39925,26771,22311,
26017,25201,23451,22992,34427,39156,32098,32190,39822,25110,31903,34999,23433,
24245,25353,26263,26696,38343,38797,26447,20197,20234,20301,20381,20553,22258,
22839,22996,23041,23561,24799,24847,24944,26131,26885,28858,30031,30064,31227,
32173,32239,32963,33806,34915,35586,36949,36986,21307,20117,20133,22495,32946,
37057,30959,19968,22769,28322,36920,31282,33576,33419,39983,20801,21360,21693,
21729,22240,23035,24341,39154,28139,32996,34093,38498,38512,38560,38907,21515,
21491,23431,28879,32701,36802,38632,21359,40284,31418,19985,30867,33276,28198,
22040,21764,27421,34074,39995,23013,21417,28006,29916,38287,22082,20113,36939,
38642,33615,39180,21473,21942,23344,24433,26144,26355,26628,27704,27891,27945,
29787,30408,31310,38964,33521,34907,35424,37613,28082,30123,30410,39365,24742,
35585,36234,38322,27022,21421,20870,22290,22576,22852,23476,24310,24616,25513,
25588,27839,28436,28814,28948,29017,29141,29503,32257,33398,33489,34199,36960,
37467,40219,22633,26044,27738,29989,20985,22830,22885,24448,24540,25276,26106,
27178,27431,27572,29579,32705,35158,40236,40206,40644,23713,27798,33659,20740,
23627,25014,33222,26742,29281,20057,20474,21368,24681,28201,31311,38899,19979,
21270,20206,20309,20285,20385,20339,21152,21487,22025,22799,23233,23478,23521,
31185,26247,26524,26550,27468,27827,28779,29634,31117,31166,31292,31623,33457,
33499,33540,33655,33775,33747,34662,35506,22057,36008,36838,36942,38686,34442,
20420,23784,25105,29273,30011,33253,33469,34558,36032,38597,39187,39381,20171,
20250,35299,22238,22602,22730,24315,24555,24618,24724,24674,25040,25106,25296,
25913,39745,26214,26800,28023,28784,30028,30342,32117,33445,34809,38283,38542,
35997,20977,21182,22806,21683,23475,23830,24936,27010,28079,30861,33995,34903,
35442,37799,39608,28012,39336,34521,22435,26623,34510,37390,21123,22151,21508,
24275,25313,25785,26684,26680,27579,29554,30906,31339,35226,35282,36203,36611,
37101,38307,38548,38761,23398,23731,27005,38989,38990,25499,31520,27179,27263,
26806,39949,28511,21106,21917,24688,25324,27963,28167,28369,33883,35088,36676,
19988,39993,21494,26907,27194,38788,26666,20828,31427,33970,37340,37772,22107,
40232,26658,33541,33841,31909,21000,33477,29926,20094,20355,20896,23506,21002,
21208,21223,24059,21914,22570,23014,23436,23448,23515,24178,24185,24739,24863,
24931,25022,25563,25954,26577,26707,26874,27454,27475,27735,28450,28567,28485,
29872,29976,30435,30475,31487,31649,31777,32233,32566,32752,32925,33382,33694,
35251,35532,36011,36996,37969,38291,38289,38306,38501,38867,39208,33304,20024,
21547,23736,24012,29609,30284,30524,23721,32747,36107,38593,38929,38996,39000,
20225,20238,21361,21916,22120,22522,22855,23305,23492,23696,24076,24190,24524,
25582,26426,26071,26082,26399,26827,26820,27231,24112,27589,27671,27773,30079,
31048,23395,31232,32000,24509,35215,35352,36020,36215,36556,36637,39138,39438,
39740,20096,20605,20736,22931,23452,25135,25216,25836,27450,29344,30097,31047,
32681,34811,35516,35696,25516,33738,38816,21513,21507,21931,26708,27224,35440,
30759,26485,40653,21364,23458,33050,34384,36870,19992,20037,20167,20241,21450,
21560,23470,24339,24613,25937,26429,27714,27762,27875,28792,29699,31350,31406,
31496,32026,31998,32102,26087,29275,21435,23621,24040,25298,25312,25369,28192,
34394,35377,36317,37624,28417,31142,39770,20136,20139,20140,20379,20384,20689,
20807,31478,20849,20982,21332,21281,21375,21483,21932,22659,23777,24375,24394,
24623,24656,24685,25375,25945,27211,27841,29378,29421,30703,33016,33029,33288,
34126,37111,37857,38911,39255,39514,20208,20957,23597,26241,26989,23616,26354,
26997,29577,26704,31873,20677,21220,22343,24062,37670,26020,27427,27453,29748,
31105,31165,31563,32202,33465,33740,34943,35167,35641,36817,37329,21535,37504,
20061,20534,21477,21306,29399,29590,30697,33510,36527,39366,39368,39378,20855,
24858,34398,21936,31354,20598,23507,36935,38533,20018,27355,37351,23633,23624,
25496,31391,27795,38772,36705,31402,29066,38536,31874,26647,32368,26705,37740,
21234,21531,34219,35347,32676,36557,37089,21350,34952,31041,20418,20670,21009,
20804,21843,22317,29674,22411,22865,24418,24452,24693,24950,24935,25001,25522,
25658,25964,26223,26690,28179,30054,31293,31995,32076,32153,32331,32619,33550,
33610,34509,35336,35427,35686,36605,38938,40335,33464,36814,39912,21127,25119,
25731,28608,38553,26689,20625,27424,27770,28500,31348,32080,34880,35363,26376,
20214,20537,20518,20581,20860,21048,21091,21927,22287,22533,23244,24314,25010,
25080,25331,25458,26908,27177,29309,29356,29486,30740,30831,32121,30476,32937,
35211,35609,36066,36562,36963,37749,38522,38997,39443,40568,20803,21407,21427,
24187,24358,28187,28304,29572,29694,32067,33335,35328,35578,38480,20046,20491,
21476,21628,22266,22993,23396,24049,24235,24359,25144,25925,26543,28246,29392,
31946,34996,32929,32993,33776,34382,35463,36328,37431,38599,39015,40723,20116,
20114,20237,21320,21577,21566,23087,24460,24481,24735,26791,27278,29786,30849,
35486,35492,35703,37264,20062,39881,20132,20348,20399,20505,20502,20809,20844,
21151,21177,21246,21402,21475,21521,21518,21897,22353,22434,22909,23380,23389,
23439,24037,24039,24055,24184,24195,24218,24247,24344,24658,24908,25239,25304,
25511,25915,26114,26179,26356,26477,26657,26775,27083,27743,27946,28009,28207,
28317,30002,30343,30828,31295,31968,32005,32024,32094,32177,32789,32771,32943,
32945,33108,33167,33322,33618,34892,34913,35611,36002,36092,37066,37237,37489,
30783,37628,38308,38477,38917,39321,39640,40251,21083,21163,21495,21512,22741,
25335,28640,35946,36703,40633,20811,21051,21578,22269,31296,37239,40288,40658,
29508,28425,33136,29969,24573,24794,39592,29403,36796,27492,38915,20170,22256,
22372,22718,23130,24680,25031,26127,26118,26681,26801,28151,30165,32058,33390,
39746,20123,20304,21449,21766,23919,24038,24046,26619,27801,29811,30722,35408,
37782,35039,22352,24231,25387,20661,20652,20877,26368,21705,22622,22971,23472,
24425,25165,25505,26685,27507,28168,28797,37319,29312,30741,30758,31085,25998,
32048,33756,35009,36617,38555,21092,22312,26448,32618,36001,20916,22338,38442,
22586,27018,32948,21682,23822,22524,30869,40442,20316,21066,21643,25662,26152,
26388,26613,31364,31574,32034,37679,26716,39853,31545,21273,20874,21047,23519,
25334,25774,25830,26413,27578,34217,38609,30352,39894,25420,37638,39851,30399,
26194,19977,20632,21442,23665,24808,25746,25955,26719,29158,29642,29987,31639,
32386,34453,35715,36059,37240,39184,26028,26283,27531,20181,20180,20282,20351,
21050,21496,21490,21987,22235,22763,22987,22985,23039,23376,23629,24066,24107,
24535,24605,25351,25903,23388,26031,26045,26088,26525,27490,27515,27663,29509,
31049,31169,31992,32025,32043,32930,33026,33267,35222,35422,35433,35430,35468,
35566,36039,36060,38604,39164,27503,20107,20284,20365,20816,23383,23546,24904,
25345,26178,27425,28363,27835,29246,29885,30164,30913,31034,32780,32819,33258,
33940,36766,27728,40575,24335,35672,40235,31482,36600,23437,38635,19971,21489,
22519,22833,23241,23460,24713,28287,28422,30142,36074,23455,34048,31712,20594,
26612,33437,23649,34122,32286,33294,20889,23556,25448,36198,26012,29038,31038,
32023,32773,35613,36554,36974,34503,37034,20511,21242,23610,26451,28796,29237,
37196,37320,37675,33509,23490,24369,24825,20027,21462,23432,25163,26417,27530,
29417,29664,31278,33131,36259,37202,39318,20754,21463,21610,23551,25480,27193,
32172,38656,22234,21454,21608,23447,23601,24030,20462,24833,25342,27954,31168,
31179,32066,32333,32722,33261,33311,33936,34886,35186,35728,36468,36655,36913,
37195,37228,38598,37276,20160,20303,20805,21313,24467,25102,26580,27713,28171,
29539,32294,37325,37507,21460,22809,23487,28113,31069,32302,31899,22654,29087,
20986,34899,36848,20426,23803,26149,30636,31459,33308,39423,20934,24490,26092,
26991,27529,28147,28310,28516,30462,32020,24033,36981,37255,38918,20966,21021,
25152,26257,26329,28186,24246,32210,32626,26360,34223,34295,35576,21161,21465,
22899,24207,24464,24661,37604,38500,20663,20767,21213,21280,21319,21484,21736,
21830,21809,22039,22888,22974,23100,23477,23558,23567,23569,23578,24196,24202,
24288,24432,25215,25220,25307,25484,25463,26119,26124,26157,26230,26494,26786,
27167,27189,27836,28040,28169,28248,28988,28966,29031,30151,30465,30813,30977,
31077,31216,31456,31505,31911,32057,32918,33750,33931,34121,34909,35059,35359,
35388,35412,35443,35937,36062,37284,37478,37758,37912,38556,38808,19978,19976,
19998,20055,20887,21104,22478,22580,22732,23330,24120,24773,25854,26465,26454,
27972,29366,30067,31331,33976,35698,37304,37664,22065,22516,39166,25325,26893,
27542,29165,32340,32887,33394,35302,39135,34645,36785,23611,20280,20449,20405,
21767,23072,23517,23529,24515,24910,25391,26032,26187,26862,27035,28024,28145,
30003,30137,30495,31070,31206,32051,33251,33455,34218,35242,35386,36523,36763,
36914,37341,38663,20154,20161,20995,22645,22764,23563,29978,23613,33102,35338,
36805,38499,38765,31525,35535,38920,37218,22259,21416,36887,21561,22402,24101,
25512,27700,28810,30561,31883,32736,34928,36930,37204,37648,37656,38543,29790,
39620,23815,23913,25968,26530,36264,38619,25454,26441,26905,33733,38935,38592,
35070,28548,25722,23544,19990,28716,30045,26159,20932,21046,21218,22995,24449,
24615,25104,25919,25972,26143,26228,26866,26646,27491,28165,29298,29983,30427,
31934,32854,22768,35069,35199,35488,35475,35531,36893,37266,38738,38745,25993,
31246,33030,38587,24109,24796,25114,26021,26132,26512,30707,31309,31821,32318,
33034,36012,36196,36321,36447,30889,20999,25305,25509,25666,25240,35373,31363,
31680,35500,38634,32118,33292,34633,20185,20808,21315,21344,23459,23554,23574,
24029,25126,25159,25776,26643,26676,27849,27973,27927,26579,28508,29006,29053,
26059,31359,31661,32218,32330,32680,33146,33307,33337,34214,35438,36046,36341,
36984,36983,37549,37521,38275,39854,21069,21892,28472,28982,20840,31109,32341,
33203,31950,22092,22609,23720,25514,26366,26365,26970,29401,30095,30094,30990,
31062,31199,31895,32032,32068,34311,35380,38459,36961,40736,20711,21109,21452,
21474,20489,21930,22766,22863,29245,23435,23652,21277,24803,24819,25436,25475,
25407,25531,25805,26089,26361,24035,27085,27133,28437,29157,20105,30185,30456,
31379,31967,32207,32156,32865,33609,33624,33900,33980,34299,35013,36208,36865,
36973,37783,38684,39442,20687,22679,24974,33235,34101,36104,36896,20419,20596,
21063,21363,24687,25417,26463,28204,36275,36895,20439,23646,36042,26063,32154,
21330,34966,20854,25539,23384,23403,23562,25613,26449,36956,20182,22810,22826,
27760,35409,21822,22549,22949,24816,25171,26561,33333,26965,38464,39364,39464,
20307,22534,23550,32784,23729,24111,24453,24608,24907,25140,26367,27888,28382,
32974,33151,33492,34955,36024,36864,36910,38538,40667,39899,20195,21488,22823,
31532,37261,38988,40441,28381,28711,21331,21828,23429,25176,25246,25299,27810,
28655,29730,35351,37944,28609,35582,33592,20967,34552,21482,21481,20294,36948,
36784,22890,33073,24061,31466,36799,26842,35895,29432,40008,27197,35504,20025,
21336,22022,22374,25285,25506,26086,27470,28129,28251,28845,30701,31471,31658,
32187,32829,32966,34507,35477,37723,22243,22727,24382,26029,26262,27264,27573,
30007,35527,20516,30693,22320,24347,24677,26234,27744,30196,31258,32622,33268,
34584,36933,39347,31689,30044,31481,31569,33988,36880,31209,31378,33590,23265,
30528,20013,20210,23449,24544,25277,26172,26609,27880,34411,34935,35387,37198,
37619,39376,27159,28710,29482,33511,33879,36015,19969,20806,20939,21899,23541,
24086,24115,24193,24340,24373,24427,24500,25074,25361,26274,26397,28526,29266,
30010,30522,32884,33081,33144,34678,35519,35548,36229,36339,37530,38263,38914,
40165,21189,25431,30452,26389,27784,29645,36035,37806,38515,27941,22684,26894,
27084,36861,37786,30171,36890,22618,26626,25524,27131,20291,28460,26584,36795,
34086,32180,37716,26943,28528,22378,22775,23340,32044,29226,21514,37347,40372,
20141,20302,20572,20597,21059,35998,21576,22564,23450,24093,24213,24237,24311,
24351,24716,25269,25402,25552,26799,27712,30855,31118,31243,32224,33351,35330,
35558,36420,36883,37048,37165,37336,40718,27877,25688,25826,25973,28404,30340,
31515,36969,37841,28346,21746,24505,25764,36685,36845,37444,20856,22635,22825,
23637,24215,28155,32399,29980,36028,36578,39003,28857,20253,27583,28593,30000,
38651,20814,21520,22581,22615,22956,23648,24466,26007,26460,28193,30331,33759,
36077,36884,37117,37709,30757,30778,21162,24230,22303,22900,24594,20498,20826,
20908,20941,20992,21776,22612,22616,22871,23445,23798,23947,24764,25237,25645,
26481,26691,26812,26847,30423,28120,28271,28059,28783,29128,24403,30168,31095,
31561,31572,31570,31958,32113,21040,33891,34153,34276,35342,35588,35910,36367,
36867,36879,37913,38518,38957,39472,38360,20685,21205,21516,22530,23566,24999,
25758,27934,30643,31461,33012,33796,36947,37509,23776,40199,21311,24471,24499,
28060,29305,30563,31167,31716,27602,29420,35501,26627,27233,20984,31361,26932,
23626,40182,33515,23493,37193,28702,22136,23663,24775,25958,27788,35930,36929,
38931,21585,26311,37389,22856,37027,20869,20045,20970,34201,35598,28760,25466,
37707,26978,39348,32260,30071,21335,26976,36575,38627,27741,20108,23612,24336,
36841,21250,36049,32905,34425,24319,26085,20083,20837,22914,23615,38894,20219,
22922,24525,35469,28641,31152,31074,23527,33905,29483,29105,24180,24565,25467,
25754,29123,31896,20035,24316,20043,22492,22178,24745,28611,32013,33021,33075,
33215,36786,35223,34468,24052,25226,25773,35207,26487,27874,27966,29750,30772,
23110,32629,33453,39340,20467,24259,25309,25490,25943,26479,30403,29260,32972,
32954,36649,37197,20493,22521,23186,26757,26995,29028,29437,36023,22770,36064,
38506,36889,34687,31204,30695,33833,20271,21093,21338,25293,26575,27850,30333,
31636,31893,33334,34180,36843,26333,28448,29190,32283,33707,39361,40614,20989,
31665,30834,31672,32903,31560,27368,24161,32908,30033,30048,20843,37474,28300,
30330,37271,39658,20240,32624,25244,31567,38309,40169,22138,22617,34532,38588,
20276,21028,21322,21453,21467,24070,25644,26001,26495,27710,27726,29256,29359,
29677,30036,32321,33324,34281,36009,31684,37318,29033,38930,39151,25405,26217,
30058,30436,30928,34115,34542,21290,21329,21542,22915,24199,24444,24754,25161,
25209,25259,26000,27604,27852,30130,30382,30865,31192,32203,32631,32933,34987,
35513,36027,36991,38750,39131,27147,31800,20633,23614,24494,26503,27608,29749,
30473,32654,40763,26570,31255,21305,30091,39661,24422,33181,33777,32920,24380,
24517,30050,31558,36924,26727,23019,23195,32016,30334,35628,20469,24426,27161,
27703,28418,29922,31080,34920,35413,35961,24287,25551,30149,31186,33495,37672,
37618,33948,34541,39981,21697,24428,25996,27996,28693,36007,36051,38971,25935,
29942,19981,20184,22496,22827,23142,23500,20904,24067,24220,24598,25206,25975,
26023,26222,28014,29238,31526,33104,33178,33433,35676,36000,36070,36212,38428,
38468,20398,25771,27494,33310,33889,34154,37096,23553,26963,39080,33914,34135,
20239,21103,24489,24133,26381,31119,33145,35079,35206,28149,24343,25173,27832,
20175,29289,39826,20998,21563,22132,22707,24996,25198,28954,22894,31881,31966,
32027,38640,25991,32862,19993,20341,20853,22592,24163,24179,24330,26564,20006,
34109,38281,38491,31859,38913,20731,22721,30294,30887,21029,30629,34065,31622,
20559,22793,29255,31687,32232,36794,36820,36941,20415,21193,23081,24321,38829,
20445,33303,37610,22275,25429,27497,29995,35036,36628,31298,21215,22675,24917,
25098,26286,27597,31807,33769,20515,20472,21253,21574,22577,22857,23453,23792,
23791,23849,24214,25265,25447,25918,26041,26379,27861,27873,28921,30770,32299,
32990,33459,33804,34028,34562,35090,35370,35914,37030,37586,39165,40179,40300,
20047,20129,20621,21078,22346,22952,24125,24536,24537,25151,26292,26395,26576,
26834,20882,32033,32938,33192,35584,35980,36031,37502,38450,21536,38956,21271,
20693,21340,22696,25778,26420,29287,30566,31302,37350,21187,27809,27526,22528,
24140,22868,26412,32763,20961,30406,25705,30952,39764,40635,22475,22969,26151,
26522,27598,21737,27097,24149,33180,26517,39850,26622,40018,26717,20134,20451,
21448,25273,26411,27819,36804,20397,32365,40639,19975,24930,28288,28459,34067,
21619,26410,39749,24051,31637,23724,23494,34588,28234,34001,31252,33032,22937,
31885,27665,30496,21209,22818,28961,29279,30683,38695,40289,26891,23167,23064,
20901,21517,21629,26126,30431,36855,37528,40180,23018,29277,28357,20813,26825,
32191,32236,38754,40634,25720,27169,33538,22916,23391,27611,29467,30450,32178,
32791,33945,20786,26408,40665,30446,26466,21247,39173,23588,25147,31870,36016,
21839,24758,32011,38272,21249,20063,20918,22812,29242,32822,37326,24357,30690,
21380,24441,32004,34220,35379,36493,38742,26611,34222,37971,24841,24840,27833,
30290,35565,36664,21807,20305,20778,21191,21451,23461,24189,24736,24962,25558,
26377,26586,28263,28044,29494,29495,30001,31056,35029,35480,36938,37009,37109,
38596,34701,22805,20104,20313,19982,35465,36671,38928,20653,24188,22934,23481,
24248,25562,25594,25793,26332,26954,27096,27915,28342,29076,29992,31407,32650,
32768,33865,33993,35201,35617,36362,36965,38525,39178,24958,25233,27442,27779,
28020,32716,32764,28096,32645,34746,35064,26469,33713,38972,38647,27931,32097,
33853,37226,20081,21365,23888,27396,28651,34253,34349,35239,21033,21519,23653,
26446,26792,29702,29827,30178,35023,35041,37324,38626,38520,24459,29575,31435,
33870,25504,30053,21129,27969,28316,29705,30041,30827,31890,38534,31452,40845,
20406,24942,26053,34396,20102,20142,20698,20001,20940,23534,26009,26753,28092,
29471,30274,30637,31260,31975,33391,35538,36988,37327,38517,38936,21147,32209,
20523,21400,26519,28107,29136,29747,33256,36650,38563,40023,40607,29792,22593,
28057,32047,39006,20196,20278,20363,20919,21169,23994,24604,29618,31036,33491,
37428,38583,38646,38666,40599,40802,26278,27508,21015,21155,28872,35010,24265,
24651,24976,28451,29001,31806,32244,32879,34030,36899,37676,21570,39791,27347,
28809,36034,36335,38706,21172,23105,24266,24324,26391,27004,27028,28010,28431,
29282,29436,31725,32769,32894,34635,37070,20845,40595,31108,32907,37682,35542,
20525,21644,35441,27498,36036,33031,24785,26528,40434,20121,20120,39952,35435,
34241,34152,26880,28286,30871,33109,24332,19984,19989,20010,20017,20022,20028,
20031,20034,20054,20056,20098,20101,35947,20106,33298,24333,20110,20126,20127,
20128,20130,20144,20147,20150,20174,20173,20164,20166,20162,20183,20190,20205,
20191,20215,20233,20314,20272,20315,20317,20311,20295,20342,20360,20367,20376,
20347,20329,20336,20369,20335,20358,20374,20760,20436,20447,20430,20440,20443,
20433,20442,20432,20452,20453,20506,20520,20500,20522,20517,20485,20252,20470,
20513,20521,20524,20478,20463,20497,20486,20547,20551,26371,20565,20560,20552,
20570,20566,20588,20600,20608,20634,20613,20660,20658,20681,20682,20659,20674,
20694,20702,20709,20717,20707,20718,20729,20725,20745,20737,20738,20758,20757,
20756,20762,20769,20794,20791,20796,20795,20799,20800,20818,20812,20820,20834,
31480,20841,20842,20846,20864,20866,22232,20876,20873,20879,20881,20883,20885,
20886,20900,20902,20898,20905,20906,20907,20915,20913,20914,20912,20917,20925,
20933,20937,20955,20960,34389,20969,20973,20976,20981,20990,20996,21003,21012,
21006,21031,21034,21038,21043,21049,21071,21060,21067,21068,21086,21076,21098,
21108,21097,21107,21119,21117,21133,21140,21138,21105,21128,21137,36776,36775,
21164,21165,21180,21173,21185,21197,21207,21214,21219,21222,39149,21216,21235,
21237,21240,21241,21254,21256,30008,21261,21264,21263,21269,21274,21283,21295,
21297,21299,21304,21312,21318,21317,19991,21321,21325,20950,21342,21353,21358,
22808,21371,21367,21378,21398,21408,21414,21413,21422,21424,21430,21443,31762,
38617,21471,26364,29166,21486,21480,21485,21498,21505,21565,21568,21548,21549,
21564,21550,21558,21545,21533,21582,21647,21621,21646,21599,21617,21623,21616,
21650,21627,21632,21622,21636,21648,21638,21703,21666,21688,21669,21676,21700,
21704,21672,21675,21698,21668,21694,21692,21720,21733,21734,21775,21780,21757,
21742,21741,21754,21730,21817,21824,21859,21836,21806,21852,21829,21846,21847,
21816,21811,21853,21913,21888,21679,21898,21919,21883,21886,21912,21918,21934,
21884,21891,21929,21895,21928,21978,21957,21983,21956,21980,21988,21972,22036,
22007,22038,22014,22013,22043,22009,22094,22096,29151,22068,22070,22066,22072,
22123,22116,22063,22124,22122,22150,22144,22154,22176,22164,22159,22181,22190,
22198,22196,22210,22204,22209,22211,22208,22216,22222,22225,22227,22231,22254,
22265,22272,22271,22276,22281,22280,22283,22285,22291,22296,22294,21959,22300,
22310,22327,22328,22350,22331,22336,22351,22377,22464,22408,22369,22399,22409,
22419,22432,22451,22436,22442,22448,22467,22470,22484,22482,22483,22538,22486,
22499,22539,22553,22557,22642,22561,22626,22603,22640,27584,22610,22589,22649,
22661,22713,22687,22699,22714,22750,22715,22712,22702,22725,22739,22737,22743,
22745,22744,22757,22748,22756,22751,22767,22778,22777,22779,22780,22781,22786,
22794,22800,22811,26790,22821,22828,22829,22834,22840,22846,31442,22869,22864,
22862,22874,22872,22882,22880,22887,22892,22889,22904,22913,22941,20318,20395,
22947,22962,22982,23016,23004,22925,23001,23002,23077,23071,23057,23068,23049,
23066,23104,23148,23113,23093,23094,23138,23146,23194,23228,23230,23243,23234,
23229,23267,23255,23270,23273,23254,23290,23291,23308,23307,23318,23346,23248,
23338,23350,23358,23363,23365,23360,23377,23381,23386,23387,23397,23401,23408,
23411,23413,23416,25992,23418,23424,23427,23462,23480,23491,23495,23497,23508,
23504,23524,23526,23522,23518,23525,23531,23536,23542,23539,23557,23559,23560,
23565,23571,23584,23586,23592,23608,23609,23617,23622,23630,23635,23632,23631,
23409,23660,23662,20066,23670,23673,23692,23697,23700,22939,23723,23739,23734,
23740,23735,23749,23742,23751,23769,23785,23805,23802,23789,23948,23786,23819,
23829,23831,23900,23839,23835,23825,23828,23842,23834,23833,23832,23884,23890,
23886,23883,23916,23923,23926,23943,23940,23938,23970,23965,23980,23982,23997,
23952,23991,23996,24009,24013,24019,24018,24022,24027,24043,24050,24053,24075,
24090,24089,24081,24091,24118,24119,24132,24131,24128,24142,24151,24148,24159,
24162,24164,24135,24181,24182,24186,40636,24191,24224,24257,24258,24264,24272,
24271,24278,24291,24285,24282,24283,24290,24289,24296,24297,24300,24305,24307,
24304,24308,24312,24318,24323,24329,24413,24412,24331,24337,24342,24361,24365,
24376,24385,24392,24396,24398,24367,24401,24406,24407,24409,24417,24429,24435,
24439,24451,24450,24447,24458,24456,24465,24455,24478,24473,24472,24480,24488,
24493,24508,24534,24571,24548,24568,24561,24541,24755,24575,24609,24672,24601,
24592,24617,24590,24625,24603,24597,24619,24614,24591,24634,24666,24641,24682,
24695,24671,24650,24646,24653,24675,24643,24676,24642,24684,24683,24665,24705,
24717,24807,24707,24730,24708,24731,24726,24727,24722,24743,24715,24801,24760,
24800,24787,24756,24560,24765,24774,24757,24792,24909,24853,24838,24822,24823,
24832,24820,24826,24835,24865,24827,24817,24845,24846,24903,24894,24872,24871,
24906,24895,24892,24876,24884,24893,24898,24900,24947,24951,24920,24921,24922,
24939,24948,24943,24933,24945,24927,24925,24915,24949,24985,24982,24967,25004,
24980,24986,24970,24977,25003,25006,25036,25034,25033,25079,25032,25027,25030,
25018,25035,32633,25037,25062,25059,25078,25082,25076,25087,25085,25084,25086,
25088,25096,25097,25101,25100,25108,25115,25118,25121,25130,25134,25136,25138,
25139,25153,25166,25182,25187,25179,25184,25192,25212,25218,25225,25214,25234,
25235,25238,25300,25219,25236,25303,25297,25275,25295,25343,25286,25812,25288,
25308,25292,25290,25282,25287,25243,25289,25356,25326,25329,25383,25346,25352,
25327,25333,25424,25406,25421,25628,25423,25494,25486,25472,25515,25462,25507,
25487,25481,25503,25525,25451,25449,25534,25577,25536,25542,25571,25545,25554,
25590,25540,25622,25652,25606,25619,25638,25654,25885,25623,25640,25615,25703,
25711,25718,25678,25898,25749,25747,25765,25769,25736,25788,25818,25810,25797,
25799,25787,25816,25794,25841,25831,33289,25824,25825,25260,25827,25839,25900,
25846,25844,25842,25850,25856,25853,25880,25884,25861,25892,25891,25899,25908,
25909,25911,25910,25912,30027,25928,25942,25941,25933,25944,25950,25949,25970,
25976,25986,25987,35722,26011,26015,26027,26039,26051,26054,26049,26052,26060,
26066,26075,26073,26080,26081,26097,26482,26122,26115,26107,26483,26165,26166,
26164,26140,26191,26180,26185,26177,26206,26205,26212,26215,26216,26207,26210,
26224,26243,26248,26254,26249,26244,26264,26269,26305,26297,26313,26302,26300,
26308,26296,26326,26330,26336,26175,26342,26345,26352,26357,26359,26383,26390,
26398,26406,26407,38712,26414,26431,26422,26433,26424,26423,26438,26462,26464,
26457,26467,26468,26505,26480,26537,26492,26474,26508,26507,26534,26529,26501,
26551,26607,26548,26604,26547,26601,26552,26596,26590,26589,26594,26606,26553,
26574,26566,26599,27292,26654,26694,26665,26688,26701,26674,26702,26803,26667,
26713,26723,26743,26751,26783,26767,26797,26772,26781,26779,26755,27310,26809,
26740,26805,26784,26810,26895,26765,26750,26881,26826,26888,26840,26914,26918,
26849,26892,26829,26836,26855,26837,26934,26898,26884,26839,26851,26917,26873,
26848,26863,26920,26922,26906,26915,26913,26822,27001,26999,26972,27000,26987,
26964,27006,26990,26937,26996,26941,26969,26928,26977,26974,26973,27009,26986,
27058,27054,27088,27071,27073,27091,27070,27086,23528,27082,27101,27067,27075,
27047,27182,27025,27040,27036,27029,27060,27102,27112,27138,27163,27135,27402,
27129,27122,27111,27141,27057,27166,27117,27156,27115,27146,27154,27329,27171,
27155,27204,27148,27250,27190,27256,27207,27234,27225,27238,27208,27192,27170,
27280,27277,27296,27268,27298,27299,27287,34327,27323,27331,27330,27320,27315,
27308,27358,27345,27359,27306,27354,27370,27387,27397,34326,27386,27410,27414,
39729,27423,27448,27447,30428,27449,39150,27463,27459,27465,27472,27481,27476,
27483,27487,27489,27512,27513,27519,27520,27524,27523,27533,27544,27541,27550,
27556,27562,27563,27567,27570,27569,27571,27575,27580,27590,27595,27603,27615,
27628,27627,27635,27631,40638,27656,27667,27668,27675,27684,27683,27742,27733,
27746,27754,27778,27789,27802,27777,27803,27774,27752,27763,27794,27792,27844,
27889,27859,27837,27863,27845,27869,27822,27825,27838,27834,27867,27887,27865,
27882,27935,34893,27958,27947,27965,27960,27929,27957,27955,27922,27916,28003,
28051,28004,27994,28025,27993,28046,28053,28644,28037,28153,28181,28170,28085,
28103,28134,28088,28102,28140,28126,28108,28136,28114,28101,28154,28121,28132,
28117,28138,28142,28205,28270,28206,28185,28274,28255,28222,28195,28267,28203,
28278,28237,28191,28227,28218,28238,28196,28415,28189,28216,28290,28330,28312,
28361,28343,28371,28349,28335,28356,28338,28372,28373,28303,28325,28354,28319,
28481,28433,28748,28396,28408,28414,28479,28402,28465,28399,28466,28364,28478,
28435,28407,28550,28538,28536,28545,28544,28527,28507,28659,28525,28546,28540,
28504,28558,28561,28610,28518,28595,28579,28577,28580,28601,28614,28586,28639,
28629,28652,28628,28632,28657,28654,28635,28681,28683,28666,28689,28673,28687,
28670,28699,28698,28532,28701,28696,28703,28720,28734,28722,28753,28771,28825,
28818,28847,28913,28844,28856,28851,28846,28895,28875,28893,28889,28937,28925,
28956,28953,29029,29013,29064,29030,29026,29004,29014,29036,29071,29179,29060,
29077,29096,29100,29143,29113,29118,29138,29129,29140,29134,29152,29164,29159,
29173,29180,29177,29183,29197,29200,29211,29224,29229,29228,29232,29234,29243,
29244,29247,29248,29254,29259,29272,29300,29310,29314,29313,29319,29330,29334,
29346,29351,29369,29362,29379,29382,29380,29390,29394,29410,29408,29409,29433,
29431,20495,29463,29450,29468,29462,29469,29492,29487,29481,29477,29502,29518,
29519,40664,29527,29546,29544,29552,29560,29557,29563,29562,29640,29619,29646,
29627,29632,29669,29678,29662,29858,29701,29807,29733,29688,29746,29754,29781,
29759,29791,29785,29761,29788,29801,29808,29795,29802,29814,29822,29835,29854,
29863,29898,29903,29908,29681,29920,29923,29927,29929,29934,29938,29936,29937,
29944,29943,29956,29955,29957,29964,29966,29965,29973,29971,29982,29990,29996,
30012,30020,30029,30026,30025,30043,30022,30042,30057,30052,30055,30059,30061,
30072,30070,30086,30087,30068,30090,30089,30082,30100,30106,30109,30117,30115,
30146,30131,30147,30133,30141,30136,30140,30129,30157,30154,30162,30169,30179,
30174,30206,30207,30204,30209,30192,30202,30194,30195,30219,30221,30217,30239,
30247,30240,30241,30242,30244,30260,30256,30267,30279,30280,30278,30300,30296,
30305,30306,30312,30313,30314,30311,30316,30320,30322,30326,30328,30332,30336,
30339,30344,30347,30350,30358,30355,30361,30362,30384,30388,30392,30393,30394,
30402,30413,30422,30418,30430,30433,30437,30439,30442,34351,30459,30472,30471,
30468,30505,30500,30494,30501,30502,30491,30519,30520,30535,30554,30568,30571,
30555,30565,30591,30590,30585,30606,30603,30609,30624,30622,30640,30646,30649,
30655,30652,30653,30651,30663,30669,30679,30682,30684,30691,30702,30716,30732,
30738,31014,30752,31018,30789,30862,30836,30854,30844,30874,30860,30883,30901,
30890,30895,30929,30918,30923,30932,30910,30908,30917,30922,30956,30951,30938,
30973,30964,30983,30994,30993,31001,31020,31019,31040,31072,31063,31071,31066,
31061,31059,31098,31103,31114,31133,31143,40779,31146,31150,31155,31161,31162,
31177,31189,31207,31212,31201,31203,31240,31245,31256,31257,31264,31263,31104,
31281,31291,31294,31287,31299,31319,31305,31329,31330,31337,40861,31344,31353,
31357,31368,31383,31381,31384,31382,31401,31432,31408,31414,31429,31428,31423,
36995,31431,31434,31437,31439,31445,31443,31449,31450,31453,31457,31458,31462,
31469,31472,31490,31503,31498,31494,31539,31512,31513,31518,31541,31528,31542,
31568,31610,31492,31565,31499,31564,31557,31605,31589,31604,31591,31600,31601,
31596,31598,31645,31640,31647,31629,31644,31642,31627,31634,31631,31581,31641,
31691,31681,31692,31695,31668,31686,31709,31721,31761,31764,31718,31717,31840,
31744,31751,31763,31731,31735,31767,31757,31734,31779,31783,31786,31775,31799,
31787,31805,31820,31811,31828,31823,31808,31824,31832,31839,31844,31830,31845,
31852,31861,31875,31888,31908,31917,31906,31915,31905,31912,31923,31922,31921,
31918,31929,31933,31936,31941,31938,31960,31954,31964,31970,39739,31983,31986,
31988,31990,31994,32006,32002,32028,32021,32010,32069,32075,32046,32050,32063,
32053,32070,32115,32086,32078,32114,32104,32110,32079,32099,32147,32137,32091,
32143,32125,32155,32186,32174,32163,32181,32199,32189,32171,32317,32162,32175,
32220,32184,32159,32176,32216,32221,32228,32222,32251,32242,32225,32261,32266,
32291,32289,32274,32305,32287,32265,32267,32290,32326,32358,32315,32309,32313,
32323,32311,32306,32314,32359,32349,32342,32350,32345,32346,32377,32362,32361,
32380,32379,32387,32213,32381,36782,32383,32392,32393,32396,32402,32400,32403,
32404,32406,32398,32411,32412,32568,32570,32581,32588,32589,32590,32592,32593,
32597,32596,32600,32607,32608,32616,32617,32615,32632,32642,32646,32643,32648,
32647,32652,32660,32670,32669,32666,32675,32687,32690,32697,32686,32694,32696,
35697,32709,32710,32714,32725,32724,32737,32742,32745,32755,32761,39132,32774,
32772,32779,32786,32792,32793,32796,32801,32808,32831,32827,32842,32838,32850,
32856,32858,32863,32866,32872,32883,32882,32880,32886,32889,32893,32895,32900,
32902,32901,32923,32915,32922,32941,20880,32940,32987,32997,32985,32989,32964,
32986,32982,33033,33007,33009,33051,33065,33059,33071,33099,38539,33094,33086,
33107,33105,33020,33137,33134,33125,33126,33140,33155,33160,33162,33152,33154,
33184,33173,33188,33187,33119,33171,33193,33200,33205,33214,33208,33213,33216,
33218,33210,33225,33229,33233,33241,33240,33224,33242,33247,33248,33255,33274,
33275,33278,33281,33282,33285,33287,33290,33293,33296,33302,33321,33323,33336,
33331,33344,33369,33368,33373,33370,33375,33380,33378,33384,33386,33387,33326,
33393,33399,33400,33406,33421,33426,33451,33439,33467,33452,33505,33507,33503,
33490,33524,33523,33530,33683,33539,33531,33529,33502,33542,33500,33545,33497,
33589,33588,33558,33586,33585,33600,33593,33616,33605,33583,33579,33559,33560,
33669,33690,33706,33695,33698,33686,33571,33678,33671,33674,33660,33717,33651,
33653,33696,33673,33704,33780,33811,33771,33742,33789,33795,33752,33803,33729,
33783,33799,33760,33778,33805,33826,33824,33725,33848,34054,33787,33901,33834,
33852,34138,33924,33911,33899,33965,33902,33922,33897,33862,33836,33903,33913,
33845,33994,33890,33977,33983,33951,34009,33997,33979,34010,34000,33985,33990,
34006,33953,34081,34047,34036,34071,34072,34092,34079,34069,34068,34044,34112,
34147,34136,34120,34113,34306,34123,34133,34176,34212,34184,34193,34186,34216,
34157,34196,34203,34282,34183,34204,34167,34174,34192,34249,34234,34255,34233,
34256,34261,34269,34277,34268,34297,34314,34323,34315,34302,34298,34310,34338,
34330,34352,34367,34381,20053,34388,34399,34407,34417,34451,34467,34473,34474,
34443,34444,34486,34479,34500,34502,34480,34505,34851,34475,34516,34526,34537,
34540,34527,34523,34543,34578,34566,34568,34560,34563,34555,34577,34569,34573,
34553,34570,34612,34623,34615,34619,34597,34601,34586,34656,34655,34680,34636,
34638,34676,34647,34664,34670,34649,34643,34659,34666,34821,34722,34719,34690,
34735,34763,34749,34752,34768,38614,34731,34756,34739,34759,34758,34747,34799,
34802,34784,34831,34829,34814,34806,34807,34830,34770,34833,34838,34837,34850,
34849,34865,34870,34873,34855,34875,34884,34882,34898,34905,34910,34914,34923,
34945,34942,34974,34933,34941,34997,34930,34946,34967,34962,34990,34969,34978,
34957,34980,34992,35007,34993,35011,35012,35028,35032,35033,35037,35065,35074,
35068,35060,35048,35058,35076,35084,35082,35091,35139,35102,35109,35114,35115,
35137,35140,35131,35126,35128,35148,35101,35168,35166,35174,35172,35181,35178,
35183,35188,35191,35198,35203,35208,35210,35219,35224,35233,35241,35238,35244,
35247,35250,35258,35261,35263,35264,35290,35292,35293,35303,35316,35320,35331,
35350,35344,35340,35355,35357,35365,35382,35393,35419,35410,35398,35400,35452,
35437,35436,35426,35461,35458,35460,35496,35489,35473,35493,35494,35482,35491,
35524,35533,35522,35546,35563,35571,35559,35556,35569,35604,35552,35554,35575,
35550,35547,35596,35591,35610,35553,35606,35600,35607,35616,35635,38827,35622,
35627,35646,35624,35649,35660,35663,35662,35657,35670,35675,35674,35691,35679,
35692,35695,35700,35709,35712,35724,35726,35730,35731,35734,35737,35738,35898,
35905,35903,35912,35916,35918,35920,35925,35938,35948,35960,35962,35970,35977,
35973,35978,35981,35982,35988,35964,35992,25117,36013,36010,36029,36018,36019,
36014,36022,36040,36033,36068,36067,36058,36093,36090,36091,36100,36101,36106,
36103,36111,36109,36112,40782,36115,36045,36116,36118,36199,36205,36209,36211,
36225,36249,36290,36286,36282,36303,36314,36310,36300,36315,36299,36330,36331,
36319,36323,36348,36360,36361,36351,36381,36382,36368,36383,36418,36405,36400,
36404,36426,36423,36425,36428,36432,36424,36441,36452,36448,36394,36451,36437,
36470,36466,36476,36481,36487,36485,36484,36491,36490,36499,36497,36500,36505,
36522,36513,36524,36528,36550,36529,36542,36549,36552,36555,36571,36579,36604,
36603,36587,36606,36618,36613,36629,36626,36633,36627,36636,36639,36635,36620,
36646,36659,36667,36665,36677,36674,36670,36684,36681,36678,36686,36695,36700,
36706,36707,36708,36764,36767,36771,36781,36783,36791,36826,36837,36834,36842,
36847,36999,36852,36869,36857,36858,36881,36885,36897,36877,36894,36886,36875,
36903,36918,36917,36921,36856,36943,36944,36945,36946,36878,36937,36926,36950,
36952,36958,36968,36975,36982,38568,36978,36994,36989,36993,36992,37002,37001,
37007,37032,37039,37041,37045,37090,37092,25160,37083,37122,37138,37145,37170,
37168,37194,37206,37208,37219,37221,37225,37235,37234,37259,37257,37250,37282,
37291,37295,37290,37301,37300,37306,37312,37313,37321,37323,37328,37334,37343,
37345,37339,37372,37365,37366,37406,37375,37396,37420,37397,37393,37470,37463,
37445,37449,37476,37448,37525,37439,37451,37456,37532,37526,37523,37531,37466,
37583,37561,37559,37609,37647,37626,37700,37678,37657,37666,37658,37667,37690,
37685,37691,37724,37728,37756,37742,37718,37808,37804,37805,37780,37817,37846,
37847,37864,37861,37848,37827,37853,37840,37832,37860,37914,37908,37907,37891,
37895,37904,37942,37931,37941,37921,37946,37953,37970,37956,37979,37984,37986,
37982,37994,37417,38000,38005,38007,38013,37978,38012,38014,38017,38015,38274,
38279,38282,38292,38294,38296,38297,38304,38312,38311,38317,38332,38331,38329,
38334,38346,28662,38339,38349,38348,38357,38356,38358,38364,38369,38373,38370,
38433,38440,38446,38447,38466,38476,38479,38475,38519,38492,38494,38493,38495,
38502,38514,38508,38541,38552,38549,38551,38570,38567,38577,38578,38576,38580,
38582,38584,38585,38606,38603,38601,38605,35149,38620,38669,38613,38649,38660,
38662,38664,38675,38670,38673,38671,38678,38681,38692,38698,38704,38713,38717,
38718,38724,38726,38728,38722,38729,38748,38752,38756,38758,38760,21202,38763,
38769,38777,38789,38780,38785,38778,38790,38795,38799,38800,38812,38824,38822,
38819,38835,38836,38851,38854,38856,38859,38876,38893,40783,38898,31455,38902,
38901,38927,38924,38968,38948,38945,38967,38973,38982,38991,38987,39019,39023,
39024,39025,39028,39027,39082,39087,39089,39094,39108,39107,39110,39145,39147,
39171,39177,39186,39188,39192,39201,39197,39198,39204,39200,39212,39214,39229,
39230,39234,39241,39237,39248,39243,39249,39250,39244,39253,39319,39320,39333,
39341,39342,39356,39391,39387,39389,39384,39377,39405,39406,39409,39410,39419,
39416,39425,39439,39429,39394,39449,39467,39479,39493,39490,39488,39491,39486,
39509,39501,39515,39511,39519,39522,39525,39524,39529,39531,39530,39597,39600,
39612,39616,39631,39633,39635,39636,39646,39647,39650,39651,39654,39663,39659,
39662,39668,39665,39671,39675,39686,39704,39706,39711,39714,39715,39717,39719,
39720,39721,39722,39726,39727,39730,39748,39747,39759,39757,39758,39761,39768,
39796,39827,39811,39825,39830,39831,39839,39840,39848,39860,39872,39882,39865,
39878,39887,39889,39890,39907,39906,39908,39892,39905,39994,39922,39921,39920,
39957,39956,39945,39955,39948,39942,39944,39954,39946,39940,39982,39963,39973,
39972,39969,39984,40007,39986,40006,39998,40026,40032,40039,40054,40056,40167,
40172,40176,40201,40200,40171,40195,40198,40234,40230,40367,40227,40223,40260,
40213,40210,40257,40255,40254,40262,40264,40285,40286,40292,40273,40272,40281,
40306,40329,40327,40363,40303,40314,40346,40356,40361,40370,40388,40385,40379,
40376,40378,40390,40399,40386,40409,40403,40440,40422,40429,40431,40445,40474,
40475,40478,40565,40569,40573,40577,40584,40587,40588,40594,40597,40593,40605,
40613,40617,40632,40618,40621,38753,40652,40654,40655,40656,40660,40668,40670,
40669,40672,40677,40680,40687,40692,40694,40695,40697,40699,40700,40701,40711,
40712,30391,40725,40737,40748,40766,40778,40786,40788,40803,40799,40800,40801,
40806,40807,40812,40810,40823,40818,40822,40853,40860,40864,22575,27079,36953,
29796,20956,29081,8560,8561,8562,8563,8564,8565,8566,8567,8568,8569,8544,8545,
8546,8547,8548,8549,8550,8551,8552,8553,65506,65508,65287,65282,12849,8470,8481,
8757,32394,35100,37704,37512,34012,20425,28859,26161,26824,37625,26363,24389,
20008,20193,20220,20224,20227,20281,20310,20370,20362,20378,20372,20429,20544,
20514,20479,20510,20550,20592,20546,20628,20724,20696,20810,20836,20893,20926,
20972,21013,21148,21158,21184,21211,21248,21255,21284,21362,21395,21426,21469,
64014,21660,21642,21673,21759,21894,22361,22373,22444,22472,22471,64015,64016,
22686,22706,22795,22867,22875,22877,22883,22948,22970,23382,23488,29999,23512,
23532,23582,23718,23738,23797,23847,23891,64017,23874,23917,23992,23993,24016,
24353,24372,24423,24503,24542,24669,24709,24714,24798,24789,24864,24818,24849,
24887,24880,24984,25107,25254,25589,25696,25757,25806,25934,26112,26133,26171,
26121,26158,26142,26148,26213,26199,26201,64018,26227,26265,26272,26290,26303,
26362,26382,63785,26470,26555,26706,26560,26625,26692,26831,64019,26984,64020,
27032,27106,27184,27243,27206,27251,27262,27362,27364,27606,27711,27740,27782,
27759,27866,27908,28039,28015,28054,28076,28111,28152,28146,28156,28217,28252,
28199,28220,28351,28552,28597,28661,28677,28679,28712,28805,28843,28943,28932,
29020,28998,28999,64021,29121,29182,29361,29374,29476,64022,29559,29629,29641,
29654,29667,29650,29703,29685,29734,29738,29737,29742,29794,29833,29855,29953,
30063,30338,30364,30366,30363,30374,64023,30534,21167,30753,30798,30820,30842,
31024,64024,64025,64026,31124,64027,31131,31441,31463,64028,31467,31646,64029,
32072,32092,32183,32160,32214,32338,32583,32673,64030,33537,33634,33663,33735,
33782,33864,33972,34131,34137,34155,64031,34224,64032,64033,34823,35061,35346,
35383,35449,35495,35518,35551,64034,35574,35667,35711,36080,36084,36114,36214,
64035,36559,64036,64037,36967,37086,64038,37141,37159,37338,37335,37342,37357,
37358,37348,37349,37382,37392,37386,37434,37440,37436,37454,37465,37457,37433,
37479,37543,37495,37496,37607,37591,37593,37584,64039,37589,37600,37587,37669,
37665,37627,64040,37662,37631,37661,37634,37744,37719,37796,37830,37854,37880,
37937,37957,37960,38290,63964,64041,38557,38575,38707,38715,38723,38733,38735,
38737,38741,38999,39013,64042,64043,39207,64044,39326,39502,39641,39644,39797,
39794,39823,39857,39867,39936,40304,40299,64045,40473,40657};

static MVMint16 shift_jis_cp_to_index (MVMThreadContext *tc, MVMGrapheme32 codepoint) {
    switch (codepoint) {
        case 0xA7: return 87;
        case 0xA8: return 14;
        case 0xB0: return 74;
        case 0xB1: return 61;
        case 0xB4: return 12;
        case 0xB6: return 182;
        case 0xD7: return 62;
        case 0xF7: return 63;
        case 0x391: return 470;
        case 0x392: return 471;
        case 0x393: return 472;
        case 0x394: return 473;
        case 0x395: return 474;
        case 0x396: return 475;
        case 0x397: return 476;
        case 0x398: return 477;
        case 0x399: return 478;
        case 0x39A: return 479;
        case 0x39B: return 480;
        case 0x39C: return 481;
        case 0x39D: return 482;
        case 0x39E: return 483;
        case 0x39F: return 484;
        case 0x3A0: return 485;
        case 0x3A1: return 486;
        case 0x3A3: return 487;
        case 0x3A4: return 488;
        case 0x3A5: return 489;
        case 0x3A6: return 490;
        case 0x3A7: return 491;
        case 0x3A8: return 492;
        case 0x3A9: return 493;
        case 0x3B1: return 502;
        case 0x3B2: return 503;
        case 0x3B3: return 504;
        case 0x3B4: return 505;
        case 0x3B5: return 506;
        case 0x3B6: return 507;
        case 0x3B7: return 508;
        case 0x3B8: return 509;
        case 0x3B9: return 510;
        case 0x3BA: return 511;
        case 0x3BB: return 512;
        case 0x3BC: return 513;
        case 0x3BD: return 514;
        case 0x3BE: return 515;
        case 0x3BF: return 516;
        case 0x3C0: return 517;
        case 0x3C1: return 518;
        case 0x3C3: return 519;
        case 0x3C4: return 520;
        case 0x3C5: return 521;
        case 0x3C6: return 522;
        case 0x3C7: return 523;
        case 0x3C8: return 524;
        case 0x3C9: return 525;
        case 0x401: return 570;
        case 0x410: return 564;
        case 0x411: return 565;
        case 0x412: return 566;
        case 0x413: return 567;
        case 0x414: return 568;
        case 0x415: return 569;
        case 0x416: return 571;
        case 0x417: return 572;
        case 0x418: return 573;
        case 0x419: return 574;
        case 0x41A: return 575;
        case 0x41B: return 576;
        case 0x41C: return 577;
        case 0x41D: return 578;
        case 0x41E: return 579;
        case 0x41F: return 580;
        case 0x420: return 581;
        case 0x421: return 582;
        case 0x422: return 583;
        case 0x423: return 584;
        case 0x424: return 585;
        case 0x425: return 586;
        case 0x426: return 587;
        case 0x427: return 588;
        case 0x428: return 589;
        case 0x429: return 590;
        case 0x42A: return 591;
        case 0x42B: return 592;
        case 0x42C: return 593;
        case 0x42D: return 594;
        case 0x42E: return 595;
        case 0x42F: return 596;
        case 0x430: return 612;
        case 0x431: return 613;
        case 0x432: return 614;
        case 0x433: return 615;
        case 0x434: return 616;
        case 0x435: return 617;
        case 0x436: return 619;
        case 0x437: return 620;
        case 0x438: return 621;
        case 0x439: return 622;
        case 0x43A: return 623;
        case 0x43B: return 624;
        case 0x43C: return 625;
        case 0x43D: return 626;
        case 0x43E: return 627;
        case 0x43F: return 628;
        case 0x440: return 629;
        case 0x441: return 630;
        case 0x442: return 631;
        case 0x443: return 632;
        case 0x444: return 633;
        case 0x445: return 634;
        case 0x446: return 635;
        case 0x447: return 636;
        case 0x448: return 637;
        case 0x449: return 638;
        case 0x44A: return 639;
        case 0x44B: return 640;
        case 0x44C: return 641;
        case 0x44D: return 642;
        case 0x44E: return 643;
        case 0x44F: return 644;
        case 0x451: return 618;
        case 0x2010: return 29;
        case 0x2015: return 28;
        case 0x2018: return 37;
        case 0x2019: return 38;
        case 0x201C: return 39;
        case 0x201D: return 40;
        case 0x2020: return 180;
        case 0x2021: return 181;
        case 0x2025: return 36;
        case 0x2026: return 35;
        case 0x2030: return 176;
        case 0x2032: return 75;
        case 0x2033: return 76;
        case 0x203B: return 101;
        case 0x2103: return 77;
        case 0x2116: return 1193;
        case 0x2121: return 1195;
        case 0x212B: return 175;
        case 0x2160: return 1148;
        case 0x2161: return 1149;
        case 0x2162: return 1150;
        case 0x2163: return 1151;
        case 0x2164: return 1152;
        case 0x2165: return 1153;
        case 0x2166: return 1154;
        case 0x2167: return 1155;
        case 0x2168: return 1156;
        case 0x2169: return 1157;
        case 0x2170: return 10716;
        case 0x2171: return 10717;
        case 0x2172: return 10718;
        case 0x2173: return 10719;
        case 0x2174: return 10720;
        case 0x2175: return 10721;
        case 0x2176: return 10722;
        case 0x2177: return 10723;
        case 0x2178: return 10724;
        case 0x2179: return 10725;
        case 0x2190: return 104;
        case 0x2191: return 105;
        case 0x2192: return 103;
        case 0x2193: return 106;
        case 0x21D2: return 138;
        case 0x21D4: return 139;
        case 0x2200: return 140;
        case 0x2202: return 156;
        case 0x2203: return 141;
        case 0x2207: return 157;
        case 0x2208: return 119;
        case 0x220B: return 120;
        case 0x2211: return 1211;
        case 0x221A: return 162;
        case 0x221D: return 164;
        case 0x221E: return 70;
        case 0x221F: return 1215;
        case 0x2220: return 153;
        case 0x2225: return 33;
        case 0x2227: return 135;
        case 0x2228: return 136;
        case 0x2229: return 126;
        case 0x222A: return 125;
        case 0x222B: return 166;
        case 0x222C: return 167;
        case 0x222E: return 1210;
        case 0x2234: return 71;
        case 0x2235: return 165;
        case 0x223D: return 163;
        case 0x2252: return 159;
        case 0x2260: return 65;
        case 0x2261: return 158;
        case 0x2266: return 68;
        case 0x2267: return 69;
        case 0x226A: return 160;
        case 0x226B: return 161;
        case 0x2282: return 123;
        case 0x2283: return 124;
        case 0x2286: return 121;
        case 0x2287: return 122;
        case 0x22A5: return 154;
        case 0x22BF: return 1216;
        case 0x2312: return 155;
        case 0x2460: return 1128;
        case 0x2461: return 1129;
        case 0x2462: return 1130;
        case 0x2463: return 1131;
        case 0x2464: return 1132;
        case 0x2465: return 1133;
        case 0x2466: return 1134;
        case 0x2467: return 1135;
        case 0x2468: return 1136;
        case 0x2469: return 1137;
        case 0x246A: return 1138;
        case 0x246B: return 1139;
        case 0x246C: return 1140;
        case 0x246D: return 1141;
        case 0x246E: return 1142;
        case 0x246F: return 1143;
        case 0x2470: return 1144;
        case 0x2471: return 1145;
        case 0x2472: return 1146;
        case 0x2473: return 1147;
        case 0x2500: return 658;
        case 0x2501: return 669;
        case 0x2502: return 659;
        case 0x2503: return 670;
        case 0x250C: return 660;
        case 0x250F: return 671;
        case 0x2510: return 661;
        case 0x2513: return 672;
        case 0x2514: return 663;
        case 0x2517: return 674;
        case 0x2518: return 662;
        case 0x251B: return 673;
        case 0x251C: return 664;
        case 0x251D: return 685;
        case 0x2520: return 680;
        case 0x2523: return 675;
        case 0x2524: return 666;
        case 0x2525: return 687;
        case 0x2528: return 682;
        case 0x252B: return 677;
        case 0x252C: return 665;
        case 0x252F: return 681;
        case 0x2530: return 686;
        case 0x2533: return 676;
        case 0x2534: return 667;
        case 0x2537: return 683;
        case 0x2538: return 688;
        case 0x253B: return 678;
        case 0x253C: return 668;
        case 0x253F: return 684;
        case 0x2542: return 689;
        case 0x254B: return 679;
        case 0x25A0: return 96;
        case 0x25A1: return 95;
        case 0x25B2: return 98;
        case 0x25B3: return 97;
        case 0x25BC: return 100;
        case 0x25BD: return 99;
        case 0x25C6: return 94;
        case 0x25C7: return 93;
        case 0x25CB: return 90;
        case 0x25CE: return 92;
        case 0x25CF: return 91;
        case 0x25EF: return 187;
        case 0x2605: return 89;
        case 0x2606: return 88;
        case 0x2640: return 73;
        case 0x2642: return 72;
        case 0x266A: return 179;
        case 0x266D: return 178;
        case 0x266F: return 177;
        case 0x3000: return 0;
        case 0x3001: return 1;
        case 0x3002: return 2;
        case 0x3003: return 22;
        case 0x3005: return 24;
        case 0x3006: return 25;
        case 0x3007: return 26;
        case 0x3008: return 49;
        case 0x3009: return 50;
        case 0x300A: return 51;
        case 0x300B: return 52;
        case 0x300C: return 53;
        case 0x300D: return 54;
        case 0x300E: return 55;
        case 0x300F: return 56;
        case 0x3010: return 57;
        case 0x3011: return 58;
        case 0x3012: return 102;
        case 0x3013: return 107;
        case 0x3014: return 43;
        case 0x3015: return 44;
        case 0x301D: return 1191;
        case 0x301F: return 1192;
        case 0x3041: return 282;
        case 0x3042: return 283;
        case 0x3043: return 284;
        case 0x3044: return 285;
        case 0x3045: return 286;
        case 0x3046: return 287;
        case 0x3047: return 288;
        case 0x3048: return 289;
        case 0x3049: return 290;
        case 0x304A: return 291;
        case 0x304B: return 292;
        case 0x304C: return 293;
        case 0x304D: return 294;
        case 0x304E: return 295;
        case 0x304F: return 296;
        case 0x3050: return 297;
        case 0x3051: return 298;
        case 0x3052: return 299;
        case 0x3053: return 300;
        case 0x3054: return 301;
        case 0x3055: return 302;
        case 0x3056: return 303;
        case 0x3057: return 304;
        case 0x3058: return 305;
        case 0x3059: return 306;
        case 0x305A: return 307;
        case 0x305B: return 308;
        case 0x305C: return 309;
        case 0x305D: return 310;
        case 0x305E: return 311;
        case 0x305F: return 312;
        case 0x3060: return 313;
        case 0x3061: return 314;
        case 0x3062: return 315;
        case 0x3063: return 316;
        case 0x3064: return 317;
        case 0x3065: return 318;
        case 0x3066: return 319;
        case 0x3067: return 320;
        case 0x3068: return 321;
        case 0x3069: return 322;
        case 0x306A: return 323;
        case 0x306B: return 324;
        case 0x306C: return 325;
        case 0x306D: return 326;
        case 0x306E: return 327;
        case 0x306F: return 328;
        case 0x3070: return 329;
        case 0x3071: return 330;
        case 0x3072: return 331;
        case 0x3073: return 332;
        case 0x3074: return 333;
        case 0x3075: return 334;
        case 0x3076: return 335;
        case 0x3077: return 336;
        case 0x3078: return 337;
        case 0x3079: return 338;
        case 0x307A: return 339;
        case 0x307B: return 340;
        case 0x307C: return 341;
        case 0x307D: return 342;
        case 0x307E: return 343;
        case 0x307F: return 344;
        case 0x3080: return 345;
        case 0x3081: return 346;
        case 0x3082: return 347;
        case 0x3083: return 348;
        case 0x3084: return 349;
        case 0x3085: return 350;
        case 0x3086: return 351;
        case 0x3087: return 352;
        case 0x3088: return 353;
        case 0x3089: return 354;
        case 0x308A: return 355;
        case 0x308B: return 356;
        case 0x308C: return 357;
        case 0x308D: return 358;
        case 0x308E: return 359;
        case 0x308F: return 360;
        case 0x3090: return 361;
        case 0x3091: return 362;
        case 0x3092: return 363;
        case 0x3093: return 364;
        case 0x309B: return 10;
        case 0x309C: return 11;
        case 0x309D: return 20;
        case 0x309E: return 21;
        case 0x30A1: return 376;
        case 0x30A2: return 377;
        case 0x30A3: return 378;
        case 0x30A4: return 379;
        case 0x30A5: return 380;
        case 0x30A6: return 381;
        case 0x30A7: return 382;
        case 0x30A8: return 383;
        case 0x30A9: return 384;
        case 0x30AA: return 385;
        case 0x30AB: return 386;
        case 0x30AC: return 387;
        case 0x30AD: return 388;
        case 0x30AE: return 389;
        case 0x30AF: return 390;
        case 0x30B0: return 391;
        case 0x30B1: return 392;
        case 0x30B2: return 393;
        case 0x30B3: return 394;
        case 0x30B4: return 395;
        case 0x30B5: return 396;
        case 0x30B6: return 397;
        case 0x30B7: return 398;
        case 0x30B8: return 399;
        case 0x30B9: return 400;
        case 0x30BA: return 401;
        case 0x30BB: return 402;
        case 0x30BC: return 403;
        case 0x30BD: return 404;
        case 0x30BE: return 405;
        case 0x30BF: return 406;
        case 0x30C0: return 407;
        case 0x30C1: return 408;
        case 0x30C2: return 409;
        case 0x30C3: return 410;
        case 0x30C4: return 411;
        case 0x30C5: return 412;
        case 0x30C6: return 413;
        case 0x30C7: return 414;
        case 0x30C8: return 415;
        case 0x30C9: return 416;
        case 0x30CA: return 417;
        case 0x30CB: return 418;
        case 0x30CC: return 419;
        case 0x30CD: return 420;
        case 0x30CE: return 421;
        case 0x30CF: return 422;
        case 0x30D0: return 423;
        case 0x30D1: return 424;
        case 0x30D2: return 425;
        case 0x30D3: return 426;
        case 0x30D4: return 427;
        case 0x30D5: return 428;
        case 0x30D6: return 429;
        case 0x30D7: return 430;
        case 0x30D8: return 431;
        case 0x30D9: return 432;
        case 0x30DA: return 433;
        case 0x30DB: return 434;
        case 0x30DC: return 435;
        case 0x30DD: return 436;
        case 0x30DE: return 437;
        case 0x30DF: return 438;
        case 0x30E0: return 439;
        case 0x30E1: return 440;
        case 0x30E2: return 441;
        case 0x30E3: return 442;
        case 0x30E4: return 443;
        case 0x30E5: return 444;
        case 0x30E6: return 445;
        case 0x30E7: return 446;
        case 0x30E8: return 447;
        case 0x30E9: return 448;
        case 0x30EA: return 449;
        case 0x30EB: return 450;
        case 0x30EC: return 451;
        case 0x30ED: return 452;
        case 0x30EE: return 453;
        case 0x30EF: return 454;
        case 0x30F0: return 455;
        case 0x30F1: return 456;
        case 0x30F2: return 457;
        case 0x30F3: return 458;
        case 0x30F4: return 459;
        case 0x30F5: return 460;
        case 0x30F6: return 461;
        case 0x30FB: return 5;
        case 0x30FC: return 27;
        case 0x30FD: return 18;
        case 0x30FE: return 19;
        case 0x3231: return 1201;
        case 0x3232: return 1202;
        case 0x3239: return 1203;
        case 0x32A4: return 1196;
        case 0x32A5: return 1197;
        case 0x32A6: return 1198;
        case 0x32A7: return 1199;
        case 0x32A8: return 1200;
        case 0x3303: return 1165;
        case 0x330D: return 1169;
        case 0x3314: return 1160;
        case 0x3318: return 1163;
        case 0x3322: return 1161;
        case 0x3323: return 1171;
        case 0x3326: return 1170;
        case 0x3327: return 1164;
        case 0x332B: return 1172;
        case 0x3336: return 1166;
        case 0x333B: return 1174;
        case 0x3349: return 1159;
        case 0x334A: return 1173;
        case 0x334D: return 1162;
        case 0x3351: return 1167;
        case 0x3357: return 1168;
        case 0x337B: return 1190;
        case 0x337C: return 1206;
        case 0x337D: return 1205;
        case 0x337E: return 1204;
        case 0x338E: return 1178;
        case 0x338F: return 1179;
        case 0x339C: return 1175;
        case 0x339D: return 1176;
        case 0x339E: return 1177;
        case 0x33A1: return 1181;
        case 0x33C4: return 1180;
        case 0x33CD: return 1194;
        case 0x4E00: return 1485;
        case 0x4E01: return 3285;
        case 0x4E03: return 2560;
        case 0x4E07: return 4039;
        case 0x4E08: return 2795;
        case 0x4E09: return 2459;
        case 0x4E0A: return 2794;
        case 0x4E0B: return 1625;
        case 0x4E0D: return 3811;
        case 0x4E0E: return 4166;
        case 0x4E10: return 4419;
        case 0x4E11: return 1518;
        case 0x4E14: return 1769;
        case 0x4E15: return 4420;
        case 0x4E16: return 2917;
        case 0x4E17: return 4639;
        case 0x4E18: return 1933;
        case 0x4E19: return 3879;
        case 0x4E1E: return 2796;
        case 0x4E21: return 4259;
        case 0x4E26: return 3887;
        case 0x4E28: return 10756;
        case 0x4E2A: return 4421;
        case 0x4E2D: return 3265;
        case 0x4E31: return 4422;
        case 0x4E32: return 2063;
        case 0x4E36: return 4423;
        case 0x4E38: return 1846;
        case 0x4E39: return 3211;
        case 0x4E3B: return 2608;
        case 0x4E3C: return 4424;
        case 0x4E3F: return 4425;
        case 0x4E42: return 4426;
        case 0x4E43: return 3592;
        case 0x4E45: return 1934;
        case 0x4E4B: return 3594;
        case 0x4E4D: return 3544;
        case 0x4E4E: return 2196;
        case 0x4E4F: return 3966;
        case 0x4E55: return 6808;
        case 0x4E56: return 4427;
        case 0x4E57: return 2797;
        case 0x4E58: return 4428;
        case 0x4E59: return 1618;
        case 0x4E5D: return 2042;
        case 0x4E5E: return 2241;
        case 0x4E5F: return 4114;
        case 0x4E62: return 4987;
        case 0x4E71: return 4215;
        case 0x4E73: return 3570;
        case 0x4E7E: return 1790;
        case 0x4E80: return 1900;
        case 0x4E82: return 4429;
        case 0x4E85: return 4430;
        case 0x4E86: return 4256;
        case 0x4E88: return 4164;
        case 0x4E89: return 3079;
        case 0x4E8A: return 4432;
        case 0x4E8B: return 2529;
        case 0x4E8C: return 3560;
        case 0x4E8E: return 4435;
        case 0x4E91: return 1533;
        case 0x4E92: return 2224;
        case 0x4E94: return 2223;
        case 0x4E95: return 1479;
        case 0x4E98: return 4366;
        case 0x4E99: return 4365;
        case 0x4E9B: return 2368;
        case 0x4E9C: return 1410;
        case 0x4E9E: return 4436;
        case 0x4E9F: return 4437;
        case 0x4EA0: return 4438;
        case 0x4EA1: return 3967;
        case 0x4EA2: return 4439;
        case 0x4EA4: return 2243;
        case 0x4EA5: return 1480;
        case 0x4EA6: return 4029;
        case 0x4EA8: return 1971;
        case 0x4EAB: return 1972;
        case 0x4EAC: return 1973;
        case 0x4EAD: return 3355;
        case 0x4EAE: return 4257;
        case 0x4EB0: return 4440;
        case 0x4EB3: return 4441;
        case 0x4EB6: return 4442;
        case 0x4EBA: return 2864;
        case 0x4EC0: return 2657;
        case 0x4EC1: return 2865;
        case 0x4EC2: return 4447;
        case 0x4EC4: return 4445;
        case 0x4EC6: return 4446;
        case 0x4EC7: return 1935;
        case 0x4ECA: return 2352;
        case 0x4ECB: return 1677;
        case 0x4ECD: return 4444;
        case 0x4ECE: return 4443;
        case 0x4ECF: return 3862;
        case 0x4ED4: return 2481;
        case 0x4ED5: return 2480;
        case 0x4ED6: return 3131;
        case 0x4ED7: return 4448;
        case 0x4ED8: return 3812;
        case 0x4ED9: return 2984;
        case 0x4EDD: return 23;
        case 0x4EDE: return 4449;
        case 0x4EDF: return 4451;
        case 0x4EE1: return 10757;
        case 0x4EE3: return 3170;
        case 0x4EE4: return 4294;
        case 0x4EE5: return 1451;
        case 0x4EED: return 4450;
        case 0x4EEE: return 1627;
        case 0x4EF0: return 2009;
        case 0x4EF2: return 3266;
        case 0x4EF6: return 2146;
        case 0x4EF7: return 4452;
        case 0x4EFB: return 3575;
        case 0x4EFC: return 10758;
        case 0x4F00: return 10759;
        case 0x4F01: return 1860;
        case 0x4F03: return 10760;
        case 0x4F09: return 4453;
        case 0x4F0A: return 1452;
        case 0x4F0D: return 2225;
        case 0x4F0E: return 1861;
        case 0x4F0F: return 3849;
        case 0x4F10: return 3683;
        case 0x4F11: return 1936;
        case 0x4F1A: return 1678;
        case 0x4F1C: return 4488;
        case 0x4F1D: return 3416;
        case 0x4F2F: return 3647;
        case 0x4F30: return 4455;
        case 0x4F34: return 3693;
        case 0x4F36: return 4295;
        case 0x4F38: return 2832;
        case 0x4F39: return 10761;
        case 0x4F3A: return 2482;
        case 0x4F3C: return 2530;
        case 0x4F3D: return 1629;
        case 0x4F43: return 3338;
        case 0x4F46: return 3197;
        case 0x4F47: return 4459;
        case 0x4F4D: return 1453;
        case 0x4F4E: return 3356;
        case 0x4F4F: return 2658;
        case 0x4F50: return 2369;
        case 0x4F51: return 4139;
        case 0x4F53: return 3147;
        case 0x4F55: return 1628;
        case 0x4F56: return 10762;
        case 0x4F57: return 4458;
        case 0x4F59: return 4165;
        case 0x4F5A: return 4454;
        case 0x4F5B: return 4456;
        case 0x4F5C: return 2427;
        case 0x4F5D: return 4457;
        case 0x4F5E: return 4891;
        case 0x4F69: return 4465;
        case 0x4F6F: return 4468;
        case 0x4F70: return 4466;
        case 0x4F73: return 1631;
        case 0x4F75: return 3880;
        case 0x4F76: return 4460;
        case 0x4F7B: return 4464;
        case 0x4F7C: return 2244;
        case 0x4F7F: return 2483;
        case 0x4F83: return 1791;
        case 0x4F86: return 4469;
        case 0x4F88: return 4461;
        case 0x4F8A: return 10764;
        case 0x4F8B: return 4296;
        case 0x4F8D: return 2531;
        case 0x4F8F: return 4462;
        case 0x4F91: return 4467;
        case 0x4F92: return 10763;
        case 0x4F94: return 10766;
        case 0x4F96: return 4470;
        case 0x4F98: return 4463;
        case 0x4F9A: return 10765;
        case 0x4F9B: return 1974;
        case 0x4F9D: return 1454;
        case 0x4FA0: return 1975;
        case 0x4FA1: return 1630;
        case 0x4FAB: return 4892;
        case 0x4FAD: return 4036;
        case 0x4FAE: return 3837;
        case 0x4FAF: return 2245;
        case 0x4FB5: return 2834;
        case 0x4FB6: return 4252;
        case 0x4FBF: return 3909;
        case 0x4FC2: return 2091;
        case 0x4FC3: return 3106;
        case 0x4FC4: return 1665;
        case 0x4FC9: return 10749;
        case 0x4FCA: return 2682;
        case 0x4FCD: return 10767;
        case 0x4FCE: return 4474;
        case 0x4FD0: return 4479;
        case 0x4FD1: return 4477;
        case 0x4FD4: return 4472;
        case 0x4FD7: return 3116;
        case 0x4FD8: return 4475;
        case 0x4FDA: return 4478;
        case 0x4FDB: return 4476;
        case 0x4FDD: return 3914;
        case 0x4FDF: return 4473;
        case 0x4FE1: return 2833;
        case 0x4FE3: return 4030;
        case 0x4FE4: return 4480;
        case 0x4FE5: return 4481;
        case 0x4FEE: return 2635;
        case 0x4FEF: return 4494;
        case 0x4FF3: return 3619;
        case 0x4FF5: return 3781;
        case 0x4FF6: return 4489;
        case 0x4FF8: return 3933;
        case 0x4FFA: return 1619;
        case 0x4FFE: return 4493;
        case 0x4FFF: return 10770;
        case 0x5005: return 4487;
        case 0x5006: return 4496;
        case 0x5009: return 3057;
        case 0x500B: return 2197;
        case 0x500D: return 3631;
        case 0x500F: return 5960;
        case 0x5011: return 4495;
        case 0x5012: return 3444;
        case 0x5014: return 4484;
        case 0x5016: return 2247;
        case 0x5019: return 2246;
        case 0x501A: return 4482;
        case 0x501E: return 10771;
        case 0x501F: return 2595;
        case 0x5021: return 4490;
        case 0x5022: return 10769;
        case 0x5023: return 3932;
        case 0x5024: return 3240;
        case 0x5025: return 4486;
        case 0x5026: return 2148;
        case 0x5028: return 4483;
        case 0x5029: return 4491;
        case 0x502A: return 4485;
        case 0x502B: return 4278;
        case 0x502C: return 4492;
        case 0x502D: return 4356;
        case 0x5036: return 2043;
        case 0x5039: return 2147;
        case 0x5040: return 10768;
        case 0x5042: return 10774;
        case 0x5043: return 4497;
        case 0x5046: return 10772;
        case 0x5047: return 4498;
        case 0x5048: return 4502;
        case 0x5049: return 1455;
        case 0x504F: return 3901;
        case 0x5050: return 4501;
        case 0x5055: return 4500;
        case 0x5056: return 4504;
        case 0x505A: return 4503;
        case 0x505C: return 3357;
        case 0x5065: return 2149;
        case 0x506C: return 4505;
        case 0x5070: return 10773;
        case 0x5072: return 2574;
        case 0x5074: return 3107;
        case 0x5075: return 3358;
        case 0x5076: return 2059;
        case 0x5078: return 4506;
        case 0x507D: return 1901;
        case 0x5080: return 4507;
        case 0x5085: return 4509;
        case 0x508D: return 3968;
        case 0x5091: return 2137;
        case 0x5094: return 10775;
        case 0x5098: return 2460;
        case 0x5099: return 3752;
        case 0x509A: return 4508;
        case 0x50AC: return 2386;
        case 0x50AD: return 4170;
        case 0x50B2: return 4511;
        case 0x50B3: return 4514;
        case 0x50B4: return 4510;
        case 0x50B5: return 2385;
        case 0x50B7: return 2724;
        case 0x50BE: return 2092;
        case 0x50C2: return 4515;
        case 0x50C5: return 2020;
        case 0x50C9: return 4512;
        case 0x50CA: return 4513;
        case 0x50CD: return 3492;
        case 0x50CF: return 3099;
        case 0x50D1: return 1976;
        case 0x50D5: return 3992;
        case 0x50D6: return 4516;
        case 0x50D8: return 10777;
        case 0x50DA: return 4258;
        case 0x50DE: return 4517;
        case 0x50E3: return 4520;
        case 0x50E5: return 4518;
        case 0x50E7: return 3053;
        case 0x50ED: return 4519;
        case 0x50EE: return 4521;
        case 0x50F4: return 10776;
        case 0x50F5: return 4523;
        case 0x50F9: return 4522;
        case 0x50FB: return 3893;
        case 0x5100: return 1902;
        case 0x5101: return 4525;
        case 0x5102: return 4526;
        case 0x5104: return 1612;
        case 0x5109: return 4524;
        case 0x5112: return 2621;
        case 0x5114: return 4529;
        case 0x5115: return 4528;
        case 0x5116: return 4527;
        case 0x5118: return 4471;
        case 0x511A: return 4530;
        case 0x511F: return 2725;
        case 0x5121: return 4531;
        case 0x512A: return 4140;
        case 0x5132: return 4098;
        case 0x5137: return 4533;
        case 0x513A: return 4532;
        case 0x513B: return 4535;
        case 0x513C: return 4534;
        case 0x513F: return 4536;
        case 0x5140: return 4537;
        case 0x5141: return 1493;
        case 0x5143: return 2182;
        case 0x5144: return 2094;
        case 0x5145: return 2659;
        case 0x5146: return 3286;
        case 0x5147: return 1977;
        case 0x5148: return 2985;
        case 0x5149: return 2248;
        case 0x514A: return 10778;
        case 0x514B: return 2333;
        case 0x514C: return 4539;
        case 0x514D: return 4081;
        case 0x514E: return 3421;
        case 0x5150: return 2532;
        case 0x5152: return 4538;
        case 0x5154: return 4540;
        case 0x515A: return 3445;
        case 0x515C: return 1776;
        case 0x5162: return 4541;
        case 0x5164: return 10779;
        case 0x5165: return 3571;
        case 0x5168: return 3027;
        case 0x5169: return 4543;
        case 0x516A: return 4544;
        case 0x516B: return 3677;
        case 0x516C: return 2249;
        case 0x516D: return 4350;
        case 0x516E: return 4545;
        case 0x5171: return 1979;
        case 0x5175: return 3881;
        case 0x5176: return 3123;
        case 0x5177: return 2054;
        case 0x5178: return 3404;
        case 0x517C: return 2150;
        case 0x5180: return 4546;
        case 0x5182: return 4547;
        case 0x5185: return 3543;
        case 0x5186: return 1566;
        case 0x5189: return 4550;
        case 0x518A: return 2442;
        case 0x518C: return 4549;
        case 0x518D: return 2387;
        case 0x518F: return 4551;
        case 0x5190: return 6563;
        case 0x5191: return 4552;
        case 0x5192: return 3980;
        case 0x5193: return 4553;
        case 0x5195: return 4554;
        case 0x5196: return 4555;
        case 0x5197: return 2798;
        case 0x5199: return 2581;
        case 0x519D: return 10780;
        case 0x51A0: return 1792;
        case 0x51A2: return 4558;
        case 0x51A4: return 4556;
        case 0x51A5: return 4070;
        case 0x51A6: return 4557;
        case 0x51A8: return 3817;
        case 0x51A9: return 4559;
        case 0x51AA: return 4560;
        case 0x51AB: return 4561;
        case 0x51AC: return 3446;
        case 0x51B0: return 4565;
        case 0x51B1: return 4563;
        case 0x51B2: return 4564;
        case 0x51B3: return 4562;
        case 0x51B4: return 2416;
        case 0x51B5: return 4566;
        case 0x51B6: return 4115;
        case 0x51B7: return 4297;
        case 0x51BD: return 4567;
        case 0x51BE: return 10781;
        case 0x51C4: return 2921;
        case 0x51C5: return 4568;
        case 0x51C6: return 2689;
        case 0x51C9: return 4569;
        case 0x51CB: return 3287;
        case 0x51CC: return 4260;
        case 0x51CD: return 3447;
        case 0x51D6: return 4642;
        case 0x51DB: return 4570;
        case 0x51DC: return 7806;
        case 0x51DD: return 2010;
        case 0x51E0: return 4571;
        case 0x51E1: return 4009;
        case 0x51E6: return 2703;
        case 0x51E7: return 3193;
        case 0x51E9: return 4573;
        case 0x51EA: return 3545;
        case 0x51EC: return 10782;
        case 0x51ED: return 4574;
        case 0x51F0: return 4575;
        case 0x51F1: return 1705;
        case 0x51F5: return 4576;
        case 0x51F6: return 1980;
        case 0x51F8: return 3521;
        case 0x51F9: return 1593;
        case 0x51FA: return 2679;
        case 0x51FD: return 3666;
        case 0x51FE: return 4577;
        case 0x5200: return 3448;
        case 0x5203: return 2866;
        case 0x5204: return 4578;
        case 0x5206: return 3865;
        case 0x5207: return 2971;
        case 0x5208: return 1787;
        case 0x520A: return 1794;
        case 0x520B: return 4579;
        case 0x520E: return 4581;
        case 0x5211: return 2093;
        case 0x5214: return 4580;
        case 0x5215: return 10783;
        case 0x5217: return 4312;
        case 0x521D: return 2704;
        case 0x5224: return 3694;
        case 0x5225: return 3897;
        case 0x5227: return 4582;
        case 0x5229: return 4223;
        case 0x522A: return 4583;
        case 0x522E: return 4584;
        case 0x5230: return 3477;
        case 0x5233: return 4585;
        case 0x5236: return 2922;
        case 0x5237: return 2443;
        case 0x5238: return 2151;
        case 0x5239: return 4586;
        case 0x523A: return 2484;
        case 0x523B: return 2334;
        case 0x5243: return 3359;
        case 0x5244: return 4588;
        case 0x5247: return 3108;
        case 0x524A: return 2428;
        case 0x524B: return 4589;
        case 0x524C: return 4590;
        case 0x524D: return 3023;
        case 0x524F: return 4587;
        case 0x5254: return 4592;
        case 0x5256: return 3969;
        case 0x525B: return 2323;
        case 0x525E: return 4591;
        case 0x5263: return 2152;
        case 0x5264: return 2411;
        case 0x5265: return 3648;
        case 0x5269: return 4595;
        case 0x526A: return 4593;
        case 0x526F: return 3850;
        case 0x5270: return 2799;
        case 0x5271: return 4602;
        case 0x5272: return 1759;
        case 0x5273: return 4596;
        case 0x5274: return 4594;
        case 0x5275: return 3054;
        case 0x527D: return 4598;
        case 0x527F: return 4597;
        case 0x5283: return 1727;
        case 0x5287: return 2131;
        case 0x5288: return 4603;
        case 0x5289: return 4242;
        case 0x528D: return 4599;
        case 0x5291: return 4604;
        case 0x5292: return 4601;
        case 0x5294: return 4600;
        case 0x529B: return 4276;
        case 0x529C: return 10784;
        case 0x529F: return 2250;
        case 0x52A0: return 1632;
        case 0x52A3: return 4313;
        case 0x52A6: return 10785;
        case 0x52A9: return 2716;
        case 0x52AA: return 3439;
        case 0x52AB: return 2324;
        case 0x52AC: return 4607;
        case 0x52AD: return 4608;
        case 0x52AF: return 10959;
        case 0x52B1: return 4298;
        case 0x52B4: return 4334;
        case 0x52B5: return 4610;
        case 0x52B9: return 2251;
        case 0x52BC: return 4609;
        case 0x52BE: return 1706;
        case 0x52C0: return 10786;
        case 0x52C1: return 4611;
        case 0x52C3: return 4001;
        case 0x52C5: return 3317;
        case 0x52C7: return 4141;
        case 0x52C9: return 3910;
        case 0x52CD: return 4612;
        case 0x52D2: return 7478;
        case 0x52D5: return 3493;
        case 0x52D7: return 4613;
        case 0x52D8: return 1795;
        case 0x52D9: return 4060;
        case 0x52DB: return 10787;
        case 0x52DD: return 2726;
        case 0x52DE: return 4614;
        case 0x52DF: return 3924;
        case 0x52E0: return 4618;
        case 0x52E2: return 2923;
        case 0x52E3: return 4615;
        case 0x52E4: return 2021;
        case 0x52E6: return 4616;
        case 0x52E7: return 1796;
        case 0x52F2: return 2081;
        case 0x52F3: return 4619;
        case 0x52F5: return 4620;
        case 0x52F8: return 4621;
        case 0x52F9: return 4622;
        case 0x52FA: return 2596;
        case 0x52FE: return 2252;
        case 0x52FF: return 4103;
        case 0x5300: return 10788;
        case 0x5301: return 4113;
        case 0x5302: return 3564;
        case 0x5305: return 3934;
        case 0x5306: return 4623;
        case 0x5307: return 10789;
        case 0x5308: return 4624;
        case 0x530D: return 4626;
        case 0x530F: return 4628;
        case 0x5310: return 4627;
        case 0x5315: return 4629;
        case 0x5316: return 1626;
        case 0x5317: return 3991;
        case 0x5319: return 2441;
        case 0x531A: return 4630;
        case 0x531D: return 3064;
        case 0x5320: return 2727;
        case 0x5321: return 1982;
        case 0x5323: return 4631;
        case 0x5324: return 10790;
        case 0x532A: return 3724;
        case 0x532F: return 4632;
        case 0x5331: return 4633;
        case 0x5333: return 4634;
        case 0x5338: return 4635;
        case 0x5339: return 3763;
        case 0x533A: return 2045;
        case 0x533B: return 1478;
        case 0x533F: return 3508;
        case 0x5340: return 4636;
        case 0x5341: return 2660;
        case 0x5343: return 2986;
        case 0x5345: return 4638;
        case 0x5346: return 4637;
        case 0x5347: return 2728;
        case 0x5348: return 2226;
        case 0x5349: return 4640;
        case 0x534A: return 3695;
        case 0x534D: return 4641;
        case 0x5351: return 3725;
        case 0x5352: return 3121;
        case 0x5353: return 3179;
        case 0x5354: return 1981;
        case 0x5357: return 3555;
        case 0x5358: return 3212;
        case 0x535A: return 3649;
        case 0x535C: return 3993;
        case 0x535E: return 4643;
        case 0x5360: return 2987;
        case 0x5366: return 2088;
        case 0x5369: return 4644;
        case 0x536E: return 4645;
        case 0x536F: return 1515;
        case 0x5370: return 1494;
        case 0x5371: return 1862;
        case 0x5372: return 10791;
        case 0x5373: return 3109;
        case 0x5374: return 1928;
        case 0x5375: return 4216;
        case 0x5377: return 4648;
        case 0x5378: return 1620;
        case 0x537B: return 4647;
        case 0x537F: return 1983;
        case 0x5382: return 4649;
        case 0x5384: return 4122;
        case 0x5393: return 10792;
        case 0x5396: return 4650;
        case 0x5398: return 4279;
        case 0x539A: return 2253;
        case 0x539F: return 2183;
        case 0x53A0: return 4651;
        case 0x53A5: return 4653;
        case 0x53A6: return 4652;
        case 0x53A8: return 2882;
        case 0x53A9: return 1528;
        case 0x53AD: return 1565;
        case 0x53AE: return 4654;
        case 0x53B0: return 4655;
        case 0x53B2: return 10793;
        case 0x53B3: return 2184;
        case 0x53B6: return 4656;
        case 0x53BB: return 1957;
        case 0x53C2: return 2461;
        case 0x53C3: return 4657;
        case 0x53C8: return 4031;
        case 0x53C9: return 2370;
        case 0x53CA: return 1937;
        case 0x53CB: return 4142;
        case 0x53CC: return 3055;
        case 0x53CD: return 3696;
        case 0x53CE: return 2630;
        case 0x53D4: return 2670;
        case 0x53D6: return 2609;
        case 0x53D7: return 2622;
        case 0x53D9: return 2717;
        case 0x53DB: return 3697;
        case 0x53DD: return 10794;
        case 0x53DF: return 4660;
        case 0x53E1: return 1538;
        case 0x53E2: return 3056;
        case 0x53E3: return 2254;
        case 0x53E4: return 2198;
        case 0x53E5: return 2044;
        case 0x53E8: return 4664;
        case 0x53E9: return 3196;
        case 0x53EA: return 3195;
        case 0x53EB: return 1984;
        case 0x53EC: return 2729;
        case 0x53ED: return 4665;
        case 0x53EE: return 4663;
        case 0x53EF: return 1633;
        case 0x53F0: return 3171;
        case 0x53F1: return 2561;
        case 0x53F2: return 2486;
        case 0x53F3: return 1509;
        case 0x53F6: return 1771;
        case 0x53F7: return 2325;
        case 0x53F8: return 2485;
        case 0x53FA: return 4666;
        case 0x5401: return 4667;
        case 0x5403: return 1920;
        case 0x5404: return 1729;
        case 0x5408: return 2326;
        case 0x5409: return 1919;
        case 0x540A: return 3352;
        case 0x540B: return 1508;
        case 0x540C: return 3494;
        case 0x540D: return 4071;
        case 0x540E: return 2256;
        case 0x540F: return 4224;
        case 0x5410: return 3422;
        case 0x5411: return 2255;
        case 0x541B: return 2082;
        case 0x541D: return 4676;
        case 0x541F: return 2040;
        case 0x5420: return 3989;
        case 0x5426: return 3726;
        case 0x5429: return 4675;
        case 0x542B: return 1847;
        case 0x542C: return 4670;
        case 0x542D: return 4671;
        case 0x542E: return 4673;
        case 0x5436: return 4674;
        case 0x5438: return 1938;
        case 0x5439: return 2884;
        case 0x543B: return 3866;
        case 0x543C: return 4672;
        case 0x543D: return 4668;
        case 0x543E: return 2228;
        case 0x5440: return 4669;
        case 0x5442: return 4327;
        case 0x5446: return 3935;
        case 0x5448: return 3361;
        case 0x5449: return 2227;
        case 0x544A: return 2335;
        case 0x544E: return 4677;
        case 0x5451: return 3538;
        case 0x545F: return 4681;
        case 0x5468: return 2631;
        case 0x546A: return 2623;
        case 0x5470: return 4684;
        case 0x5471: return 4682;
        case 0x5473: return 4044;
        case 0x5475: return 4679;
        case 0x5476: return 4688;
        case 0x5477: return 4683;
        case 0x547B: return 4686;
        case 0x547C: return 2199;
        case 0x547D: return 4072;
        case 0x5480: return 4687;
        case 0x5484: return 4689;
        case 0x5486: return 4691;
        case 0x548A: return 10797;
        case 0x548B: return 2429;
        case 0x548C: return 4357;
        case 0x548E: return 4680;
        case 0x548F: return 4678;
        case 0x5490: return 4690;
        case 0x5492: return 4685;
        case 0x549C: return 10796;
        case 0x54A2: return 4693;
        case 0x54A4: return 4702;
        case 0x54A5: return 4695;
        case 0x54A8: return 4699;
        case 0x54A9: return 10798;
        case 0x54AB: return 4700;
        case 0x54AC: return 4696;
        case 0x54AF: return 4729;
        case 0x54B2: return 2422;
        case 0x54B3: return 1708;
        case 0x54B8: return 4694;
        case 0x54BC: return 4704;
        case 0x54BD: return 1495;
        case 0x54BE: return 4703;
        case 0x54C0: return 1414;
        case 0x54C1: return 3801;
        case 0x54C2: return 4701;
        case 0x54C4: return 4697;
        case 0x54C7: return 4692;
        case 0x54C8: return 4698;
        case 0x54C9: return 2389;
        case 0x54D8: return 4705;
        case 0x54E1: return 1496;
        case 0x54E2: return 4714;
        case 0x54E5: return 4706;
        case 0x54E6: return 4707;
        case 0x54E8: return 2730;
        case 0x54E9: return 4020;
        case 0x54ED: return 4712;
        case 0x54EE: return 4711;
        case 0x54F2: return 3398;
        case 0x54FA: return 4713;
        case 0x54FD: return 4710;
        case 0x54FF: return 10799;
        case 0x5504: return 1523;
        case 0x5506: return 2371;
        case 0x5507: return 2835;
        case 0x550F: return 4708;
        case 0x5510: return 3449;
        case 0x5514: return 4709;
        case 0x5516: return 1411;
        case 0x552E: return 4719;
        case 0x552F: return 4138;
        case 0x5531: return 2732;
        case 0x5533: return 4725;
        case 0x5538: return 4724;
        case 0x5539: return 4715;
        case 0x553E: return 3136;
        case 0x5540: return 4716;
        case 0x5544: return 3180;
        case 0x5545: return 4721;
        case 0x5546: return 2731;
        case 0x554C: return 4718;
        case 0x554F: return 4109;
        case 0x5553: return 2095;
        case 0x5556: return 4722;
        case 0x5557: return 4723;
        case 0x555C: return 4720;
        case 0x555D: return 4726;
        case 0x5563: return 4717;
        case 0x557B: return 4732;
        case 0x557C: return 4737;
        case 0x557E: return 4733;
        case 0x5580: return 4728;
        case 0x5583: return 4738;
        case 0x5584: return 3024;
        case 0x5586: return 10800;
        case 0x5587: return 4740;
        case 0x5589: return 2257;
        case 0x558A: return 4730;
        case 0x558B: return 3288;
        case 0x5598: return 4734;
        case 0x5599: return 4727;
        case 0x559A: return 1798;
        case 0x559C: return 1863;
        case 0x559D: return 1760;
        case 0x559E: return 4735;
        case 0x559F: return 4731;
        case 0x55A7: return 2153;
        case 0x55A8: return 4741;
        case 0x55A9: return 4739;
        case 0x55AA: return 3058;
        case 0x55AB: return 1921;
        case 0x55AC: return 1985;
        case 0x55AE: return 4736;
        case 0x55B0: return 2057;
        case 0x55B6: return 1539;
        case 0x55C4: return 4745;
        case 0x55C5: return 4743;
        case 0x55C7: return 4800;
        case 0x55D4: return 4748;
        case 0x55DA: return 4742;
        case 0x55DC: return 4746;
        case 0x55DF: return 4744;
        case 0x55E3: return 2487;
        case 0x55E4: return 4747;
        case 0x55F7: return 4750;
        case 0x55F9: return 4755;
        case 0x55FD: return 4753;
        case 0x55FE: return 4752;
        case 0x5606: return 3213;
        case 0x5609: return 1634;
        case 0x5614: return 4749;
        case 0x5616: return 4751;
        case 0x5617: return 2733;
        case 0x5618: return 1522;
        case 0x561B: return 4754;
        case 0x5629: return 1659;
        case 0x562F: return 4765;
        case 0x5631: return 2817;
        case 0x5632: return 4761;
        case 0x5634: return 4759;
        case 0x5636: return 4760;
        case 0x5638: return 4762;
        case 0x5642: return 1532;
        case 0x564C: return 3032;
        case 0x564E: return 4756;
        case 0x5650: return 4757;
        case 0x565B: return 1781;
        case 0x5664: return 4764;
        case 0x5668: return 1864;
        case 0x566A: return 4767;
        case 0x566B: return 4763;
        case 0x566C: return 4766;
        case 0x5674: return 3867;
        case 0x5678: return 3530;
        case 0x567A: return 3689;
        case 0x5680: return 4769;
        case 0x5686: return 4768;
        case 0x5687: return 1728;
        case 0x568A: return 4770;
        case 0x568F: return 4773;
        case 0x5694: return 4772;
        case 0x56A0: return 4771;
        case 0x56A2: return 3596;
        case 0x56A5: return 4774;
        case 0x56AE: return 4775;
        case 0x56B4: return 4777;
        case 0x56B6: return 4776;
        case 0x56BC: return 4779;
        case 0x56C0: return 4782;
        case 0x56C1: return 4780;
        case 0x56C2: return 4778;
        case 0x56C3: return 4781;
        case 0x56C8: return 4783;
        case 0x56CE: return 4784;
        case 0x56D1: return 4785;
        case 0x56D3: return 4786;
        case 0x56D7: return 4787;
        case 0x56D8: return 4548;
        case 0x56DA: return 2629;
        case 0x56DB: return 2488;
        case 0x56DE: return 1680;
        case 0x56E0: return 1497;
        case 0x56E3: return 3231;
        case 0x56EE: return 4788;
        case 0x56F0: return 2353;
        case 0x56F2: return 1456;
        case 0x56F3: return 2881;
        case 0x56F9: return 4789;
        case 0x56FA: return 2200;
        case 0x56FD: return 2336;
        case 0x56FF: return 4791;
        case 0x5700: return 4790;
        case 0x5703: return 3917;
        case 0x5704: return 4792;
        case 0x5708: return 4794;
        case 0x5709: return 4793;
        case 0x570B: return 4795;
        case 0x570D: return 4796;
        case 0x570F: return 2154;
        case 0x5712: return 1567;
        case 0x5713: return 4797;
        case 0x5716: return 4799;
        case 0x5718: return 4798;
        case 0x571C: return 4801;
        case 0x571F: return 3441;
        case 0x5726: return 4802;
        case 0x5727: return 1430;
        case 0x5728: return 2412;
        case 0x572D: return 2096;
        case 0x5730: return 3242;
        case 0x5737: return 4803;
        case 0x5738: return 4804;
        case 0x573B: return 4806;
        case 0x5740: return 4807;
        case 0x5742: return 2417;
        case 0x5747: return 2022;
        case 0x574A: return 3970;
        case 0x574E: return 4805;
        case 0x574F: return 4808;
        case 0x5750: return 2382;
        case 0x5751: return 2258;
        case 0x5759: return 10801;
        case 0x5761: return 4812;
        case 0x5764: return 2354;
        case 0x5765: return 10802;
        case 0x5766: return 3214;
        case 0x5769: return 4809;
        case 0x576A: return 3347;
        case 0x577F: return 4813;
        case 0x5782: return 2885;
        case 0x5788: return 4811;
        case 0x5789: return 4814;
        case 0x578B: return 2098;
        case 0x5793: return 4815;
        case 0x57A0: return 4816;
        case 0x57A2: return 2259;
        case 0x57A3: return 1723;
        case 0x57A4: return 4818;
        case 0x57AA: return 4819;
        case 0x57AC: return 10803;
        case 0x57B0: return 4820;
        case 0x57B3: return 4817;
        case 0x57C0: return 4810;
        case 0x57C3: return 4821;
        case 0x57C6: return 4822;
        case 0x57C7: return 10805;
        case 0x57C8: return 10804;
        case 0x57CB: return 4015;
        case 0x57CE: return 2800;
        case 0x57D2: return 4824;
        case 0x57D3: return 4825;
        case 0x57D4: return 4823;
        case 0x57D6: return 4827;
        case 0x57DC: return 3595;
        case 0x57DF: return 1481;
        case 0x57E0: return 3813;
        case 0x57E3: return 4828;
        case 0x57F4: return 2818;
        case 0x57F7: return 2562;
        case 0x57F9: return 3632;
        case 0x57FA: return 1865;
        case 0x57FC: return 2424;
        case 0x5800: return 4004;
        case 0x5802: return 3495;
        case 0x5805: return 2155;
        case 0x5806: return 3148;
        case 0x580A: return 4826;
        case 0x580B: return 4829;
        case 0x5815: return 3137;
        case 0x5819: return 4830;
        case 0x581D: return 4831;
        case 0x5821: return 4833;
        case 0x5824: return 3362;
        case 0x582A: return 1799;
        case 0x582F: return 7802;
        case 0x5830: return 1568;
        case 0x5831: return 3936;
        case 0x5834: return 2801;
        case 0x5835: return 3423;
        case 0x583A: return 2419;
        case 0x583D: return 4839;
        case 0x5840: return 3882;
        case 0x5841: return 4290;
        case 0x584A: return 1681;
        case 0x584B: return 4835;
        case 0x5851: return 3033;
        case 0x5852: return 4838;
        case 0x5854: return 3450;
        case 0x5857: return 3424;
        case 0x5858: return 3451;
        case 0x5859: return 3690;
        case 0x585A: return 3334;
        case 0x585E: return 2390;
        case 0x5862: return 4834;
        case 0x5869: return 1589;
        case 0x586B: return 3405;
        case 0x5870: return 4836;
        case 0x5872: return 4832;
        case 0x5875: return 2867;
        case 0x5879: return 4840;
        case 0x587E: return 2677;
        case 0x5883: return 1986;
        case 0x5885: return 4841;
        case 0x5893: return 3925;
        case 0x5897: return 3100;
        case 0x589C: return 3327;
        case 0x589E: return 10808;
        case 0x589F: return 4843;
        case 0x58A8: return 3994;
        case 0x58AB: return 4844;
        case 0x58AE: return 4849;
        case 0x58B2: return 10809;
        case 0x58B3: return 3868;
        case 0x58B8: return 4848;
        case 0x58B9: return 4842;
        case 0x58BA: return 4845;
        case 0x58BB: return 4847;
        case 0x58BE: return 2355;
        case 0x58C1: return 3894;
        case 0x58C5: return 4850;
        case 0x58C7: return 3232;
        case 0x58CA: return 1682;
        case 0x58CC: return 2802;
        case 0x58D1: return 4852;
        case 0x58D3: return 4851;
        case 0x58D5: return 2327;
        case 0x58D7: return 4853;
        case 0x58D8: return 4855;
        case 0x58D9: return 4854;
        case 0x58DC: return 4857;
        case 0x58DE: return 4846;
        case 0x58DF: return 4859;
        case 0x58E4: return 4858;
        case 0x58E5: return 4856;
        case 0x58EB: return 2489;
        case 0x58EC: return 2868;
        case 0x58EE: return 3059;
        case 0x58EF: return 4860;
        case 0x58F0: return 2941;
        case 0x58F1: return 1486;
        case 0x58F2: return 3639;
        case 0x58F7: return 3348;
        case 0x58F9: return 4862;
        case 0x58FA: return 4861;
        case 0x58FB: return 4863;
        case 0x58FC: return 4864;
        case 0x58FD: return 4865;
        case 0x5902: return 4866;
        case 0x5909: return 3902;
        case 0x590A: return 4867;
        case 0x590B: return 10810;
        case 0x590F: return 1635;
        case 0x5910: return 4868;
        case 0x5915: return 4163;
        case 0x5916: return 1707;
        case 0x5918: return 4646;
        case 0x5919: return 2671;
        case 0x591A: return 3132;
        case 0x591B: return 4869;
        case 0x591C: return 4116;
        case 0x5922: return 4061;
        case 0x5925: return 4871;
        case 0x5927: return 3172;
        case 0x5929: return 3406;
        case 0x592A: return 3133;
        case 0x592B: return 3814;
        case 0x592C: return 4872;
        case 0x592D: return 4873;
        case 0x592E: return 1594;
        case 0x5931: return 2563;
        case 0x5932: return 4874;
        case 0x5937: return 1457;
        case 0x5938: return 4875;
        case 0x593E: return 4876;
        case 0x5944: return 1569;
        case 0x5947: return 1866;
        case 0x5948: return 3541;
        case 0x5949: return 3937;
        case 0x594E: return 4880;
        case 0x594F: return 3060;
        case 0x5950: return 4879;
        case 0x5951: return 2099;
        case 0x5953: return 10811;
        case 0x5954: return 4006;
        case 0x5955: return 4878;
        case 0x5957: return 3452;
        case 0x5958: return 4882;
        case 0x595A: return 4881;
        case 0x595B: return 10812;
        case 0x595D: return 10813;
        case 0x5960: return 4884;
        case 0x5962: return 4883;
        case 0x5963: return 10814;
        case 0x5965: return 1595;
        case 0x5967: return 4885;
        case 0x5968: return 2734;
        case 0x5969: return 4887;
        case 0x596A: return 3200;
        case 0x596C: return 4886;
        case 0x596E: return 3872;
        case 0x5973: return 2718;
        case 0x5974: return 3442;
        case 0x5978: return 4888;
        case 0x597D: return 2260;
        case 0x5981: return 4889;
        case 0x5982: return 3572;
        case 0x5983: return 3727;
        case 0x5984: return 4090;
        case 0x598A: return 3576;
        case 0x598D: return 4898;
        case 0x5993: return 1903;
        case 0x5996: return 4172;
        case 0x5999: return 4056;
        case 0x599B: return 4993;
        case 0x599D: return 4890;
        case 0x59A3: return 4893;
        case 0x59A4: return 10815;
        case 0x59A5: return 3138;
        case 0x59A8: return 3971;
        case 0x59AC: return 3425;
        case 0x59B2: return 4894;
        case 0x59B9: return 4016;
        case 0x59BA: return 10816;
        case 0x59BB: return 2391;
        case 0x59BE: return 2735;
        case 0x59C6: return 4895;
        case 0x59C9: return 2491;
        case 0x59CB: return 2490;
        case 0x59D0: return 1434;
        case 0x59D1: return 2201;
        case 0x59D3: return 2924;
        case 0x59D4: return 1458;
        case 0x59D9: return 4899;
        case 0x59DA: return 4900;
        case 0x59DC: return 4897;
        case 0x59E5: return 1527;
        case 0x59E6: return 1800;
        case 0x59E8: return 4896;
        case 0x59EA: return 4078;
        case 0x59EB: return 3776;
        case 0x59F6: return 1417;
        case 0x59FB: return 1498;
        case 0x59FF: return 2492;
        case 0x5A01: return 1459;
        case 0x5A03: return 1412;
        case 0x5A09: return 4905;
        case 0x5A11: return 4903;
        case 0x5A18: return 4069;
        case 0x5A1A: return 4906;
        case 0x5A1C: return 4904;
        case 0x5A1F: return 4902;
        case 0x5A20: return 2836;
        case 0x5A25: return 4901;
        case 0x5A29: return 3911;
        case 0x5A2F: return 2229;
        case 0x5A35: return 4910;
        case 0x5A36: return 4911;
        case 0x5A3C: return 2736;
        case 0x5A40: return 4907;
        case 0x5A41: return 4335;
        case 0x5A46: return 3615;
        case 0x5A49: return 4909;
        case 0x5A5A: return 2356;
        case 0x5A62: return 4912;
        case 0x5A66: return 3815;
        case 0x5A6A: return 4913;
        case 0x5A6C: return 4908;
        case 0x5A7F: return 4068;
        case 0x5A92: return 3633;
        case 0x5A9A: return 4914;
        case 0x5A9B: return 3777;
        case 0x5ABC: return 4915;
        case 0x5ABD: return 4919;
        case 0x5ABE: return 4916;
        case 0x5AC1: return 1636;
        case 0x5AC2: return 4918;
        case 0x5AC9: return 2564;
        case 0x5ACB: return 4917;
        case 0x5ACC: return 2156;
        case 0x5AD0: return 4931;
        case 0x5AD6: return 4924;
        case 0x5AD7: return 4921;
        case 0x5AE1: return 3263;
        case 0x5AE3: return 4920;
        case 0x5AE6: return 4922;
        case 0x5AE9: return 4923;
        case 0x5AFA: return 4925;
        case 0x5AFB: return 4926;
        case 0x5B09: return 1867;
        case 0x5B0B: return 4928;
        case 0x5B0C: return 4927;
        case 0x5B16: return 4929;
        case 0x5B22: return 2803;
        case 0x5B2A: return 4932;
        case 0x5B2C: return 3349;
        case 0x5B30: return 1540;
        case 0x5B32: return 4930;
        case 0x5B36: return 4933;
        case 0x5B3E: return 4934;
        case 0x5B40: return 4937;
        case 0x5B43: return 4935;
        case 0x5B45: return 4936;
        case 0x5B50: return 2493;
        case 0x5B51: return 4938;
        case 0x5B54: return 2261;
        case 0x5B55: return 4939;
        case 0x5B56: return 10817;
        case 0x5B57: return 2533;
        case 0x5B58: return 3125;
        case 0x5B5A: return 4940;
        case 0x5B5B: return 4941;
        case 0x5B5C: return 2501;
        case 0x5B5D: return 2262;
        case 0x5B5F: return 4091;
        case 0x5B63: return 1887;
        case 0x5B64: return 2202;
        case 0x5B65: return 4942;
        case 0x5B66: return 1747;
        case 0x5B69: return 4943;
        case 0x5B6B: return 3126;
        case 0x5B70: return 4944;
        case 0x5B71: return 4984;
        case 0x5B73: return 4945;
        case 0x5B75: return 4946;
        case 0x5B78: return 4947;
        case 0x5B7A: return 4949;
        case 0x5B80: return 4950;
        case 0x5B83: return 4951;
        case 0x5B85: return 3181;
        case 0x5B87: return 1510;
        case 0x5B88: return 2610;
        case 0x5B89: return 1443;
        case 0x5B8B: return 3062;
        case 0x5B8C: return 1801;
        case 0x5B8D: return 2558;
        case 0x5B8F: return 2263;
        case 0x5B95: return 3453;
        case 0x5B97: return 2632;
        case 0x5B98: return 1802;
        case 0x5B99: return 3267;
        case 0x5B9A: return 3363;
        case 0x5B9B: return 1433;
        case 0x5B9C: return 1904;
        case 0x5B9D: return 3938;
        case 0x5B9F: return 2571;
        case 0x5BA2: return 1929;
        case 0x5BA3: return 2988;
        case 0x5BA4: return 2565;
        case 0x5BA5: return 4143;
        case 0x5BA6: return 4952;
        case 0x5BAE: return 1939;
        case 0x5BB0: return 2392;
        case 0x5BB3: return 1709;
        case 0x5BB4: return 1570;
        case 0x5BB5: return 2737;
        case 0x5BB6: return 1637;
        case 0x5BB8: return 4953;
        case 0x5BB9: return 4173;
        case 0x5BBF: return 2672;
        case 0x5BC0: return 10818;
        case 0x5BC2: return 2605;
        case 0x5BC3: return 4954;
        case 0x5BC4: return 1868;
        case 0x5BC5: return 3527;
        case 0x5BC6: return 4050;
        case 0x5BC7: return 4955;
        case 0x5BC9: return 4956;
        case 0x5BCC: return 3816;
        case 0x5BD0: return 4958;
        case 0x5BD2: return 1793;
        case 0x5BD3: return 2060;
        case 0x5BD4: return 4957;
        case 0x5BD8: return 10820;
        case 0x5BDB: return 1803;
        case 0x5BDD: return 2837;
        case 0x5BDE: return 4962;
        case 0x5BDF: return 2444;
        case 0x5BE1: return 1638;
        case 0x5BE2: return 4961;
        case 0x5BE4: return 4959;
        case 0x5BE5: return 4963;
        case 0x5BE6: return 4960;
        case 0x5BE7: return 3582;
        case 0x5BE8: return 5590;
        case 0x5BE9: return 2838;
        case 0x5BEB: return 4964;
        case 0x5BEC: return 10821;
        case 0x5BEE: return 4261;
        case 0x5BF0: return 4965;
        case 0x5BF3: return 4967;
        case 0x5BF5: return 3289;
        case 0x5BF6: return 4966;
        case 0x5BF8: return 2916;
        case 0x5BFA: return 2534;
        case 0x5BFE: return 3149;
        case 0x5BFF: return 2624;
        case 0x5C01: return 3844;
        case 0x5C02: return 2989;
        case 0x5C04: return 2582;
        case 0x5C05: return 4968;
        case 0x5C06: return 2738;
        case 0x5C07: return 4969;
        case 0x5C08: return 4970;
        case 0x5C09: return 1460;
        case 0x5C0A: return 3127;
        case 0x5C0B: return 2869;
        case 0x5C0D: return 4971;
        case 0x5C0E: return 3496;
        case 0x5C0F: return 2739;
        case 0x5C11: return 2740;
        case 0x5C13: return 4972;
        case 0x5C16: return 2990;
        case 0x5C1A: return 2741;
        case 0x5C1E: return 10822;
        case 0x5C20: return 4973;
        case 0x5C22: return 4974;
        case 0x5C24: return 4105;
        case 0x5C28: return 4975;
        case 0x5C2D: return 2011;
        case 0x5C31: return 2633;
        case 0x5C38: return 4976;
        case 0x5C39: return 4977;
        case 0x5C3A: return 2597;
        case 0x5C3B: return 2831;
        case 0x5C3C: return 3561;
        case 0x5C3D: return 2871;
        case 0x5C3E: return 3753;
        case 0x5C3F: return 3573;
        case 0x5C40: return 2014;
        case 0x5C41: return 4978;
        case 0x5C45: return 1958;
        case 0x5C46: return 4979;
        case 0x5C48: return 2067;
        case 0x5C4A: return 3524;
        case 0x5C4B: return 1613;
        case 0x5C4D: return 2494;
        case 0x5C4E: return 4980;
        case 0x5C4F: return 4983;
        case 0x5C50: return 4982;
        case 0x5C51: return 2066;
        case 0x5C53: return 4981;
        case 0x5C55: return 3407;
        case 0x5C5E: return 3117;
        case 0x5C60: return 3426;
        case 0x5C61: return 2577;
        case 0x5C64: return 3063;
        case 0x5C65: return 4225;
        case 0x5C6C: return 4985;
        case 0x5C6E: return 4986;
        case 0x5C6F: return 3531;
        case 0x5C71: return 2462;
        case 0x5C76: return 4988;
        case 0x5C79: return 4989;
        case 0x5C8C: return 4990;
        case 0x5C90: return 1869;
        case 0x5C91: return 4991;
        case 0x5C94: return 4992;
        case 0x5CA1: return 1609;
        case 0x5CA6: return 10823;
        case 0x5CA8: return 3034;
        case 0x5CA9: return 1853;
        case 0x5CAB: return 4994;
        case 0x5CAC: return 4049;
        case 0x5CB1: return 3151;
        case 0x5CB3: return 1748;
        case 0x5CB6: return 4996;
        case 0x5CB7: return 4998;
        case 0x5CB8: return 1848;
        case 0x5CBA: return 10824;
        case 0x5CBB: return 4995;
        case 0x5CBC: return 4997;
        case 0x5CBE: return 5000;
        case 0x5CC5: return 4999;
        case 0x5CC7: return 5001;
        case 0x5CD9: return 5002;
        case 0x5CE0: return 3506;
        case 0x5CE1: return 1987;
        case 0x5CE8: return 1666;
        case 0x5CE9: return 5003;
        case 0x5CEA: return 5008;
        case 0x5CED: return 5006;
        case 0x5CEF: return 3940;
        case 0x5CF0: return 3939;
        case 0x5CF5: return 10825;
        case 0x5CF6: return 3454;
        case 0x5CFA: return 5005;
        case 0x5CFB: return 2683;
        case 0x5CFD: return 5004;
        case 0x5D07: return 2901;
        case 0x5D0B: return 5009;
        case 0x5D0E: return 2423;
        case 0x5D11: return 5015;
        case 0x5D14: return 5016;
        case 0x5D15: return 5010;
        case 0x5D16: return 1710;
        case 0x5D17: return 5011;
        case 0x5D18: return 5020;
        case 0x5D19: return 5019;
        case 0x5D1A: return 5018;
        case 0x5D1B: return 5014;
        case 0x5D1F: return 5013;
        case 0x5D22: return 5017;
        case 0x5D27: return 10826;
        case 0x5D29: return 3941;
        case 0x5D42: return 10829;
        case 0x5D4B: return 5024;
        case 0x5D4C: return 5021;
        case 0x5D4E: return 5023;
        case 0x5D50: return 4217;
        case 0x5D52: return 5022;
        case 0x5D53: return 10827;
        case 0x5D5C: return 5012;
        case 0x5D69: return 2902;
        case 0x5D6C: return 5025;
        case 0x5D6D: return 10830;
        case 0x5D6F: return 2372;
        case 0x5D73: return 5026;
        case 0x5D76: return 5027;
        case 0x5D82: return 5030;
        case 0x5D84: return 5029;
        case 0x5D87: return 5028;
        case 0x5D8B: return 3455;
        case 0x5D8C: return 5007;
        case 0x5D90: return 5036;
        case 0x5D9D: return 5032;
        case 0x5DA2: return 5031;
        case 0x5DAC: return 5033;
        case 0x5DAE: return 5034;
        case 0x5DB7: return 5037;
        case 0x5DB8: return 10831;
        case 0x5DB9: return 10832;
        case 0x5DBA: return 4299;
        case 0x5DBC: return 5038;
        case 0x5DBD: return 5035;
        case 0x5DC9: return 5039;
        case 0x5DCC: return 1849;
        case 0x5DCD: return 5040;
        case 0x5DD0: return 10833;
        case 0x5DD2: return 5042;
        case 0x5DD3: return 5041;
        case 0x5DD6: return 5043;
        case 0x5DDB: return 5044;
        case 0x5DDD: return 2991;
        case 0x5DDE: return 2634;
        case 0x5DE1: return 2699;
        case 0x5DE3: return 3074;
        case 0x5DE5: return 2264;
        case 0x5DE6: return 2373;
        case 0x5DE7: return 2265;
        case 0x5DE8: return 1959;
        case 0x5DEB: return 5045;
        case 0x5DEE: return 2374;
        case 0x5DF1: return 2203;
        case 0x5DF2: return 5046;
        case 0x5DF3: return 4047;
        case 0x5DF4: return 3606;
        case 0x5DF5: return 5047;
        case 0x5DF7: return 2266;
        case 0x5DFB: return 1797;
        case 0x5DFD: return 3202;
        case 0x5DFE: return 2023;
        case 0x5E02: return 2495;
        case 0x5E03: return 3818;
        case 0x5E06: return 3698;
        case 0x5E0B: return 5048;
        case 0x5E0C: return 1870;
        case 0x5E11: return 5051;
        case 0x5E16: return 3290;
        case 0x5E19: return 5050;
        case 0x5E1A: return 5049;
        case 0x5E1B: return 5052;
        case 0x5E1D: return 3364;
        case 0x5E25: return 2886;
        case 0x5E2B: return 2496;
        case 0x5E2D: return 2955;
        case 0x5E2F: return 3152;
        case 0x5E30: return 1881;
        case 0x5E33: return 3291;
        case 0x5E36: return 5053;
        case 0x5E37: return 5054;
        case 0x5E38: return 2804;
        case 0x5E3D: return 3972;
        case 0x5E40: return 5057;
        case 0x5E43: return 5056;
        case 0x5E44: return 5055;
        case 0x5E45: return 3852;
        case 0x5E47: return 5064;
        case 0x5E4C: return 4005;
        case 0x5E4E: return 5058;
        case 0x5E54: return 5060;
        case 0x5E55: return 4022;
        case 0x5E57: return 5059;
        case 0x5E5F: return 5061;
        case 0x5E61: return 3673;
        case 0x5E62: return 5062;
        case 0x5E63: return 3883;
        case 0x5E64: return 5063;
        case 0x5E72: return 1804;
        case 0x5E73: return 3884;
        case 0x5E74: return 3586;
        case 0x5E75: return 5065;
        case 0x5E76: return 5066;
        case 0x5E78: return 2267;
        case 0x5E79: return 1805;
        case 0x5E7A: return 5067;
        case 0x5E7B: return 2185;
        case 0x5E7C: return 4171;
        case 0x5E7D: return 4144;
        case 0x5E7E: return 1871;
        case 0x5E7F: return 5069;
        case 0x5E81: return 3292;
        case 0x5E83: return 2268;
        case 0x5E84: return 2742;
        case 0x5E87: return 3728;
        case 0x5E8A: return 2743;
        case 0x5E8F: return 2719;
        case 0x5E95: return 3365;
        case 0x5E96: return 3942;
        case 0x5E97: return 3408;
        case 0x5E9A: return 2269;
        case 0x5E9C: return 3819;
        case 0x5EA0: return 5070;
        case 0x5EA6: return 3440;
        case 0x5EA7: return 2383;
        case 0x5EAB: return 2204;
        case 0x5EAD: return 3366;
        case 0x5EB5: return 1444;
        case 0x5EB6: return 2709;
        case 0x5EB7: return 2270;
        case 0x5EB8: return 4174;
        case 0x5EC1: return 5071;
        case 0x5EC2: return 5072;
        case 0x5EC3: return 3620;
        case 0x5EC8: return 5073;
        case 0x5EC9: return 4316;
        case 0x5ECA: return 4336;
        case 0x5ECF: return 5075;
        case 0x5ED0: return 5074;
        case 0x5ED3: return 1730;
        case 0x5ED6: return 5076;
        case 0x5EDA: return 5079;
        case 0x5EDB: return 5080;
        case 0x5EDD: return 5078;
        case 0x5EDF: return 3791;
        case 0x5EE0: return 2744;
        case 0x5EE1: return 5082;
        case 0x5EE2: return 5081;
        case 0x5EE3: return 5077;
        case 0x5EE8: return 5083;
        case 0x5EE9: return 5084;
        case 0x5EEC: return 5085;
        case 0x5EF0: return 5088;
        case 0x5EF1: return 5086;
        case 0x5EF3: return 5087;
        case 0x5EF4: return 5089;
        case 0x5EF6: return 1571;
        case 0x5EF7: return 3367;
        case 0x5EF8: return 5090;
        case 0x5EFA: return 2157;
        case 0x5EFB: return 1683;
        case 0x5EFC: return 3593;
        case 0x5EFE: return 5091;
        case 0x5EFF: return 3568;
        case 0x5F01: return 3912;
        case 0x5F03: return 5092;
        case 0x5F04: return 4337;
        case 0x5F09: return 5093;
        case 0x5F0A: return 3885;
        case 0x5F0B: return 5096;
        case 0x5F0C: return 4418;
        case 0x5F0D: return 4434;
        case 0x5F0F: return 2553;
        case 0x5F10: return 3562;
        case 0x5F11: return 5097;
        case 0x5F13: return 1940;
        case 0x5F14: return 3293;
        case 0x5F15: return 1499;
        case 0x5F16: return 5098;
        case 0x5F17: return 3859;
        case 0x5F18: return 2271;
        case 0x5F1B: return 3243;
        case 0x5F1F: return 3368;
        case 0x5F21: return 10834;
        case 0x5F25: return 4120;
        case 0x5F26: return 2186;
        case 0x5F27: return 2205;
        case 0x5F29: return 5099;
        case 0x5F2D: return 5100;
        case 0x5F2F: return 5106;
        case 0x5F31: return 2606;
        case 0x5F34: return 10835;
        case 0x5F35: return 3294;
        case 0x5F37: return 1988;
        case 0x5F38: return 5101;
        case 0x5F3C: return 3770;
        case 0x5F3E: return 3233;
        case 0x5F41: return 5102;
        case 0x5F45: return 10755;
        case 0x5F48: return 5103;
        case 0x5F4A: return 1989;
        case 0x5F4C: return 5104;
        case 0x5F4E: return 5105;
        case 0x5F51: return 5107;
        case 0x5F53: return 3469;
        case 0x5F56: return 5108;
        case 0x5F57: return 5109;
        case 0x5F59: return 5110;
        case 0x5F5C: return 5095;
        case 0x5F5D: return 5094;
        case 0x5F61: return 5111;
        case 0x5F62: return 2100;
        case 0x5F66: return 3766;
        case 0x5F67: return 10836;
        case 0x5F69: return 2393;
        case 0x5F6A: return 3782;
        case 0x5F6B: return 3295;
        case 0x5F6C: return 3802;
        case 0x5F6D: return 5112;
        case 0x5F70: return 2745;
        case 0x5F71: return 1541;
        case 0x5F73: return 5113;
        case 0x5F77: return 5114;
        case 0x5F79: return 4123;
        case 0x5F7C: return 3729;
        case 0x5F7F: return 5117;
        case 0x5F80: return 1596;
        case 0x5F81: return 2925;
        case 0x5F82: return 5116;
        case 0x5F83: return 5115;
        case 0x5F84: return 2101;
        case 0x5F85: return 3153;
        case 0x5F87: return 5121;
        case 0x5F88: return 5119;
        case 0x5F8A: return 5118;
        case 0x5F8B: return 4236;
        case 0x5F8C: return 2230;
        case 0x5F90: return 2720;
        case 0x5F91: return 5120;
        case 0x5F92: return 3427;
        case 0x5F93: return 2661;
        case 0x5F97: return 3509;
        case 0x5F98: return 5124;
        case 0x5F99: return 5123;
        case 0x5F9E: return 5122;
        case 0x5FA0: return 5125;
        case 0x5FA1: return 2231;
        case 0x5FA8: return 5126;
        case 0x5FA9: return 3851;
        case 0x5FAA: return 2690;
        case 0x5FAD: return 5127;
        case 0x5FAE: return 3754;
        case 0x5FB3: return 3510;
        case 0x5FB4: return 3296;
        case 0x5FB7: return 10837;
        case 0x5FB9: return 3399;
        case 0x5FBC: return 5128;
        case 0x5FBD: return 1890;
        case 0x5FC3: return 2839;
        case 0x5FC5: return 3771;
        case 0x5FCC: return 1872;
        case 0x5FCD: return 3577;
        case 0x5FD6: return 5129;
        case 0x5FD7: return 2497;
        case 0x5FD8: return 3973;
        case 0x5FD9: return 3974;
        case 0x5FDC: return 1597;
        case 0x5FDD: return 5134;
        case 0x5FDE: return 10838;
        case 0x5FE0: return 3268;
        case 0x5FE4: return 5131;
        case 0x5FEB: return 1684;
        case 0x5FF0: return 5182;
        case 0x5FF1: return 5133;
        case 0x5FF5: return 3587;
        case 0x5FF8: return 5132;
        case 0x5FFB: return 5130;
        case 0x5FFD: return 2345;
        case 0x5FFF: return 5136;
        case 0x600E: return 5142;
        case 0x600F: return 5148;
        case 0x6010: return 5140;
        case 0x6012: return 3443;
        case 0x6015: return 5145;
        case 0x6016: return 3820;
        case 0x6019: return 5139;
        case 0x601B: return 5144;
        case 0x601C: return 4300;
        case 0x601D: return 2498;
        case 0x6020: return 3154;
        case 0x6021: return 5137;
        case 0x6025: return 1941;
        case 0x6026: return 5147;
        case 0x6027: return 2926;
        case 0x6028: return 1572;
        case 0x6029: return 5141;
        case 0x602A: return 1685;
        case 0x602B: return 5146;
        case 0x602F: return 1990;
        case 0x6031: return 5143;
        case 0x603A: return 5149;
        case 0x6041: return 5151;
        case 0x6042: return 5161;
        case 0x6043: return 5159;
        case 0x6046: return 5156;
        case 0x604A: return 5155;
        case 0x604B: return 4317;
        case 0x604D: return 5157;
        case 0x6050: return 1991;
        case 0x6052: return 2272;
        case 0x6055: return 2721;
        case 0x6059: return 5164;
        case 0x605A: return 5150;
        case 0x605D: return 10839;
        case 0x605F: return 5154;
        case 0x6060: return 5138;
        case 0x6062: return 1687;
        case 0x6063: return 5158;
        case 0x6064: return 5160;
        case 0x6065: return 3244;
        case 0x6068: return 2357;
        case 0x6069: return 1621;
        case 0x606A: return 5152;
        case 0x606B: return 5163;
        case 0x606C: return 5162;
        case 0x606D: return 1992;
        case 0x606F: return 3110;
        case 0x6070: return 1761;
        case 0x6075: return 2102;
        case 0x6077: return 5153;
        case 0x6081: return 5165;
        case 0x6083: return 5168;
        case 0x6084: return 5170;
        case 0x6085: return 10840;
        case 0x6089: return 2566;
        case 0x608A: return 10841;
        case 0x608B: return 5176;
        case 0x608C: return 3369;
        case 0x608D: return 5166;
        case 0x6092: return 5174;
        case 0x6094: return 1686;
        case 0x6096: return 5172;
        case 0x6097: return 5173;
        case 0x609A: return 5169;
        case 0x609B: return 5171;
        case 0x609F: return 2232;
        case 0x60A0: return 4145;
        case 0x60A3: return 1806;
        case 0x60A6: return 1560;
        case 0x60A7: return 5175;
        case 0x60A9: return 3597;
        case 0x60AA: return 1422;
        case 0x60B2: return 3730;
        case 0x60B3: return 5135;
        case 0x60B4: return 5181;
        case 0x60B5: return 5185;
        case 0x60B6: return 4110;
        case 0x60B8: return 5178;
        case 0x60BC: return 3456;
        case 0x60BD: return 5183;
        case 0x60C5: return 2805;
        case 0x60C6: return 5184;
        case 0x60C7: return 3532;
        case 0x60D1: return 4362;
        case 0x60D3: return 5180;
        case 0x60D5: return 10843;
        case 0x60D8: return 5186;
        case 0x60DA: return 2346;
        case 0x60DC: return 2956;
        case 0x60DE: return 10842;
        case 0x60DF: return 1461;
        case 0x60E0: return 5179;
        case 0x60E1: return 5177;
        case 0x60E3: return 3065;
        case 0x60E7: return 5167;
        case 0x60E8: return 2463;
        case 0x60F0: return 3139;
        case 0x60F1: return 5198;
        case 0x60F2: return 10845;
        case 0x60F3: return 3066;
        case 0x60F4: return 5193;
        case 0x60F6: return 5190;
        case 0x60F7: return 5191;
        case 0x60F9: return 2607;
        case 0x60FA: return 5194;
        case 0x60FB: return 5197;
        case 0x6100: return 5192;
        case 0x6101: return 2636;
        case 0x6103: return 5195;
        case 0x6106: return 5189;
        case 0x6108: return 4133;
        case 0x6109: return 4132;
        case 0x610D: return 5199;
        case 0x610E: return 5200;
        case 0x610F: return 1462;
        case 0x6111: return 10846;
        case 0x6115: return 5188;
        case 0x611A: return 2055;
        case 0x611B: return 1415;
        case 0x611F: return 1807;
        case 0x6120: return 10844;
        case 0x6121: return 5196;
        case 0x6127: return 5204;
        case 0x6128: return 5203;
        case 0x612C: return 5208;
        case 0x6130: return 10848;
        case 0x6134: return 5209;
        case 0x6137: return 10847;
        case 0x613C: return 5207;
        case 0x613D: return 5210;
        case 0x613E: return 5202;
        case 0x613F: return 5206;
        case 0x6142: return 5211;
        case 0x6144: return 5212;
        case 0x6147: return 5201;
        case 0x6148: return 2535;
        case 0x614A: return 5205;
        case 0x614B: return 3155;
        case 0x614C: return 2273;
        case 0x614D: return 5187;
        case 0x614E: return 2840;
        case 0x6153: return 5225;
        case 0x6155: return 3926;
        case 0x6158: return 5215;
        case 0x6159: return 5216;
        case 0x615A: return 5217;
        case 0x615D: return 5224;
        case 0x615F: return 5223;
        case 0x6162: return 4040;
        case 0x6163: return 1808;
        case 0x6165: return 5221;
        case 0x6167: return 2104;
        case 0x6168: return 1711;
        case 0x616B: return 5218;
        case 0x616E: return 4253;
        case 0x616F: return 5220;
        case 0x6170: return 1463;
        case 0x6171: return 5222;
        case 0x6173: return 5213;
        case 0x6174: return 5219;
        case 0x6175: return 5226;
        case 0x6176: return 2103;
        case 0x6177: return 5214;
        case 0x617E: return 4196;
        case 0x6182: return 4146;
        case 0x6187: return 5229;
        case 0x618A: return 5233;
        case 0x618E: return 3101;
        case 0x6190: return 4318;
        case 0x6191: return 5234;
        case 0x6194: return 5231;
        case 0x6196: return 5228;
        case 0x6198: return 10849;
        case 0x6199: return 5227;
        case 0x619A: return 5232;
        case 0x61A4: return 3869;
        case 0x61A7: return 3497;
        case 0x61A9: return 2105;
        case 0x61AB: return 5235;
        case 0x61AC: return 5230;
        case 0x61AE: return 5236;
        case 0x61B2: return 2158;
        case 0x61B6: return 1614;
        case 0x61BA: return 5244;
        case 0x61BE: return 1809;
        case 0x61C3: return 5242;
        case 0x61C6: return 5243;
        case 0x61C7: return 2358;
        case 0x61C8: return 5241;
        case 0x61C9: return 5239;
        case 0x61CA: return 5238;
        case 0x61CB: return 5245;
        case 0x61CC: return 5237;
        case 0x61CD: return 5247;
        case 0x61D0: return 1688;
        case 0x61E3: return 5249;
        case 0x61E6: return 5248;
        case 0x61F2: return 3297;
        case 0x61F4: return 5252;
        case 0x61F6: return 5250;
        case 0x61F7: return 5240;
        case 0x61F8: return 2159;
        case 0x61FA: return 5251;
        case 0x61FC: return 5255;
        case 0x61FD: return 5254;
        case 0x61FE: return 5256;
        case 0x61FF: return 5253;
        case 0x6200: return 5257;
        case 0x6208: return 5258;
        case 0x6209: return 5259;
        case 0x620A: return 3927;
        case 0x620C: return 5261;
        case 0x620D: return 5260;
        case 0x620E: return 2662;
        case 0x6210: return 2927;
        case 0x6211: return 1667;
        case 0x6212: return 1689;
        case 0x6213: return 10850;
        case 0x6214: return 5262;
        case 0x6216: return 1440;
        case 0x621A: return 2957;
        case 0x621B: return 5263;
        case 0x621D: return 7084;
        case 0x621E: return 5264;
        case 0x621F: return 2132;
        case 0x6221: return 5265;
        case 0x6226: return 2992;
        case 0x622A: return 5266;
        case 0x622E: return 5267;
        case 0x622F: return 1905;
        case 0x6230: return 5268;
        case 0x6232: return 5269;
        case 0x6233: return 5270;
        case 0x6234: return 3156;
        case 0x6238: return 2206;
        case 0x623B: return 4106;
        case 0x623F: return 3975;
        case 0x6240: return 2705;
        case 0x6241: return 5271;
        case 0x6247: return 2993;
        case 0x6248: return 7266;
        case 0x6249: return 3731;
        case 0x624B: return 2611;
        case 0x624D: return 2394;
        case 0x624E: return 5272;
        case 0x6253: return 3140;
        case 0x6255: return 3860;
        case 0x6258: return 3182;
        case 0x625B: return 5275;
        case 0x625E: return 5273;
        case 0x6260: return 5276;
        case 0x6263: return 5274;
        case 0x6268: return 5277;
        case 0x626E: return 3870;
        case 0x6271: return 1432;
        case 0x6276: return 3821;
        case 0x6279: return 3732;
        case 0x627C: return 5278;
        case 0x627E: return 5281;
        case 0x627F: return 2746;
        case 0x6280: return 1906;
        case 0x6282: return 5279;
        case 0x6283: return 5286;
        case 0x6284: return 2747;
        case 0x6289: return 5280;
        case 0x628A: return 3607;
        case 0x6291: return 4197;
        case 0x6292: return 5282;
        case 0x6293: return 5283;
        case 0x6294: return 5287;
        case 0x6295: return 3457;
        case 0x6296: return 5284;
        case 0x6297: return 2274;
        case 0x6298: return 2975;
        case 0x629B: return 5301;
        case 0x629C: return 3685;
        case 0x629E: return 3183;
        case 0x62A6: return 10851;
        case 0x62AB: return 3733;
        case 0x62AC: return 5370;
        case 0x62B1: return 3943;
        case 0x62B5: return 3370;
        case 0x62B9: return 4032;
        case 0x62BB: return 5290;
        case 0x62BC: return 1598;
        case 0x62BD: return 3269;
        case 0x62C2: return 5299;
        case 0x62C5: return 3215;
        case 0x62C6: return 5293;
        case 0x62C7: return 5300;
        case 0x62C8: return 5295;
        case 0x62C9: return 5302;
        case 0x62CA: return 5298;
        case 0x62CC: return 5297;
        case 0x62CD: return 3650;
        case 0x62CF: return 5291;
        case 0x62D0: return 1690;
        case 0x62D1: return 5289;
        case 0x62D2: return 1960;
        case 0x62D3: return 3184;
        case 0x62D4: return 5285;
        case 0x62D7: return 5288;
        case 0x62D8: return 2275;
        case 0x62D9: return 2972;
        case 0x62DB: return 2748;
        case 0x62DC: return 5296;
        case 0x62DD: return 3621;
        case 0x62E0: return 1961;
        case 0x62E1: return 1731;
        case 0x62EC: return 1762;
        case 0x62ED: return 2820;
        case 0x62EE: return 5304;
        case 0x62EF: return 5309;
        case 0x62F1: return 5305;
        case 0x62F3: return 2160;
        case 0x62F5: return 5310;
        case 0x62F6: return 2445;
        case 0x62F7: return 2328;
        case 0x62FE: return 2637;
        case 0x62FF: return 5292;
        case 0x6301: return 2536;
        case 0x6302: return 5307;
        case 0x6307: return 2499;
        case 0x6308: return 5308;
        case 0x6309: return 1445;
        case 0x630C: return 5303;
        case 0x6311: return 3298;
        case 0x6319: return 1962;
        case 0x631F: return 1993;
        case 0x6327: return 5306;
        case 0x6328: return 1416;
        case 0x632B: return 2384;
        case 0x632F: return 2841;
        case 0x633A: return 3371;
        case 0x633D: return 3717;
        case 0x633E: return 5312;
        case 0x633F: return 3069;
        case 0x6349: return 3111;
        case 0x634C: return 2454;
        case 0x634D: return 5313;
        case 0x634F: return 5315;
        case 0x6350: return 5311;
        case 0x6355: return 3918;
        case 0x6357: return 3318;
        case 0x635C: return 3067;
        case 0x6367: return 3944;
        case 0x6368: return 2583;
        case 0x6369: return 5327;
        case 0x636B: return 5326;
        case 0x636E: return 2907;
        case 0x6372: return 2161;
        case 0x6376: return 5320;
        case 0x6377: return 2750;
        case 0x637A: return 3549;
        case 0x637B: return 3588;
        case 0x6380: return 5318;
        case 0x6383: return 3068;
        case 0x6388: return 2625;
        case 0x6389: return 5323;
        case 0x638C: return 2749;
        case 0x638E: return 5317;
        case 0x638F: return 5322;
        case 0x6392: return 3622;
        case 0x6396: return 5316;
        case 0x6398: return 2068;
        case 0x639B: return 1752;
        case 0x639F: return 5324;
        case 0x63A0: return 4240;
        case 0x63A1: return 2395;
        case 0x63A2: return 3216;
        case 0x63A3: return 5321;
        case 0x63A5: return 2973;
        case 0x63A7: return 2276;
        case 0x63A8: return 2887;
        case 0x63A9: return 1573;
        case 0x63AA: return 3035;
        case 0x63AB: return 5319;
        case 0x63AC: return 1916;
        case 0x63B2: return 2106;
        case 0x63B4: return 3336;
        case 0x63B5: return 5325;
        case 0x63BB: return 3070;
        case 0x63BE: return 5328;
        case 0x63C0: return 5330;
        case 0x63C3: return 3124;
        case 0x63C4: return 5336;
        case 0x63C6: return 5331;
        case 0x63C9: return 5333;
        case 0x63CF: return 3792;
        case 0x63D0: return 3372;
        case 0x63D2: return 5334;
        case 0x63D6: return 4147;
        case 0x63DA: return 4175;
        case 0x63DB: return 1810;
        case 0x63E1: return 1423;
        case 0x63E3: return 5332;
        case 0x63E9: return 5329;
        case 0x63EE: return 1873;
        case 0x63F4: return 1574;
        case 0x63F5: return 10852;
        case 0x63F6: return 5335;
        case 0x63FA: return 4176;
        case 0x6406: return 5339;
        case 0x640D: return 3128;
        case 0x640F: return 5346;
        case 0x6413: return 5340;
        case 0x6416: return 5337;
        case 0x6417: return 5344;
        case 0x641C: return 5314;
        case 0x6426: return 5341;
        case 0x6428: return 5345;
        case 0x642C: return 3699;
        case 0x642D: return 3458;
        case 0x6434: return 5338;
        case 0x6436: return 5342;
        case 0x643A: return 2107;
        case 0x643E: return 2430;
        case 0x6442: return 2974;
        case 0x644E: return 5350;
        case 0x6458: return 3389;
        case 0x6460: return 10853;
        case 0x6467: return 5347;
        case 0x6469: return 4011;
        case 0x646F: return 5348;
        case 0x6476: return 5349;
        case 0x6478: return 4087;
        case 0x647A: return 2915;
        case 0x6483: return 2133;
        case 0x6488: return 5356;
        case 0x6492: return 2464;
        case 0x6493: return 5353;
        case 0x6495: return 5352;
        case 0x649A: return 3589;
        case 0x649D: return 10854;
        case 0x649E: return 3498;
        case 0x64A4: return 3400;
        case 0x64A5: return 5354;
        case 0x64A9: return 5355;
        case 0x64AB: return 3838;
        case 0x64AD: return 3608;
        case 0x64AE: return 2446;
        case 0x64B0: return 2994;
        case 0x64B2: return 3995;
        case 0x64B9: return 1732;
        case 0x64BB: return 5362;
        case 0x64BC: return 5357;
        case 0x64C1: return 4177;
        case 0x64C2: return 5364;
        case 0x64C5: return 5360;
        case 0x64C7: return 5361;
        case 0x64CD: return 3071;
        case 0x64CE: return 10855;
        case 0x64D2: return 5359;
        case 0x64D4: return 5294;
        case 0x64D8: return 5363;
        case 0x64DA: return 5358;
        case 0x64E0: return 5368;
        case 0x64E1: return 5369;
        case 0x64E2: return 3390;
        case 0x64E3: return 5371;
        case 0x64E6: return 2447;
        case 0x64E7: return 5366;
        case 0x64EC: return 1907;
        case 0x64EF: return 5372;
        case 0x64F1: return 5365;
        case 0x64F2: return 5376;
        case 0x64F4: return 5375;
        case 0x64F6: return 5374;
        case 0x64FA: return 5377;
        case 0x64FD: return 5379;
        case 0x64FE: return 2806;
        case 0x6500: return 5378;
        case 0x6505: return 5382;
        case 0x6518: return 5380;
        case 0x651C: return 5381;
        case 0x651D: return 5343;
        case 0x6523: return 5384;
        case 0x6524: return 5383;
        case 0x652A: return 5351;
        case 0x652B: return 5385;
        case 0x652C: return 5373;
        case 0x652F: return 2500;
        case 0x6534: return 5386;
        case 0x6535: return 5387;
        case 0x6536: return 5389;
        case 0x6537: return 5388;
        case 0x6538: return 5390;
        case 0x6539: return 1691;
        case 0x653B: return 2277;
        case 0x653E: return 3945;
        case 0x653F: return 2928;
        case 0x6545: return 2207;
        case 0x6548: return 5392;
        case 0x654D: return 5395;
        case 0x654E: return 10856;
        case 0x654F: return 3809;
        case 0x6551: return 1942;
        case 0x6555: return 5394;
        case 0x6556: return 5393;
        case 0x6557: return 3623;
        case 0x6558: return 5396;
        case 0x6559: return 1994;
        case 0x655D: return 5398;
        case 0x655E: return 5397;
        case 0x6562: return 1811;
        case 0x6563: return 2465;
        case 0x6566: return 3533;
        case 0x656C: return 2108;
        case 0x6570: return 2903;
        case 0x6572: return 5399;
        case 0x6574: return 2929;
        case 0x6575: return 3391;
        case 0x6577: return 3822;
        case 0x6578: return 5400;
        case 0x6582: return 5401;
        case 0x6583: return 5402;
        case 0x6587: return 3877;
        case 0x6588: return 4948;
        case 0x6589: return 2951;
        case 0x658C: return 3803;
        case 0x658E: return 2405;
        case 0x6590: return 3734;
        case 0x6591: return 3700;
        case 0x6597: return 3428;
        case 0x6599: return 4262;
        case 0x659B: return 5404;
        case 0x659C: return 2585;
        case 0x659F: return 5405;
        case 0x65A1: return 1431;
        case 0x65A4: return 2025;
        case 0x65A5: return 2958;
        case 0x65A7: return 3823;
        case 0x65AB: return 5406;
        case 0x65AC: return 2477;
        case 0x65AD: return 3234;
        case 0x65AF: return 2502;
        case 0x65B0: return 2842;
        case 0x65B7: return 5407;
        case 0x65B9: return 3946;
        case 0x65BC: return 1590;
        case 0x65BD: return 2503;
        case 0x65C1: return 5410;
        case 0x65C3: return 5408;
        case 0x65C4: return 5411;
        case 0x65C5: return 4254;
        case 0x65C6: return 5409;
        case 0x65CB: return 3004;
        case 0x65CC: return 5412;
        case 0x65CF: return 3119;
        case 0x65D2: return 5413;
        case 0x65D7: return 1875;
        case 0x65D9: return 5415;
        case 0x65DB: return 5414;
        case 0x65E0: return 5416;
        case 0x65E1: return 5417;
        case 0x65E2: return 1876;
        case 0x65E5: return 3569;
        case 0x65E6: return 3217;
        case 0x65E7: return 1955;
        case 0x65E8: return 2504;
        case 0x65E9: return 3072;
        case 0x65EC: return 2691;
        case 0x65ED: return 1425;
        case 0x65F1: return 5418;
        case 0x65FA: return 1599;
        case 0x65FB: return 5422;
        case 0x6600: return 10857;
        case 0x6602: return 2278;
        case 0x6603: return 5421;
        case 0x6606: return 2360;
        case 0x6607: return 2751;
        case 0x6609: return 10860;
        case 0x660A: return 5420;
        case 0x660C: return 2752;
        case 0x660E: return 4073;
        case 0x660F: return 2359;
        case 0x6613: return 1464;
        case 0x6614: return 2959;
        case 0x6615: return 10858;
        case 0x661C: return 5427;
        case 0x661E: return 10862;
        case 0x661F: return 2930;
        case 0x6620: return 1542;
        case 0x6624: return 10863;
        case 0x6625: return 2684;
        case 0x6627: return 4017;
        case 0x6628: return 2431;
        case 0x662D: return 2753;
        case 0x662E: return 10861;
        case 0x662F: return 2920;
        case 0x6631: return 10751;
        case 0x6634: return 5426;
        case 0x6635: return 5424;
        case 0x6636: return 5425;
        case 0x663B: return 10859;
        case 0x663C: return 3270;
        case 0x663F: return 5457;
        case 0x6641: return 5431;
        case 0x6642: return 2537;
        case 0x6643: return 2279;
        case 0x6644: return 5429;
        case 0x6649: return 5430;
        case 0x664B: return 2843;
        case 0x664F: return 5428;
        case 0x6652: return 2458;
        case 0x6657: return 10865;
        case 0x6659: return 10866;
        case 0x665D: return 5433;
        case 0x665E: return 5432;
        case 0x665F: return 5437;
        case 0x6662: return 5438;
        case 0x6664: return 5434;
        case 0x6665: return 10864;
        case 0x6666: return 1693;
        case 0x6667: return 5435;
        case 0x6668: return 5436;
        case 0x6669: return 3718;
        case 0x666E: return 3824;
        case 0x666F: return 2109;
        case 0x6670: return 5439;
        case 0x6673: return 10868;
        case 0x6674: return 2931;
        case 0x6676: return 2754;
        case 0x667A: return 3245;
        case 0x6681: return 2012;
        case 0x6683: return 5440;
        case 0x6684: return 5444;
        case 0x6687: return 1640;
        case 0x6688: return 5441;
        case 0x6689: return 5443;
        case 0x668E: return 5442;
        case 0x6691: return 2706;
        case 0x6696: return 3235;
        case 0x6697: return 1446;
        case 0x6698: return 5445;
        case 0x6699: return 10869;
        case 0x669D: return 5446;
        case 0x66A0: return 10870;
        case 0x66A2: return 3299;
        case 0x66A6: return 4310;
        case 0x66AB: return 2478;
        case 0x66AE: return 3928;
        case 0x66B2: return 10871;
        case 0x66B4: return 3976;
        case 0x66B8: return 5453;
        case 0x66B9: return 5448;
        case 0x66BC: return 5451;
        case 0x66BE: return 5450;
        case 0x66BF: return 10872;
        case 0x66C1: return 5447;
        case 0x66C4: return 5452;
        case 0x66C7: return 3539;
        case 0x66C9: return 5449;
        case 0x66D6: return 5454;
        case 0x66D9: return 2707;
        case 0x66DA: return 5455;
        case 0x66DC: return 4178;
        case 0x66DD: return 3659;
        case 0x66E0: return 5456;
        case 0x66E6: return 5458;
        case 0x66E9: return 5459;
        case 0x66F0: return 5460;
        case 0x66F2: return 2015;
        case 0x66F3: return 1543;
        case 0x66F4: return 2280;
        case 0x66F5: return 5461;
        case 0x66F7: return 5462;
        case 0x66F8: return 2712;
        case 0x66F9: return 3073;
        case 0x66FA: return 10873;
        case 0x66FB: return 10754;
        case 0x66FC: return 4661;
        case 0x66FD: return 3037;
        case 0x66FE: return 3036;
        case 0x66FF: return 3157;
        case 0x6700: return 2388;
        case 0x6703: return 4499;
        case 0x6708: return 2145;
        case 0x6709: return 4148;
        case 0x670B: return 3947;
        case 0x670D: return 3853;
        case 0x670E: return 10874;
        case 0x670F: return 5463;
        case 0x6714: return 2432;
        case 0x6715: return 3320;
        case 0x6716: return 5464;
        case 0x6717: return 4338;
        case 0x671B: return 3977;
        case 0x671D: return 3300;
        case 0x671E: return 5465;
        case 0x671F: return 1877;
        case 0x6726: return 5466;
        case 0x6727: return 5467;
        case 0x6728: return 4099;
        case 0x672A: return 4045;
        case 0x672B: return 4033;
        case 0x672C: return 4007;
        case 0x672D: return 2448;
        case 0x672E: return 5469;
        case 0x6731: return 2612;
        case 0x6734: return 3996;
        case 0x6736: return 5471;
        case 0x6737: return 5474;
        case 0x6738: return 5473;
        case 0x673A: return 1874;
        case 0x673D: return 1943;
        case 0x673F: return 5470;
        case 0x6741: return 5472;
        case 0x6746: return 5475;
        case 0x6749: return 2908;
        case 0x674E: return 4226;
        case 0x674F: return 1450;
        case 0x6750: return 2413;
        case 0x6751: return 3129;
        case 0x6753: return 2598;
        case 0x6756: return 2808;
        case 0x6759: return 5478;
        case 0x675C: return 3429;
        case 0x675E: return 5476;
        case 0x675F: return 3112;
        case 0x6760: return 5477;
        case 0x6761: return 2807;
        case 0x6762: return 4102;
        case 0x6763: return 5479;
        case 0x6764: return 5480;
        case 0x6765: return 4207;
        case 0x6766: return 10876;
        case 0x676A: return 5485;
        case 0x676D: return 2281;
        case 0x676F: return 3624;
        case 0x6770: return 5482;
        case 0x6771: return 3459;
        case 0x6772: return 5419;
        case 0x6773: return 5423;
        case 0x6775: return 1926;
        case 0x6777: return 3610;
        case 0x677C: return 5484;
        case 0x677E: return 2755;
        case 0x677F: return 3701;
        case 0x6785: return 5490;
        case 0x6787: return 3755;
        case 0x6789: return 5481;
        case 0x678B: return 5487;
        case 0x678C: return 5486;
        case 0x6790: return 2960;
        case 0x6795: return 4024;
        case 0x6797: return 4280;
        case 0x679A: return 4018;
        case 0x679C: return 1641;
        case 0x679D: return 2505;
        case 0x67A0: return 4363;
        case 0x67A1: return 5489;
        case 0x67A2: return 2904;
        case 0x67A6: return 5488;
        case 0x67A9: return 5483;
        case 0x67AF: return 2208;
        case 0x67B3: return 5495;
        case 0x67B4: return 5493;
        case 0x67B6: return 1642;
        case 0x67B7: return 5491;
        case 0x67B8: return 5497;
        case 0x67B9: return 5503;
        case 0x67BB: return 10877;
        case 0x67C0: return 10879;
        case 0x67C1: return 3141;
        case 0x67C4: return 3886;
        case 0x67C6: return 5505;
        case 0x67CA: return 3761;
        case 0x67CE: return 5504;
        case 0x67CF: return 3651;
        case 0x67D0: return 3978;
        case 0x67D1: return 1812;
        case 0x67D3: return 3000;
        case 0x67D4: return 2663;
        case 0x67D8: return 3340;
        case 0x67DA: return 4149;
        case 0x67DD: return 5500;
        case 0x67DE: return 5499;
        case 0x67E2: return 5501;
        case 0x67E4: return 5498;
        case 0x67E7: return 5506;
        case 0x67E9: return 5496;
        case 0x67EC: return 5494;
        case 0x67EE: return 5502;
        case 0x67EF: return 5492;
        case 0x67F1: return 3271;
        case 0x67F3: return 4129;
        case 0x67F4: return 2575;
        case 0x67F5: return 2433;
        case 0x67FB: return 2375;
        case 0x67FE: return 4026;
        case 0x67FF: return 1724;
        case 0x6801: return 10880;
        case 0x6802: return 3335;
        case 0x6803: return 3519;
        case 0x6804: return 1544;
        case 0x6813: return 2995;
        case 0x6816: return 2933;
        case 0x6817: return 2077;
        case 0x681E: return 5508;
        case 0x6821: return 2282;
        case 0x6822: return 1783;
        case 0x6829: return 5510;
        case 0x682A: return 1775;
        case 0x682B: return 5516;
        case 0x6832: return 5513;
        case 0x6834: return 2996;
        case 0x6838: return 1734;
        case 0x6839: return 2361;
        case 0x683C: return 1733;
        case 0x683D: return 2396;
        case 0x6840: return 5511;
        case 0x6841: return 2136;
        case 0x6842: return 2110;
        case 0x6843: return 3460;
        case 0x6844: return 10881;
        case 0x6846: return 5509;
        case 0x6848: return 1447;
        case 0x684D: return 5512;
        case 0x684E: return 5514;
        case 0x6850: return 2018;
        case 0x6851: return 2079;
        case 0x6852: return 10878;
        case 0x6853: return 1813;
        case 0x6854: return 1922;
        case 0x6859: return 5517;
        case 0x685C: return 2438;
        case 0x685D: return 4028;
        case 0x685F: return 2466;
        case 0x6863: return 5518;
        case 0x6867: return 3775;
        case 0x6874: return 5530;
        case 0x6876: return 1616;
        case 0x6877: return 5519;
        case 0x687E: return 5536;
        case 0x687F: return 5520;
        case 0x6881: return 4263;
        case 0x6883: return 5527;
        case 0x6885: return 3634;
        case 0x688D: return 5535;
        case 0x688F: return 5522;
        case 0x6893: return 1429;
        case 0x6894: return 5524;
        case 0x6897: return 2283;
        case 0x689B: return 5526;
        case 0x689D: return 5525;
        case 0x689F: return 5521;
        case 0x68A0: return 5532;
        case 0x68A2: return 2756;
        case 0x68A6: return 4870;
        case 0x68A7: return 2233;
        case 0x68A8: return 4227;
        case 0x68AD: return 5523;
        case 0x68AF: return 3373;
        case 0x68B0: return 1694;
        case 0x68B1: return 2362;
        case 0x68B3: return 5515;
        case 0x68B5: return 5531;
        case 0x68B6: return 1756;
        case 0x68B9: return 5529;
        case 0x68BA: return 5533;
        case 0x68BC: return 3461;
        case 0x68C4: return 1879;
        case 0x68C6: return 5563;
        case 0x68C8: return 10752;
        case 0x68C9: return 4082;
        case 0x68CA: return 5538;
        case 0x68CB: return 1878;
        case 0x68CD: return 5545;
        case 0x68CF: return 10882;
        case 0x68D2: return 3979;
        case 0x68D4: return 5546;
        case 0x68D5: return 5548;
        case 0x68D7: return 5552;
        case 0x68D8: return 5540;
        case 0x68DA: return 3205;
        case 0x68DF: return 3462;
        case 0x68E0: return 5556;
        case 0x68E1: return 5543;
        case 0x68E3: return 5553;
        case 0x68E7: return 5547;
        case 0x68EE: return 2844;
        case 0x68EF: return 5557;
        case 0x68F2: return 2932;
        case 0x68F9: return 5555;
        case 0x68FA: return 1814;
        case 0x6900: return 4371;
        case 0x6901: return 5537;
        case 0x6904: return 5551;
        case 0x6905: return 1465;
        case 0x6908: return 5539;
        case 0x690B: return 4067;
        case 0x690C: return 5544;
        case 0x690D: return 2821;
        case 0x690E: return 3328;
        case 0x690F: return 5534;
        case 0x6912: return 5550;
        case 0x6919: return 2909;
        case 0x691A: return 5560;
        case 0x691B: return 1772;
        case 0x691C: return 2162;
        case 0x6921: return 5562;
        case 0x6922: return 5541;
        case 0x6923: return 5561;
        case 0x6925: return 5554;
        case 0x6926: return 5542;
        case 0x6928: return 5558;
        case 0x692A: return 5559;
        case 0x6930: return 5576;
        case 0x6934: return 3523;
        case 0x6936: return 5549;
        case 0x6939: return 5572;
        case 0x693D: return 5574;
        case 0x693F: return 3345;
        case 0x694A: return 4179;
        case 0x6953: return 3845;
        case 0x6954: return 5569;
        case 0x6955: return 3143;
        case 0x6959: return 5575;
        case 0x695A: return 3038;
        case 0x695C: return 5566;
        case 0x695D: return 5579;
        case 0x695E: return 5578;
        case 0x6960: return 3556;
        case 0x6961: return 5577;
        case 0x6962: return 3551;
        case 0x6968: return 10884;
        case 0x696A: return 5581;
        case 0x696B: return 5568;
        case 0x696D: return 2013;
        case 0x696E: return 5571;
        case 0x696F: return 2692;
        case 0x6973: return 3635;
        case 0x6974: return 5573;
        case 0x6975: return 2016;
        case 0x6977: return 5565;
        case 0x6978: return 5567;
        case 0x6979: return 5564;
        case 0x697C: return 4339;
        case 0x697D: return 1749;
        case 0x697E: return 5570;
        case 0x6981: return 5580;
        case 0x6982: return 1712;
        case 0x698A: return 2420;
        case 0x698E: return 1564;
        case 0x6991: return 5597;
        case 0x6994: return 4340;
        case 0x6995: return 5600;
        case 0x6998: return 10886;
        case 0x699B: return 2845;
        case 0x699C: return 5599;
        case 0x69A0: return 5598;
        case 0x69A7: return 5595;
        case 0x69AE: return 5583;
        case 0x69B1: return 5612;
        case 0x69B2: return 5582;
        case 0x69B4: return 5601;
        case 0x69BB: return 5593;
        case 0x69BE: return 5588;
        case 0x69BF: return 5585;
        case 0x69C1: return 5586;
        case 0x69C3: return 5594;
        case 0x69C7: return 7803;
        case 0x69CA: return 5591;
        case 0x69CB: return 2284;
        case 0x69CC: return 3329;
        case 0x69CD: return 3075;
        case 0x69CE: return 5589;
        case 0x69D0: return 5584;
        case 0x69D3: return 5587;
        case 0x69D8: return 4180;
        case 0x69D9: return 4021;
        case 0x69DD: return 5592;
        case 0x69DE: return 5602;
        case 0x69E2: return 10887;
        case 0x69E7: return 5610;
        case 0x69E8: return 5603;
        case 0x69EB: return 5616;
        case 0x69ED: return 5614;
        case 0x69F2: return 5609;
        case 0x69F9: return 5608;
        case 0x69FB: return 3337;
        case 0x69FD: return 3076;
        case 0x69FF: return 5606;
        case 0x6A02: return 5604;
        case 0x6A05: return 5611;
        case 0x6A0A: return 5617;
        case 0x6A0B: return 3750;
        case 0x6A0C: return 5623;
        case 0x6A12: return 5618;
        case 0x6A13: return 5621;
        case 0x6A14: return 5615;
        case 0x6A17: return 3279;
        case 0x6A19: return 3783;
        case 0x6A1B: return 5605;
        case 0x6A1E: return 5613;
        case 0x6A1F: return 2757;
        case 0x6A21: return 4088;
        case 0x6A22: return 5633;
        case 0x6A23: return 5620;
        case 0x6A29: return 2163;
        case 0x6A2A: return 1600;
        case 0x6A2B: return 1754;
        case 0x6A2E: return 5596;
        case 0x6A30: return 10888;
        case 0x6A35: return 2758;
        case 0x6A36: return 5625;
        case 0x6A38: return 5632;
        case 0x6A39: return 2626;
        case 0x6A3A: return 1773;
        case 0x6A3D: return 3209;
        case 0x6A44: return 5622;
        case 0x6A46: return 10890;
        case 0x6A47: return 5627;
        case 0x6A48: return 5631;
        case 0x6A4B: return 1995;
        case 0x6A58: return 1923;
        case 0x6A59: return 5629;
        case 0x6A5F: return 1880;
        case 0x6A61: return 3520;
        case 0x6A62: return 5628;
        case 0x6A66: return 5630;
        case 0x6A6B: return 10889;
        case 0x6A72: return 5624;
        case 0x6A73: return 10891;
        case 0x6A78: return 5626;
        case 0x6A7E: return 10892;
        case 0x6A7F: return 1755;
        case 0x6A80: return 3236;
        case 0x6A84: return 5637;
        case 0x6A8D: return 5635;
        case 0x6A8E: return 2234;
        case 0x6A90: return 5634;
        case 0x6A97: return 5640;
        case 0x6A9C: return 5507;
        case 0x6AA0: return 5636;
        case 0x6AA2: return 5638;
        case 0x6AA3: return 5639;
        case 0x6AAA: return 5651;
        case 0x6AAC: return 5647;
        case 0x6AAE: return 5528;
        case 0x6AB3: return 5646;
        case 0x6AB8: return 5645;
        case 0x6ABB: return 5642;
        case 0x6AC1: return 5619;
        case 0x6AC2: return 5644;
        case 0x6AC3: return 5643;
        case 0x6AD1: return 5649;
        case 0x6AD3: return 4329;
        case 0x6ADA: return 5652;
        case 0x6ADB: return 2064;
        case 0x6ADE: return 5648;
        case 0x6ADF: return 5650;
        case 0x6AE2: return 10893;
        case 0x6AE4: return 10894;
        case 0x6AE8: return 3672;
        case 0x6AEA: return 5653;
        case 0x6AFA: return 5657;
        case 0x6AFB: return 5654;
        case 0x6B04: return 4218;
        case 0x6B05: return 5655;
        case 0x6B0A: return 5607;
        case 0x6B12: return 5658;
        case 0x6B16: return 5659;
        case 0x6B1D: return 1524;
        case 0x6B1F: return 5661;
        case 0x6B20: return 2138;
        case 0x6B21: return 2538;
        case 0x6B23: return 2026;
        case 0x6B27: return 1601;
        case 0x6B32: return 4198;
        case 0x6B37: return 5663;
        case 0x6B38: return 5662;
        case 0x6B39: return 5665;
        case 0x6B3A: return 1908;
        case 0x6B3D: return 2027;
        case 0x6B3E: return 1815;
        case 0x6B43: return 5668;
        case 0x6B47: return 5667;
        case 0x6B49: return 5669;
        case 0x6B4C: return 1643;
        case 0x6B4E: return 3218;
        case 0x6B50: return 5670;
        case 0x6B53: return 1816;
        case 0x6B54: return 5672;
        case 0x6B59: return 5671;
        case 0x6B5B: return 5673;
        case 0x6B5F: return 5674;
        case 0x6B61: return 5675;
        case 0x6B62: return 2506;
        case 0x6B63: return 2934;
        case 0x6B64: return 2350;
        case 0x6B66: return 3839;
        case 0x6B69: return 3919;
        case 0x6B6A: return 4359;
        case 0x6B6F: return 2528;
        case 0x6B73: return 2397;
        case 0x6B74: return 4311;
        case 0x6B78: return 5676;
        case 0x6B79: return 5677;
        case 0x6B7B: return 2507;
        case 0x6B7F: return 5678;
        case 0x6B80: return 5679;
        case 0x6B83: return 5681;
        case 0x6B84: return 5680;
        case 0x6B86: return 4003;
        case 0x6B89: return 2693;
        case 0x6B8A: return 2613;
        case 0x6B8B: return 2479;
        case 0x6B8D: return 5682;
        case 0x6B95: return 5684;
        case 0x6B96: return 2822;
        case 0x6B98: return 5683;
        case 0x6B9E: return 5685;
        case 0x6BA4: return 5686;
        case 0x6BAA: return 5687;
        case 0x6BAB: return 5688;
        case 0x6BAF: return 5689;
        case 0x6BB1: return 5691;
        case 0x6BB2: return 5690;
        case 0x6BB3: return 5692;
        case 0x6BB4: return 1602;
        case 0x6BB5: return 3237;
        case 0x6BB7: return 5693;
        case 0x6BBA: return 2449;
        case 0x6BBB: return 1735;
        case 0x6BBC: return 5694;
        case 0x6BBF: return 3417;
        case 0x6BC0: return 4837;
        case 0x6BC5: return 1882;
        case 0x6BC6: return 5695;
        case 0x6BCB: return 5696;
        case 0x6BCD: return 3929;
        case 0x6BCE: return 4019;
        case 0x6BD2: return 3516;
        case 0x6BD3: return 5697;
        case 0x6BD4: return 3735;
        case 0x6BD6: return 10895;
        case 0x6BD8: return 3756;
        case 0x6BDB: return 4092;
        case 0x6BDF: return 5698;
        case 0x6BEB: return 5700;
        case 0x6BEC: return 5699;
        case 0x6BEF: return 5702;
        case 0x6BF3: return 5701;
        case 0x6C08: return 5704;
        case 0x6C0F: return 2508;
        case 0x6C11: return 4058;
        case 0x6C13: return 5705;
        case 0x6C14: return 5706;
        case 0x6C17: return 1883;
        case 0x6C1B: return 5707;
        case 0x6C23: return 5709;
        case 0x6C24: return 5708;
        case 0x6C34: return 2888;
        case 0x6C37: return 3784;
        case 0x6C38: return 1545;
        case 0x6C3E: return 3702;
        case 0x6C3F: return 10896;
        case 0x6C40: return 3374;
        case 0x6C41: return 2664;
        case 0x6C42: return 1944;
        case 0x6C4E: return 3703;
        case 0x6C50: return 2551;
        case 0x6C55: return 5711;
        case 0x6C57: return 1817;
        case 0x6C5A: return 1591;
        case 0x6C5C: return 10897;
        case 0x6C5D: return 3559;
        case 0x6C5E: return 5710;
        case 0x6C5F: return 2285;
        case 0x6C60: return 3246;
        case 0x6C62: return 5712;
        case 0x6C68: return 5720;
        case 0x6C6A: return 5713;
        case 0x6C6F: return 10899;
        case 0x6C70: return 3134;
        case 0x6C72: return 1945;
        case 0x6C73: return 5721;
        case 0x6C7A: return 2139;
        case 0x6C7D: return 1884;
        case 0x6C7E: return 5719;
        case 0x6C81: return 5717;
        case 0x6C82: return 5714;
        case 0x6C83: return 4199;
        case 0x6C86: return 10898;
        case 0x6C88: return 3321;
        case 0x6C8C: return 3534;
        case 0x6C8D: return 5715;
        case 0x6C90: return 5723;
        case 0x6C92: return 5722;
        case 0x6C93: return 2070;
        case 0x6C96: return 1610;
        case 0x6C99: return 2376;
        case 0x6C9A: return 5716;
        case 0x6C9B: return 5718;
        case 0x6CA1: return 4002;
        case 0x6CA2: return 3185;
        case 0x6CAB: return 4034;
        case 0x6CAE: return 5731;
        case 0x6CB1: return 5732;
        case 0x6CB3: return 1644;
        case 0x6CB8: return 3861;
        case 0x6CB9: return 4134;
        case 0x6CBA: return 5734;
        case 0x6CBB: return 2540;
        case 0x6CBC: return 2759;
        case 0x6CBD: return 5727;
        case 0x6CBE: return 5733;
        case 0x6CBF: return 1575;
        case 0x6CC1: return 1996;
        case 0x6CC4: return 5724;
        case 0x6CC5: return 5729;
        case 0x6CC9: return 2997;
        case 0x6CCA: return 3652;
        case 0x6CCC: return 3736;
        case 0x6CD3: return 5726;
        case 0x6CD5: return 3948;
        case 0x6CD7: return 5728;
        case 0x6CD9: return 5737;
        case 0x6CDA: return 10900;
        case 0x6CDB: return 5735;
        case 0x6CDD: return 5730;
        case 0x6CE1: return 3949;
        case 0x6CE2: return 3611;
        case 0x6CE3: return 1946;
        case 0x6CE5: return 3388;
        case 0x6CE8: return 3272;
        case 0x6CEA: return 5738;
        case 0x6CEF: return 5736;
        case 0x6CF0: return 3158;
        case 0x6CF1: return 5725;
        case 0x6CF3: return 1546;
        case 0x6D04: return 10901;
        case 0x6D0B: return 4181;
        case 0x6D0C: return 5749;
        case 0x6D12: return 5748;
        case 0x6D17: return 2999;
        case 0x6D19: return 5745;
        case 0x6D1B: return 4211;
        case 0x6D1E: return 3499;
        case 0x6D1F: return 5739;
        case 0x6D25: return 3326;
        case 0x6D29: return 1547;
        case 0x6D2A: return 2286;
        case 0x6D2B: return 5742;
        case 0x6D32: return 2638;
        case 0x6D33: return 5747;
        case 0x6D35: return 5746;
        case 0x6D36: return 5741;
        case 0x6D38: return 5744;
        case 0x6D3B: return 1763;
        case 0x6D3D: return 5743;
        case 0x6D3E: return 3612;
        case 0x6D41: return 4243;
        case 0x6D44: return 2809;
        case 0x6D45: return 2998;
        case 0x6D59: return 5755;
        case 0x6D5A: return 5753;
        case 0x6D5C: return 3804;
        case 0x6D63: return 5750;
        case 0x6D64: return 5752;
        case 0x6D66: return 1529;
        case 0x6D69: return 2287;
        case 0x6D6A: return 4341;
        case 0x6D6C: return 1720;
        case 0x6D6E: return 3825;
        case 0x6D6F: return 10903;
        case 0x6D74: return 4200;
        case 0x6D77: return 1695;
        case 0x6D78: return 2846;
        case 0x6D79: return 5754;
        case 0x6D85: return 5759;
        case 0x6D87: return 10902;
        case 0x6D88: return 2760;
        case 0x6D8C: return 4151;
        case 0x6D8E: return 5756;
        case 0x6D93: return 5751;
        case 0x6D95: return 5757;
        case 0x6D96: return 10904;
        case 0x6D99: return 4291;
        case 0x6D9B: return 3466;
        case 0x6D9C: return 3511;
        case 0x6DAC: return 10905;
        case 0x6DAF: return 1713;
        case 0x6DB2: return 1556;
        case 0x6DB5: return 5763;
        case 0x6DB8: return 5766;
        case 0x6DBC: return 4264;
        case 0x6DC0: return 4203;
        case 0x6DC5: return 5773;
        case 0x6DC6: return 5767;
        case 0x6DC7: return 5764;
        case 0x6DCB: return 4281;
        case 0x6DCC: return 5770;
        case 0x6DCF: return 10906;
        case 0x6DD1: return 2673;
        case 0x6DD2: return 5772;
        case 0x6DD5: return 5777;
        case 0x6DD8: return 3464;
        case 0x6DD9: return 5775;
        case 0x6DDE: return 5769;
        case 0x6DE1: return 3219;
        case 0x6DE4: return 5776;
        case 0x6DE6: return 5765;
        case 0x6DE8: return 5771;
        case 0x6DEA: return 5778;
        case 0x6DEB: return 1501;
        case 0x6DEC: return 5768;
        case 0x6DEE: return 5779;
        case 0x6DF1: return 2847;
        case 0x6DF2: return 10908;
        case 0x6DF3: return 2694;
        case 0x6DF5: return 3858;
        case 0x6DF7: return 2363;
        case 0x6DF8: return 10907;
        case 0x6DF9: return 5760;
        case 0x6DFA: return 5774;
        case 0x6DFB: return 3409;
        case 0x6DFC: return 10909;
        case 0x6E05: return 2935;
        case 0x6E07: return 1764;
        case 0x6E08: return 2398;
        case 0x6E09: return 2761;
        case 0x6E0A: return 5762;
        case 0x6E0B: return 2665;
        case 0x6E13: return 2111;
        case 0x6E15: return 5761;
        case 0x6E19: return 5783;
        case 0x6E1A: return 2708;
        case 0x6E1B: return 2187;
        case 0x6E1D: return 5798;
        case 0x6E1F: return 5792;
        case 0x6E20: return 1963;
        case 0x6E21: return 3430;
        case 0x6E23: return 5787;
        case 0x6E24: return 5796;
        case 0x6E25: return 1424;
        case 0x6E26: return 1521;
        case 0x6E27: return 10912;
        case 0x6E29: return 1622;
        case 0x6E2B: return 5789;
        case 0x6E2C: return 3113;
        case 0x6E2D: return 5780;
        case 0x6E2E: return 5782;
        case 0x6E2F: return 2288;
        case 0x6E38: return 5799;
        case 0x6E39: return 10910;
        case 0x6E3A: return 5794;
        case 0x6E3C: return 10913;
        case 0x6E3E: return 5786;
        case 0x6E43: return 5793;
        case 0x6E4A: return 4052;
        case 0x6E4D: return 5791;
        case 0x6E4E: return 5795;
        case 0x6E56: return 2209;
        case 0x6E58: return 2762;
        case 0x6E5B: return 3220;
        case 0x6E5C: return 10911;
        case 0x6E5F: return 5785;
        case 0x6E67: return 4150;
        case 0x6E6B: return 5788;
        case 0x6E6E: return 5781;
        case 0x6E6F: return 3465;
        case 0x6E72: return 5784;
        case 0x6E76: return 5790;
        case 0x6E7E: return 4372;
        case 0x6E7F: return 2567;
        case 0x6E80: return 4041;
        case 0x6E82: return 5800;
        case 0x6E8C: return 3679;
        case 0x6E8F: return 5812;
        case 0x6E90: return 2188;
        case 0x6E96: return 2695;
        case 0x6E98: return 5802;
        case 0x6E9C: return 4244;
        case 0x6E9D: return 2289;
        case 0x6E9F: return 5815;
        case 0x6EA2: return 1487;
        case 0x6EA5: return 5813;
        case 0x6EAA: return 5801;
        case 0x6EAF: return 5807;
        case 0x6EB2: return 5809;
        case 0x6EB6: return 4182;
        case 0x6EB7: return 5804;
        case 0x6EBA: return 3397;
        case 0x6EBD: return 5806;
        case 0x6EBF: return 10914;
        case 0x6EC2: return 5814;
        case 0x6EC4: return 5808;
        case 0x6EC5: return 4080;
        case 0x6EC9: return 5803;
        case 0x6ECB: return 2539;
        case 0x6ECC: return 5827;
        case 0x6ED1: return 1765;
        case 0x6ED3: return 5805;
        case 0x6ED4: return 5810;
        case 0x6ED5: return 5811;
        case 0x6EDD: return 3177;
        case 0x6EDE: return 3159;
        case 0x6EEC: return 5819;
        case 0x6EEF: return 5825;
        case 0x6EF2: return 5823;
        case 0x6EF4: return 3392;
        case 0x6EF7: return 5830;
        case 0x6EF8: return 5820;
        case 0x6EFE: return 5821;
        case 0x6EFF: return 5797;
        case 0x6F01: return 1968;
        case 0x6F02: return 3785;
        case 0x6F06: return 2568;
        case 0x6F09: return 2342;
        case 0x6F0F: return 4342;
        case 0x6F11: return 5817;
        case 0x6F13: return 5829;
        case 0x6F14: return 1576;
        case 0x6F15: return 3077;
        case 0x6F20: return 3660;
        case 0x6F22: return 1818;
        case 0x6F23: return 4319;
        case 0x6F2B: return 4042;
        case 0x6F2C: return 3339;
        case 0x6F31: return 5824;
        case 0x6F32: return 5826;
        case 0x6F38: return 3025;
        case 0x6F3E: return 5828;
        case 0x6F3F: return 5822;
        case 0x6F41: return 5816;
        case 0x6F45: return 1820;
        case 0x6F54: return 2140;
        case 0x6F58: return 5842;
        case 0x6F5B: return 5837;
        case 0x6F5C: return 3001;
        case 0x6F5F: return 1758;
        case 0x6F64: return 2696;
        case 0x6F66: return 5846;
        case 0x6F6D: return 5839;
        case 0x6F6E: return 3301;
        case 0x6F6F: return 5836;
        case 0x6F70: return 3346;
        case 0x6F74: return 5871;
        case 0x6F78: return 5833;
        case 0x6F7A: return 5832;
        case 0x6F7C: return 5841;
        case 0x6F80: return 5835;
        case 0x6F81: return 5834;
        case 0x6F82: return 5840;
        case 0x6F84: return 2914;
        case 0x6F86: return 5831;
        case 0x6F88: return 10915;
        case 0x6F8E: return 5843;
        case 0x6F91: return 5844;
        case 0x6F97: return 1819;
        case 0x6FA1: return 5849;
        case 0x6FA3: return 5848;
        case 0x6FA4: return 5850;
        case 0x6FAA: return 5853;
        case 0x6FB1: return 3418;
        case 0x6FB3: return 5847;
        case 0x6FB5: return 10916;
        case 0x6FB9: return 5851;
        case 0x6FC0: return 2134;
        case 0x6FC1: return 3190;
        case 0x6FC2: return 5845;
        case 0x6FC3: return 3598;
        case 0x6FC6: return 5852;
        case 0x6FD4: return 5857;
        case 0x6FD5: return 5855;
        case 0x6FD8: return 5858;
        case 0x6FDB: return 5861;
        case 0x6FDF: return 5854;
        case 0x6FE0: return 2329;
        case 0x6FE1: return 3579;
        case 0x6FE4: return 5758;
        case 0x6FEB: return 4219;
        case 0x6FEC: return 5856;
        case 0x6FEE: return 5860;
        case 0x6FEF: return 3186;
        case 0x6FF1: return 5859;
        case 0x6FF3: return 5838;
        case 0x6FF5: return 10917;
        case 0x6FF6: return 7404;
        case 0x6FFA: return 5864;
        case 0x6FFE: return 5868;
        case 0x7001: return 5866;
        case 0x7005: return 10918;
        case 0x7007: return 10919;
        case 0x7009: return 5862;
        case 0x700B: return 5863;
        case 0x700F: return 5867;
        case 0x7011: return 5865;
        case 0x7015: return 3805;
        case 0x7018: return 5873;
        case 0x701A: return 5870;
        case 0x701B: return 5869;
        case 0x701D: return 5872;
        case 0x701E: return 3529;
        case 0x701F: return 5874;
        case 0x7026: return 3280;
        case 0x7027: return 3178;
        case 0x7028: return 10920;
        case 0x702C: return 2918;
        case 0x7030: return 5875;
        case 0x7032: return 5877;
        case 0x703E: return 5876;
        case 0x704C: return 5818;
        case 0x7051: return 5878;
        case 0x7058: return 3548;
        case 0x7063: return 5879;
        case 0x706B: return 1645;
        case 0x706F: return 3467;
        case 0x7070: return 1696;
        case 0x7078: return 1947;
        case 0x707C: return 2599;
        case 0x707D: return 2399;
        case 0x7085: return 10921;
        case 0x7089: return 4330;
        case 0x708A: return 2889;
        case 0x708E: return 1577;
        case 0x7092: return 5881;
        case 0x7099: return 5880;
        case 0x70AB: return 10922;
        case 0x70AC: return 5884;
        case 0x70AD: return 3221;
        case 0x70AE: return 5887;
        case 0x70AF: return 5882;
        case 0x70B3: return 5886;
        case 0x70B8: return 5885;
        case 0x70B9: return 3415;
        case 0x70BA: return 1466;
        case 0x70BB: return 10750;
        case 0x70C8: return 4314;
        case 0x70CB: return 5889;
        case 0x70CF: return 1511;
        case 0x70D9: return 5891;
        case 0x70DD: return 5890;
        case 0x70DF: return 5888;
        case 0x70F1: return 5883;
        case 0x70F9: return 3950;
        case 0x70FD: return 5893;
        case 0x7104: return 10924;
        case 0x7109: return 5892;
        case 0x710F: return 10923;
        case 0x7114: return 1578;
        case 0x7119: return 5895;
        case 0x711A: return 3871;
        case 0x711C: return 5894;
        case 0x7121: return 4062;
        case 0x7126: return 2764;
        case 0x7136: return 3026;
        case 0x713C: return 2763;
        case 0x7146: return 10926;
        case 0x7147: return 10927;
        case 0x7149: return 4320;
        case 0x714C: return 5901;
        case 0x714E: return 3002;
        case 0x7155: return 5897;
        case 0x7156: return 5902;
        case 0x7159: return 1579;
        case 0x715C: return 10925;
        case 0x7162: return 5900;
        case 0x7164: return 3636;
        case 0x7165: return 5896;
        case 0x7166: return 5899;
        case 0x7167: return 2765;
        case 0x7169: return 3714;
        case 0x716C: return 5903;
        case 0x716E: return 2586;
        case 0x717D: return 3003;
        case 0x7184: return 5906;
        case 0x7188: return 5898;
        case 0x718A: return 2074;
        case 0x718F: return 5904;
        case 0x7194: return 4183;
        case 0x7195: return 5907;
        case 0x7199: return 7807;
        case 0x719F: return 2678;
        case 0x71A8: return 5908;
        case 0x71AC: return 5909;
        case 0x71B1: return 3585;
        case 0x71B9: return 5911;
        case 0x71BE: return 5912;
        case 0x71C1: return 10929;
        case 0x71C3: return 3590;
        case 0x71C8: return 3468;
        case 0x71C9: return 5914;
        case 0x71CE: return 5916;
        case 0x71D0: return 4282;
        case 0x71D2: return 5913;
        case 0x71D4: return 5915;
        case 0x71D5: return 1580;
        case 0x71D7: return 5910;
        case 0x71DF: return 4758;
        case 0x71E0: return 5917;
        case 0x71E5: return 3078;
        case 0x71E6: return 2467;
        case 0x71E7: return 5919;
        case 0x71EC: return 5918;
        case 0x71ED: return 2823;
        case 0x71EE: return 4662;
        case 0x71F5: return 5920;
        case 0x71F9: return 5922;
        case 0x71FB: return 5905;
        case 0x71FC: return 5921;
        case 0x71FE: return 10930;
        case 0x71FF: return 5923;
        case 0x7206: return 3661;
        case 0x720D: return 5924;
        case 0x7210: return 5925;
        case 0x721B: return 5926;
        case 0x7228: return 5927;
        case 0x722A: return 3351;
        case 0x722C: return 5929;
        case 0x722D: return 5928;
        case 0x7230: return 5930;
        case 0x7232: return 5931;
        case 0x7235: return 2600;
        case 0x7236: return 3826;
        case 0x723A: return 4117;
        case 0x723B: return 5932;
        case 0x723C: return 5933;
        case 0x723D: return 3061;
        case 0x723E: return 2541;
        case 0x723F: return 5934;
        case 0x7240: return 5935;
        case 0x7246: return 5936;
        case 0x7247: return 3903;
        case 0x7248: return 3704;
        case 0x724B: return 5937;
        case 0x724C: return 3626;
        case 0x7252: return 3302;
        case 0x7258: return 5938;
        case 0x7259: return 1668;
        case 0x725B: return 1956;
        case 0x725D: return 4079;
        case 0x725F: return 4063;
        case 0x7261: return 1617;
        case 0x7262: return 4343;
        case 0x7267: return 3997;
        case 0x7269: return 3863;
        case 0x7272: return 2936;
        case 0x7274: return 5939;
        case 0x7279: return 3512;
        case 0x727D: return 2164;
        case 0x727E: return 5940;
        case 0x7280: return 2401;
        case 0x7281: return 5942;
        case 0x7282: return 5941;
        case 0x7287: return 5943;
        case 0x7292: return 5944;
        case 0x7296: return 5945;
        case 0x72A0: return 1909;
        case 0x72A2: return 5946;
        case 0x72A7: return 5947;
        case 0x72AC: return 2165;
        case 0x72AF: return 3705;
        case 0x72B1: return 10931;
        case 0x72B2: return 5949;
        case 0x72B6: return 2810;
        case 0x72B9: return 5948;
        case 0x72BE: return 10932;
        case 0x72C2: return 1997;
        case 0x72C3: return 5950;
        case 0x72C4: return 5952;
        case 0x72C6: return 5951;
        case 0x72CE: return 5953;
        case 0x72D0: return 2210;
        case 0x72D2: return 5954;
        case 0x72D7: return 2046;
        case 0x72D9: return 3039;
        case 0x72DB: return 2348;
        case 0x72E0: return 5956;
        case 0x72E1: return 5957;
        case 0x72E2: return 5955;
        case 0x72E9: return 2614;
        case 0x72EC: return 3517;
        case 0x72ED: return 1998;
        case 0x72F7: return 5959;
        case 0x72F8: return 3207;
        case 0x72F9: return 5958;
        case 0x72FC: return 4344;
        case 0x72FD: return 3637;
        case 0x730A: return 5962;
        case 0x7316: return 5964;
        case 0x7317: return 5961;
        case 0x731B: return 4093;
        case 0x731C: return 5963;
        case 0x731D: return 5965;
        case 0x731F: return 4265;
        case 0x7324: return 10933;
        case 0x7325: return 5969;
        case 0x7329: return 5968;
        case 0x732A: return 3281;
        case 0x732B: return 3584;
        case 0x732E: return 2166;
        case 0x732F: return 5967;
        case 0x7334: return 5966;
        case 0x7336: return 4152;
        case 0x7337: return 4153;
        case 0x733E: return 5970;
        case 0x733F: return 1581;
        case 0x7344: return 2341;
        case 0x7345: return 2509;
        case 0x734E: return 5971;
        case 0x734F: return 5972;
        case 0x7357: return 5974;
        case 0x7363: return 2666;
        case 0x7368: return 5976;
        case 0x736A: return 5975;
        case 0x7370: return 5977;
        case 0x7372: return 1736;
        case 0x7375: return 5979;
        case 0x7377: return 10935;
        case 0x7378: return 5978;
        case 0x737A: return 5981;
        case 0x737B: return 5980;
        case 0x7384: return 2189;
        case 0x7387: return 4237;
        case 0x7389: return 2017;
        case 0x738B: return 1603;
        case 0x7396: return 2047;
        case 0x73A9: return 1850;
        case 0x73B2: return 4301;
        case 0x73B3: return 5983;
        case 0x73BB: return 5985;
        case 0x73BD: return 10936;
        case 0x73C0: return 5986;
        case 0x73C2: return 1646;
        case 0x73C8: return 5982;
        case 0x73C9: return 10937;
        case 0x73CA: return 2468;
        case 0x73CD: return 3322;
        case 0x73CE: return 5984;
        case 0x73D2: return 10940;
        case 0x73D6: return 10938;
        case 0x73DE: return 5989;
        case 0x73E0: return 2615;
        case 0x73E3: return 10939;
        case 0x73E5: return 5987;
        case 0x73EA: return 2097;
        case 0x73ED: return 3706;
        case 0x73EE: return 5988;
        case 0x73F1: return 6015;
        case 0x73F5: return 10942;
        case 0x73F8: return 5994;
        case 0x73FE: return 2190;
        case 0x7403: return 1948;
        case 0x7405: return 5991;
        case 0x7406: return 4228;
        case 0x7407: return 10941;
        case 0x7409: return 4245;
        case 0x7422: return 3187;
        case 0x7425: return 5993;
        case 0x7426: return 10943;
        case 0x7429: return 10945;
        case 0x742A: return 10944;
        case 0x742E: return 10946;
        case 0x7432: return 5995;
        case 0x7433: return 4283;
        case 0x7434: return 2028;
        case 0x7435: return 3757;
        case 0x7436: return 3613;
        case 0x743A: return 5996;
        case 0x743F: return 5998;
        case 0x7441: return 6001;
        case 0x7455: return 5997;
        case 0x7459: return 6000;
        case 0x745A: return 2235;
        case 0x745B: return 1548;
        case 0x745C: return 6002;
        case 0x745E: return 2899;
        case 0x745F: return 5999;
        case 0x7460: return 4289;
        case 0x7462: return 10947;
        case 0x7463: return 6005;
        case 0x7464: return 7805;
        case 0x7469: return 6003;
        case 0x746A: return 6006;
        case 0x746F: return 5992;
        case 0x7470: return 6004;
        case 0x7473: return 2377;
        case 0x7476: return 6007;
        case 0x747E: return 6008;
        case 0x7483: return 4229;
        case 0x7489: return 10948;
        case 0x748B: return 6009;
        case 0x749E: return 6010;
        case 0x749F: return 10949;
        case 0x74A2: return 5990;
        case 0x74A7: return 6011;
        case 0x74B0: return 1821;
        case 0x74BD: return 2542;
        case 0x74CA: return 6012;
        case 0x74CF: return 6013;
        case 0x74D4: return 6014;
        case 0x74DC: return 1530;
        case 0x74E0: return 6016;
        case 0x74E2: return 3786;
        case 0x74E3: return 6017;
        case 0x74E6: return 1789;
        case 0x74E7: return 6018;
        case 0x74E9: return 6019;
        case 0x74EE: return 6020;
        case 0x74F0: return 6022;
        case 0x74F1: return 6023;
        case 0x74F2: return 6021;
        case 0x74F6: return 3810;
        case 0x74F7: return 6025;
        case 0x74F8: return 6024;
        case 0x7501: return 10950;
        case 0x7503: return 6027;
        case 0x7504: return 6026;
        case 0x7505: return 6028;
        case 0x750C: return 6029;
        case 0x750D: return 6031;
        case 0x750E: return 6030;
        case 0x7511: return 2344;
        case 0x7513: return 6033;
        case 0x7515: return 6032;
        case 0x7518: return 1822;
        case 0x751A: return 2870;
        case 0x751C: return 3411;
        case 0x751E: return 6034;
        case 0x751F: return 2937;
        case 0x7523: return 2469;
        case 0x7525: return 1592;
        case 0x7526: return 6035;
        case 0x7528: return 4184;
        case 0x752B: return 3920;
        case 0x752C: return 6036;
        case 0x752F: return 10819;
        case 0x7530: return 3419;
        case 0x7531: return 4154;
        case 0x7532: return 2290;
        case 0x7533: return 2848;
        case 0x7537: return 3238;
        case 0x7538: return 4625;
        case 0x753A: return 3303;
        case 0x753B: return 1669;
        case 0x753C: return 6037;
        case 0x7544: return 6038;
        case 0x7546: return 6043;
        case 0x7549: return 6041;
        case 0x754A: return 6040;
        case 0x754B: return 5391;
        case 0x754C: return 1697;
        case 0x754D: return 6039;
        case 0x754F: return 1467;
        case 0x7551: return 3675;
        case 0x7554: return 3707;
        case 0x7559: return 4246;
        case 0x755A: return 6044;
        case 0x755B: return 6042;
        case 0x755C: return 3255;
        case 0x755D: return 2919;
        case 0x7560: return 3676;
        case 0x7562: return 3772;
        case 0x7564: return 6046;
        case 0x7565: return 4241;
        case 0x7566: return 2112;
        case 0x7567: return 6047;
        case 0x7569: return 6045;
        case 0x756A: return 3719;
        case 0x756B: return 6048;
        case 0x756D: return 6049;
        case 0x756F: return 10951;
        case 0x7570: return 1468;
        case 0x7573: return 2811;
        case 0x7574: return 6054;
        case 0x7576: return 6051;
        case 0x7577: return 3554;
        case 0x7578: return 6050;
        case 0x757F: return 1885;
        case 0x7582: return 6057;
        case 0x7586: return 6052;
        case 0x7587: return 6053;
        case 0x7589: return 6056;
        case 0x758A: return 6055;
        case 0x758B: return 3764;
        case 0x758E: return 3041;
        case 0x758F: return 3040;
        case 0x7591: return 1910;
        case 0x7594: return 6058;
        case 0x759A: return 6059;
        case 0x759D: return 6060;
        case 0x75A3: return 6062;
        case 0x75A5: return 6061;
        case 0x75AB: return 1557;
        case 0x75B1: return 6070;
        case 0x75B2: return 3737;
        case 0x75B3: return 6064;
        case 0x75B5: return 6066;
        case 0x75B8: return 6068;
        case 0x75B9: return 2849;
        case 0x75BC: return 6069;
        case 0x75BD: return 6067;
        case 0x75BE: return 2569;
        case 0x75C2: return 6063;
        case 0x75C3: return 6065;
        case 0x75C5: return 3793;
        case 0x75C7: return 2766;
        case 0x75CA: return 6072;
        case 0x75CD: return 6071;
        case 0x75D2: return 6073;
        case 0x75D4: return 2543;
        case 0x75D5: return 2364;
        case 0x75D8: return 3470;
        case 0x75D9: return 6074;
        case 0x75DB: return 3332;
        case 0x75DE: return 6076;
        case 0x75E2: return 4230;
        case 0x75E3: return 6075;
        case 0x75E9: return 3080;
        case 0x75F0: return 6081;
        case 0x75F2: return 6083;
        case 0x75F3: return 6084;
        case 0x75F4: return 3247;
        case 0x75FA: return 6082;
        case 0x75FC: return 6079;
        case 0x75FE: return 6077;
        case 0x75FF: return 6078;
        case 0x7601: return 6080;
        case 0x7609: return 6087;
        case 0x760B: return 6085;
        case 0x760D: return 6086;
        case 0x761F: return 6088;
        case 0x7620: return 6090;
        case 0x7621: return 6091;
        case 0x7622: return 6092;
        case 0x7624: return 6093;
        case 0x7627: return 6089;
        case 0x7630: return 6095;
        case 0x7634: return 6094;
        case 0x763B: return 6096;
        case 0x7642: return 4266;
        case 0x7646: return 6099;
        case 0x7647: return 6097;
        case 0x7648: return 6098;
        case 0x764C: return 1851;
        case 0x7652: return 4135;
        case 0x7656: return 3895;
        case 0x7658: return 6101;
        case 0x765C: return 6100;
        case 0x7661: return 6102;
        case 0x7662: return 6103;
        case 0x7667: return 6107;
        case 0x7668: return 6104;
        case 0x7669: return 6105;
        case 0x766A: return 6106;
        case 0x766C: return 6108;
        case 0x7670: return 6109;
        case 0x7672: return 6110;
        case 0x7676: return 6111;
        case 0x7678: return 6112;
        case 0x767A: return 3680;
        case 0x767B: return 3431;
        case 0x767C: return 6113;
        case 0x767D: return 3653;
        case 0x767E: return 3779;
        case 0x7680: return 6114;
        case 0x7682: return 10952;
        case 0x7683: return 6115;
        case 0x7684: return 3393;
        case 0x7686: return 1698;
        case 0x7687: return 2291;
        case 0x7688: return 6116;
        case 0x768B: return 6117;
        case 0x768E: return 6118;
        case 0x7690: return 2452;
        case 0x7693: return 6120;
        case 0x7696: return 6119;
        case 0x7699: return 6121;
        case 0x769A: return 6122;
        case 0x769B: return 10955;
        case 0x769C: return 10953;
        case 0x769E: return 10954;
        case 0x76A6: return 10956;
        case 0x76AE: return 3738;
        case 0x76B0: return 6123;
        case 0x76B4: return 6124;
        case 0x76B7: return 7780;
        case 0x76B8: return 6125;
        case 0x76B9: return 6126;
        case 0x76BA: return 6127;
        case 0x76BF: return 2457;
        case 0x76C2: return 6128;
        case 0x76C3: return 3625;
        case 0x76C6: return 4010;
        case 0x76C8: return 1549;
        case 0x76CA: return 1558;
        case 0x76CD: return 6129;
        case 0x76D2: return 6131;
        case 0x76D6: return 6130;
        case 0x76D7: return 3463;
        case 0x76DB: return 2938;
        case 0x76DC: return 5664;
        case 0x76DE: return 6132;
        case 0x76DF: return 4074;
        case 0x76E1: return 6133;
        case 0x76E3: return 1823;
        case 0x76E4: return 3720;
        case 0x76E5: return 6134;
        case 0x76E7: return 6135;
        case 0x76EA: return 6136;
        case 0x76EE: return 4101;
        case 0x76F2: return 4094;
        case 0x76F4: return 3319;
        case 0x76F8: return 3081;
        case 0x76FB: return 6138;
        case 0x76FE: return 2697;
        case 0x7701: return 2767;
        case 0x7704: return 6141;
        case 0x7707: return 6140;
        case 0x7708: return 6139;
        case 0x7709: return 3758;
        case 0x770B: return 1824;
        case 0x770C: return 2170;
        case 0x771B: return 6147;
        case 0x771E: return 6144;
        case 0x771F: return 2850;
        case 0x7720: return 4059;
        case 0x7724: return 6143;
        case 0x7725: return 6145;
        case 0x7726: return 6146;
        case 0x7729: return 6142;
        case 0x7737: return 6148;
        case 0x7738: return 6149;
        case 0x773A: return 3304;
        case 0x773C: return 1852;
        case 0x7740: return 3264;
        case 0x7746: return 10958;
        case 0x7747: return 6150;
        case 0x775A: return 6151;
        case 0x775B: return 6154;
        case 0x7761: return 2890;
        case 0x7763: return 3513;
        case 0x7765: return 6155;
        case 0x7766: return 3998;
        case 0x7768: return 6152;
        case 0x776B: return 6153;
        case 0x7779: return 6158;
        case 0x777E: return 6157;
        case 0x777F: return 6156;
        case 0x778B: return 6160;
        case 0x778E: return 6159;
        case 0x7791: return 6161;
        case 0x779E: return 6163;
        case 0x77A0: return 6162;
        case 0x77A5: return 3898;
        case 0x77AC: return 2685;
        case 0x77AD: return 4267;
        case 0x77B0: return 6164;
        case 0x77B3: return 3500;
        case 0x77B6: return 6165;
        case 0x77B9: return 6166;
        case 0x77BB: return 6170;
        case 0x77BC: return 6168;
        case 0x77BD: return 6169;
        case 0x77BF: return 6167;
        case 0x77C7: return 6171;
        case 0x77CD: return 6172;
        case 0x77D7: return 6173;
        case 0x77DA: return 6174;
        case 0x77DB: return 4064;
        case 0x77DC: return 6175;
        case 0x77E2: return 4121;
        case 0x77E3: return 6176;
        case 0x77E5: return 3241;
        case 0x77E7: return 3645;
        case 0x77E9: return 2048;
        case 0x77ED: return 3222;
        case 0x77EE: return 6177;
        case 0x77EF: return 1999;
        case 0x77F3: return 2961;
        case 0x77FC: return 6178;
        case 0x7802: return 2378;
        case 0x780C: return 6179;
        case 0x7812: return 6180;
        case 0x7814: return 2167;
        case 0x7815: return 2402;
        case 0x7820: return 6182;
        case 0x7821: return 10960;
        case 0x7825: return 3437;
        case 0x7826: return 2403;
        case 0x7827: return 1925;
        case 0x7832: return 3951;
        case 0x7834: return 3614;
        case 0x783A: return 3438;
        case 0x783F: return 2315;
        case 0x7845: return 6184;
        case 0x784E: return 10961;
        case 0x785D: return 2768;
        case 0x7864: return 10962;
        case 0x786B: return 4247;
        case 0x786C: return 2292;
        case 0x786F: return 2168;
        case 0x7872: return 3668;
        case 0x7874: return 6186;
        case 0x787A: return 10963;
        case 0x787C: return 6188;
        case 0x7881: return 2236;
        case 0x7886: return 6187;
        case 0x7887: return 3375;
        case 0x788C: return 6190;
        case 0x788D: return 1714;
        case 0x788E: return 6185;
        case 0x7891: return 3739;
        case 0x7893: return 1519;
        case 0x7895: return 2425;
        case 0x7897: return 4373;
        case 0x789A: return 6189;
        case 0x78A3: return 6191;
        case 0x78A7: return 3896;
        case 0x78A9: return 2970;
        case 0x78AA: return 6193;
        case 0x78AF: return 6194;
        case 0x78B5: return 6192;
        case 0x78BA: return 1737;
        case 0x78BC: return 6200;
        case 0x78BE: return 6199;
        case 0x78C1: return 2544;
        case 0x78C5: return 6201;
        case 0x78C6: return 6196;
        case 0x78CA: return 6202;
        case 0x78CB: return 6197;
        case 0x78D0: return 3721;
        case 0x78D1: return 6195;
        case 0x78D4: return 6198;
        case 0x78DA: return 6205;
        case 0x78E7: return 6204;
        case 0x78E8: return 4012;
        case 0x78EC: return 6203;
        case 0x78EF: return 1484;
        case 0x78F4: return 6207;
        case 0x78FD: return 6206;
        case 0x7901: return 2769;
        case 0x7907: return 6208;
        case 0x790E: return 3042;
        case 0x7911: return 6210;
        case 0x7912: return 6209;
        case 0x7919: return 6211;
        case 0x7926: return 6181;
        case 0x792A: return 6183;
        case 0x792B: return 6213;
        case 0x792C: return 6212;
        case 0x7930: return 10964;
        case 0x793A: return 2545;
        case 0x793C: return 4302;
        case 0x793E: return 2587;
        case 0x7940: return 6214;
        case 0x7941: return 2090;
        case 0x7947: return 1911;
        case 0x7948: return 1886;
        case 0x7949: return 2510;
        case 0x7950: return 4155;
        case 0x7953: return 6220;
        case 0x7955: return 6219;
        case 0x7956: return 3043;
        case 0x7957: return 6216;
        case 0x795A: return 6218;
        case 0x795D: return 2674;
        case 0x795E: return 2851;
        case 0x795F: return 6217;
        case 0x7960: return 6215;
        case 0x7962: return 3581;
        case 0x7965: return 2770;
        case 0x7968: return 3787;
        case 0x796D: return 2404;
        case 0x7977: return 3471;
        case 0x797A: return 6221;
        case 0x797F: return 6222;
        case 0x7980: return 6244;
        case 0x7981: return 2029;
        case 0x7984: return 4352;
        case 0x7985: return 3028;
        case 0x798A: return 6223;
        case 0x798D: return 1647;
        case 0x798E: return 3376;
        case 0x798F: return 3854;
        case 0x7994: return 10968;
        case 0x799B: return 10970;
        case 0x799D: return 6224;
        case 0x79A6: return 1969;
        case 0x79A7: return 6225;
        case 0x79AA: return 6227;
        case 0x79AE: return 6228;
        case 0x79B0: return 3580;
        case 0x79B3: return 6229;
        case 0x79B9: return 6230;
        case 0x79BA: return 6231;
        case 0x79BD: return 2030;
        case 0x79BE: return 1648;
        case 0x79BF: return 3514;
        case 0x79C0: return 2639;
        case 0x79C1: return 2511;
        case 0x79C9: return 6232;
        case 0x79CB: return 2640;
        case 0x79D1: return 1639;
        case 0x79D2: return 3794;
        case 0x79D5: return 6233;
        case 0x79D8: return 3740;
        case 0x79DF: return 3044;
        case 0x79E1: return 6236;
        case 0x79E3: return 6237;
        case 0x79E4: return 3644;
        case 0x79E6: return 2852;
        case 0x79E7: return 6234;
        case 0x79E9: return 3260;
        case 0x79EC: return 6235;
        case 0x79F0: return 2771;
        case 0x79FB: return 1469;
        case 0x7A00: return 1888;
        case 0x7A08: return 6238;
        case 0x7A0B: return 3377;
        case 0x7A0D: return 6239;
        case 0x7A0E: return 2952;
        case 0x7A14: return 4054;
        case 0x7A17: return 3762;
        case 0x7A18: return 6240;
        case 0x7A19: return 6241;
        case 0x7A1A: return 3248;
        case 0x7A1C: return 4268;
        case 0x7A1F: return 6243;
        case 0x7A20: return 6242;
        case 0x7A2E: return 2616;
        case 0x7A31: return 6245;
        case 0x7A32: return 1489;
        case 0x7A37: return 6248;
        case 0x7A3B: return 6246;
        case 0x7A3C: return 1649;
        case 0x7A3D: return 2113;
        case 0x7A3E: return 6247;
        case 0x7A3F: return 2293;
        case 0x7A40: return 2337;
        case 0x7A42: return 3923;
        case 0x7A43: return 6249;
        case 0x7A46: return 3999;
        case 0x7A49: return 6251;
        case 0x7A4D: return 2962;
        case 0x7A4E: return 1550;
        case 0x7A4F: return 1623;
        case 0x7A50: return 1421;
        case 0x7A57: return 6250;
        case 0x7A61: return 6252;
        case 0x7A62: return 6253;
        case 0x7A63: return 2812;
        case 0x7A69: return 6254;
        case 0x7A6B: return 1738;
        case 0x7A70: return 6256;
        case 0x7A74: return 2141;
        case 0x7A76: return 1949;
        case 0x7A79: return 6257;
        case 0x7A7A: return 2058;
        case 0x7A7D: return 6258;
        case 0x7A7F: return 3005;
        case 0x7A81: return 3522;
        case 0x7A83: return 2977;
        case 0x7A84: return 2434;
        case 0x7A88: return 6259;
        case 0x7A92: return 3261;
        case 0x7A93: return 3082;
        case 0x7A95: return 6261;
        case 0x7A96: return 6263;
        case 0x7A97: return 6260;
        case 0x7A98: return 6262;
        case 0x7A9F: return 2069;
        case 0x7AA9: return 6264;
        case 0x7AAA: return 2073;
        case 0x7AAE: return 1950;
        case 0x7AAF: return 4185;
        case 0x7AB0: return 6266;
        case 0x7AB6: return 6267;
        case 0x7ABA: return 1517;
        case 0x7ABF: return 6270;
        case 0x7AC3: return 1777;
        case 0x7AC4: return 6269;
        case 0x7AC5: return 6268;
        case 0x7AC7: return 6272;
        case 0x7AC8: return 6265;
        case 0x7ACA: return 6273;
        case 0x7ACB: return 4238;
        case 0x7ACD: return 6274;
        case 0x7ACF: return 6275;
        case 0x7AD1: return 10971;
        case 0x7AD2: return 4877;
        case 0x7AD3: return 6277;
        case 0x7AD5: return 6276;
        case 0x7AD9: return 6278;
        case 0x7ADA: return 6279;
        case 0x7ADC: return 4250;
        case 0x7ADD: return 6280;
        case 0x7ADF: return 7504;
        case 0x7AE0: return 2772;
        case 0x7AE1: return 6281;
        case 0x7AE2: return 6282;
        case 0x7AE3: return 2686;
        case 0x7AE5: return 3501;
        case 0x7AE6: return 6283;
        case 0x7AE7: return 10972;
        case 0x7AEA: return 3203;
        case 0x7AEB: return 10974;
        case 0x7AED: return 6284;
        case 0x7AEF: return 3223;
        case 0x7AF0: return 6285;
        case 0x7AF6: return 1978;
        case 0x7AF8: return 4542;
        case 0x7AF9: return 3256;
        case 0x7AFA: return 2556;
        case 0x7AFF: return 1825;
        case 0x7B02: return 6286;
        case 0x7B04: return 6299;
        case 0x7B06: return 6289;
        case 0x7B08: return 1951;
        case 0x7B0A: return 6288;
        case 0x7B0B: return 6301;
        case 0x7B0F: return 6287;
        case 0x7B11: return 2773;
        case 0x7B18: return 6291;
        case 0x7B19: return 6292;
        case 0x7B1B: return 3394;
        case 0x7B1E: return 6293;
        case 0x7B20: return 1753;
        case 0x7B25: return 2877;
        case 0x7B26: return 3827;
        case 0x7B28: return 6295;
        case 0x7B2C: return 3173;
        case 0x7B33: return 6290;
        case 0x7B35: return 6294;
        case 0x7B36: return 6296;
        case 0x7B39: return 2440;
        case 0x7B45: return 6303;
        case 0x7B46: return 3773;
        case 0x7B48: return 3671;
        case 0x7B49: return 3472;
        case 0x7B4B: return 2031;
        case 0x7B4C: return 6302;
        case 0x7B4D: return 6300;
        case 0x7B4F: return 3686;
        case 0x7B50: return 6297;
        case 0x7B51: return 3257;
        case 0x7B52: return 3474;
        case 0x7B54: return 3473;
        case 0x7B56: return 2435;
        case 0x7B5D: return 6321;
        case 0x7B65: return 6305;
        case 0x7B67: return 6307;
        case 0x7B6C: return 6310;
        case 0x7B6E: return 6311;
        case 0x7B70: return 6308;
        case 0x7B71: return 6309;
        case 0x7B74: return 6306;
        case 0x7B75: return 6304;
        case 0x7B7A: return 6298;
        case 0x7B86: return 3900;
        case 0x7B87: return 1650;
        case 0x7B8B: return 6318;
        case 0x7B8D: return 6315;
        case 0x7B8F: return 6320;
        case 0x7B92: return 6319;
        case 0x7B94: return 3654;
        case 0x7B95: return 4048;
        case 0x7B97: return 2470;
        case 0x7B98: return 6313;
        case 0x7B99: return 6322;
        case 0x7B9A: return 6317;
        case 0x7B9C: return 6316;
        case 0x7B9D: return 6312;
        case 0x7B9E: return 10975;
        case 0x7B9F: return 6314;
        case 0x7BA1: return 1826;
        case 0x7BAA: return 3224;
        case 0x7BAD: return 3006;
        case 0x7BB1: return 3667;
        case 0x7BB4: return 6327;
        case 0x7BB8: return 3669;
        case 0x7BC0: return 2978;
        case 0x7BC1: return 6324;
        case 0x7BC4: return 3712;
        case 0x7BC6: return 6328;
        case 0x7BC7: return 3904;
        case 0x7BC9: return 3254;
        case 0x7BCB: return 6323;
        case 0x7BCC: return 6325;
        case 0x7BCF: return 6326;
        case 0x7BDD: return 6329;
        case 0x7BE0: return 2573;
        case 0x7BE4: return 3515;
        case 0x7BE5: return 6334;
        case 0x7BE6: return 6333;
        case 0x7BE9: return 6330;
        case 0x7BED: return 4345;
        case 0x7BF3: return 6339;
        case 0x7BF6: return 6343;
        case 0x7BF7: return 6340;
        case 0x7C00: return 6336;
        case 0x7C07: return 6337;
        case 0x7C0D: return 6342;
        case 0x7C11: return 6331;
        case 0x7C12: return 4658;
        case 0x7C13: return 6338;
        case 0x7C14: return 6332;
        case 0x7C17: return 6341;
        case 0x7C1F: return 6347;
        case 0x7C21: return 1827;
        case 0x7C23: return 6344;
        case 0x7C27: return 6345;
        case 0x7C2A: return 6346;
        case 0x7C2B: return 6349;
        case 0x7C37: return 6348;
        case 0x7C38: return 3751;
        case 0x7C3D: return 6350;
        case 0x7C3E: return 4321;
        case 0x7C3F: return 3930;
        case 0x7C40: return 6355;
        case 0x7C43: return 6352;
        case 0x7C4C: return 6351;
        case 0x7C4D: return 2963;
        case 0x7C4F: return 6354;
        case 0x7C50: return 6356;
        case 0x7C54: return 6353;
        case 0x7C56: return 6360;
        case 0x7C58: return 6357;
        case 0x7C5F: return 6358;
        case 0x7C60: return 6335;
        case 0x7C64: return 6359;
        case 0x7C65: return 6361;
        case 0x7C6C: return 6362;
        case 0x7C73: return 3891;
        case 0x7C75: return 6363;
        case 0x7C7E: return 4107;
        case 0x7C81: return 2019;
        case 0x7C82: return 2076;
        case 0x7C83: return 6364;
        case 0x7C89: return 3873;
        case 0x7C8B: return 2891;
        case 0x7C8D: return 4057;
        case 0x7C90: return 6365;
        case 0x7C92: return 4248;
        case 0x7C95: return 3655;
        case 0x7C97: return 3045;
        case 0x7C98: return 3591;
        case 0x7C9B: return 2676;
        case 0x7C9F: return 1441;
        case 0x7CA1: return 6370;
        case 0x7CA2: return 6368;
        case 0x7CA4: return 6366;
        case 0x7CA5: return 1786;
        case 0x7CA7: return 2774;
        case 0x7CA8: return 6371;
        case 0x7CAB: return 6369;
        case 0x7CAD: return 6367;
        case 0x7CAE: return 6375;
        case 0x7CB1: return 6374;
        case 0x7CB2: return 6373;
        case 0x7CB3: return 6372;
        case 0x7CB9: return 6376;
        case 0x7CBD: return 6377;
        case 0x7CBE: return 2939;
        case 0x7CC0: return 6378;
        case 0x7CC2: return 6380;
        case 0x7CC5: return 6379;
        case 0x7CCA: return 2211;
        case 0x7CCE: return 3031;
        case 0x7CD2: return 6382;
        case 0x7CD6: return 3475;
        case 0x7CD8: return 6381;
        case 0x7CDC: return 6383;
        case 0x7CDE: return 3874;
        case 0x7CDF: return 3083;
        case 0x7CE0: return 2294;
        case 0x7CE2: return 6384;
        case 0x7CE7: return 4269;
        case 0x7CEF: return 6386;
        case 0x7CF2: return 6387;
        case 0x7CF4: return 6388;
        case 0x7CF6: return 6389;
        case 0x7CF8: return 2512;
        case 0x7CFA: return 6390;
        case 0x7CFB: return 2114;
        case 0x7CFE: return 1953;
        case 0x7D00: return 1889;
        case 0x7D02: return 6392;
        case 0x7D04: return 4124;
        case 0x7D05: return 2295;
        case 0x7D06: return 6391;
        case 0x7D0A: return 6395;
        case 0x7D0B: return 4111;
        case 0x7D0D: return 3599;
        case 0x7D10: return 3778;
        case 0x7D14: return 2698;
        case 0x7D15: return 6394;
        case 0x7D17: return 2588;
        case 0x7D18: return 2296;
        case 0x7D19: return 2513;
        case 0x7D1A: return 1952;
        case 0x7D1B: return 3875;
        case 0x7D1C: return 6393;
        case 0x7D20: return 3046;
        case 0x7D21: return 3981;
        case 0x7D22: return 2436;
        case 0x7D2B: return 2514;
        case 0x7D2C: return 3350;
        case 0x7D2E: return 6398;
        case 0x7D2F: return 4292;
        case 0x7D30: return 2406;
        case 0x7D32: return 6399;
        case 0x7D33: return 2853;
        case 0x7D35: return 6401;
        case 0x7D39: return 2775;
        case 0x7D3A: return 2365;
        case 0x7D3F: return 6400;
        case 0x7D42: return 2641;
        case 0x7D43: return 2191;
        case 0x7D44: return 3047;
        case 0x7D45: return 6396;
        case 0x7D46: return 6402;
        case 0x7D48: return 10977;
        case 0x7D4B: return 6397;
        case 0x7D4C: return 2115;
        case 0x7D4E: return 6405;
        case 0x7D4F: return 6409;
        case 0x7D50: return 2142;
        case 0x7D56: return 6404;
        case 0x7D5B: return 6413;
        case 0x7D5C: return 10978;
        case 0x7D5E: return 2297;
        case 0x7D61: return 4212;
        case 0x7D62: return 1437;
        case 0x7D63: return 6410;
        case 0x7D66: return 1954;
        case 0x7D68: return 6407;
        case 0x7D6E: return 6408;
        case 0x7D71: return 3476;
        case 0x7D72: return 6406;
        case 0x7D73: return 6403;
        case 0x7D75: return 1699;
        case 0x7D76: return 2981;
        case 0x7D79: return 2169;
        case 0x7D7D: return 6415;
        case 0x7D89: return 6412;
        case 0x7D8F: return 6414;
        case 0x7D93: return 6411;
        case 0x7D99: return 2116;
        case 0x7D9A: return 3120;
        case 0x7D9B: return 6416;
        case 0x7D9C: return 3085;
        case 0x7D9F: return 6429;
        case 0x7DA0: return 10980;
        case 0x7DA2: return 6425;
        case 0x7DA3: return 6419;
        case 0x7DAB: return 6423;
        case 0x7DAC: return 2627;
        case 0x7DAD: return 1470;
        case 0x7DAE: return 6418;
        case 0x7DAF: return 6426;
        case 0x7DB0: return 6430;
        case 0x7DB1: return 2298;
        case 0x7DB2: return 4095;
        case 0x7DB4: return 3343;
        case 0x7DB5: return 6420;
        case 0x7DB7: return 10979;
        case 0x7DB8: return 6428;
        case 0x7DBA: return 6417;
        case 0x7DBB: return 3225;
        case 0x7DBD: return 6422;
        case 0x7DBE: return 1438;
        case 0x7DBF: return 4083;
        case 0x7DC7: return 6421;
        case 0x7DCA: return 2032;
        case 0x7DCB: return 3741;
        case 0x7DCF: return 3084;
        case 0x7DD1: return 4277;
        case 0x7DD2: return 2710;
        case 0x7DD5: return 6469;
        case 0x7DD6: return 10981;
        case 0x7DD8: return 6431;
        case 0x7DDA: return 3007;
        case 0x7DDC: return 6427;
        case 0x7DDD: return 6432;
        case 0x7DDE: return 6434;
        case 0x7DE0: return 3378;
        case 0x7DE1: return 6437;
        case 0x7DE4: return 6433;
        case 0x7DE8: return 3905;
        case 0x7DE9: return 1828;
        case 0x7DEC: return 4084;
        case 0x7DEF: return 1471;
        case 0x7DF2: return 6436;
        case 0x7DF4: return 4322;
        case 0x7DFB: return 6435;
        case 0x7E01: return 1582;
        case 0x7E04: return 3553;
        case 0x7E05: return 6438;
        case 0x7E09: return 6445;
        case 0x7E0A: return 6439;
        case 0x7E0B: return 6446;
        case 0x7E12: return 6442;
        case 0x7E1B: return 3662;
        case 0x7E1E: return 2579;
        case 0x7E1F: return 6444;
        case 0x7E21: return 6441;
        case 0x7E22: return 6447;
        case 0x7E23: return 6440;
        case 0x7E26: return 2667;
        case 0x7E2B: return 3952;
        case 0x7E2E: return 2675;
        case 0x7E31: return 6443;
        case 0x7E32: return 6455;
        case 0x7E35: return 6451;
        case 0x7E37: return 6454;
        case 0x7E39: return 6452;
        case 0x7E3A: return 6456;
        case 0x7E3B: return 6450;
        case 0x7E3D: return 6424;
        case 0x7E3E: return 2964;
        case 0x7E41: return 3708;
        case 0x7E43: return 6453;
        case 0x7E46: return 6448;
        case 0x7E4A: return 3008;
        case 0x7E4B: return 2117;
        case 0x7E4D: return 2642;
        case 0x7E52: return 10982;
        case 0x7E54: return 2824;
        case 0x7E55: return 3029;
        case 0x7E56: return 6459;
        case 0x7E59: return 6461;
        case 0x7E5A: return 6462;
        case 0x7E5D: return 6458;
        case 0x7E5E: return 6460;
        case 0x7E66: return 6449;
        case 0x7E67: return 6457;
        case 0x7E69: return 6465;
        case 0x7E6A: return 6464;
        case 0x7E6D: return 4037;
        case 0x7E70: return 2078;
        case 0x7E79: return 6463;
        case 0x7E7B: return 6467;
        case 0x7E7C: return 6466;
        case 0x7E7D: return 6470;
        case 0x7E7F: return 6472;
        case 0x7E82: return 2471;
        case 0x7E83: return 6468;
        case 0x7E88: return 6473;
        case 0x7E89: return 6474;
        case 0x7E8A: return 10744;
        case 0x7E8C: return 6475;
        case 0x7E8E: return 6481;
        case 0x7E8F: return 3410;
        case 0x7E90: return 6477;
        case 0x7E92: return 6476;
        case 0x7E93: return 6478;
        case 0x7E94: return 6479;
        case 0x7E96: return 6480;
        case 0x7E9B: return 6482;
        case 0x7E9C: return 6483;
        case 0x7F36: return 1829;
        case 0x7F38: return 6484;
        case 0x7F3A: return 6485;
        case 0x7F45: return 6486;
        case 0x7F47: return 10983;
        case 0x7F4C: return 6487;
        case 0x7F4D: return 6488;
        case 0x7F4E: return 6489;
        case 0x7F50: return 6490;
        case 0x7F51: return 6491;
        case 0x7F54: return 6493;
        case 0x7F55: return 6492;
        case 0x7F58: return 6494;
        case 0x7F5F: return 6495;
        case 0x7F60: return 6496;
        case 0x7F67: return 6499;
        case 0x7F68: return 6497;
        case 0x7F69: return 6498;
        case 0x7F6A: return 2414;
        case 0x7F6B: return 2118;
        case 0x7F6E: return 3249;
        case 0x7F70: return 3684;
        case 0x7F72: return 2711;
        case 0x7F75: return 3616;
        case 0x7F77: return 3742;
        case 0x7F78: return 6500;
        case 0x7F79: return 5246;
        case 0x7F82: return 6501;
        case 0x7F83: return 6503;
        case 0x7F85: return 4204;
        case 0x7F86: return 6502;
        case 0x7F87: return 6505;
        case 0x7F88: return 6504;
        case 0x7F8A: return 4186;
        case 0x7F8C: return 6506;
        case 0x7F8E: return 3759;
        case 0x7F94: return 6507;
        case 0x7F9A: return 6510;
        case 0x7F9D: return 6509;
        case 0x7F9E: return 6508;
        case 0x7FA1: return 10984;
        case 0x7FA3: return 6511;
        case 0x7FA4: return 2085;
        case 0x7FA8: return 3009;
        case 0x7FA9: return 1912;
        case 0x7FAE: return 6515;
        case 0x7FAF: return 6512;
        case 0x7FB2: return 6513;
        case 0x7FB6: return 6516;
        case 0x7FB8: return 6517;
        case 0x7FB9: return 6514;
        case 0x7FBD: return 1512;
        case 0x7FC1: return 1604;
        case 0x7FC5: return 6519;
        case 0x7FC6: return 6520;
        case 0x7FCA: return 6521;
        case 0x7FCC: return 4201;
        case 0x7FD2: return 2643;
        case 0x7FD4: return 6523;
        case 0x7FD5: return 6522;
        case 0x7FE0: return 2892;
        case 0x7FE1: return 6524;
        case 0x7FE6: return 6525;
        case 0x7FE9: return 6526;
        case 0x7FEB: return 1854;
        case 0x7FF0: return 1830;
        case 0x7FF3: return 6527;
        case 0x7FF9: return 6528;
        case 0x7FFB: return 4008;
        case 0x7FFC: return 4202;
        case 0x8000: return 4187;
        case 0x8001: return 4346;
        case 0x8003: return 2300;
        case 0x8004: return 6531;
        case 0x8005: return 2589;
        case 0x8006: return 6530;
        case 0x800B: return 6532;
        case 0x800C: return 2546;
        case 0x8010: return 3150;
        case 0x8012: return 6533;
        case 0x8015: return 2299;
        case 0x8017: return 4096;
        case 0x8018: return 6534;
        case 0x8019: return 6535;
        case 0x801C: return 6536;
        case 0x8021: return 6537;
        case 0x8028: return 6538;
        case 0x8033: return 2547;
        case 0x8036: return 4118;
        case 0x803B: return 6540;
        case 0x803D: return 3226;
        case 0x803F: return 6539;
        case 0x8046: return 6542;
        case 0x804A: return 6541;
        case 0x8052: return 6543;
        case 0x8056: return 2940;
        case 0x8058: return 6544;
        case 0x805A: return 6545;
        case 0x805E: return 3878;
        case 0x805F: return 6546;
        case 0x8061: return 3086;
        case 0x8062: return 6547;
        case 0x8068: return 6548;
        case 0x806F: return 4323;
        case 0x8070: return 6551;
        case 0x8072: return 6550;
        case 0x8073: return 6549;
        case 0x8074: return 3305;
        case 0x8076: return 6552;
        case 0x8077: return 2825;
        case 0x8079: return 6553;
        case 0x807D: return 6554;
        case 0x807E: return 4347;
        case 0x807F: return 6555;
        case 0x8084: return 6556;
        case 0x8085: return 6558;
        case 0x8086: return 6557;
        case 0x8087: return 3670;
        case 0x8089: return 3566;
        case 0x808B: return 4353;
        case 0x808C: return 3674;
        case 0x8093: return 6560;
        case 0x8096: return 2776;
        case 0x8098: return 3769;
        case 0x809A: return 6561;
        case 0x809B: return 6559;
        case 0x809D: return 1831;
        case 0x80A1: return 2213;
        case 0x80A2: return 2515;
        case 0x80A5: return 3743;
        case 0x80A9: return 2171;
        case 0x80AA: return 3982;
        case 0x80AC: return 6564;
        case 0x80AD: return 6562;
        case 0x80AF: return 2301;
        case 0x80B1: return 2302;
        case 0x80B2: return 1482;
        case 0x80B4: return 2421;
        case 0x80BA: return 3628;
        case 0x80C3: return 1472;
        case 0x80C4: return 6569;
        case 0x80C6: return 3227;
        case 0x80CC: return 3627;
        case 0x80CE: return 3160;
        case 0x80D6: return 6571;
        case 0x80D9: return 6567;
        case 0x80DA: return 6570;
        case 0x80DB: return 6565;
        case 0x80DD: return 6568;
        case 0x80DE: return 3953;
        case 0x80E1: return 2214;
        case 0x80E4: return 1502;
        case 0x80E5: return 6566;
        case 0x80EF: return 6573;
        case 0x80F1: return 6574;
        case 0x80F4: return 3502;
        case 0x80F8: return 2000;
        case 0x80FC: return 6585;
        case 0x80FD: return 3600;
        case 0x8102: return 2516;
        case 0x8105: return 2001;
        case 0x8106: return 2953;
        case 0x8107: return 4361;
        case 0x8108: return 4055;
        case 0x8109: return 6572;
        case 0x810A: return 2965;
        case 0x811A: return 1930;
        case 0x811B: return 6575;
        case 0x8123: return 6577;
        case 0x8129: return 6576;
        case 0x812F: return 6578;
        case 0x8131: return 3201;
        case 0x8133: return 3601;
        case 0x8139: return 3306;
        case 0x813E: return 6582;
        case 0x8146: return 6581;
        case 0x814B: return 6579;
        case 0x814E: return 2872;
        case 0x8150: return 3828;
        case 0x8151: return 6584;
        case 0x8153: return 6583;
        case 0x8154: return 2303;
        case 0x8155: return 4374;
        case 0x815F: return 6600;
        case 0x8165: return 6588;
        case 0x8166: return 6589;
        case 0x816B: return 2617;
        case 0x816E: return 6587;
        case 0x8170: return 2343;
        case 0x8171: return 6586;
        case 0x8174: return 6590;
        case 0x8178: return 3307;
        case 0x8179: return 3855;
        case 0x817A: return 3010;
        case 0x817F: return 3161;
        case 0x8180: return 6594;
        case 0x8182: return 6595;
        case 0x8183: return 6591;
        case 0x8188: return 6592;
        case 0x818A: return 6593;
        case 0x818F: return 2304;
        case 0x8193: return 6601;
        case 0x8195: return 6597;
        case 0x819A: return 3829;
        case 0x819C: return 4023;
        case 0x819D: return 3767;
        case 0x81A0: return 6596;
        case 0x81A3: return 6599;
        case 0x81A4: return 6598;
        case 0x81A8: return 3983;
        case 0x81A9: return 6602;
        case 0x81B0: return 6603;
        case 0x81B3: return 3030;
        case 0x81B5: return 6604;
        case 0x81B8: return 6606;
        case 0x81BA: return 6610;
        case 0x81BD: return 6607;
        case 0x81BE: return 6605;
        case 0x81BF: return 3602;
        case 0x81C0: return 6608;
        case 0x81C2: return 6609;
        case 0x81C6: return 1615;
        case 0x81C8: return 6616;
        case 0x81C9: return 6611;
        case 0x81CD: return 6612;
        case 0x81D1: return 6613;
        case 0x81D3: return 3102;
        case 0x81D8: return 6615;
        case 0x81D9: return 6614;
        case 0x81DA: return 6617;
        case 0x81DF: return 6618;
        case 0x81E0: return 6619;
        case 0x81E3: return 2854;
        case 0x81E5: return 1670;
        case 0x81E7: return 6620;
        case 0x81E8: return 4284;
        case 0x81EA: return 2548;
        case 0x81ED: return 2644;
        case 0x81F3: return 2517;
        case 0x81F4: return 3250;
        case 0x81FA: return 6621;
        case 0x81FB: return 6622;
        case 0x81FC: return 1520;
        case 0x81FE: return 6623;
        case 0x8201: return 6624;
        case 0x8202: return 6625;
        case 0x8205: return 6626;
        case 0x8207: return 6627;
        case 0x8208: return 2002;
        case 0x8209: return 5367;
        case 0x820A: return 6628;
        case 0x820C: return 2982;
        case 0x820D: return 6629;
        case 0x820E: return 2580;
        case 0x8210: return 6630;
        case 0x8212: return 4433;
        case 0x8216: return 6631;
        case 0x8217: return 3915;
        case 0x8218: return 1845;
        case 0x821B: return 3011;
        case 0x821C: return 2687;
        case 0x821E: return 3840;
        case 0x821F: return 2645;
        case 0x8229: return 6632;
        case 0x822A: return 2305;
        case 0x822B: return 6633;
        case 0x822C: return 3709;
        case 0x822E: return 6647;
        case 0x8233: return 6635;
        case 0x8235: return 3142;
        case 0x8236: return 3656;
        case 0x8237: return 2192;
        case 0x8238: return 6634;
        case 0x8239: return 3012;
        case 0x8240: return 6636;
        case 0x8247: return 3379;
        case 0x8258: return 6638;
        case 0x8259: return 6637;
        case 0x825A: return 6640;
        case 0x825D: return 6639;
        case 0x825F: return 6641;
        case 0x8262: return 6643;
        case 0x8264: return 6642;
        case 0x8266: return 1832;
        case 0x8268: return 6644;
        case 0x826A: return 6645;
        case 0x826B: return 6646;
        case 0x826E: return 2366;
        case 0x826F: return 4270;
        case 0x8271: return 6648;
        case 0x8272: return 2826;
        case 0x8276: return 1583;
        case 0x8277: return 6649;
        case 0x8278: return 6650;
        case 0x827E: return 6651;
        case 0x828B: return 1491;
        case 0x828D: return 6652;
        case 0x8292: return 6653;
        case 0x8299: return 3830;
        case 0x829D: return 2576;
        case 0x829F: return 6655;
        case 0x82A5: return 1700;
        case 0x82A6: return 1427;
        case 0x82AB: return 6654;
        case 0x82AC: return 6657;
        case 0x82AD: return 3617;
        case 0x82AF: return 2855;
        case 0x82B1: return 1651;
        case 0x82B3: return 3954;
        case 0x82B8: return 2128;
        case 0x82B9: return 2033;
        case 0x82BB: return 6656;
        case 0x82BD: return 1671;
        case 0x82C5: return 1788;
        case 0x82D1: return 1584;
        case 0x82D2: return 6661;
        case 0x82D3: return 4303;
        case 0x82D4: return 3162;
        case 0x82D7: return 3795;
        case 0x82D9: return 6673;
        case 0x82DB: return 1652;
        case 0x82DC: return 6671;
        case 0x82DE: return 6669;
        case 0x82DF: return 6660;
        case 0x82E1: return 6658;
        case 0x82E3: return 6659;
        case 0x82E5: return 2604;
        case 0x82E6: return 2049;
        case 0x82E7: return 3282;
        case 0x82EB: return 3526;
        case 0x82F1: return 1552;
        case 0x82F3: return 6663;
        case 0x82F4: return 6662;
        case 0x82F9: return 6668;
        case 0x82FA: return 6664;
        case 0x82FB: return 6667;
        case 0x8301: return 10986;
        case 0x8302: return 4089;
        case 0x8303: return 6666;
        case 0x8304: return 1653;
        case 0x8305: return 1784;
        case 0x8306: return 6670;
        case 0x8309: return 6672;
        case 0x830E: return 2119;
        case 0x8316: return 6676;
        case 0x8317: return 6685;
        case 0x8318: return 6686;
        case 0x831C: return 1420;
        case 0x8323: return 6693;
        case 0x8328: return 1490;
        case 0x832B: return 6684;
        case 0x832F: return 6683;
        case 0x8331: return 6678;
        case 0x8332: return 6677;
        case 0x8334: return 6675;
        case 0x8335: return 6674;
        case 0x8336: return 3262;
        case 0x8338: return 3192;
        case 0x8339: return 6680;
        case 0x8340: return 6679;
        case 0x8345: return 6682;
        case 0x8349: return 3087;
        case 0x834A: return 2120;
        case 0x834F: return 1536;
        case 0x8350: return 6681;
        case 0x8352: return 2306;
        case 0x8358: return 3088;
        case 0x8362: return 10987;
        case 0x8373: return 6699;
        case 0x8375: return 6700;
        case 0x8377: return 1654;
        case 0x837B: return 1611;
        case 0x837C: return 6697;
        case 0x837F: return 10988;
        case 0x8385: return 6687;
        case 0x8387: return 6695;
        case 0x8389: return 6702;
        case 0x838A: return 6696;
        case 0x838E: return 6694;
        case 0x8393: return 6665;
        case 0x8396: return 6692;
        case 0x839A: return 6688;
        case 0x839E: return 1833;
        case 0x839F: return 6690;
        case 0x83A0: return 6701;
        case 0x83A2: return 6691;
        case 0x83A8: return 6703;
        case 0x83AA: return 6689;
        case 0x83AB: return 3663;
        case 0x83B1: return 4208;
        case 0x83B5: return 6698;
        case 0x83BD: return 6720;
        case 0x83C1: return 6712;
        case 0x83C5: return 2910;
        case 0x83C7: return 10989;
        case 0x83CA: return 1917;
        case 0x83CC: return 2034;
        case 0x83CE: return 6707;
        case 0x83D3: return 1656;
        case 0x83D6: return 2777;
        case 0x83D8: return 6710;
        case 0x83DC: return 2407;
        case 0x83DF: return 3432;
        case 0x83E0: return 6715;
        case 0x83E9: return 3931;
        case 0x83EB: return 6706;
        case 0x83EF: return 1655;
        case 0x83F0: return 2215;
        case 0x83F1: return 3768;
        case 0x83F2: return 6716;
        case 0x83F4: return 6704;
        case 0x83F6: return 10990;
        case 0x83F7: return 6713;
        case 0x83FB: return 6723;
        case 0x83FD: return 6708;
        case 0x8403: return 6709;
        case 0x8404: return 3503;
        case 0x8407: return 6714;
        case 0x840B: return 6711;
        case 0x840C: return 3955;
        case 0x840D: return 6717;
        case 0x840E: return 1473;
        case 0x8413: return 6705;
        case 0x8420: return 6719;
        case 0x8422: return 6718;
        case 0x8429: return 3646;
        case 0x842A: return 6725;
        case 0x842C: return 6736;
        case 0x8431: return 1785;
        case 0x8435: return 6739;
        case 0x8438: return 6721;
        case 0x843C: return 6726;
        case 0x843D: return 4213;
        case 0x8446: return 6735;
        case 0x8448: return 10991;
        case 0x8449: return 4188;
        case 0x844E: return 4239;
        case 0x8457: return 3283;
        case 0x845B: return 1766;
        case 0x8461: return 3841;
        case 0x8462: return 6741;
        case 0x8463: return 3478;
        case 0x8466: return 1426;
        case 0x8469: return 6734;
        case 0x846B: return 6730;
        case 0x846C: return 3089;
        case 0x846D: return 6724;
        case 0x846E: return 6732;
        case 0x846F: return 6737;
        case 0x8471: return 3583;
        case 0x8475: return 1419;
        case 0x8477: return 6729;
        case 0x8479: return 6738;
        case 0x847A: return 3847;
        case 0x8482: return 6733;
        case 0x8484: return 6728;
        case 0x848B: return 2778;
        case 0x8490: return 2646;
        case 0x8494: return 2549;
        case 0x8499: return 4097;
        case 0x849C: return 3798;
        case 0x849F: return 6744;
        case 0x84A1: return 6753;
        case 0x84AD: return 6731;
        case 0x84B2: return 1778;
        case 0x84B4: return 10992;
        case 0x84B8: return 2813;
        case 0x84B9: return 6742;
        case 0x84BB: return 6747;
        case 0x84BC: return 3090;
        case 0x84BF: return 6743;
        case 0x84C1: return 6750;
        case 0x84C4: return 3258;
        case 0x84C6: return 6751;
        case 0x84C9: return 4189;
        case 0x84CA: return 6740;
        case 0x84CB: return 1715;
        case 0x84CD: return 6746;
        case 0x84D0: return 6749;
        case 0x84D1: return 4053;
        case 0x84D6: return 6752;
        case 0x84D9: return 6745;
        case 0x84DA: return 6748;
        case 0x84DC: return 10748;
        case 0x84EC: return 3956;
        case 0x84EE: return 4324;
        case 0x84F4: return 6756;
        case 0x84FC: return 6763;
        case 0x84FF: return 6755;
        case 0x8500: return 2572;
        case 0x8506: return 6722;
        case 0x8511: return 3899;
        case 0x8513: return 4043;
        case 0x8514: return 6762;
        case 0x8515: return 6761;
        case 0x8517: return 6757;
        case 0x8518: return 6758;
        case 0x851A: return 1525;
        case 0x851F: return 6760;
        case 0x8521: return 6754;
        case 0x8526: return 3342;
        case 0x852C: return 6759;
        case 0x852D: return 1503;
        case 0x8535: return 3103;
        case 0x853D: return 3888;
        case 0x8540: return 6764;
        case 0x8541: return 6768;
        case 0x8543: return 3722;
        case 0x8548: return 6767;
        case 0x8549: return 2779;
        case 0x854A: return 2578;
        case 0x854B: return 6770;
        case 0x854E: return 2003;
        case 0x8553: return 10993;
        case 0x8555: return 6771;
        case 0x8557: return 3848;
        case 0x8558: return 6766;
        case 0x8559: return 10994;
        case 0x855A: return 6727;
        case 0x8563: return 6765;
        case 0x8568: return 4370;
        case 0x8569: return 3479;
        case 0x856A: return 3842;
        case 0x856B: return 10995;
        case 0x856D: return 6778;
        case 0x8577: return 6784;
        case 0x857E: return 6785;
        case 0x8580: return 6772;
        case 0x8584: return 3657;
        case 0x8587: return 6782;
        case 0x8588: return 6774;
        case 0x858A: return 6776;
        case 0x8590: return 6786;
        case 0x8591: return 6775;
        case 0x8594: return 6779;
        case 0x8597: return 1585;
        case 0x8599: return 3546;
        case 0x859B: return 6780;
        case 0x859C: return 6783;
        case 0x85A4: return 6773;
        case 0x85A6: return 3013;
        case 0x85A8: return 6777;
        case 0x85A9: return 2450;
        case 0x85AA: return 2856;
        case 0x85AB: return 2083;
        case 0x85AC: return 4125;
        case 0x85AE: return 4130;
        case 0x85AF: return 2713;
        case 0x85B0: return 10997;
        case 0x85B9: return 6790;
        case 0x85BA: return 6788;
        case 0x85C1: return 4369;
        case 0x85C9: return 6787;
        case 0x85CD: return 4220;
        case 0x85CF: return 6789;
        case 0x85D0: return 6791;
        case 0x85D5: return 6792;
        case 0x85DC: return 6795;
        case 0x85DD: return 6793;
        case 0x85E4: return 3480;
        case 0x85E5: return 6794;
        case 0x85E9: return 3710;
        case 0x85EA: return 6781;
        case 0x85F7: return 2714;
        case 0x85F9: return 6796;
        case 0x85FA: return 6801;
        case 0x85FB: return 3091;
        case 0x85FE: return 6800;
        case 0x8602: return 6769;
        case 0x8606: return 6802;
        case 0x8607: return 3048;
        case 0x860A: return 6797;
        case 0x860B: return 6799;
        case 0x8613: return 6798;
        case 0x8616: return 5656;
        case 0x8617: return 5641;
        case 0x861A: return 6804;
        case 0x8622: return 6803;
        case 0x862D: return 4221;
        case 0x862F: return 6137;
        case 0x8630: return 6805;
        case 0x863F: return 6806;
        case 0x864D: return 6807;
        case 0x864E: return 2216;
        case 0x8650: return 1931;
        case 0x8654: return 6809;
        case 0x8655: return 4572;
        case 0x865A: return 1964;
        case 0x865C: return 4255;
        case 0x865E: return 2056;
        case 0x865F: return 6810;
        case 0x8667: return 6811;
        case 0x866B: return 3273;
        case 0x8671: return 6812;
        case 0x8679: return 3567;
        case 0x867B: return 1435;
        case 0x868A: return 1664;
        case 0x868B: return 6817;
        case 0x868C: return 6818;
        case 0x8693: return 6813;
        case 0x8695: return 2472;
        case 0x86A3: return 6814;
        case 0x86A4: return 3605;
        case 0x86A9: return 6815;
        case 0x86AA: return 6816;
        case 0x86AB: return 6826;
        case 0x86AF: return 6820;
        case 0x86B0: return 6823;
        case 0x86B6: return 6819;
        case 0x86C4: return 6821;
        case 0x86C6: return 6822;
        case 0x86C7: return 2593;
        case 0x86C9: return 6824;
        case 0x86CB: return 3228;
        case 0x86CD: return 2121;
        case 0x86CE: return 1725;
        case 0x86D4: return 6827;
        case 0x86D9: return 1722;
        case 0x86DB: return 6832;
        case 0x86DE: return 6828;
        case 0x86DF: return 6831;
        case 0x86E4: return 3691;
        case 0x86E9: return 6829;
        case 0x86EC: return 6830;
        case 0x86ED: return 3799;
        case 0x86EE: return 3723;
        case 0x86EF: return 6833;
        case 0x86F8: return 3194;
        case 0x86F9: return 6843;
        case 0x86FB: return 6839;
        case 0x86FE: return 1672;
        case 0x8700: return 6837;
        case 0x8702: return 3957;
        case 0x8703: return 6838;
        case 0x8706: return 6835;
        case 0x8708: return 6836;
        case 0x8709: return 6841;
        case 0x870A: return 6844;
        case 0x870D: return 6842;
        case 0x8711: return 6840;
        case 0x8712: return 6834;
        case 0x8718: return 3251;
        case 0x871A: return 6851;
        case 0x871C: return 4051;
        case 0x8725: return 6849;
        case 0x8729: return 6850;
        case 0x8734: return 6845;
        case 0x8737: return 6847;
        case 0x873B: return 6848;
        case 0x873F: return 6846;
        case 0x8749: return 2983;
        case 0x874B: return 4348;
        case 0x874C: return 6855;
        case 0x874E: return 6856;
        case 0x8753: return 6862;
        case 0x8755: return 2829;
        case 0x8757: return 6858;
        case 0x8759: return 6861;
        case 0x875F: return 6853;
        case 0x8760: return 6852;
        case 0x8763: return 6863;
        case 0x8766: return 1657;
        case 0x8768: return 6859;
        case 0x876A: return 6864;
        case 0x876E: return 6860;
        case 0x8774: return 6857;
        case 0x8776: return 3308;
        case 0x8778: return 6854;
        case 0x877F: return 3643;
        case 0x8782: return 6868;
        case 0x878D: return 4162;
        case 0x879F: return 6867;
        case 0x87A2: return 6866;
        case 0x87AB: return 6875;
        case 0x87AF: return 6869;
        case 0x87B3: return 6877;
        case 0x87BA: return 4205;
        case 0x87BB: return 6880;
        case 0x87BD: return 6871;
        case 0x87C0: return 6872;
        case 0x87C4: return 6876;
        case 0x87C6: return 6879;
        case 0x87C7: return 6878;
        case 0x87CB: return 6870;
        case 0x87D0: return 6873;
        case 0x87D2: return 6890;
        case 0x87E0: return 6883;
        case 0x87EF: return 6881;
        case 0x87F2: return 6882;
        case 0x87F6: return 6887;
        case 0x87F7: return 6888;
        case 0x87F9: return 1701;
        case 0x87FB: return 1913;
        case 0x87FE: return 6886;
        case 0x8805: return 6865;
        case 0x8807: return 11000;
        case 0x880D: return 6885;
        case 0x880E: return 6889;
        case 0x880F: return 6884;
        case 0x8811: return 6891;
        case 0x8815: return 6893;
        case 0x8816: return 6892;
        case 0x8821: return 6895;
        case 0x8822: return 6894;
        case 0x8823: return 6825;
        case 0x8827: return 6899;
        case 0x8831: return 6896;
        case 0x8836: return 6897;
        case 0x8839: return 6898;
        case 0x883B: return 6900;
        case 0x8840: return 2143;
        case 0x8842: return 6902;
        case 0x8844: return 6901;
        case 0x8846: return 2647;
        case 0x884C: return 2307;
        case 0x884D: return 5740;
        case 0x8852: return 6903;
        case 0x8853: return 2680;
        case 0x8857: return 1716;
        case 0x8859: return 6904;
        case 0x885B: return 1553;
        case 0x885D: return 2780;
        case 0x885E: return 6905;
        case 0x8861: return 2308;
        case 0x8862: return 6906;
        case 0x8863: return 1474;
        case 0x8868: return 3788;
        case 0x886B: return 6907;
        case 0x8870: return 2893;
        case 0x8872: return 6914;
        case 0x8875: return 6911;
        case 0x8877: return 3274;
        case 0x887D: return 6912;
        case 0x887E: return 6909;
        case 0x887F: return 2035;
        case 0x8881: return 6908;
        case 0x8882: return 6915;
        case 0x8888: return 2089;
        case 0x888B: return 3163;
        case 0x888D: return 6921;
        case 0x8892: return 6917;
        case 0x8896: return 3122;
        case 0x8897: return 6916;
        case 0x8899: return 6919;
        case 0x889E: return 6910;
        case 0x88A2: return 6920;
        case 0x88A4: return 6922;
        case 0x88AB: return 3744;
        case 0x88AE: return 6918;
        case 0x88B0: return 6923;
        case 0x88B1: return 6925;
        case 0x88B4: return 2212;
        case 0x88B5: return 6913;
        case 0x88B7: return 1442;
        case 0x88BF: return 6924;
        case 0x88C1: return 2408;
        case 0x88C2: return 4315;
        case 0x88C3: return 6926;
        case 0x88C4: return 6927;
        case 0x88C5: return 3092;
        case 0x88CF: return 4231;
        case 0x88D4: return 6928;
        case 0x88D5: return 4156;
        case 0x88D8: return 6929;
        case 0x88D9: return 6930;
        case 0x88DC: return 3921;
        case 0x88DD: return 6931;
        case 0x88DF: return 2381;
        case 0x88E1: return 4232;
        case 0x88E8: return 6936;
        case 0x88F2: return 6937;
        case 0x88F3: return 2781;
        case 0x88F4: return 6935;
        case 0x88F5: return 11001;
        case 0x88F8: return 4206;
        case 0x88F9: return 6932;
        case 0x88FC: return 6934;
        case 0x88FD: return 2942;
        case 0x88FE: return 2913;
        case 0x8902: return 6933;
        case 0x8904: return 6938;
        case 0x8907: return 3856;
        case 0x890A: return 6940;
        case 0x890C: return 6939;
        case 0x8910: return 1767;
        case 0x8912: return 3958;
        case 0x8913: return 6941;
        case 0x891C: return 10745;
        case 0x891D: return 6953;
        case 0x891E: return 6943;
        case 0x8925: return 6944;
        case 0x892A: return 6945;
        case 0x892B: return 6946;
        case 0x8936: return 6950;
        case 0x8938: return 6951;
        case 0x893B: return 6949;
        case 0x8941: return 6947;
        case 0x8943: return 6942;
        case 0x8944: return 6948;
        case 0x894C: return 6952;
        case 0x894D: return 7448;
        case 0x8956: return 1605;
        case 0x895E: return 6955;
        case 0x895F: return 2036;
        case 0x8960: return 6954;
        case 0x8964: return 6957;
        case 0x8966: return 6956;
        case 0x896A: return 6959;
        case 0x896D: return 6958;
        case 0x896F: return 6960;
        case 0x8972: return 2648;
        case 0x8974: return 6961;
        case 0x8977: return 6962;
        case 0x897E: return 6963;
        case 0x897F: return 2943;
        case 0x8981: return 4190;
        case 0x8983: return 6964;
        case 0x8986: return 3857;
        case 0x8987: return 3609;
        case 0x8988: return 6965;
        case 0x898A: return 6966;
        case 0x898B: return 2172;
        case 0x898F: return 1891;
        case 0x8993: return 6967;
        case 0x8996: return 2518;
        case 0x8997: return 3604;
        case 0x8998: return 6968;
        case 0x899A: return 1739;
        case 0x89A1: return 6969;
        case 0x89A6: return 6971;
        case 0x89A7: return 4222;
        case 0x89A9: return 6970;
        case 0x89AA: return 2857;
        case 0x89AC: return 6972;
        case 0x89AF: return 6973;
        case 0x89B2: return 6974;
        case 0x89B3: return 1834;
        case 0x89BA: return 6975;
        case 0x89BD: return 6976;
        case 0x89BF: return 6977;
        case 0x89C0: return 6978;
        case 0x89D2: return 1740;
        case 0x89DA: return 6979;
        case 0x89DC: return 6980;
        case 0x89DD: return 6981;
        case 0x89E3: return 1679;
        case 0x89E6: return 2827;
        case 0x89E7: return 6982;
        case 0x89F4: return 6983;
        case 0x89F8: return 6984;
        case 0x8A00: return 2193;
        case 0x8A02: return 3380;
        case 0x8A03: return 6985;
        case 0x8A08: return 2122;
        case 0x8A0A: return 2873;
        case 0x8A0C: return 6988;
        case 0x8A0E: return 3481;
        case 0x8A10: return 6987;
        case 0x8A12: return 11002;
        case 0x8A13: return 2084;
        case 0x8A16: return 6986;
        case 0x8A17: return 3188;
        case 0x8A18: return 1892;
        case 0x8A1B: return 6989;
        case 0x8A1D: return 6990;
        case 0x8A1F: return 2782;
        case 0x8A23: return 2144;
        case 0x8A25: return 6991;
        case 0x8A2A: return 3959;
        case 0x8A2D: return 2976;
        case 0x8A31: return 1965;
        case 0x8A33: return 4126;
        case 0x8A34: return 3049;
        case 0x8A36: return 6992;
        case 0x8A37: return 11003;
        case 0x8A3A: return 2858;
        case 0x8A3B: return 3275;
        case 0x8A3C: return 2783;
        case 0x8A41: return 6993;
        case 0x8A46: return 6996;
        case 0x8A48: return 6997;
        case 0x8A50: return 2379;
        case 0x8A51: return 3135;
        case 0x8A52: return 6995;
        case 0x8A54: return 2784;
        case 0x8A55: return 3789;
        case 0x8A5B: return 6994;
        case 0x8A5E: return 2519;
        case 0x8A60: return 1554;
        case 0x8A62: return 7001;
        case 0x8A63: return 2123;
        case 0x8A66: return 2521;
        case 0x8A69: return 2520;
        case 0x8A6B: return 4368;
        case 0x8A6C: return 7000;
        case 0x8A6D: return 6999;
        case 0x8A6E: return 3014;
        case 0x8A70: return 1924;
        case 0x8A71: return 4358;
        case 0x8A72: return 1717;
        case 0x8A73: return 2785;
        case 0x8A79: return 11004;
        case 0x8A7C: return 6998;
        case 0x8A82: return 7003;
        case 0x8A84: return 7004;
        case 0x8A85: return 7002;
        case 0x8A87: return 2217;
        case 0x8A89: return 4167;
        case 0x8A8C: return 2522;
        case 0x8A8D: return 3578;
        case 0x8A91: return 7007;
        case 0x8A93: return 2945;
        case 0x8A95: return 3229;
        case 0x8A98: return 4157;
        case 0x8A9A: return 7010;
        case 0x8A9E: return 2237;
        case 0x8AA0: return 2944;
        case 0x8AA1: return 7006;
        case 0x8AA3: return 7011;
        case 0x8AA4: return 2238;
        case 0x8AA5: return 7008;
        case 0x8AA6: return 7009;
        case 0x8AA7: return 11005;
        case 0x8AA8: return 7005;
        case 0x8AAC: return 2979;
        case 0x8AAD: return 3518;
        case 0x8AB0: return 3210;
        case 0x8AB2: return 1658;
        case 0x8AB9: return 3745;
        case 0x8ABC: return 1914;
        case 0x8ABE: return 11006;
        case 0x8ABF: return 3309;
        case 0x8AC2: return 7014;
        case 0x8AC4: return 7012;
        case 0x8AC7: return 3239;
        case 0x8ACB: return 2946;
        case 0x8ACC: return 1835;
        case 0x8ACD: return 7013;
        case 0x8ACF: return 2878;
        case 0x8AD2: return 4271;
        case 0x8AD6: return 4355;
        case 0x8ADA: return 7015;
        case 0x8ADB: return 7026;
        case 0x8ADC: return 3310;
        case 0x8ADE: return 7025;
        case 0x8ADF: return 11007;
        case 0x8AE0: return 7022;
        case 0x8AE1: return 7030;
        case 0x8AE2: return 7023;
        case 0x8AE4: return 7019;
        case 0x8AE6: return 3381;
        case 0x8AE7: return 7018;
        case 0x8AEB: return 7016;
        case 0x8AED: return 4136;
        case 0x8AEE: return 2523;
        case 0x8AF1: return 7020;
        case 0x8AF3: return 7017;
        case 0x8AF6: return 11009;
        case 0x8AF7: return 7024;
        case 0x8AF8: return 2715;
        case 0x8AFA: return 2194;
        case 0x8AFE: return 3191;
        case 0x8B00: return 3984;
        case 0x8B01: return 1561;
        case 0x8B02: return 1475;
        case 0x8B04: return 3482;
        case 0x8B07: return 7028;
        case 0x8B0C: return 7027;
        case 0x8B0E: return 3547;
        case 0x8B10: return 7032;
        case 0x8B14: return 7021;
        case 0x8B16: return 7031;
        case 0x8B17: return 7033;
        case 0x8B19: return 2173;
        case 0x8B1A: return 7029;
        case 0x8B1B: return 2309;
        case 0x8B1D: return 2590;
        case 0x8B20: return 7034;
        case 0x8B21: return 4191;
        case 0x8B26: return 7037;
        case 0x8B28: return 7040;
        case 0x8B2B: return 7038;
        case 0x8B2C: return 3780;
        case 0x8B33: return 7035;
        case 0x8B39: return 2037;
        case 0x8B3E: return 7039;
        case 0x8B41: return 7041;
        case 0x8B49: return 7045;
        case 0x8B4C: return 7042;
        case 0x8B4E: return 7044;
        case 0x8B4F: return 7043;
        case 0x8B53: return 11010;
        case 0x8B56: return 7046;
        case 0x8B58: return 2554;
        case 0x8B5A: return 7048;
        case 0x8B5B: return 7047;
        case 0x8B5C: return 3831;
        case 0x8B5F: return 7050;
        case 0x8B66: return 2124;
        case 0x8B6B: return 7049;
        case 0x8B6C: return 7051;
        case 0x8B6F: return 7052;
        case 0x8B70: return 1915;
        case 0x8B71: return 6518;
        case 0x8B72: return 2814;
        case 0x8B74: return 7053;
        case 0x8B77: return 2239;
        case 0x8B7D: return 7054;
        case 0x8B7F: return 11011;
        case 0x8B80: return 7055;
        case 0x8B83: return 2473;
        case 0x8B8A: return 5403;
        case 0x8B8C: return 7056;
        case 0x8B8E: return 7057;
        case 0x8B90: return 2649;
        case 0x8B92: return 7058;
        case 0x8B93: return 7059;
        case 0x8B96: return 7060;
        case 0x8B99: return 7061;
        case 0x8B9A: return 7062;
        case 0x8C37: return 3206;
        case 0x8C3A: return 7063;
        case 0x8C3F: return 7065;
        case 0x8C41: return 7064;
        case 0x8C46: return 3483;
        case 0x8C48: return 7066;
        case 0x8C4A: return 3960;
        case 0x8C4C: return 7067;
        case 0x8C4E: return 7068;
        case 0x8C50: return 7069;
        case 0x8C55: return 7070;
        case 0x8C5A: return 3535;
        case 0x8C61: return 2786;
        case 0x8C62: return 7071;
        case 0x8C6A: return 2330;
        case 0x8C6B: return 4431;
        case 0x8C6C: return 7072;
        case 0x8C78: return 7073;
        case 0x8C79: return 3790;
        case 0x8C7A: return 7074;
        case 0x8C7C: return 7082;
        case 0x8C82: return 7075;
        case 0x8C85: return 7077;
        case 0x8C89: return 7076;
        case 0x8C8A: return 7078;
        case 0x8C8C: return 3985;
        case 0x8C8D: return 7079;
        case 0x8C8E: return 7080;
        case 0x8C94: return 7081;
        case 0x8C98: return 7083;
        case 0x8C9D: return 1704;
        case 0x8C9E: return 3360;
        case 0x8CA0: return 3832;
        case 0x8CA1: return 2415;
        case 0x8CA2: return 2310;
        case 0x8CA7: return 3806;
        case 0x8CA8: return 1660;
        case 0x8CA9: return 3711;
        case 0x8CAA: return 7086;
        case 0x8CAB: return 1836;
        case 0x8CAC: return 2966;
        case 0x8CAD: return 7085;
        case 0x8CAE: return 7090;
        case 0x8CAF: return 3284;
        case 0x8CB0: return 4108;
        case 0x8CB2: return 7088;
        case 0x8CB3: return 7089;
        case 0x8CB4: return 1893;
        case 0x8CB6: return 7091;
        case 0x8CB7: return 3638;
        case 0x8CB8: return 3164;
        case 0x8CBB: return 3746;
        case 0x8CBC: return 3412;
        case 0x8CBD: return 7087;
        case 0x8CBF: return 3986;
        case 0x8CC0: return 1673;
        case 0x8CC1: return 7093;
        case 0x8CC2: return 4331;
        case 0x8CC3: return 3323;
        case 0x8CC4: return 4360;
        case 0x8CC7: return 2524;
        case 0x8CC8: return 7092;
        case 0x8CCA: return 3118;
        case 0x8CCD: return 7109;
        case 0x8CCE: return 3015;
        case 0x8CD1: return 3565;
        case 0x8CD3: return 3807;
        case 0x8CDA: return 7096;
        case 0x8CDB: return 2474;
        case 0x8CDC: return 2525;
        case 0x8CDE: return 2787;
        case 0x8CE0: return 3640;
        case 0x8CE2: return 2174;
        case 0x8CE3: return 7095;
        case 0x8CE4: return 7094;
        case 0x8CE6: return 3833;
        case 0x8CEA: return 2570;
        case 0x8CED: return 3433;
        case 0x8CF0: return 11012;
        case 0x8CF4: return 11013;
        case 0x8CFA: return 7098;
        case 0x8CFB: return 7099;
        case 0x8CFC: return 2311;
        case 0x8CFD: return 7097;
        case 0x8D04: return 7100;
        case 0x8D05: return 7101;
        case 0x8D07: return 7103;
        case 0x8D08: return 3104;
        case 0x8D0A: return 7102;
        case 0x8D0B: return 1855;
        case 0x8D0D: return 7105;
        case 0x8D0F: return 7104;
        case 0x8D10: return 7106;
        case 0x8D12: return 11014;
        case 0x8D13: return 7108;
        case 0x8D14: return 7110;
        case 0x8D16: return 7111;
        case 0x8D64: return 2967;
        case 0x8D66: return 2584;
        case 0x8D67: return 7112;
        case 0x8D6B: return 1741;
        case 0x8D6D: return 7113;
        case 0x8D70: return 3093;
        case 0x8D71: return 7114;
        case 0x8D73: return 7115;
        case 0x8D74: return 3834;
        case 0x8D76: return 11015;
        case 0x8D77: return 1894;
        case 0x8D81: return 7116;
        case 0x8D85: return 3311;
        case 0x8D8A: return 1562;
        case 0x8D99: return 7117;
        case 0x8DA3: return 2618;
        case 0x8DA8: return 2905;
        case 0x8DB3: return 3114;
        case 0x8DBA: return 7120;
        case 0x8DBE: return 7119;
        case 0x8DC2: return 7118;
        case 0x8DCB: return 7126;
        case 0x8DCC: return 7124;
        case 0x8DCF: return 7121;
        case 0x8DD6: return 7123;
        case 0x8DDA: return 7122;
        case 0x8DDB: return 7125;
        case 0x8DDD: return 1966;
        case 0x8DDF: return 7129;
        case 0x8DE1: return 2968;
        case 0x8DE3: return 7130;
        case 0x8DE8: return 2218;
        case 0x8DEA: return 7127;
        case 0x8DEB: return 7128;
        case 0x8DEF: return 4332;
        case 0x8DF3: return 3312;
        case 0x8DF5: return 3016;
        case 0x8DFC: return 7131;
        case 0x8DFF: return 7134;
        case 0x8E08: return 7132;
        case 0x8E09: return 7133;
        case 0x8E0A: return 4192;
        case 0x8E0F: return 3484;
        case 0x8E10: return 7137;
        case 0x8E1D: return 7135;
        case 0x8E1E: return 7136;
        case 0x8E1F: return 7138;
        case 0x8E2A: return 7152;
        case 0x8E30: return 7141;
        case 0x8E34: return 7142;
        case 0x8E35: return 7140;
        case 0x8E42: return 7139;
        case 0x8E44: return 3382;
        case 0x8E47: return 7144;
        case 0x8E48: return 7148;
        case 0x8E49: return 7145;
        case 0x8E4A: return 7143;
        case 0x8E4C: return 7146;
        case 0x8E50: return 7147;
        case 0x8E55: return 7154;
        case 0x8E59: return 7149;
        case 0x8E5F: return 2969;
        case 0x8E60: return 7151;
        case 0x8E63: return 7153;
        case 0x8E64: return 7150;
        case 0x8E72: return 7156;
        case 0x8E74: return 2650;
        case 0x8E76: return 7155;
        case 0x8E7C: return 7157;
        case 0x8E81: return 7158;
        case 0x8E84: return 7161;
        case 0x8E85: return 7160;
        case 0x8E87: return 7159;
        case 0x8E8A: return 7163;
        case 0x8E8B: return 7162;
        case 0x8E8D: return 4127;
        case 0x8E91: return 7165;
        case 0x8E93: return 7164;
        case 0x8E94: return 7166;
        case 0x8E99: return 7167;
        case 0x8EA1: return 7169;
        case 0x8EAA: return 7168;
        case 0x8EAB: return 2859;
        case 0x8EAC: return 7170;
        case 0x8EAF: return 2050;
        case 0x8EB0: return 7171;
        case 0x8EB1: return 7173;
        case 0x8EBE: return 7174;
        case 0x8EC5: return 7175;
        case 0x8EC6: return 7172;
        case 0x8EC8: return 7176;
        case 0x8ECA: return 2591;
        case 0x8ECB: return 7177;
        case 0x8ECC: return 1895;
        case 0x8ECD: return 2086;
        case 0x8ECF: return 11017;
        case 0x8ED2: return 2175;
        case 0x8EDB: return 7178;
        case 0x8EDF: return 3557;
        case 0x8EE2: return 3413;
        case 0x8EE3: return 7179;
        case 0x8EEB: return 7182;
        case 0x8EF8: return 2557;
        case 0x8EFB: return 7181;
        case 0x8EFC: return 7180;
        case 0x8EFD: return 2125;
        case 0x8EFE: return 7183;
        case 0x8F03: return 1742;
        case 0x8F05: return 7185;
        case 0x8F09: return 2409;
        case 0x8F0A: return 7184;
        case 0x8F0C: return 7193;
        case 0x8F12: return 7187;
        case 0x8F13: return 7189;
        case 0x8F14: return 3922;
        case 0x8F15: return 7186;
        case 0x8F19: return 7188;
        case 0x8F1B: return 7192;
        case 0x8F1C: return 7190;
        case 0x8F1D: return 1896;
        case 0x8F1F: return 7191;
        case 0x8F26: return 7194;
        case 0x8F29: return 3629;
        case 0x8F2A: return 4285;
        case 0x8F2F: return 2651;
        case 0x8F33: return 7195;
        case 0x8F38: return 4137;
        case 0x8F39: return 7197;
        case 0x8F3B: return 7196;
        case 0x8F3E: return 7200;
        case 0x8F3F: return 4168;
        case 0x8F42: return 7199;
        case 0x8F44: return 1768;
        case 0x8F45: return 7198;
        case 0x8F46: return 7203;
        case 0x8F49: return 7202;
        case 0x8F4C: return 7201;
        case 0x8F4D: return 3401;
        case 0x8F4E: return 7204;
        case 0x8F57: return 7205;
        case 0x8F5C: return 7206;
        case 0x8F5F: return 2331;
        case 0x8F61: return 2072;
        case 0x8F62: return 7207;
        case 0x8F63: return 7208;
        case 0x8F64: return 7209;
        case 0x8F9B: return 2860;
        case 0x8F9C: return 7210;
        case 0x8F9E: return 2550;
        case 0x8F9F: return 7211;
        case 0x8FA3: return 7212;
        case 0x8FA7: return 4606;
        case 0x8FA8: return 4605;
        case 0x8FAD: return 7213;
        case 0x8FAE: return 6471;
        case 0x8FAF: return 7214;
        case 0x8FB0: return 3199;
        case 0x8FB1: return 2830;
        case 0x8FB2: return 3603;
        case 0x8FB7: return 7215;
        case 0x8FBA: return 3906;
        case 0x8FBB: return 3341;
        case 0x8FBC: return 2349;
        case 0x8FBF: return 3204;
        case 0x8FC2: return 1513;
        case 0x8FC4: return 4035;
        case 0x8FC5: return 2874;
        case 0x8FCE: return 2129;
        case 0x8FD1: return 2038;
        case 0x8FD4: return 3907;
        case 0x8FDA: return 7216;
        case 0x8FE2: return 7218;
        case 0x8FE5: return 7217;
        case 0x8FE6: return 1661;
        case 0x8FE9: return 3563;
        case 0x8FEA: return 7219;
        case 0x8FEB: return 3658;
        case 0x8FED: return 3402;
        case 0x8FEF: return 7220;
        case 0x8FF0: return 2681;
        case 0x8FF4: return 7222;
        case 0x8FF7: return 4075;
        case 0x8FF8: return 7237;
        case 0x8FF9: return 7224;
        case 0x8FFA: return 7225;
        case 0x8FFD: return 3330;
        case 0x9000: return 3165;
        case 0x9001: return 3094;
        case 0x9003: return 3485;
        case 0x9005: return 7223;
        case 0x9006: return 1932;
        case 0x900B: return 7232;
        case 0x900D: return 7229;
        case 0x900E: return 7242;
        case 0x900F: return 3486;
        case 0x9010: return 3259;
        case 0x9011: return 7226;
        case 0x9013: return 3383;
        case 0x9014: return 3434;
        case 0x9015: return 7227;
        case 0x9016: return 7231;
        case 0x9017: return 2883;
        case 0x9019: return 3642;
        case 0x901A: return 3333;
        case 0x901D: return 2947;
        case 0x901E: return 7230;
        case 0x901F: return 3115;
        case 0x9020: return 3105;
        case 0x9021: return 7228;
        case 0x9022: return 1418;
        case 0x9023: return 4325;
        case 0x9027: return 7233;
        case 0x902E: return 3166;
        case 0x9031: return 2652;
        case 0x9032: return 2861;
        case 0x9035: return 7235;
        case 0x9036: return 7234;
        case 0x9038: return 1488;
        case 0x9039: return 7236;
        case 0x903C: return 3774;
        case 0x903E: return 7244;
        case 0x9041: return 3536;
        case 0x9042: return 2894;
        case 0x9045: return 3252;
        case 0x9047: return 2061;
        case 0x9049: return 7243;
        case 0x904A: return 4158;
        case 0x904B: return 1534;
        case 0x904D: return 3908;
        case 0x904E: return 1662;
        case 0x904F: return 7238;
        case 0x9050: return 7239;
        case 0x9051: return 7240;
        case 0x9052: return 7241;
        case 0x9053: return 3504;
        case 0x9054: return 3198;
        case 0x9055: return 1476;
        case 0x9056: return 7245;
        case 0x9058: return 7246;
        case 0x9059: return 7804;
        case 0x905C: return 3130;
        case 0x905E: return 7247;
        case 0x9060: return 1586;
        case 0x9061: return 3051;
        case 0x9063: return 2176;
        case 0x9065: return 4193;
        case 0x9067: return 11020;
        case 0x9068: return 7248;
        case 0x9069: return 3395;
        case 0x906D: return 3095;
        case 0x906E: return 2592;
        case 0x906F: return 7249;
        case 0x9072: return 7252;
        case 0x9075: return 2700;
        case 0x9076: return 7250;
        case 0x9077: return 3018;
        case 0x9078: return 3017;
        case 0x907A: return 1477;
        case 0x907C: return 4272;
        case 0x907D: return 7254;
        case 0x907F: return 3747;
        case 0x9080: return 7256;
        case 0x9081: return 7255;
        case 0x9082: return 7253;
        case 0x9083: return 6271;
        case 0x9084: return 1837;
        case 0x9087: return 7221;
        case 0x9089: return 7258;
        case 0x908A: return 7257;
        case 0x908F: return 7259;
        case 0x9091: return 4159;
        case 0x90A3: return 3542;
        case 0x90A6: return 3961;
        case 0x90A8: return 7260;
        case 0x90AA: return 2594;
        case 0x90AF: return 7261;
        case 0x90B1: return 7262;
        case 0x90B5: return 7263;
        case 0x90B8: return 3384;
        case 0x90C1: return 1483;
        case 0x90CA: return 2312;
        case 0x90CE: return 4349;
        case 0x90DB: return 7267;
        case 0x90DE: return 11021;
        case 0x90E1: return 2087;
        case 0x90E2: return 7264;
        case 0x90E4: return 7265;
        case 0x90E8: return 3843;
        case 0x90ED: return 1743;
        case 0x90F5: return 4160;
        case 0x90F7: return 2004;
        case 0x90FD: return 3435;
        case 0x9102: return 7268;
        case 0x9112: return 7269;
        case 0x9115: return 11023;
        case 0x9119: return 7270;
        case 0x9127: return 11024;
        case 0x912D: return 3385;
        case 0x9130: return 7272;
        case 0x9132: return 7271;
        case 0x9149: return 3528;
        case 0x914A: return 7273;
        case 0x914B: return 2653;
        case 0x914C: return 2601;
        case 0x914D: return 3630;
        case 0x914E: return 3276;
        case 0x9152: return 2619;
        case 0x9154: return 2895;
        case 0x9156: return 7274;
        case 0x9158: return 7275;
        case 0x9162: return 2880;
        case 0x9163: return 7276;
        case 0x9165: return 7277;
        case 0x9169: return 7278;
        case 0x916A: return 4214;
        case 0x916C: return 2654;
        case 0x9172: return 7280;
        case 0x9173: return 7279;
        case 0x9175: return 2313;
        case 0x9177: return 2338;
        case 0x9178: return 2475;
        case 0x9182: return 7283;
        case 0x9187: return 2701;
        case 0x9189: return 7282;
        case 0x918B: return 7281;
        case 0x918D: return 3174;
        case 0x9190: return 2240;
        case 0x9192: return 2948;
        case 0x9197: return 3681;
        case 0x919C: return 2656;
        case 0x91A2: return 7284;
        case 0x91A4: return 2788;
        case 0x91AA: return 7287;
        case 0x91AB: return 7285;
        case 0x91AF: return 7286;
        case 0x91B4: return 7289;
        case 0x91B5: return 7288;
        case 0x91B8: return 2815;
        case 0x91BA: return 7290;
        case 0x91C0: return 7291;
        case 0x91C1: return 7292;
        case 0x91C6: return 3713;
        case 0x91C7: return 2400;
        case 0x91C8: return 2602;
        case 0x91C9: return 7293;
        case 0x91CB: return 7294;
        case 0x91CC: return 4233;
        case 0x91CD: return 2668;
        case 0x91CE: return 4119;
        case 0x91CF: return 4273;
        case 0x91D0: return 7295;
        case 0x91D1: return 2039;
        case 0x91D6: return 7296;
        case 0x91D7: return 11026;
        case 0x91D8: return 3386;
        case 0x91DA: return 11025;
        case 0x91DB: return 7299;
        case 0x91DC: return 1779;
        case 0x91DD: return 2862;
        case 0x91DE: return 11027;
        case 0x91DF: return 7297;
        case 0x91E1: return 7298;
        case 0x91E3: return 3353;
        case 0x91E4: return 11030;
        case 0x91E5: return 11031;
        case 0x91E6: return 4000;
        case 0x91E7: return 2065;
        case 0x91ED: return 11028;
        case 0x91EE: return 11029;
        case 0x91F5: return 7301;
        case 0x91F6: return 7302;
        case 0x91FC: return 7300;
        case 0x91FF: return 7304;
        case 0x9206: return 11032;
        case 0x920A: return 11034;
        case 0x920D: return 3540;
        case 0x920E: return 1726;
        case 0x9210: return 11033;
        case 0x9211: return 7308;
        case 0x9214: return 7305;
        case 0x9215: return 7307;
        case 0x921E: return 7303;
        case 0x9229: return 7378;
        case 0x922C: return 7306;
        case 0x9234: return 4304;
        case 0x9237: return 2219;
        case 0x9239: return 11041;
        case 0x923A: return 11035;
        case 0x923C: return 11037;
        case 0x923F: return 7316;
        case 0x9240: return 11036;
        case 0x9244: return 3403;
        case 0x9245: return 7311;
        case 0x9248: return 7314;
        case 0x9249: return 7312;
        case 0x924B: return 7317;
        case 0x924E: return 11038;
        case 0x9250: return 7318;
        case 0x9251: return 11040;
        case 0x9257: return 7310;
        case 0x9259: return 11039;
        case 0x925A: return 7323;
        case 0x925B: return 1587;
        case 0x925E: return 7309;
        case 0x9262: return 3678;
        case 0x9264: return 7313;
        case 0x9266: return 2789;
        case 0x9267: return 11042;
        case 0x9271: return 2314;
        case 0x9277: return 11044;
        case 0x9278: return 11045;
        case 0x927E: return 3987;
        case 0x9280: return 2041;
        case 0x9283: return 2669;
        case 0x9285: return 3505;
        case 0x9288: return 10747;
        case 0x9291: return 3020;
        case 0x9293: return 7321;
        case 0x9295: return 7315;
        case 0x9296: return 7320;
        case 0x9298: return 4076;
        case 0x929A: return 3313;
        case 0x929B: return 7322;
        case 0x929C: return 7319;
        case 0x92A7: return 11043;
        case 0x92AD: return 3019;
        case 0x92B7: return 7326;
        case 0x92B9: return 7325;
        case 0x92CF: return 7324;
        case 0x92D0: return 11049;
        case 0x92D2: return 3962;
        case 0x92D3: return 11053;
        case 0x92D5: return 11051;
        case 0x92D7: return 11047;
        case 0x92D9: return 11048;
        case 0x92E0: return 11052;
        case 0x92E4: return 2722;
        case 0x92E7: return 11046;
        case 0x92E9: return 7327;
        case 0x92EA: return 3916;
        case 0x92ED: return 1555;
        case 0x92F2: return 3797;
        case 0x92F3: return 3277;
        case 0x92F8: return 1967;
        case 0x92F9: return 10753;
        case 0x92FA: return 7329;
        case 0x92FB: return 11056;
        case 0x92FC: return 2316;
        case 0x92FF: return 11059;
        case 0x9302: return 11061;
        case 0x9306: return 2455;
        case 0x930F: return 7328;
        case 0x9310: return 2896;
        case 0x9318: return 2897;
        case 0x9319: return 7332;
        case 0x931A: return 7334;
        case 0x931D: return 11060;
        case 0x931E: return 11058;
        case 0x9320: return 2816;
        case 0x9321: return 11055;
        case 0x9322: return 7333;
        case 0x9323: return 7335;
        case 0x9325: return 11054;
        case 0x9326: return 2024;
        case 0x9328: return 3796;
        case 0x932B: return 2603;
        case 0x932C: return 4326;
        case 0x932E: return 7331;
        case 0x932F: return 2437;
        case 0x9332: return 4354;
        case 0x9335: return 7337;
        case 0x933A: return 7336;
        case 0x933B: return 7338;
        case 0x9344: return 7330;
        case 0x9348: return 10746;
        case 0x934B: return 3550;
        case 0x934D: return 3436;
        case 0x9354: return 3344;
        case 0x9356: return 7343;
        case 0x9357: return 11063;
        case 0x935B: return 3230;
        case 0x935C: return 7339;
        case 0x9360: return 7340;
        case 0x936C: return 2080;
        case 0x936E: return 7342;
        case 0x9370: return 11062;
        case 0x9375: return 2177;
        case 0x937C: return 7341;
        case 0x937E: return 2790;
        case 0x938C: return 1780;
        case 0x9394: return 7347;
        case 0x9396: return 2380;
        case 0x9397: return 3096;
        case 0x939A: return 3331;
        case 0x93A4: return 11064;
        case 0x93A7: return 1718;
        case 0x93AC: return 7345;
        case 0x93AD: return 7346;
        case 0x93AE: return 3324;
        case 0x93B0: return 7344;
        case 0x93B9: return 7348;
        case 0x93C3: return 7354;
        case 0x93C6: return 11065;
        case 0x93C8: return 7357;
        case 0x93D0: return 7356;
        case 0x93D1: return 3396;
        case 0x93D6: return 7349;
        case 0x93D7: return 7350;
        case 0x93D8: return 7353;
        case 0x93DD: return 7355;
        case 0x93DE: return 11066;
        case 0x93E1: return 2005;
        case 0x93E4: return 7358;
        case 0x93E5: return 7352;
        case 0x93E8: return 7351;
        case 0x93F8: return 11067;
        case 0x9403: return 7362;
        case 0x9407: return 7363;
        case 0x9410: return 7364;
        case 0x9413: return 7361;
        case 0x9414: return 7360;
        case 0x9418: return 2791;
        case 0x9419: return 3487;
        case 0x941A: return 7359;
        case 0x9421: return 7368;
        case 0x942B: return 7366;
        case 0x9431: return 11068;
        case 0x9435: return 7367;
        case 0x9436: return 7365;
        case 0x9438: return 3189;
        case 0x943A: return 7369;
        case 0x9441: return 7370;
        case 0x9444: return 7372;
        case 0x9445: return 11069;
        case 0x9448: return 11070;
        case 0x9451: return 1838;
        case 0x9452: return 7371;
        case 0x9453: return 4131;
        case 0x945A: return 7383;
        case 0x945B: return 7373;
        case 0x945E: return 7376;
        case 0x9460: return 7374;
        case 0x9462: return 7375;
        case 0x946A: return 7377;
        case 0x9470: return 7379;
        case 0x9475: return 7380;
        case 0x9477: return 7381;
        case 0x947C: return 7384;
        case 0x947D: return 7382;
        case 0x947E: return 7385;
        case 0x947F: return 7387;
        case 0x9481: return 7386;
        case 0x9577: return 3314;
        case 0x9580: return 4112;
        case 0x9582: return 7388;
        case 0x9583: return 3021;
        case 0x9587: return 7389;
        case 0x9589: return 3889;
        case 0x958A: return 7390;
        case 0x958B: return 1702;
        case 0x958F: return 1531;
        case 0x9591: return 1840;
        case 0x9592: return 11071;
        case 0x9593: return 1839;
        case 0x9594: return 7391;
        case 0x9596: return 7392;
        case 0x9598: return 7393;
        case 0x9599: return 7394;
        case 0x95A0: return 7395;
        case 0x95A2: return 1841;
        case 0x95A3: return 1744;
        case 0x95A4: return 2317;
        case 0x95A5: return 3687;
        case 0x95A7: return 7397;
        case 0x95A8: return 7396;
        case 0x95AD: return 7398;
        case 0x95B2: return 1563;
        case 0x95B9: return 7401;
        case 0x95BB: return 7400;
        case 0x95BC: return 7399;
        case 0x95BE: return 7402;
        case 0x95C3: return 7405;
        case 0x95C7: return 1448;
        case 0x95CA: return 7403;
        case 0x95CC: return 7407;
        case 0x95CD: return 7406;
        case 0x95D4: return 7409;
        case 0x95D5: return 7408;
        case 0x95D6: return 7410;
        case 0x95D8: return 3491;
        case 0x95DC: return 7411;
        case 0x95E1: return 7412;
        case 0x95E2: return 7414;
        case 0x95E5: return 7413;
        case 0x961C: return 3835;
        case 0x9621: return 7415;
        case 0x9628: return 7416;
        case 0x962A: return 2418;
        case 0x962E: return 7417;
        case 0x962F: return 7418;
        case 0x9632: return 3988;
        case 0x963B: return 3050;
        case 0x963F: return 1413;
        case 0x9640: return 3144;
        case 0x9642: return 7419;
        case 0x9644: return 3836;
        case 0x964B: return 7422;
        case 0x964C: return 7420;
        case 0x964D: return 2318;
        case 0x964F: return 7421;
        case 0x9650: return 2195;
        case 0x965B: return 3890;
        case 0x965C: return 7424;
        case 0x965D: return 7426;
        case 0x965E: return 7425;
        case 0x965F: return 7427;
        case 0x9662: return 1504;
        case 0x9663: return 2875;
        case 0x9664: return 2723;
        case 0x9665: return 1842;
        case 0x9666: return 7428;
        case 0x966A: return 3641;
        case 0x966C: return 7430;
        case 0x9670: return 1505;
        case 0x9672: return 7429;
        case 0x9673: return 3325;
        case 0x9675: return 4274;
        case 0x9676: return 3488;
        case 0x9677: return 7423;
        case 0x9678: return 4235;
        case 0x967A: return 2178;
        case 0x967D: return 4194;
        case 0x9685: return 2062;
        case 0x9686: return 4249;
        case 0x9688: return 2075;
        case 0x968A: return 3167;
        case 0x968B: return 6580;
        case 0x968D: return 7431;
        case 0x968E: return 1703;
        case 0x968F: return 2898;
        case 0x9694: return 1745;
        case 0x9695: return 7433;
        case 0x9697: return 7434;
        case 0x9698: return 7432;
        case 0x9699: return 2135;
        case 0x969B: return 2410;
        case 0x969C: return 2792;
        case 0x969D: return 11074;
        case 0x96A0: return 1506;
        case 0x96A3: return 4286;
        case 0x96A7: return 7436;
        case 0x96A8: return 7251;
        case 0x96AA: return 7435;
        case 0x96AF: return 11075;
        case 0x96B0: return 7439;
        case 0x96B1: return 7437;
        case 0x96B2: return 7438;
        case 0x96B4: return 7440;
        case 0x96B6: return 7441;
        case 0x96B7: return 4305;
        case 0x96B8: return 7442;
        case 0x96B9: return 7443;
        case 0x96BB: return 2954;
        case 0x96BC: return 3692;
        case 0x96C0: return 2912;
        case 0x96C1: return 1856;
        case 0x96C4: return 4161;
        case 0x96C5: return 1674;
        case 0x96C6: return 2655;
        case 0x96C7: return 2220;
        case 0x96C9: return 7446;
        case 0x96CB: return 7445;
        case 0x96CC: return 2526;
        case 0x96CD: return 7447;
        case 0x96CE: return 7444;
        case 0x96D1: return 2451;
        case 0x96D5: return 7451;
        case 0x96D6: return 6874;
        case 0x96D9: return 4659;
        case 0x96DB: return 2906;
        case 0x96DC: return 7449;
        case 0x96E2: return 4234;
        case 0x96E3: return 3558;
        case 0x96E8: return 1514;
        case 0x96EA: return 2980;
        case 0x96EB: return 2559;
        case 0x96F0: return 3876;
        case 0x96F2: return 1535;
        case 0x96F6: return 4306;
        case 0x96F7: return 4210;
        case 0x96F9: return 7452;
        case 0x96FB: return 3420;
        case 0x9700: return 2628;
        case 0x9704: return 7453;
        case 0x9706: return 7454;
        case 0x9707: return 2863;
        case 0x9708: return 7455;
        case 0x970A: return 4307;
        case 0x970D: return 7450;
        case 0x970E: return 7457;
        case 0x970F: return 7459;
        case 0x9711: return 7458;
        case 0x9713: return 7456;
        case 0x9716: return 7460;
        case 0x9719: return 7461;
        case 0x971C: return 3097;
        case 0x971E: return 1663;
        case 0x9724: return 7462;
        case 0x9727: return 4065;
        case 0x972A: return 7463;
        case 0x9730: return 7464;
        case 0x9732: return 4333;
        case 0x9733: return 11076;
        case 0x9738: return 5468;
        case 0x9739: return 7465;
        case 0x973B: return 11077;
        case 0x973D: return 7466;
        case 0x973E: return 7467;
        case 0x9742: return 7471;
        case 0x9743: return 11078;
        case 0x9744: return 7468;
        case 0x9746: return 7469;
        case 0x9748: return 7470;
        case 0x9749: return 7472;
        case 0x974D: return 11079;
        case 0x974F: return 11080;
        case 0x9751: return 11081;
        case 0x9752: return 2949;
        case 0x9755: return 11082;
        case 0x9756: return 4128;
        case 0x9759: return 2950;
        case 0x975C: return 7473;
        case 0x975E: return 3748;
        case 0x9760: return 7474;
        case 0x9761: return 7758;
        case 0x9762: return 4085;
        case 0x9764: return 7475;
        case 0x9766: return 7476;
        case 0x9768: return 7477;
        case 0x9769: return 1746;
        case 0x976B: return 7479;
        case 0x976D: return 2876;
        case 0x9771: return 7480;
        case 0x9774: return 2071;
        case 0x9779: return 7481;
        case 0x977A: return 7485;
        case 0x977C: return 7483;
        case 0x9781: return 7484;
        case 0x9784: return 1774;
        case 0x9785: return 7482;
        case 0x9786: return 7486;
        case 0x978B: return 7487;
        case 0x978D: return 1449;
        case 0x978F: return 7488;
        case 0x9790: return 7489;
        case 0x9798: return 2793;
        case 0x979C: return 7490;
        case 0x97A0: return 1918;
        case 0x97A3: return 7493;
        case 0x97A6: return 7492;
        case 0x97A8: return 7491;
        case 0x97AB: return 7036;
        case 0x97AD: return 3913;
        case 0x97B3: return 7494;
        case 0x97B4: return 7495;
        case 0x97C3: return 7496;
        case 0x97C6: return 7497;
        case 0x97C8: return 7498;
        case 0x97CB: return 7499;
        case 0x97D3: return 1843;
        case 0x97DC: return 7500;
        case 0x97ED: return 7501;
        case 0x97EE: return 3574;
        case 0x97F2: return 7503;
        case 0x97F3: return 1624;
        case 0x97F5: return 7506;
        case 0x97F6: return 7505;
        case 0x97FB: return 1507;
        case 0x97FF: return 2006;
        case 0x9801: return 3892;
        case 0x9802: return 3315;
        case 0x9803: return 2351;
        case 0x9805: return 2319;
        case 0x9806: return 2702;
        case 0x9808: return 2879;
        case 0x980C: return 7508;
        case 0x980F: return 7507;
        case 0x9810: return 4169;
        case 0x9811: return 1857;
        case 0x9812: return 3715;
        case 0x9813: return 3537;
        case 0x9817: return 2911;
        case 0x9818: return 4275;
        case 0x981A: return 2126;
        case 0x9821: return 7511;
        case 0x9824: return 7510;
        case 0x982C: return 3990;
        case 0x982D: return 3489;
        case 0x9834: return 1551;
        case 0x9837: return 7512;
        case 0x9838: return 7509;
        case 0x983B: return 3808;
        case 0x983C: return 4209;
        case 0x983D: return 7513;
        case 0x9846: return 7514;
        case 0x984B: return 7516;
        case 0x984C: return 3175;
        case 0x984D: return 1750;
        case 0x984E: return 1751;
        case 0x984F: return 7515;
        case 0x9854: return 1858;
        case 0x9855: return 2179;
        case 0x9857: return 11083;
        case 0x9858: return 1859;
        case 0x985B: return 3414;
        case 0x985E: return 4293;
        case 0x9865: return 11084;
        case 0x9867: return 2221;
        case 0x986B: return 7517;
        case 0x986F: return 7518;
        case 0x9870: return 7519;
        case 0x9871: return 7520;
        case 0x9873: return 7522;
        case 0x9874: return 7521;
        case 0x98A8: return 3846;
        case 0x98AA: return 7523;
        case 0x98AF: return 7524;
        case 0x98B1: return 7525;
        case 0x98B6: return 7526;
        case 0x98C3: return 7528;
        case 0x98C4: return 7527;
        case 0x98C6: return 7529;
        case 0x98DB: return 3749;
        case 0x98DC: return 6529;
        case 0x98DF: return 2828;
        case 0x98E2: return 1897;
        case 0x98E9: return 7530;
        case 0x98EB: return 7531;
        case 0x98ED: return 4617;
        case 0x98EE: return 5666;
        case 0x98EF: return 3716;
        case 0x98F2: return 1500;
        case 0x98F4: return 1436;
        case 0x98FC: return 2527;
        case 0x98FD: return 3963;
        case 0x98FE: return 2819;
        case 0x9903: return 7532;
        case 0x9905: return 4104;
        case 0x9909: return 7533;
        case 0x990A: return 4195;
        case 0x990C: return 1537;
        case 0x9910: return 2476;
        case 0x9912: return 7534;
        case 0x9913: return 1675;
        case 0x9914: return 7535;
        case 0x9918: return 7536;
        case 0x991D: return 7538;
        case 0x991E: return 7539;
        case 0x9920: return 7541;
        case 0x9921: return 7537;
        case 0x9924: return 7540;
        case 0x9927: return 11087;
        case 0x9928: return 1844;
        case 0x992C: return 7542;
        case 0x992E: return 7543;
        case 0x993D: return 7544;
        case 0x993E: return 7545;
        case 0x9942: return 7546;
        case 0x9945: return 7548;
        case 0x9949: return 7547;
        case 0x994B: return 7550;
        case 0x994C: return 7553;
        case 0x9950: return 7549;
        case 0x9951: return 7551;
        case 0x9952: return 7552;
        case 0x9955: return 7554;
        case 0x9957: return 2007;
        case 0x9996: return 2620;
        case 0x9997: return 7555;
        case 0x9998: return 7556;
        case 0x9999: return 2320;
        case 0x999E: return 11089;
        case 0x99A5: return 7557;
        case 0x99A8: return 1721;
        case 0x99AC: return 3618;
        case 0x99AD: return 7558;
        case 0x99AE: return 7559;
        case 0x99B3: return 3253;
        case 0x99B4: return 3552;
        case 0x99BC: return 7560;
        case 0x99C1: return 3664;
        case 0x99C4: return 3145;
        case 0x99C5: return 1559;
        case 0x99C6: return 2051;
        case 0x99C8: return 2052;
        case 0x99D0: return 3278;
        case 0x99D1: return 7565;
        case 0x99D2: return 2053;
        case 0x99D5: return 1676;
        case 0x99D8: return 7564;
        case 0x99DB: return 7562;
        case 0x99DD: return 7563;
        case 0x99DF: return 7561;
        case 0x99E2: return 7575;
        case 0x99ED: return 7566;
        case 0x99EE: return 7567;
        case 0x99F1: return 7568;
        case 0x99F2: return 7569;
        case 0x99F8: return 7571;
        case 0x99FB: return 7570;
        case 0x99FF: return 2688;
        case 0x9A01: return 7572;
        case 0x9A05: return 7574;
        case 0x9A0E: return 1898;
        case 0x9A0F: return 7573;
        case 0x9A12: return 3098;
        case 0x9A13: return 2180;
        case 0x9A19: return 7576;
        case 0x9A28: return 3146;
        case 0x9A2B: return 7577;
        case 0x9A30: return 3490;
        case 0x9A37: return 7578;
        case 0x9A3E: return 7583;
        case 0x9A40: return 7581;
        case 0x9A42: return 7580;
        case 0x9A43: return 7582;
        case 0x9A45: return 7579;
        case 0x9A4D: return 7585;
        case 0x9A4E: return 11090;
        case 0x9A55: return 7584;
        case 0x9A57: return 7587;
        case 0x9A5A: return 2008;
        case 0x9A5B: return 7586;
        case 0x9A5F: return 7588;
        case 0x9A62: return 7589;
        case 0x9A64: return 7591;
        case 0x9A65: return 7590;
        case 0x9A69: return 7592;
        case 0x9A6A: return 7594;
        case 0x9A6B: return 7593;
        case 0x9AA8: return 2347;
        case 0x9AAD: return 7595;
        case 0x9AB0: return 7596;
        case 0x9AB8: return 1719;
        case 0x9ABC: return 7597;
        case 0x9AC0: return 7598;
        case 0x9AC4: return 2900;
        case 0x9ACF: return 7599;
        case 0x9AD1: return 7600;
        case 0x9AD3: return 7601;
        case 0x9AD4: return 7602;
        case 0x9AD8: return 2321;
        case 0x9AD9: return 11091;
        case 0x9ADC: return 11092;
        case 0x9ADE: return 7603;
        case 0x9ADF: return 7604;
        case 0x9AE2: return 7605;
        case 0x9AE3: return 7606;
        case 0x9AE6: return 7607;
        case 0x9AEA: return 3682;
        case 0x9AEB: return 7609;
        case 0x9AED: return 3765;
        case 0x9AEE: return 7610;
        case 0x9AEF: return 7608;
        case 0x9AF1: return 7612;
        case 0x9AF4: return 7611;
        case 0x9AF7: return 7613;
        case 0x9AFB: return 7614;
        case 0x9B06: return 7615;
        case 0x9B18: return 7616;
        case 0x9B1A: return 7617;
        case 0x9B1F: return 7618;
        case 0x9B22: return 7619;
        case 0x9B23: return 7620;
        case 0x9B25: return 7621;
        case 0x9B27: return 7622;
        case 0x9B28: return 7623;
        case 0x9B29: return 7624;
        case 0x9B2A: return 7625;
        case 0x9B2E: return 7626;
        case 0x9B2F: return 7627;
        case 0x9B31: return 5660;
        case 0x9B32: return 7628;
        case 0x9B3B: return 6385;
        case 0x9B3C: return 1899;
        case 0x9B41: return 1692;
        case 0x9B42: return 2367;
        case 0x9B43: return 7630;
        case 0x9B44: return 7629;
        case 0x9B45: return 4046;
        case 0x9B4D: return 7632;
        case 0x9B4E: return 7633;
        case 0x9B4F: return 7631;
        case 0x9B51: return 7634;
        case 0x9B54: return 4013;
        case 0x9B58: return 7635;
        case 0x9B5A: return 1970;
        case 0x9B6F: return 4328;
        case 0x9B72: return 11094;
        case 0x9B74: return 7636;
        case 0x9B75: return 11093;
        case 0x9B83: return 7638;
        case 0x9B8E: return 1439;
        case 0x9B8F: return 11095;
        case 0x9B91: return 7639;
        case 0x9B92: return 3864;
        case 0x9B93: return 7637;
        case 0x9B96: return 7640;
        case 0x9B97: return 7641;
        case 0x9B9F: return 7642;
        case 0x9BA0: return 7643;
        case 0x9BA8: return 7644;
        case 0x9BAA: return 4025;
        case 0x9BAB: return 2456;
        case 0x9BAD: return 2439;
        case 0x9BAE: return 3022;
        case 0x9BB1: return 11096;
        case 0x9BB4: return 7645;
        case 0x9BB9: return 7648;
        case 0x9BBB: return 11097;
        case 0x9BC0: return 7646;
        case 0x9BC6: return 7649;
        case 0x9BC9: return 2242;
        case 0x9BCA: return 7647;
        case 0x9BCF: return 7650;
        case 0x9BD1: return 7651;
        case 0x9BD2: return 7652;
        case 0x9BD4: return 7656;
        case 0x9BD6: return 2453;
        case 0x9BDB: return 3169;
        case 0x9BE1: return 7657;
        case 0x9BE2: return 7654;
        case 0x9BE3: return 7653;
        case 0x9BE4: return 7655;
        case 0x9BE8: return 2130;
        case 0x9BF0: return 7661;
        case 0x9BF1: return 7660;
        case 0x9BF2: return 7659;
        case 0x9BF5: return 1428;
        case 0x9C00: return 11098;
        case 0x9C04: return 7671;
        case 0x9C06: return 7667;
        case 0x9C08: return 7668;
        case 0x9C09: return 7664;
        case 0x9C0A: return 7670;
        case 0x9C0C: return 7666;
        case 0x9C0D: return 1757;
        case 0x9C10: return 4367;
        case 0x9C12: return 7669;
        case 0x9C13: return 7665;
        case 0x9C14: return 7663;
        case 0x9C15: return 7662;
        case 0x9C1B: return 7673;
        case 0x9C21: return 7676;
        case 0x9C24: return 7675;
        case 0x9C25: return 7674;
        case 0x9C2D: return 3800;
        case 0x9C2E: return 7672;
        case 0x9C2F: return 1492;
        case 0x9C30: return 7677;
        case 0x9C32: return 7679;
        case 0x9C39: return 1770;
        case 0x9C3A: return 7658;
        case 0x9C3B: return 1526;
        case 0x9C3E: return 7681;
        case 0x9C46: return 7680;
        case 0x9C47: return 7678;
        case 0x9C48: return 3208;
        case 0x9C52: return 4027;
        case 0x9C57: return 4287;
        case 0x9C5A: return 7682;
        case 0x9C60: return 7683;
        case 0x9C67: return 7684;
        case 0x9C76: return 7685;
        case 0x9C78: return 7686;
        case 0x9CE5: return 3316;
        case 0x9CE7: return 7687;
        case 0x9CE9: return 3688;
        case 0x9CEB: return 7692;
        case 0x9CEC: return 7688;
        case 0x9CF0: return 7689;
        case 0x9CF3: return 3964;
        case 0x9CF4: return 4077;
        case 0x9CF6: return 3525;
        case 0x9D03: return 7693;
        case 0x9D06: return 7694;
        case 0x9D07: return 3507;
        case 0x9D08: return 7691;
        case 0x9D09: return 7690;
        case 0x9D0E: return 1607;
        case 0x9D12: return 7702;
        case 0x9D15: return 7701;
        case 0x9D1B: return 1588;
        case 0x9D1F: return 7699;
        case 0x9D23: return 7698;
        case 0x9D26: return 7696;
        case 0x9D28: return 1782;
        case 0x9D2A: return 7695;
        case 0x9D2B: return 2555;
        case 0x9D2C: return 1606;
        case 0x9D3B: return 2322;
        case 0x9D3E: return 7705;
        case 0x9D3F: return 7704;
        case 0x9D41: return 7703;
        case 0x9D44: return 7700;
        case 0x9D46: return 7706;
        case 0x9D48: return 7707;
        case 0x9D50: return 7712;
        case 0x9D51: return 7711;
        case 0x9D59: return 7713;
        case 0x9D5C: return 1516;
        case 0x9D5D: return 7708;
        case 0x9D5E: return 7709;
        case 0x9D60: return 2339;
        case 0x9D61: return 4066;
        case 0x9D64: return 7710;
        case 0x9D6B: return 11100;
        case 0x9D6C: return 3965;
        case 0x9D6F: return 7718;
        case 0x9D70: return 11099;
        case 0x9D72: return 7714;
        case 0x9D7A: return 7719;
        case 0x9D87: return 7716;
        case 0x9D89: return 7715;
        case 0x9D8F: return 2127;
        case 0x9D9A: return 7720;
        case 0x9DA4: return 7721;
        case 0x9DA9: return 7722;
        case 0x9DAB: return 7717;
        case 0x9DAF: return 7697;
        case 0x9DB2: return 7723;
        case 0x9DB4: return 3354;
        case 0x9DB8: return 7727;
        case 0x9DBA: return 7728;
        case 0x9DBB: return 7726;
        case 0x9DC1: return 7725;
        case 0x9DC2: return 7731;
        case 0x9DC4: return 7724;
        case 0x9DC6: return 7729;
        case 0x9DCF: return 7730;
        case 0x9DD3: return 7733;
        case 0x9DD9: return 7732;
        case 0x9DE6: return 7735;
        case 0x9DED: return 7736;
        case 0x9DEF: return 7737;
        case 0x9DF2: return 4364;
        case 0x9DF8: return 7734;
        case 0x9DF9: return 3176;
        case 0x9DFA: return 2426;
        case 0x9DFD: return 7738;
        case 0x9E19: return 11102;
        case 0x9E1A: return 7739;
        case 0x9E1B: return 7740;
        case 0x9E1E: return 7741;
        case 0x9E75: return 7742;
        case 0x9E78: return 2181;
        case 0x9E79: return 7743;
        case 0x9E7D: return 7744;
        case 0x9E7F: return 2552;
        case 0x9E81: return 7745;
        case 0x9E88: return 7746;
        case 0x9E8B: return 7747;
        case 0x9E8C: return 7748;
        case 0x9E91: return 7751;
        case 0x9E92: return 7749;
        case 0x9E93: return 4351;
        case 0x9E95: return 7750;
        case 0x9E97: return 4308;
        case 0x9E9D: return 7752;
        case 0x9E9F: return 4288;
        case 0x9EA5: return 7753;
        case 0x9EA6: return 3665;
        case 0x9EA9: return 7754;
        case 0x9EAA: return 7756;
        case 0x9EAD: return 7757;
        case 0x9EB8: return 7755;
        case 0x9EB9: return 2332;
        case 0x9EBA: return 4086;
        case 0x9EBB: return 4014;
        case 0x9EBC: return 5068;
        case 0x9EBE: return 5703;
        case 0x9EBF: return 4038;
        case 0x9EC4: return 1608;
        case 0x9ECC: return 7759;
        case 0x9ECD: return 1927;
        case 0x9ECE: return 7760;
        case 0x9ECF: return 7761;
        case 0x9ED0: return 7762;
        case 0x9ED1: return 11103;
        case 0x9ED2: return 2340;
        case 0x9ED4: return 7763;
        case 0x9ED8: return 5973;
        case 0x9ED9: return 4100;
        case 0x9EDB: return 3168;
        case 0x9EDC: return 7764;
        case 0x9EDD: return 7766;
        case 0x9EDE: return 7765;
        case 0x9EE0: return 7767;
        case 0x9EE5: return 7768;
        case 0x9EE8: return 7769;
        case 0x9EEF: return 7770;
        case 0x9EF4: return 7771;
        case 0x9EF6: return 7772;
        case 0x9EF7: return 7773;
        case 0x9EF9: return 7774;
        case 0x9EFB: return 7775;
        case 0x9EFC: return 7776;
        case 0x9EFD: return 7777;
        case 0x9F07: return 7778;
        case 0x9F08: return 7779;
        case 0x9F0E: return 3387;
        case 0x9F13: return 2222;
        case 0x9F15: return 7781;
        case 0x9F20: return 3052;
        case 0x9F21: return 7782;
        case 0x9F2C: return 7783;
        case 0x9F3B: return 3760;
        case 0x9F3E: return 7784;
        case 0x9F4A: return 7785;
        case 0x9F4B: return 6226;
        case 0x9F4E: return 7107;
        case 0x9F4F: return 7502;
        case 0x9F52: return 7786;
        case 0x9F54: return 7787;
        case 0x9F5F: return 7789;
        case 0x9F60: return 7790;
        case 0x9F61: return 7791;
        case 0x9F62: return 4309;
        case 0x9F63: return 7788;
        case 0x9F66: return 7792;
        case 0x9F67: return 7793;
        case 0x9F6A: return 7795;
        case 0x9F6C: return 7794;
        case 0x9F72: return 7797;
        case 0x9F76: return 7798;
        case 0x9F77: return 7796;
        case 0x9F8D: return 4251;
        case 0x9F95: return 7799;
        case 0x9F9C: return 7800;
        case 0x9F9D: return 6255;
        case 0x9FA0: return 7801;
        case 0xF929: return 10875;
        case 0xF9DC: return 11072;
        case 0xFA0E: return 10795;
        case 0xFA0F: return 10806;
        case 0xFA10: return 10807;
        case 0xFA11: return 10828;
        case 0xFA12: return 10867;
        case 0xFA13: return 10883;
        case 0xFA14: return 10885;
        case 0xFA15: return 10928;
        case 0xFA16: return 10934;
        case 0xFA17: return 10957;
        case 0xFA18: return 10965;
        case 0xFA19: return 10966;
        case 0xFA1A: return 10967;
        case 0xFA1B: return 10969;
        case 0xFA1C: return 10973;
        case 0xFA1D: return 10976;
        case 0xFA1E: return 10985;
        case 0xFA1F: return 10996;
        case 0xFA20: return 10998;
        case 0xFA21: return 10999;
        case 0xFA22: return 11008;
        case 0xFA23: return 11016;
        case 0xFA24: return 11018;
        case 0xFA25: return 11019;
        case 0xFA26: return 11022;
        case 0xFA27: return 11050;
        case 0xFA28: return 11057;
        case 0xFA29: return 11073;
        case 0xFA2A: return 11085;
        case 0xFA2B: return 11086;
        case 0xFA2C: return 11088;
        case 0xFA2D: return 11101;
        case 0xFF01: return 9;
        case 0xFF02: return 10739;
        case 0xFF03: return 83;
        case 0xFF04: return 79;
        case 0xFF05: return 82;
        case 0xFF06: return 84;
        case 0xFF07: return 10738;
        case 0xFF08: return 41;
        case 0xFF09: return 42;
        case 0xFF0A: return 85;
        case 0xFF0B: return 59;
        case 0xFF0C: return 3;
        case 0xFF0D: return 60;
        case 0xFF0E: return 4;
        case 0xFF0F: return 30;
        case 0xFF10: return 203;
        case 0xFF11: return 204;
        case 0xFF12: return 205;
        case 0xFF13: return 206;
        case 0xFF14: return 207;
        case 0xFF15: return 208;
        case 0xFF16: return 209;
        case 0xFF17: return 210;
        case 0xFF18: return 211;
        case 0xFF19: return 212;
        case 0xFF1A: return 6;
        case 0xFF1B: return 7;
        case 0xFF1C: return 66;
        case 0xFF1D: return 64;
        case 0xFF1E: return 67;
        case 0xFF1F: return 8;
        case 0xFF20: return 86;
        case 0xFF21: return 220;
        case 0xFF22: return 221;
        case 0xFF23: return 222;
        case 0xFF24: return 223;
        case 0xFF25: return 224;
        case 0xFF26: return 225;
        case 0xFF27: return 226;
        case 0xFF28: return 227;
        case 0xFF29: return 228;
        case 0xFF2A: return 229;
        case 0xFF2B: return 230;
        case 0xFF2C: return 231;
        case 0xFF2D: return 232;
        case 0xFF2E: return 233;
        case 0xFF2F: return 234;
        case 0xFF30: return 235;
        case 0xFF31: return 236;
        case 0xFF32: return 237;
        case 0xFF33: return 238;
        case 0xFF34: return 239;
        case 0xFF35: return 240;
        case 0xFF36: return 241;
        case 0xFF37: return 242;
        case 0xFF38: return 243;
        case 0xFF39: return 244;
        case 0xFF3A: return 245;
        case 0xFF3B: return 45;
        case 0xFF3C: return 31;
        case 0xFF3D: return 46;
        case 0xFF3E: return 15;
        case 0xFF3F: return 17;
        case 0xFF40: return 13;
        case 0xFF41: return 252;
        case 0xFF42: return 253;
        case 0xFF43: return 254;
        case 0xFF44: return 255;
        case 0xFF45: return 256;
        case 0xFF46: return 257;
        case 0xFF47: return 258;
        case 0xFF48: return 259;
        case 0xFF49: return 260;
        case 0xFF4A: return 261;
        case 0xFF4B: return 262;
        case 0xFF4C: return 263;
        case 0xFF4D: return 264;
        case 0xFF4E: return 265;
        case 0xFF4F: return 266;
        case 0xFF50: return 267;
        case 0xFF51: return 268;
        case 0xFF52: return 269;
        case 0xFF53: return 270;
        case 0xFF54: return 271;
        case 0xFF55: return 272;
        case 0xFF56: return 273;
        case 0xFF57: return 274;
        case 0xFF58: return 275;
        case 0xFF59: return 276;
        case 0xFF5A: return 277;
        case 0xFF5B: return 47;
        case 0xFF5C: return 34;
        case 0xFF5D: return 48;
        case 0xFF5E: return 32;
        case 0xFFE0: return 80;
        case 0xFFE1: return 81;
        case 0xFFE2: return 137;
        case 0xFFE3: return 16;
        case 0xFFE4: return 10737;
        case 0xFFE5: return 78;
        default: return SHIFTJIS_NULL;
    }
}
/* End generated code */