/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import nu.validator.htmlparser.annotation.Inline;
import nu.validator.htmlparser.annotation.Local;
import nu.validator.htmlparser.annotation.NsUri;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.Portability;
import nu.validator.htmlparser.impl.TaintableLocatorImpl;
import nu.validator.htmlparser.impl.TreeBuilder;

final class StackNode<T> {
    final int idxInTreeBuilder;
    int flags;
    @Local
    String name;
    @Local
    String popName;
    @NsUri
    String ns;
    T node;
    HtmlAttributes attributes;
    private int refcount = 0;
    private TaintableLocatorImpl locator;

    public TaintableLocatorImpl getLocator() {
        return this.locator;
    }

    @Inline
    public int getFlags() {
        return this.flags;
    }

    public int getGroup() {
        return this.flags & 0x7F;
    }

    public boolean isScoping() {
        return (this.flags & 0x8000000) != 0;
    }

    public boolean isSpecial() {
        return (this.flags & 0x20000000) != 0;
    }

    public boolean isFosterParenting() {
        return (this.flags & 0x10000000) != 0;
    }

    public boolean isHtmlIntegrationPoint() {
        return (this.flags & 0x1000000) != 0;
    }

    public boolean isOptionalEndTag() {
        return (this.flags & 0x800000) != 0;
    }

    StackNode(int idxInTreeBuilder) {
        this.idxInTreeBuilder = idxInTreeBuilder;
        this.refcount = 0;
    }

    void setValues(int flags, @NsUri String ns, @Local String name, T node, @Local String popName, HtmlAttributes attributes, TaintableLocatorImpl locator) {
        assert (this.isUnused());
        this.flags = flags;
        this.name = name;
        this.popName = popName;
        this.ns = ns;
        this.node = node;
        this.attributes = attributes;
        this.refcount = 1;
        this.locator = locator;
    }

    void setValues(ElementName elementName, T node, TaintableLocatorImpl locator) {
        assert (this.isUnused());
        this.flags = elementName.getFlags();
        this.name = elementName.getName();
        this.popName = elementName.getName();
        this.ns = "http://www.w3.org/1999/xhtml";
        this.node = node;
        this.attributes = null;
        this.refcount = 1;
        assert (elementName.isInterned()) : "Don't use this constructor for custom elements.";
        this.locator = locator;
    }

    void setValues(ElementName elementName, T node, HtmlAttributes attributes, TaintableLocatorImpl locator) {
        assert (this.isUnused());
        this.flags = elementName.getFlags();
        this.name = elementName.getName();
        this.popName = elementName.getName();
        this.ns = "http://www.w3.org/1999/xhtml";
        this.node = node;
        this.attributes = attributes;
        this.refcount = 1;
        assert (elementName.isInterned()) : "Don't use this constructor for custom elements.";
        this.locator = locator;
    }

    void setValues(ElementName elementName, T node, @Local String popName, TaintableLocatorImpl locator) {
        assert (this.isUnused());
        this.flags = elementName.getFlags();
        this.name = elementName.getName();
        this.popName = popName;
        this.ns = "http://www.w3.org/1999/xhtml";
        this.node = node;
        this.attributes = null;
        this.refcount = 1;
        this.locator = locator;
    }

    void setValues(ElementName elementName, @Local String popName, T node, TaintableLocatorImpl locator) {
        assert (this.isUnused());
        this.flags = StackNode.prepareSvgFlags(elementName.getFlags());
        this.name = elementName.getName();
        this.popName = popName;
        this.ns = "http://www.w3.org/2000/svg";
        this.node = node;
        this.attributes = null;
        this.refcount = 1;
        this.locator = locator;
    }

    void setValues(ElementName elementName, T node, @Local String popName, boolean markAsIntegrationPoint, TaintableLocatorImpl locator) {
        assert (this.isUnused());
        this.flags = StackNode.prepareMathFlags(elementName.getFlags(), markAsIntegrationPoint);
        this.name = elementName.getName();
        this.popName = popName;
        this.ns = "http://www.w3.org/1998/Math/MathML";
        this.node = node;
        this.attributes = null;
        this.refcount = 1;
        this.locator = locator;
    }

    private static int prepareSvgFlags(int flags) {
        if (((flags &= 0xC77FFFFF) & 0x4000000) != 0) {
            flags |= 0x29000000;
        }
        return flags;
    }

    private static int prepareMathFlags(int flags, boolean markAsIntegrationPoint) {
        if (((flags &= 0xC77FFFFF) & 0x2000000) != 0) {
            flags |= 0x28000000;
        }
        if (markAsIntegrationPoint) {
            flags |= 0x1000000;
        }
        return flags;
    }

    private void destructor() {
    }

    public void dropAttributes() {
        this.attributes = null;
    }

    @Local
    public String toString() {
        return this.name;
    }

    public void retain() {
        ++this.refcount;
    }

    public void release(TreeBuilder<T> owningTreeBuilder) {
        --this.refcount;
        assert (this.refcount >= 0);
        if (this.refcount == 0) {
            Portability.delete(this.attributes);
            if (this.idxInTreeBuilder >= 0) {
                owningTreeBuilder.notifyUnusedStackNode(this.idxInTreeBuilder);
            } else {
                assert (owningTreeBuilder == null);
                Portability.delete(this);
            }
        }
    }

    boolean isUnused() {
        return this.refcount == 0;
    }
}

