/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class YwtProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression("%(..),").number("(d+):").number("d+,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([EW])").number("(ddd.d{6}),").expression("([NS])").number("(dd.d{6}),").number("(d+)?,").number("(d+),").number("(d+),").number("(d+),").expression("([^,]+),").expression("([-0-9a-fA-F]+)").any().compile();

    public YwtProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("%SN") && channel != null) {
            int start;
            int end = start = sentence.indexOf(58);
            for (int i = 0; i < 4; ++i) {
                end = sentence.indexOf(44, end + 1);
            }
            if (end == -1) {
                end = sentence.length();
            }
            channel.writeAndFlush((Object)new NetworkMessage("%AT+SN=" + sentence.substring(start, end), remoteAddress));
            return null;
        }
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        String type = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
        position.setAltitude(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextDouble());
        int satellites = parser.nextInt();
        position.setValid(satellites != 0);
        position.set("sat", satellites);
        String reportId = parser.next();
        position.set("status", parser.next());
        if ((type.equals("KP") || type.equals("EP")) && channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("%AT+" + type + "=" + reportId + "\r\n", remoteAddress));
        }
        return position;
    }
}

