/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Context;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class Tk103ProtocolEncoder
extends StringProtocolEncoder {
    private final boolean forceAlternative;

    public Tk103ProtocolEncoder() {
        this.forceAlternative = false;
    }

    public Tk103ProtocolEncoder(boolean forceAlternative) {
        this.forceAlternative = forceAlternative;
    }

    private String formatAlt(Command command, String format, String ... keys) {
        return this.formatCommand(command, "[begin]sms2," + format + ",[end]", keys);
    }

    @Override
    protected Object encodeCommand(Command command) {
        boolean alternative = this.forceAlternative || Context.getIdentityManager().lookupAttributeBoolean(command.getDeviceId(), "tk103.alternative", false, true);
        this.initDevicePassword(command, "123456");
        if (alternative) {
            switch (command.getType()) {
                case "custom": {
                    return this.formatAlt(command, "{%s}", "data");
                }
                case "getVersion": {
                    return this.formatAlt(command, "*about*", new String[0]);
                }
                case "powerOff": {
                    return this.formatAlt(command, "*turnoff*", new String[0]);
                }
                case "rebootDevice": {
                    return this.formatAlt(command, "88888888", new String[0]);
                }
                case "positionSingle": {
                    return this.formatAlt(command, "*getposl*", new String[0]);
                }
                case "positionPeriodic": {
                    return this.formatAlt(command, "*routetrack*99*", new String[0]);
                }
                case "positionStop": {
                    return this.formatAlt(command, "*routetrackoff*", new String[0]);
                }
                case "getDeviceStatus": {
                    return this.formatAlt(command, "*status*", new String[0]);
                }
                case "deviceIdentification": {
                    return this.formatAlt(command, "999999", new String[0]);
                }
                case "modeDeepSleep": {
                    return this.formatAlt(command, command.getBoolean("enable") ? "*sleep*2*" : "*sleepoff*", new String[0]);
                }
                case "modePowerSaving": {
                    return this.formatAlt(command, command.getBoolean("enable") ? "*sleepv*" : "*sleepoff*", new String[0]);
                }
                case "alarmSos": {
                    return this.formatAlt(command, command.getBoolean("enable") ? "*soson*" : "*sosoff*", new String[0]);
                }
                case "setConnection": {
                    return this.formatAlt(command, "*setip*%s*{%s}*", command.getString("server").replace(".", "*"), "port");
                }
                case "sosNumber": {
                    return this.formatAlt(command, "*master*{%s}*{%s}*", "devicePassword", "phone");
                }
            }
            return null;
        }
        switch (command.getType()) {
            case "custom": {
                return this.formatCommand(command, "({%s}{%s})", "uniqueId", "data");
            }
            case "getVersion": {
                return this.formatCommand(command, "({%s}AP07)", "uniqueId");
            }
            case "rebootDevice": {
                return this.formatCommand(command, "({%s}AT00)", "uniqueId");
            }
            case "setOdometer": {
                return this.formatCommand(command, "({%s}AX01)", "uniqueId");
            }
            case "positionSingle": {
                return this.formatCommand(command, "({%s}AP00)", "uniqueId");
            }
            case "positionPeriodic": {
                return this.formatCommand(command, "({%s}AR00%s0000)", "uniqueId", String.format("%04X", command.getInteger("frequency")));
            }
            case "positionStop": {
                return this.formatCommand(command, "({%s}AR0000000000)", "uniqueId");
            }
            case "engineStop": {
                return this.formatCommand(command, "({%s}AV010)", "uniqueId");
            }
            case "engineResume": {
                return this.formatCommand(command, "({%s}AV011)", "uniqueId");
            }
            case "outputControl": {
                return this.formatCommand(command, "({%s}AV00{%s})", "uniqueId", "data");
            }
        }
        return null;
    }
}

