/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class T800xProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 1;
    public static final int MSG_GPS = 2;
    public static final int MSG_HEARTBEAT = 3;
    public static final int MSG_ALARM = 4;
    public static final int MSG_COMMAND = 129;

    public T800xProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, short header, int type, ByteBuf imei) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)15);
            response.writeShort((int)header);
            response.writeByte(type);
            response.writeShort(response.capacity());
            response.writeShort(1);
            response.writeBytes(imei);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private String decodeAlarm(short value) {
        switch (value) {
            case 3: {
                return "sos";
            }
            case 4: {
                return "overspeed";
            }
            case 5: {
                return "geofenceEnter";
            }
            case 6: {
                return "geofenceExit";
            }
            case 8: 
            case 10: {
                return "vibration";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        short header = buf.readShort();
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        int index = buf.readUnsignedShort();
        ByteBuf imei = buf.readSlice(8);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)imei).substring(1));
        if (deviceSession == null) {
            return null;
        }
        if (type == 1 || type == 4 || type == 3) {
            this.sendResponse(channel, header, type, imei);
        }
        if (type == 2 || type == 4) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("index", index);
            buf.readUnsignedShort();
            buf.readUnsignedShort();
            buf.readUnsignedByte();
            buf.readUnsignedShort();
            buf.readUnsignedShort();
            short status = buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedShort();
            int io = buf.readUnsignedShort();
            position.set("ignition", BitUtil.check(io, 14));
            position.set("ac", BitUtil.check(io, 13));
            position.set("adc1", buf.readUnsignedShort());
            position.set("adc2", buf.readUnsignedShort());
            position.set("alarm", this.decodeAlarm(buf.readUnsignedByte()));
            buf.readUnsignedByte();
            position.set("odometer", buf.readUnsignedInt());
            int battery = BcdUtil.readInteger(buf, 2);
            if (battery == 0) {
                battery = 100;
            }
            position.set("battery", battery);
            DateBuilder dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
            if (BitUtil.check(status, 6)) {
                position.setValid(!BitUtil.check(status, 7));
                position.setTime(dateBuilder.getDate());
                position.setAltitude(buf.readFloatLE());
                position.setLongitude(buf.readFloatLE());
                position.setLatitude(buf.readFloatLE());
                position.setSpeed(UnitsConverter.knotsFromKph((double)BcdUtil.readInteger(buf, 4) * 0.1));
                position.setCourse(buf.readUnsignedShort());
            } else {
                this.getLastLocation(position, dateBuilder.getDate());
                int mcc = buf.readUnsignedShortLE();
                int mnc = buf.readUnsignedShortLE();
                if (mcc != 65535 && mnc != 65535) {
                    Network network = new Network();
                    for (int i = 0; i < 3; ++i) {
                        network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShortLE(), buf.readUnsignedShortLE()));
                    }
                    position.setNetwork(network);
                }
            }
            if (buf.readableBytes() >= 2) {
                position.set("power", (double)BcdUtil.readInteger(buf, 4) * 0.01);
            }
            return position;
        }
        return null;
    }
}

